/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.ttdbobjects.TTPrimaryKeyIndexType;
import oracle.dbtools.raptor.timesten.ttdbobjects.TimestenElement;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Table;
import oracle.javatools.db.jdbc.JdbcTableBuilder;

public class TTTableBuilder
extends JdbcTableBuilder<Table> {
    private static final String DSTRIBUTION_TYPE = "SELECT DISTRIBUTIONMODE FROM TABLES WHERE TBLNAME = ? AND TBLOWNER = ?";
    private static final String PARTITION_REFERENCE = "SELECT DISTINCT rtrim(i.ixname) FROM TABLES t, indexes i, columns c WHERE rtrim(t.tblowner) = ?  and rtrim(t.tblname) = ? and t.tblid=c.id and t.tblid=i.tblid and (t.distributionmode = 6 or t.distributionmode = 7) and i.sys9 & 16384 <> 0";
    private static final String PARTITION_HASH = "select rtrim(c.COLNAME),c.distpos from tables t,  columns c WHERE rtrim(t.tblowner) = ?  and rtrim(t.tblname) = ? and t.tblid=c.id order by c.distpos;";
    private static final int DISTRIBUTION_HASH_TYPE = 4;
    private static final int DISTRIBUTION_DUPLICATE_TYPE = 5;
    private static final int DISTRIBUTION_REFERENCE_TYPE = 6;
    private static final int DISTRIBUTION_REFERENCE_N_TYPE = 7;
    private static final String INDEX_INFO = "SELECT i.IXTYPE ,i.PAGESPARAM from sys.indexes i, sys.tables t  where cast(i.ISPRIMARY as char(1)) = 0x1 and i.tblid=t.tblid and rtrim(t.tblowner) = ?  and rtrim(t.tblname) = ?";
    private static final String INLINE_QUERY = "select rtrim(c.COLNAME), COLLEN , INLINELEN from tables t,  columns c WHERE rtrim(t.tblowner) = ?  and rtrim(t.tblname) = ? and t.tblid=c.id ";
    protected static Logger logger = Logger.getLogger(TTTableBuilder.class.getPackage().getName());

    public TTTableBuilder(JdbcDatabase jdbcDatabase, String string) {
        super(jdbcDatabase, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AbstractDBObjectBuilder.PropertyBuilder(value={"TIMESTENELEMENT"})
    public void buildTimestenElement(Table table) throws DBException {
        Connection connection = this.getConnection();
        if (TimesTenPlugInDatabaseImpl.isGridDatabase(connection)) {
            TimestenElement timestenElement = new TimestenElement();
            Statement statement = null;
            Statement statement2 = null;
            try {
                Connections.getInstance().lock(connection);
                statement = connection.prepareStatement(DSTRIBUTION_TYPE);
                statement.setString(1, table.getName());
                statement.setString(2, table.getSchema().getName());
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    switch (n) {
                        case 4: {
                            timestenElement.setTimestenPartitionType(TimestenElement.TTPartitionType.HASH);
                            break;
                        }
                        case 5: {
                            timestenElement.setTimestenPartitionType(TimestenElement.TTPartitionType.DUPLICATE);
                            break;
                        }
                        case 6: {
                            timestenElement.setTimestenPartitionType(TimestenElement.TTPartitionType.REFERENCE);
                            break;
                        }
                        case 7: {
                            timestenElement.setTimestenPartitionType(TimestenElement.TTPartitionType.REFERENCE);
                        }
                    }
                }
                if (timestenElement.getTimestenPartitionType() == TimestenElement.TTPartitionType.REFERENCE) {
                    statement2 = connection.prepareStatement(PARTITION_REFERENCE);
                    statement2.setString(1, table.getSchema().getName());
                    statement2.setString(2, table.getName());
                    ResultSet resultSet2 = statement2.executeQuery();
                    while (resultSet2.next()) {
                        timestenElement.setForeignKey(resultSet2.getString(1));
                    }
                    try {
                        resultSet2.close();
                    }
                    catch (SQLException sQLException) {}
                } else if (timestenElement.getTimestenPartitionType() == TimestenElement.TTPartitionType.HASH) {
                    statement2 = connection.prepareStatement(PARTITION_HASH);
                    statement2.setString(1, table.getSchema().getName());
                    statement2.setString(2, table.getName());
                    ResultSet resultSet3 = statement2.executeQuery();
                    while (resultSet3.next()) {
                        int n = resultSet3.getInt(2);
                        if (n <= 0) continue;
                        timestenElement.getColumnHash().add(table.getColumn(resultSet3.getString(1)));
                    }
                    try {
                        resultSet3.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException sQLException) {
                logger.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (statement2 != null) {
                    try {
                        statement2.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (connection != null) {
                    Connections.getInstance().unlock(connection);
                }
            }
            table.setProperty("TIMESTENELEMENT", (Object)timestenElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AbstractDBObjectBuilder.PropertyBuilder(value={"TTPrimaryKeyIndexType"})
    public void buildIndexTypes(Table table) {
        Connection connection = this.getConnection();
        try {
            Connections.getInstance().lock(connection);
            PreparedStatement preparedStatement = null;
            preparedStatement = connection.prepareStatement(INDEX_INFO);
            preparedStatement.setString(1, table.getSchema().getName());
            preparedStatement.setString(2, table.getName());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                int n2 = resultSet.getInt(2);
                TTPrimaryKeyIndexType tTPrimaryKeyIndexType = new TTPrimaryKeyIndexType();
                if (n == 0) {
                    tTPrimaryKeyIndexType.setIndexType(TTPrimaryKeyIndexType.TTPrimaryKeyType.HASH);
                    tTPrimaryKeyIndexType.setPagesSize(n2);
                } else if (n == 1 || n == 3) {
                    tTPrimaryKeyIndexType.setIndexType(TTPrimaryKeyIndexType.TTPrimaryKeyType.RANGE);
                }
                table.setProperty("TTPrimaryKeyIndexType", (Object)tTPrimaryKeyIndexType);
                return;
            }
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
        }
        finally {
            Connections.getInstance().unlock(connection);
        }
        table.setProperty("TTPrimaryKeyIndexType", (Object)new TTPrimaryKeyIndexType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addExtraColumnAttributes(Table table) throws SQLException, DBException {
        Connection connection = this.getConnection();
        try {
            Connections.getInstance().lock(connection);
            PreparedStatement preparedStatement = null;
            preparedStatement = connection.prepareStatement(INLINE_QUERY);
            preparedStatement.setString(1, table.getSchema().getName());
            preparedStatement.setString(2, table.getName());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                long l = resultSet.getLong(2);
                long l2 = resultSet.getInt(3);
                if (l2 <= l) continue;
                table.getColumn(string).setProperty("inline", (Object)true);
            }
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
        }
        finally {
            Connections.getInstance().unlock(connection);
        }
    }

    public boolean canBuildEditableObject() {
        return true;
    }
}

