/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.commands;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.TransientConnectionProperties;
import oracle.dbtools.raptor.timesten.connection.TTSQLExceptionListener;
import oracle.dbtools.raptor.utils.Connections;

public class BuiltInProcedure
extends CommandListener {
    private static final Logger LOGGER = Logger.getLogger(BuiltInProcedure.class.getPackage().getName());
    private static final String BUILT_IN_REGEX = "^[cC][aA][lL][lL]\\s+[tT][tT].+";
    private static final String SCRIPT_REGEX = "^@.+|^start\\s+.+";
    private static final String SQL_COMMENT = "\\s*#.*|^--.*|\\s*rem\\s+.*";
    private static final int ROW_HEIGHT = 20;
    private static final byte SPACE_BETWEEN_COLUMNS = 2;
    private boolean thePlsqlFlag;
    private static final String EXEC_REGEX = "^exec[u]?[t]?[e]?\\s+.*";
    private static final String SERVEROUTPUT_ON_REGEX = "\\s*set\\s+serveroutput\\s+on\\s*";
    private static final String SERVEROUTPUT_OFF_REGEX = "\\s*set\\s+serveroutput\\s+off\\s*";
    private static final TransientConnectionProperties theTransientConnectionProperties = TransientConnectionProperties.getInstance();
    private Hashtable theTtVerProcList = new Hashtable();
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            if (!this.thePlsqlFlag) {
                return;
            }
            String string = this.processDbmsOutput1(scriptRunnerContext, connection);
            if (!string.equals("\n")) {
                if (theTransientConnectionProperties.isServerOutputEnabled(connection)) {
                    scriptRunnerContext.getOutputStream().write(string.getBytes("UTF-8"));
                }
                scriptRunnerContext.pushDbmsOutput(string);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "dbms output failed:" + exception.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Connections connections = Connections.getInstance();
        if (!connections.isTimesTen(connection)) {
            return false;
        }
        TTSQLExceptionListener tTSQLExceptionListener = TTSQLExceptionListener.getTheInstance();
        String string = null;
        this.thePlsqlFlag = false;
        String string2 = null;
        int n = 0;
        while (n < 3) {
            block61: {
                boolean bl = false;
                try {
                    string = iSQLCommand.getSql();
                    LOGGER.log(Level.FINEST, "Cmd: <" + string + ">, length: " + string.length());
                    if (Pattern.compile(SQL_COMMENT, 34).matcher(string).matches()) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    if (Pattern.compile(BUILT_IN_REGEX, 34).matcher(string).matches()) {
                        LOGGER.log(Level.INFO, Messages.getString("BuiltInProcedure.ExecitingTimesTenBuildInProcedure") + string);
                        this.executeBuiltInProcedureSql(scriptRunnerContext, connection, string);
                        boolean bl3 = true;
                        return bl3;
                    }
                    if (Pattern.compile(SCRIPT_REGEX, 34).matcher(string).matches()) {
                        boolean bl4 = false;
                        return bl4;
                    }
                    if (Pattern.compile(SERVEROUTPUT_ON_REGEX, 34).matcher(string).matches()) {
                        LOGGER.log(Level.INFO, "dbms_output control on: " + string);
                        theTransientConnectionProperties.enableServerOutput(connection);
                        boolean bl5 = false;
                        return bl5;
                    }
                    if (Pattern.compile(SERVEROUTPUT_OFF_REGEX, 34).matcher(string).matches()) {
                        LOGGER.log(Level.INFO, "dbms_output control off: " + string);
                        theTransientConnectionProperties.disableServerOutput(connection);
                        boolean bl6 = false;
                        return bl6;
                    }
                    if (this.isAnonymousBlock(string)) {
                        LOGGER.log(Level.INFO, "anonymous block: " + string);
                        this.thePlsqlFlag = true;
                        this.executeBuiltInProcedureSql(scriptRunnerContext, connection, string);
                        boolean bl7 = true;
                        return bl7;
                    }
                    if (this.isUserPlsqlCode(string, connection)) {
                        LOGGER.log(Level.INFO, "user PLSQL: " + string);
                        this.thePlsqlFlag = true;
                        this.executeBuiltInProcedureSql(scriptRunnerContext, connection, string);
                        boolean bl8 = true;
                        return bl8;
                    }
                    if (Pattern.compile(EXEC_REGEX, 34).matcher(string).matches()) {
                        this.thePlsqlFlag = true;
                        this.executePlsql(scriptRunnerContext, connection, string);
                        boolean bl9 = true;
                        return bl9;
                    }
                    this.executeMiscellaneousSql(scriptRunnerContext, connection, string);
                    boolean bl10 = true;
                    return bl10;
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2;
                    if (tTSQLExceptionListener.isTransientFailoverException(sQLException, connection) && n < 2) {
                        try {
                            scriptRunnerContext.getOutputStream().write((MessageFormat.format(Messages.getString("TimesTenFailover.retryAttempt"), n + 1) + "\n").getBytes("UTF-8"));
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {}
                        break block61;
                    }
                    bl = true;
                    while (sQLException2 != null) {
                        if (string2 == null) {
                            string2 = TTSQLExceptionScrubber.getMessage(sQLException2.getLocalizedMessage(), string, LOGGER);
                        } else {
                            String string3 = TTSQLExceptionScrubber.getMessage(sQLException2.getLocalizedMessage(), string, LOGGER);
                            string2 = string2 + "\n" + string3;
                        }
                        sQLException2 = sQLException2.getNextException();
                    }
                    break block46;
                    return true;
                }
                catch (Exception exception) {
                    bl = true;
                    string2 = TTSQLExceptionScrubber.getMessage(exception.getLocalizedMessage(), string, LOGGER);
                    return true;
                }
                finally {
                    if (bl) {
                        try {
                            scriptRunnerContext.getOutputStream().write(("\n" + string.trim() + " " + Messages.getString("BuiltInProcedure.Failed") + "\n" + string2 + "\n").getBytes("UTF-8"));
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            ++n;
        }
        return true;
    }

    private void executeMiscellaneousSql(ScriptRunnerContext scriptRunnerContext, Connection connection, String string) throws Exception {
        this.executeBuiltInProcedureSql(scriptRunnerContext, connection, string);
    }

    private void executePlsql(ScriptRunnerContext scriptRunnerContext, Connection connection, String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("BEGIN ");
        String[] stringArray = string.split("\\s");
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("Invalid PL/SQL invocation");
        }
        String string2 = stringArray[1].trim();
        stringBuffer.append(string2);
        if (string2.charAt(string2.length() - 1) != ';') {
            stringBuffer.append(";");
        }
        stringBuffer.append("END;");
        LOGGER.info(Messages.getString("BuiltInProcedure.Type") + stringBuffer.toString());
        this.executeBuiltInProcedureSql(scriptRunnerContext, connection, stringBuffer.toString());
    }

    private boolean isAnonymousBlock(String string) {
        boolean bl = false;
        List list = LexerToken.parse((String)string);
        for (int i = 0; i < 10 && i < list.size(); ++i) {
            LexerToken lexerToken = (LexerToken)list.get(i);
            if ("DECLARE".equalsIgnoreCase(lexerToken.content)) {
                bl = true;
                break;
            }
            if ("BEGIN".equalsIgnoreCase(lexerToken.content)) {
                bl = true;
                break;
            }
            if ("PACKAGE".equalsIgnoreCase(lexerToken.content)) {
                bl = false;
                break;
            }
            if ("PROCEDURE".equalsIgnoreCase(lexerToken.content)) {
                bl = false;
                break;
            }
            if ("FUNCTION".equalsIgnoreCase(lexerToken.content)) {
                bl = false;
                break;
            }
            if ("TRIGGER".equalsIgnoreCase(lexerToken.content)) {
                bl = false;
                break;
            }
            if ("TYPE".equalsIgnoreCase(lexerToken.content)) {
                bl = false;
                break;
            }
            if (!"BODY".equalsIgnoreCase(lexerToken.content)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private HashSet getTtProcedureList(final Connection connection) throws Exception {
        String string = TimesTenUtil.ttFullDotVersion(connection);
        HashSet<String> hashSet = (HashSet<String>)this.theTtVerProcList.get(string);
        if (hashSet != null) {
            return hashSet;
        }
        hashSet = new HashSet<String>();
        Callable<ResultSet> callable = new Callable<ResultSet>(){

            @Override
            public ResultSet call() throws Exception {
                ResultSet resultSet = null;
                Statement statement = connection.createStatement();
                resultSet = statement.executeQuery("call ttprocedures()");
                return resultSet;
            }
        };
        ResultSet resultSet = (ResultSet)callable.call();
        hashSet = new HashSet(120);
        while (resultSet.next()) {
            String string2 = resultSet.getString(3).trim().toLowerCase();
            hashSet.add(string2);
        }
        resultSet.close();
        this.theTtVerProcList.put(string, hashSet);
        return hashSet;
    }

    private boolean isUserPlsqlCode(String string, Connection connection) {
        try {
            String[] stringArray = string.split("\\s+");
            if (stringArray[0].equalsIgnoreCase("call")) {
                return !this.getTtProcedureList(connection).contains(stringArray[1]);
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBuiltInProcedureSql(ScriptRunnerContext scriptRunnerContext, final Connection connection, final String string) throws Exception {
        ResultSet resultSet;
        Connections connections;
        block46: {
            connections = Connections.getInstance();
            resultSet = null;
            boolean bl = false;
            try {
                connections.lock(connection);
                Callable<ResultSet> callable = new Callable<ResultSet>(){

                    @Override
                    public ResultSet call() throws Exception {
                        ResultSet resultSet = null;
                        Statement statement = connection.createStatement();
                        boolean bl = statement.execute(string);
                        if (bl) {
                            resultSet = statement.getResultSet();
                        }
                        return resultSet;
                    }
                };
                resultSet = (ResultSet)callable.call();
                boolean bl2 = false;
                if (resultSet != null && resultSet.getMetaData().getColumnCount() > 0) {
                    bl2 = this.processResultSet(resultSet, scriptRunnerContext, string);
                }
                if (!this.thePlsqlFlag) {
                    String string2 = string;
                    try {
                        String[] stringArray = string.toLowerCase().split("\\s+");
                        stringArray = BuiltInProcedure.removeEmptyString(stringArray);
                        String string3 = BuiltInProcedure.join1(stringArray, " ");
                        String string4 = stringArray[0];
                        if (stringArray.length >= 2) {
                            if (stringArray.length >= 4 && stringArray[1].equals("cache") || stringArray[2].equals("group")) {
                                string2 = string4 + " cache group";
                            } else if (string4.equals("create") || string4.equals("drop")) {
                                string2 = stringArray[0] + " " + stringArray[1];
                                if (stringArray.length >= 4) {
                                    if (stringArray[1].equals("cache") && stringArray[2].equals("group") || stringArray[1].equals("public") && stringArray[2].equals("synonym")) {
                                        string2 = string4 + " " + stringArray[1] + " " + stringArray[2];
                                    } else if (stringArray[1].equals("active") && stringArray[2].equals("standby") && stringArray[3].equals("pair")) {
                                        string2 = string4 + " active standby pair";
                                    } else if (string4.equals("create")) {
                                        if (stringArray[2].equals("cache") && stringArray[3].equals("group")) {
                                            string2 = "create cache group";
                                        } else if (stringArray[1].equals("or") && stringArray[2].equals("replace")) {
                                            string2 = string4 + " " + stringArray[3];
                                            if (stringArray.length >= 5 && stringArray[3].equals("package") && stringArray[4].equals("body")) {
                                                string2 = string2 + " body";
                                            }
                                        } else if (stringArray[1].equals("package") && stringArray[2].equals("body")) {
                                            string2 = "create package body";
                                        } else if (stringArray[1].equals("dynamic") || stringArray[1].equals("readonly") || stringArray[1].equals("asynchronous") || stringArray[1].equals("synchronous")) {
                                            string2 = "create cache group";
                                        }
                                    }
                                }
                            } else if (string4.equals("insert") || string4.equals("alter") || string4.equals("merge") || string4.equals("refresh") || string4.equals("commit") || string4.equals("grant") || string4.equals("revoke") || string4.equals("rollback") || string4.equals("update") || string4.equals("delete")) {
                                string2 = string4;
                                bl2 = false;
                            } else if (string4.equals("refresh") && stringArray.length >= 3) {
                                string2 = string4 + " " + stringArray[1] + " " + stringArray[2];
                            }
                        }
                        if (string3.startsWith("unique index")) {
                            string2 = string4 + " " + stringArray[1] + " " + stringArray[2];
                        } else if (string3.startsWith("or replace package body")) {
                            string2 = string4 + " or replace package body";
                        } else if (string3.startsWith("or replace")) {
                            string2 = string4 + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3];
                        } else if (string3.startsWith("materialized view log")) {
                            string2 = string4 + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3];
                        } else if (string3.startsWith("materialized view")) {
                            string2 = string4 + " " + stringArray[1] + " " + stringArray[2];
                        } else if (string3.startsWith("cache group")) {
                            string2 = string4 + " " + stringArray[1] + " " + stringArray[2];
                        } else if (string3.startsWith("package body")) {
                            string2 = string4 + " " + stringArray[1] + " " + stringArray[2];
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!bl2) {
                        scriptRunnerContext.getOutputStream().write((string2 + Messages.getString("BuiltInProcedure.Succeeded")).getBytes("UTF-8"));
                    }
                    break block46;
                }
                scriptRunnerContext.getOutputStream().write((oracle.dbtools.raptor.newscriptrunner.Messages.getString((String)"PLSQL.4") + "\n").getBytes("UTF-8"));
            }
            catch (Throwable throwable) {
                try {
                    connections.unlock(connection);
                    DBUtil.closeResultSet(resultSet);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            connections.unlock(connection);
            DBUtil.closeResultSet((ResultSet)resultSet);
        }
        catch (Exception exception) {}
    }

    private String processDbmsOutput1(ScriptRunnerContext scriptRunnerContext, Connection connection) throws Exception {
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        return dBUtil.getDBMSOUTPUT();
    }

    private boolean processResultSet(ResultSet resultSet, ScriptRunnerContext scriptRunnerContext, String string) throws Exception {
        MyResultSetModel myResultSetModel = new MyResultSetModel(resultSet);
        List list = myResultSetModel.generateASCIIOutput();
        for (String string2 : list) {
            scriptRunnerContext.getOutputStream().write(string2.getBytes("UTF-8"));
        }
        return list.size() > 0;
    }

    public static String toHexString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return BuiltInProcedure.toHexString(byArray, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        char[] cArray = new char[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            short s = (short)(0xFF & byArray[i]);
            cArray[n2++] = HEX_DIGITS[s / 16];
            cArray[n2++] = HEX_DIGITS[s % 16];
        }
        StringBuffer stringBuffer = new StringBuffer(cArray.length + 1);
        stringBuffer.append(cArray);
        if (stringBuffer.length() % 2 == 1) {
            stringBuffer.append("0");
        }
        String string = stringBuffer.toString();
        return string;
    }

    public static String convertTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(timestamp.getTime());
        calendar.set(14, timestamp.getNanos() / 1000000);
        boolean bl = false;
        if (calendar.get(0) == 0) {
            bl = true;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer stringBuffer = new StringBuffer(64);
        if (bl) {
            stringBuffer.append("-");
        }
        stringBuffer.append(simpleDateFormat.format(calendar.getTime()));
        stringBuffer.append(".");
        stringBuffer.append(timestamp.getNanos());
        return stringBuffer.toString();
    }

    public static String convertDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(date.getTime());
        boolean bl = false;
        if (calendar.get(0) == 0) {
            bl = true;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer stringBuffer = new StringBuffer(64);
        if (bl) {
            stringBuffer.append("-");
        }
        stringBuffer.append(simpleDateFormat.format(calendar.getTime()));
        return stringBuffer.toString();
    }

    public static String join1(String[] stringArray, String string) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < stringArray.length; ++i) {
            if (i > 1) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String[] removeEmptyString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0].length() != 0) {
            return stringArray;
        }
        return Arrays.copyOfRange(stringArray, 1, stringArray.length);
    }

    private class MyResultSetModel
    extends AbstractTableModel {
        private List<Object[]> theRows = new ArrayList<Object[]>(32);
        private String[] theColumnNames;
        private int[] theColumnOffset;
        private int[] theColumnWidth;
        private int theNoColumns;
        private int[] theSqlType;
        private int theMaxWidth;

        private MyResultSetModel(ResultSet resultSet) throws Exception {
            this.init(resultSet);
        }

        private void init(ResultSet resultSet) throws Exception {
            int n;
            int n2;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.theNoColumns = resultSetMetaData.getColumnCount();
            this.theColumnNames = new String[this.theNoColumns];
            this.theSqlType = new int[this.theNoColumns];
            this.theColumnWidth = new int[this.theNoColumns];
            this.theColumnOffset = new int[this.theNoColumns];
            for (n2 = 1; n2 <= this.theNoColumns; ++n2) {
                this.theColumnNames[n2 - 1] = resultSetMetaData.getColumnName(n2);
                this.theSqlType[n2 - 1] = resultSetMetaData.getColumnType(n2);
                if (this.theColumnNames[n2 - 1].length() <= this.theColumnWidth[n2 - 1]) continue;
                this.theColumnWidth[n2 - 1] = this.theColumnNames[n2 - 1].length();
            }
            n2 = 0;
            while (resultSet.next()) {
                Object[] objectArray = new Object[this.theNoColumns];
                for (int i = 1; i <= this.theNoColumns; ++i) {
                    int n3;
                    objectArray[i - 1] = resultSet.getObject(i);
                    if (this.theSqlType[i - 1] == -2 || this.theSqlType[i - 1] == -3 || this.theSqlType[i - 1] == 2004 || this.theSqlType[i - 1] == -4) {
                        objectArray[i - 1] = BuiltInProcedure.toHexString(resultSet.getBytes(i));
                    } else if (this.theSqlType[i - 1] == 91) {
                        objectArray[i - 1] = BuiltInProcedure.convertDate(resultSet.getDate(i));
                    } else if (this.theSqlType[i - 1] == 93) {
                        objectArray[i - 1] = BuiltInProcedure.convertTimestamp(resultSet.getTimestamp(i));
                    } else if (this.theSqlType[i - 1] == 2005) {
                        objectArray[i - 1] = resultSet.getString(i);
                        System.out.println(objectArray[i - 1]);
                    }
                    if (objectArray[i - 1] == null) {
                        objectArray[i - 1] = "(null)";
                    }
                    if ((n3 = objectArray[i - 1].toString().trim().length()) <= this.theColumnWidth[i - 1]) continue;
                    this.theColumnWidth[i - 1] = n3;
                }
                this.theRows.add(objectArray);
                ++n2;
            }
            this.theColumnOffset[0] = 0;
            for (n = 1; n < this.theNoColumns; ++n) {
                this.theColumnOffset[n] = this.theColumnOffset[n - 1] + this.theColumnWidth[n - 1] + 2;
            }
            this.theMaxWidth = this.theColumnOffset[n - 1] + this.theColumnWidth[n - 1] + 8;
        }

        private List<String> generateASCIIOutput() {
            int n;
            int n2;
            ArrayList<String> arrayList = new ArrayList<String>(this.theRows.size());
            char[] cArray = new char[this.theMaxWidth];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = 32;
            }
            String string = new String(cArray);
            StringBuffer stringBuffer = null;
            Object object = null;
            arrayList.add("\n");
            stringBuffer = new StringBuffer(string);
            for (int i = 0; i < this.theNoColumns; ++i) {
                stringBuffer.insert(this.theColumnOffset[i], this.theColumnNames[i]);
            }
            stringBuffer.append("\n");
            arrayList.add(stringBuffer.toString());
            char[] cArray2 = null;
            stringBuffer = new StringBuffer(string);
            for (n2 = 0; n2 < this.theNoColumns; ++n2) {
                cArray2 = new char[this.theColumnWidth[n2]];
                for (n = 0; n < cArray2.length; ++n) {
                    cArray2[n] = 45;
                }
                stringBuffer.insert(this.theColumnOffset[n2], cArray2);
            }
            stringBuffer.append("\n");
            arrayList.add(stringBuffer.toString());
            for (n2 = 0; n2 < this.theRows.size(); ++n2) {
                stringBuffer = new StringBuffer(string);
                for (n = 0; n < this.theNoColumns; ++n) {
                    object = this.theRows.get(n2)[n];
                    if (object == null) continue;
                    stringBuffer.insert(this.theColumnOffset[n], object.toString().trim());
                }
                stringBuffer.append("\n");
                arrayList.add(stringBuffer.toString());
            }
            if (this.theRows.size() > 1) {
                arrayList.add("\n" + this.theRows.size() + " rows selected\n");
            }
            return arrayList;
        }

        @Override
        public int getColumnCount() {
            return this.theColumnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.theRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > this.theNoColumns) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        @Override
        public String getColumnName(int n) {
            return this.theColumnNames[n];
        }
    }
}

