/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenPassthrough;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.connection.X10ConnectionProperties;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTableRow;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class Common {
    public static final int MAX_PARALLEL_LOADS = 16;
    public static final int MAX_IDX_LENGTH = 25;
    public static final int UNIQUE_VALUES = 8;
    public static final int SECONDS_TO_UPDATE_COUNT = 3;
    public static final int ORACLE_PASSWORD_ERROR = 15022;
    public static final int ROWS_NEEDED_FOR_PARALLEL_LOAD = 500000;
    public static final int DEFAULT_PARALLEL_THREAD_COUNT = 4;
    public static final int MINIMUM_PARALLEL_THREAD_COUNT = 2;
    public static final int DISABLE_PARALLEL_LOADS = 1;
    public static final int ENABLE_DEFAULT_PARALLEL_LOADS = 2;
    public static final int TABLE_ALREADY_EXIST = 2207;
    public static final int SPACE_EXHAUSTED_EXCEPTION = 802;
    public static final int ROOT = 1;
    public static final int SCHEMA = 2;
    public static final int TABLE = 3;
    public static final int ROW_COUNT_COL_IDX = 0;
    public static final int COMPRESSED_COL_IDX = 1;
    public static final int ORACLE_MAX_BYTES_COL_IDX = 2;
    public static final int TT_IL_BYTES_COL_IDX = 3;
    public static final int TT_MAX_OOL_BYTES_COL_IDX = 4;
    public static final int EST_UNCOMP_SIZE_COL_IDX = 5;
    public static final int EST_COMP_SIZE_COL_IDX = 6;
    public static final int COL_NAME_COL_IDX = 0;
    public static final int SKIPPED_COL_IDX = 1;
    public static final int NULLABLE_COL_IDX = 2;
    public static final int LEN_SEMANTICS_COL_IDX = 3;
    public static final int ORACLE_DATA_TYPE_COL_IDX = 4;
    public static final int ORACLE_PREC_COL_IDX = 5;
    public static final int ORACLE_SCALE_COL_IDX = 6;
    public static final int ORACLE_MAX_PREC_COL_IDX = 7;
    public static final int ORACLE_MAX_SCALE_COL_IDX = 8;
    public static final int ORACLE_DATA_LEN_COL_IDX = 9;
    public static final int ORACLE_CHAR_LEN_COL_IDX = 10;
    public static final int ORACLE_MAX_CHAR_LEN_COL_IDX = 11;
    public static final int TT_DATA_TYPE_COL_IDX = 12;
    public static final int TT_PREC_COL_IDX = 13;
    public static final int TT_SCALE_COL_IDX = 14;
    public static final int TT_DATA_LEN_COL_IDX = 15;
    public static final int TT_CHAR_LEN_COL_IDX = 16;
    public static final int COMP_POINTER_SIZE_COL_IDX = 17;
    public static final int DISTINCT_VALUES_COL_IDX = 18;
    public static final int OOL_FLAG_COL_IDX = 19;
    public static final int UNKNOWN_TYPE = 0;
    public static final int INVALID_TYPE = 1;
    public static final int TT_TYPE_VARCHAR2 = 2;
    public static final int TT_TYPE_NVARCHAR2 = 3;
    public static final int TT_TYPE_NUMBER = 4;
    public static final int TT_TYPE_FLOAT = 5;
    public static final int TT_TYPE_DATE = 6;
    public static final int TT_TYPE_BINARY_FLOAT = 7;
    public static final int TT_TYPE_BINARY_DOUBLE = 8;
    public static final int TT_TYPE_TIMESTAMP = 9;
    public static final int TT_TYPE_CHAR = 10;
    public static final int TT_TYPE_NCHAR = 11;
    public static final int TT_TYPE_CLOB = 12;
    public static final int TT_TYPE_NCLOB = 13;
    public static final int TT_TYPE_BLOB = 14;
    public static final int TT_TYPE_TINYINT = 15;
    public static final int TT_TYPE_SMALLINT = 16;
    public static final int TT_TYPE_INTEGER = 17;
    public static final int TT_TYPE_BIGINT = 18;
    public static final int TT_TYPE_VARBINARY = 19;
    public static final int ORA_TYPE_VARCHAR2 = 2;
    public static final int ORA_TYPE_NVARCHAR2 = 3;
    public static final int ORA_TYPE_NUMBER = 4;
    public static final int ORA_TYPE_FLOAT = 5;
    public static final int ORA_TYPE_DATE = 6;
    public static final int ORA_TYPE_BINARY_FLOAT = 7;
    public static final int ORA_TYPE_BINARY_DOUBLE = 8;
    public static final int ORA_TYPE_TIMESTAMP = 9;
    public static final int ORA_TYPE_TIMESTAMP_TZ = 10;
    public static final int ORA_TYPE_TIMESTAMP_LTZ = 11;
    public static final int ORA_TYPE_CHAR = 12;
    public static final int ORA_TYPE_NCHAR = 13;
    public static final int ORA_TYPE_CLOB = 14;
    public static final int ORA_TYPE_NCLOB = 15;
    public static final int ORA_TYPE_BLOB = 16;
    public static final int ORA_TYPE_RAW = 17;
    public static final int ORA_TYPE_LONG = 18;
    public static final int ORA_TYPE_LONG_RAW = 19;
    public static final int COMPRESS_VARIABLE = 2;
    public static final int INT_VALUE_NULL = -999999999;
    public static final int ORA_NUMBER_MAX_PRECISION = 38;
    public static final int SQLNAMELENMAX = 32;
    public static final Icon ERROR_ICON = OracleIcons.getIcon((String)"error.png");
    public static final Icon OK_ICON = OracleIcons.getIcon((String)"gutter/checkmark_status.png");
    public static final String CONNECTION_NAME = "connectionName";
    public static final String INDEX_CREATION_POLICY = "indexCreationPolicy";
    public static final String CREATE_INDEXES_IF_NO_ERRORS = "createIndexesIfNoErrors";
    public static final String QUERY = "query";
    public static final String ROW_COUNT = "rowCount";
    public static final String CREATE_TABLE_STMT = "createTableStmt";
    public static final String TT_USER = "ttUser";
    public static final String TT_TABLE = "ttTable";
    public static final String ORACLE_USER = "oracleUser";
    public static final String ORACLE_TABLE = "oracleTable";
    public static final String N_PARALLEL_LOADS = "nParallelLoads";
    public static final String NUMBER_OF_THREADS = "numberOfThreads";
    public static final String LOAD_OPTIONS = "loadOptions";
    public static final String DEFAULT = "default";
    public static final String ID = "id";
    public static final String STATUS = "status";
    public static final String ORACLE_SCN = "oracleSCN";
    public static final String PARALLEL_LOADS = "parallelLoads";
    public static final String LOADS = "loads";
    public static final String LOAD_ERRORS = "loadErrors";
    public static final String ERROR_CODE = "errorCode";
    public static final String ERROR_MSG = "errorMessage";
    public static final String TABLES = "tables";
    public static final String KEY_TABLES = "TABLES";
    public static final String KEY_INDEXPOLICY = "INDEX_CREATION_POLICY";
    public static final String KEY_DBOBJECT = "DBOBJECT";
    public static final String KEY_PASSTHROUGH = "TIMESTENPASSTHROUGH";
    public static final String KEY_ANALYSISPARAM = "ANALYSISPARAM";
    public static final String KEY_ADVANCED_MODE = "ADVANCED_MODE";
    public static final String KEY_LOAD_OPTIONS = "LOAD_OPTIONS";
    public static final String KEY_READY = "READY";
    public static final String ON_BAD_TYPE = "OnBadType";
    public static final String PARALLEL = "Parallel";
    public static final String NUM_MAPPING = "NumMapping";
    public static final String VAR_MAPPING = "VarMapping";
    public static final String RAW_MAPPING = "RawMapping";
    public static final String LOB_MAPPING = "LOBMapping";
    public static final String TIMESTAMP_MAPPING = "TSTZMapping";
    public static final String TYPE_MAPPING_PADDING = "TMPadding";
    public static final String COMPRESSION = "Compression";
    public static final String COMPRESSION_PADDING = "CPadding";
    public static final String COMPRESSION_FACTOR = "CFactor";
    public static final String COMPRESSION_MIN_ROWS = "CMinRows";
    public static final String INLINE_LIMIT = "InlineLimit";
    public static final String STOP_ANALYSIS = "Stop Analysis on any Bad Type";
    public static final String SKIP_COLUMNS = "Skip Columns with Bad Types";
    public static final String[] NUMBER_OPT = new String[]{"No Mapping", "Standard Mapping", "Aggressive Mapping"};
    public static final String[] RAW_LOB_TYPES_OPT = new String[]{"Treat as unsupported type", "Map to VAR*"};
    public static final String[] TIMESTAMP_OPT = new String[]{"Treat as unsupported type", "Map to TIMESTAMP"};
    public static final String[] VARCHAR2_OPT = new String[]{"No Mapping", "Aggressive Mapping"};
    public static final String[] COMPRESSION_OPT = new String[]{"No Compression", "Use Maximum Number of Distinct Values", "Use Optimal Number of Distinct Values"};
    public static final String COMMIT = "commit;";
    public static final String TT_IND_PREFIX = "SQLD_";
    public static final String GET_INDEXES = "SELECT OWNER, INDEX_NAME, INDEX_TYPE, TABLE_TYPE, UNIQUENESS FROM ALL_INDEXES WHERE TABLE_OWNER = '#towner#' AND TABLE_NAME = '#tname#' AND STATUS = 'VALID' and INDEX_TYPE IN ('NORMAL', 'FUNCTION-BASED NORMAL', 'BITMAP', 'IOT_TOP') AND TABLE_TYPE IN ('TABLE', 'VIEW') ORDER BY TABLE_OWNER, TABLE_NAME";
    public static final String GET_COLUMNS = "SELECT COLUMN_NAME, COLUMN_POSITION, DESCEND FROM ALL_IND_COLUMNS WHERE INDEX_OWNER = '#iowner#' AND INDEX_NAME = '#iname#' ORDER BY COLUMN_POSITION";
    public static final String GET_COL_EXPR = "SELECT COLUMN_EXPRESSION FROM ALL_IND_EXPRESSIONS WHERE INDEX_OWNER = '#iowner#' AND INDEX_NAME = '#iname#' AND COLUMN_POSITION = #colpos#";
    public static final String GET_PRIMARY_KEYS = "SELECT CONSTRAINT_NAME, INDEX_NAME FROM ALL_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'P' AND STATUS = 'ENABLED' AND VALIDATED = 'VALIDATED' AND OWNER = '#towner#' AND TABLE_NAME = '#tname#'";
    public static final String GET_UNIQUE_KEYS = "SELECT CONSTRAINT_NAME FROM ALL_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'U' AND STATUS = 'ENABLED' AND VALIDATED = 'VALIDATED' AND OWNER = '#towner#' AND TABLE_NAME = '#tname#'";
    public static final String EXIST_INDEX = "SELECT IXTYPE, ISUNIQUE, ISPRIMARY FROM SYS.INDEXES WHERE IXNAME = '#iname#' AND IXOWNER = '#iowner#' AND TBLID = #tblid#";
    public static final String UNIQUE_COL = "SELECT COLOPTIONS FROM SYS.COLUMNS WHERE ID = #id# AND COLNAME = '#colname#'";
    public static final String GET_TABLE_ID = "SELECT TBLID FROM SYS.TABLES WHERE TBLNAME = '#tname#' AND TBLOWNER = '#towner#'";
    public static final String GET_COL_NUM = "SELECT COLNUM FROM SYS.COLUMNS WHERE ID = #id# AND COLNAME = '#colname#'";
    public static final String GET_TT_IDX_NAME = "SELECT IXNAME FROM SYS.INDEXES WHERE TBLID = #tblid# AND KEYCOLS = 0x#keycols#";
    public static final String LOAD_TABLE_FROM_ORACLE = "call ttLoadFromOracle('#tblOwner#', '#tblName#', '#Query#', #numThreads# #options#);";
    public static final String USER_TABLES_UNFILTERED = "SELECT table_name FROM all_tables WHERE owner = '#user#'";
    public static final String USER_TABLES_FILTERED = "SELECT table_name FROM all_tables WHERE owner = '#user#' AND table_name #filter#";
    public static final String GET_CONSTRAINT_DATA = "SELECT AC.CONSTRAINT_NAME, AC.CONSTRAINT_TYPE, AC.R_CONSTRAINT_NAME, ACC.COLUMN_NAME, ACC.POSITION FROM ALL_CONSTRAINTS AC, ALL_CONS_COLUMNS ACC WHERE AC.OWNER = '#owner#' AND AC.STATUS = 'ENABLED' AND AC.VALIDATED = 'VALIDATED' AND AC.TABLE_NAME = '#table#' AND AC.CONSTRAINT_NAME = ACC.CONSTRAINT_NAME  AND AC.CONSTRAINT_TYPE IN ('P', 'R', 'U') ORDER BY AC.CONSTRAINT_TYPE, AC.CONSTRAINT_NAME, ACC.POSITION";
    public static final String TABLE_SELECT = "SELECT * from #schema#.#tableName#";
    public static final String TABLE_SCHEMA_LOAD_FROM_ORA = "call ttTableSchemaFromOraQueryGet('#owner#','#table#','#query#');";
    public static final String[] likeOptions = new String[]{"=", "<>", "LIKE", "NOT LIKE"};
    public static final String DO_PASSTHROUGH = "call ttOptSetFlag('PassThrough', 3);";
    public static final String REMOVE_PASSTHROUGH = "call ttOptSetFlag('PassThrough', 1);";
    public static final String ORA_HASH = " WHERE ORA_HASH(ROWID,#SEED#)=#SEEDCOUNT#";
    public static final String ORA_HASH_WITH_WHERE_CLAUSE = " WHERE ORA_HASH(ROWID,#SEED#)=#SEEDCOUNT# AND";
    public static final String UPDATE_TABLE_STATS = "call ttOptUpdateStats('#owner#.#table#', 1, 0);";
    public static final String TABLE_EXIST = "SELECT COUNT(1) FROM ALL_TABLES WHERE TABLE_NAME = UPPER('#TABLE#') AND OWNER = UPPER('#OWNER#')";
    public static final String MAX_PARALLEL_LOADS_PROP = "oracle.dbtools.raptor.timesten.maxparallelloads";
    private static final String VALID_QUERY_REGEX = "(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\")|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*\"[^\"]+\")|(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*\"[^\"]+\")";
    private static final String VALID_QUERY_REGEX_EXT = "(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\")|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*\"[^\"]+\")|(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*\"[^\"]+\")|(SELECT\\s+.+\\s+FROM\\s+[^\"\\s\\.]+)|(SELECT\\s+.+\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+.+\\s+FROM\\s+\"[^\"]+\")|(SELECT\\s+.+\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+.+\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*\"[^\"]+\")|(SELECT\\s+.+\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*\"[^\"]+\")|";
    public static final Icon SCHEMA_FOLDER_ICON = RaptorImagesArb.getIcon((String)"SCHEMA_FOLDER");
    public static final Icon TABLE_ICON = RaptorImagesArb.getIcon((String)"OTHER_TABLES");
    public static final Icon SCHEMA_ICON = RaptorImagesArb.getIcon((String)"SCHEMA");
    public static final Icon TABLE_FOLDER_ICON = RaptorImagesArb.getIcon((String)"TABLE_FOLDER");
    private static Boolean isAcadia = null;
    private static Boolean isGrid = null;
    public static final Pattern VALID_QUERY_PATTERN = Pattern.compile("(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\")|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*\"[^\"]+\")|(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*\"[^\"]+\")");
    public static final Pattern VALID_QUERY_PATTERN_EXT = Pattern.compile("(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\")|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*\"[^\"]+\")|(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*\"[^\"]+\")|(SELECT\\s+.+\\s+FROM\\s+[^\"\\s\\.]+)|(SELECT\\s+.+\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+.+\\s+FROM\\s+\"[^\"]+\")|(SELECT\\s+.+\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+.+\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*\"[^\"]+\")|(SELECT\\s+.+\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*\"[^\"]+\")|");
    private static final String EXT_ID = "oracle.sqldeveloper.timesten";
    private static final String ST_ERROR_LOG = "lfo_single_table_errlog.json";
    private static final String MT_ERROR_LOG = "lfo_multi_table_errlog.json";
    public static final String Y = "Y";
    public static final String N = "N";

    public static boolean validQuery(String string) {
        return VALID_QUERY_PATTERN_EXT.matcher(string.trim().toUpperCase()).matches();
    }

    public static String getOracleTableFromQuery(String string) {
        int n = -1;
        Matcher matcher = VALID_QUERY_PATTERN_EXT.matcher(string = string.trim().toUpperCase());
        if (matcher.matches()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (matcher.start(i) < 0) continue;
                n = i;
                break;
            }
        }
        if (n >= 0 && n < matcher.groupCount()) {
            switch (n) {
                case 1: 
                case 7: {
                    n = string.indexOf("FROM");
                    return string.substring(n + 4).trim();
                }
                case 2: 
                case 8: {
                    n = string.lastIndexOf(".");
                    return string.substring(n + 1).trim();
                }
                case 3: 
                case 9: {
                    n = string.indexOf("\"");
                    return string.substring(n);
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 11: 
                case 12: {
                    n = string.lastIndexOf(".");
                    return string.substring(n + 1).trim();
                }
            }
        }
        return null;
    }

    public static boolean isParallelLoadEnabled(int n) {
        return n > 1;
    }

    public static String getTableName(LoadTableRow loadTableRow) {
        if (loadTableRow != null) {
            return loadTableRow.getOracleUser().toUpperCase() + "." + Common.getOracleTableFromQuery(loadTableRow.getSelectQuery()).toUpperCase();
        }
        return null;
    }

    public static boolean isPropertyTrue(String string, DBObject dBObject) {
        X10ConnectionProperties x10ConnectionProperties = X10ConnectionProperties.getTheInstance();
        return Boolean.parseBoolean(x10ConnectionProperties.getProperty(Connections.getDisplayName((String)dBObject.getConnectionName()), string));
    }

    public static Boolean isAcadia() {
        return isAcadia;
    }

    public static Boolean isGrid() {
        return isGrid;
    }

    public static Boolean isNetworkTiomeoutSupported(Connection connection) throws SQLException {
        try {
            connection.getNetworkTimeout();
            return true;
        }
        catch (AbstractMethodError abstractMethodError) {
            return false;
        }
    }

    public static void setTTVersion(DBObject dBObject) {
        isAcadia = Common.isPropertyTrue("isAcadia", dBObject);
        isGrid = isAcadia != false ? Boolean.valueOf(TimesTenPlugInDatabaseImpl.isGridDatabase(dBObject.getConnection())) : Boolean.valueOf(false);
    }

    public static boolean isOkPassthrough(DBObject dBObject) {
        TimesTenPassthrough timesTenPassthrough = new TimesTenPassthrough(dBObject);
        try {
            timesTenPassthrough.executeQueryOnOracle("SELECT * FROM PRODUCT_COMPONENT_VERSION");
        }
        catch (SQLException sQLException) {
            MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(timesTenPassthrough.getConnection(), timesTenPassthrough.getLastError(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }

    static Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    static void saveErrorLog(List<LoadTableRow> list) {
        String string = Common.getErrLogFile(false);
        try {
            JsonWriter jsonWriter = Json.createWriter((Writer)new PrintWriter(string, "UTF-8"));
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            for (LoadTableRow loadTableRow : list) {
                if (loadTableRow.getLoadDataResult() == null || loadTableRow.getLoadDataResult().getErrors().size() <= 0) continue;
                JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
                jsonObjectBuilder2.add(TT_USER, loadTableRow.getTimesTenUser());
                jsonObjectBuilder2.add(TT_TABLE, loadTableRow.getTimesTenTable());
                jsonObjectBuilder2.add(ORACLE_USER, loadTableRow.getOracleUser());
                jsonObjectBuilder2.add(ORACLE_TABLE, loadTableRow.getOracleTable());
                JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
                for (LoadTableRow.LFOError lFOError : loadTableRow.getLoadDataResult().getErrors()) {
                    JsonObjectBuilder jsonObjectBuilder3 = Json.createObjectBuilder();
                    jsonObjectBuilder3.add(ERROR_CODE, lFOError.getErrorCode());
                    jsonObjectBuilder3.add(ERROR_MSG, lFOError.getErrorMessage());
                    jsonArrayBuilder2.add(jsonObjectBuilder3);
                }
                jsonObjectBuilder2.add(LOAD_ERRORS, jsonArrayBuilder2);
                jsonArrayBuilder.add(jsonObjectBuilder2);
            }
            jsonObjectBuilder.add(TABLES, jsonArrayBuilder);
            jsonWriter.writeObject(jsonObjectBuilder.build());
            jsonWriter.close();
        }
        catch (Exception exception) {
            Logger.getLogger(Common.class.getPackage().getName()).severe(MessageFormat.format(Messages.getString("LoadTablesFromOracle.saveFileError"), string) + ": " + exception.getMessage());
        }
    }

    static void saveErrorLog(String string, String string2, String string3, LoadTableRow.LoadDataResult loadDataResult) {
        String string4 = Common.getErrLogFile(true);
        try {
            JsonWriter jsonWriter = Json.createWriter((Writer)new PrintWriter(string4, "UTF-8"));
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            jsonObjectBuilder.add(TT_USER, string);
            jsonObjectBuilder.add(TT_TABLE, string2);
            jsonObjectBuilder.add(ORACLE_USER, string);
            jsonObjectBuilder.add(ORACLE_TABLE, string3);
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            for (LoadTableRow.LFOError lFOError : loadDataResult.getErrors()) {
                JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
                jsonObjectBuilder2.add(ERROR_CODE, lFOError.getErrorCode());
                jsonObjectBuilder2.add(ERROR_MSG, lFOError.getErrorMessage());
                jsonArrayBuilder.add(jsonObjectBuilder2);
            }
            jsonObjectBuilder.add(LOAD_ERRORS, jsonArrayBuilder);
            jsonWriter.writeObject(jsonObjectBuilder.build());
            jsonWriter.close();
        }
        catch (Exception exception) {
            Logger.getLogger(Common.class.getPackage().getName()).severe(MessageFormat.format(Messages.getString("LoadTablesFromOracle.saveFileError"), string4) + ": " + exception.getMessage());
        }
    }

    private static String getErrLogFile(boolean bl) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        URL uRL = extensionRegistry.getSystemDirectory(EXT_ID);
        URL uRL2 = URLFactory.newURL((URL)uRL, (String)(bl ? ST_ERROR_LOG : MT_ERROR_LOG));
        return uRL2.getFile();
    }

    public static enum TableInfoRowIdx {
        ROW_COUNT(0),
        COMPRESSED(1),
        ORACLE_MAX_BYTES(2),
        TT_INLINE_BYTES(3),
        TT_MAX_OUT_OF_LINE_BYTES(4),
        ESTIMATED_UNCOMPRESSED_SIZE(5),
        ESTIMATED_COMPRESSED_SIZE(6);

        private final int value;

        private TableInfoRowIdx(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ColIdx {
        USERNAME(0),
        TABLENAME(1),
        QUERY(2),
        ROWCOUNT(3),
        ONLY_CREATE_TABLE(4),
        CREATE(5),
        DISTRIBUTION(6),
        STATUS(7);

        private final int value;

        private ColIdx(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum LoadStatus {
        FATAL_ERROR(-3),
        ERROR(-2),
        LOADED_ERROR(-1),
        CREATED(0),
        LOADED(1),
        WAITING(2),
        IN_PROGRESS(3),
        SQL_EXCEPTION(4),
        CANCELLED(5);

        private final int value;

        private LoadStatus(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        String getStatusMessage() {
            return this.getStatusMessage(false);
        }

        String getStatusMessage(boolean bl) {
            switch (this) {
                case FATAL_ERROR: {
                    return bl ? Messages.getString("LoadTablesFromOracle.fatalErrExt") : Messages.getString("LoadTablesFromOracle.fatalErr");
                }
                case ERROR: {
                    return bl ? Messages.getString("LoadTablesFromOracle.errExt") : Messages.getString("LoadTablesFromOracle.err");
                }
                case LOADED_ERROR: {
                    return bl ? Messages.getString("LoadTablesFromOracle.loadedErrExt") : Messages.getString("LoadTablesFromOracle.loadedErr");
                }
                case CREATED: {
                    return bl ? Messages.getString("LoadTablesFromOracle.tableCreatedExt") : Messages.getString("LoadTablesFromOracle.tableCreated");
                }
                case LOADED: {
                    return bl ? Messages.getString("LoadTablesFromOracle.loadedExt") : Messages.getString("LoadTablesFromOracle.loaded");
                }
                case IN_PROGRESS: {
                    return Messages.getString("LoadTablesFromOracle.inProgress");
                }
                case CANCELLED: {
                    return Messages.getString("LoadTablesFromOracle.cancelled");
                }
            }
            return "";
        }
    }
}

