/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenPassthrough;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadOptions;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTableRow;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTablesTable;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoaderPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.StatusPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.TableRefresher;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;

public class LoadSummaryTraversablePanel
extends DefaultTraversablePanel
implements TableRefresher,
LoaderPanel {
    private static final long serialVersionUID = 1L;
    private LoadPanel _panel;
    private LoadTablesTable _loadTable;
    private boolean initialized;
    private TraversableContext dataContext;

    public void onEntry(TraversableContext traversableContext) {
        this.dataContext = traversableContext;
        if (!this.initialized) {
            this.init((DBObject)traversableContext.get("DBOBJECT"));
            this.displayInfo();
        }
        if (this._loadTable.getRowCount() > 0) {
            this._loadTable.setRowSelectionInterval(0, 0);
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.saveProfileIfRequired();
    }

    public void saveProfileIfRequired() {
        if (Common.isAcadia().booleanValue()) {
            List<LoadTableRow> list = this._loadTable.getData();
            for (LoadTableRow loadTableRow : list) {
                if (loadTableRow.getLoadDataResult() == null || loadTableRow.getLoadDataResult().getErrors().size() <= 0) continue;
                if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)Messages.getString("LoadTablesFromOracle.errorSaveProfileConfirm"), (String)Messages.getString("LoadTablesFromOracle.saveProfile"), null, (boolean)true)) {
                    StatusPanel statusPanel = this._panel.getStatusPanel();
                    statusPanel.saveProfile();
                }
                Common.saveErrorLog(this._loadTable.getData());
                return;
            }
        }
    }

    private void init(DBObject dBObject) {
        this.setLayout(new BorderLayout());
        this._loadTable = new LoadTablesTable(this, dBObject, false);
        this._panel = new LoadPanel(this._loadTable, true);
        this.add(this._panel, "Center");
        this.initialized = true;
    }

    private void displayInfo() {
        List list = (List)this.dataContext.get("TABLES");
        for (LoadTableRow loadTableRow : list) {
            this._loadTable.addRow(loadTableRow);
        }
        this._loadTable.refreshTheCompleteTable();
    }

    @Override
    public void refreshTheCompleteTable() {
        this._loadTable.refreshTheCompleteTable();
    }

    @Override
    public void refreshRow(int n) {
        this._loadTable.refreshRow(n);
    }

    public TraversableContext getDataContext() {
        return this.dataContext;
    }

    @Override
    public LoadOptions getLoadOptions() {
        return (LoadOptions)this.dataContext.get("LOAD_OPTIONS");
    }

    @Override
    public TimesTenPassthrough getPassthrough() {
        return (TimesTenPassthrough)this.dataContext.get("TIMESTENPASSTHROUGH");
    }

    @Override
    public Component getLoadComponent() {
        return this;
    }

    @Override
    public void updateOnFinish() {
    }
}

