/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableColsJTable;
import oracle.dbtools.raptor.timesten.editors.TimesTenViewerContextMenu;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Element;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;

abstract class TTTableViewer
extends AsynchronousViewerEditor
implements DbEditor {
    static TTTableViewer _lastViewerUpdated = null;
    protected BasicEditorPane _code;
    protected DBObject _lastdbObject;
    protected DBObject _dbObject;
    protected IdeAction _refreshAction;
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_TE_Editor");
    private static final Logger __logger = Logger.getLogger(TTTableViewer.class.getPackage().getName());
    protected JTable _table;
    protected JScrollPane _scrollPane;

    TTTableViewer() {
    }

    protected abstract String GetPurposeTxt();

    protected void createTable() {
        this._table = new JTable();
        this._table.setAutoResizeMode(0);
        this._table.setRowSelectionAllowed(false);
        this._table.setColumnSelectionAllowed(false);
        this.postCreateHook();
    }

    protected void postCreateHook() {
        this._table.setAutoResizeMode(0);
        TimesTenViewerContextMenu.attachMenu(this._table);
    }

    protected abstract void createTableModel() throws Exception;

    protected JComponent createViewerUI() {
        this.createTable();
        this._scrollPane = new JScrollPane(this._table, 22, 32);
        this._refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)"Refresh", null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true);
        this._refreshAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                TTTableViewer.this.updateContent(true);
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return false;
            }
        });
        TTTableViewer.invokeLaterAfterRepaint((Runnable)new Runnable(){

            @Override
            public void run() {
                Toolbar toolbar = (Toolbar)UIUtils.findFirstOfType((JComponent)((JComponent)TTTableViewer.this.getFixedTopMargin()), Toolbar.class);
                toolbar.add((ToggleAction)TTTableViewer.this._refreshAction.newLocalAction((View)TTTableViewer.this));
            }
        });
        return this._scrollPane;
    }

    protected String getBinds() {
        return null;
    }

    protected void updateContent() {
        this.updateContent(false);
    }

    protected void updateContent(boolean bl) {
        __logger.log(Level.INFO, this.GetPurposeTxt() + " updateContent: " + bl);
        if (!bl) {
            _lastViewerUpdated = this;
            __logger.log(Level.INFO, "_lastViewerUpdated: " + (Object)((Object)_lastViewerUpdated));
        } else if (_lastViewerUpdated != null && _lastViewerUpdated != this) {
            TTTableViewer.forceUpdateLastViewer();
        }
        ViewerNode viewerNode = this.getViewerNode();
        if (viewerNode != null) {
            this._dbObject = new DBObject((Element)this.getViewerNode());
        }
        if (bl || this._dbObject != null && (this._lastdbObject == null || this._lastdbObject.getObjectName() != this._dbObject.getObjectName())) {
            try {
                this.createTableModel();
            }
            catch (Exception exception) {
                __logger.log(Level.SEVERE, "Generating " + this.GetPurposeTxt() + " failed");
                if (exception instanceof SQLException) {
                    MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(this._dbObject.getConnectionName(), null, (SQLException)exception), (String)Messages.getString("TimesTen.common.error"), null);
                }
                MessageDialog.error(null, (Object)exception.getMessage(), (String)Messages.getString("TimesTen.common.error"), null);
            }
            this._lastdbObject = this._dbObject;
            CGCTableColsJTable.initColumnWidth(this._table, true);
        }
    }

    public static boolean forceUpdateLastViewer() {
        __logger.log(Level.INFO, "forceUpdateLastViewer: " + (Object)((Object)_lastViewerUpdated));
        try {
            _lastViewerUpdated.updateContent(true);
        }
        catch (Exception exception) {
            __logger.log(Level.WARNING, "forceUpdateLastViewer failed");
            return false;
        }
        return true;
    }

    public Object getPrintable() {
        return this._scrollPane;
    }

    protected void cleanUp() {
        this._table = null;
        this._scrollPane = null;
    }

    public String getConnectionName() {
        return this._dbObject.getConnectionName();
    }
}

