/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.JButton;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InvalidInputException;
import oracle.dbtools.raptor.timesten.grid.object.TTGridObject;
import oracle.dbtools.raptor.timesten.grid.topology.Topology;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyElement;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyPanel;
import oracle.ide.Ide;

public class DSGAssignmentPanel
extends TTGUIBasePanel {
    private static Logger _logger = Logger.getLogger(DSGAssignmentPanel.class.getName());
    private JButton _suggestButton;
    private TopologyPanel _topologyPanel;
    private Topology topology;

    public DSGAssignmentPanel() {
        if (this.grid != null) {
            this.topology = this.grid.getHostTopology();
        }
        this.init();
    }

    public void setTopology(Topology topology) {
        this.topology = topology;
        this._topologyPanel.setTopology(topology);
        this._topologyPanel.updateDraw();
    }

    public JButton getSuggestButton() {
        return this._suggestButton;
    }

    public void validInput() throws InvalidInputException {
        if (this.topology.getKSafety() > 1 && !this.sameNumberOfInstances()) {
            throw new InvalidInputException(Messages.getString("TimesTenGrid.unbalancedDSGs"));
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this._suggestButton = new JButton(Messages.getString("TimesTenGrid.suggestAssignment"));
        this._suggestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DSGAssignmentPanel.this.getSuggestions();
            }
        });
        this._suggestButton.setName(Messages.getString("TimesTenGrid.suggestAssignment"));
        this._topologyPanel = new TopologyPanel(this.topology, false);
        if (this.topology != null) {
            this._topologyPanel.updateDraw();
        }
        this.add((Component)((Object)this._topologyPanel), "Center");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._okButton) {
            try {
                this.validInput();
            }
            catch (InvalidInputException invalidInputException) {
                Common.displayErrorMsg(this, invalidInputException.getMessage());
                return;
            }
            this.modifyHosts();
        }
    }

    private boolean sameNumberOfInstances() {
        int n = this.topology.getKSafety();
        int n2 = this.topology.getElementsInTopologyHideRemoved(1).size();
        for (int i = 0; i < n; ++i) {
            if (this.topology.getElementsInTopologyHideRemoved(i + 1).size() == n2) continue;
            return false;
        }
        return true;
    }

    private void modifyHosts() {
        this._progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.assignToDSG"), Messages.getString("TimesTenGrid.assigningToDSG"), null);
        this._progressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            boolean atLeastOneHostModified;

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    Object object;
                    DSGAssignmentPanel.this._progressMonitor.start();
                    this.atLeastOneHostModified = false;
                    for (int i = 1; i <= DSGAssignmentPanel.this.grid.getProperties().getK(); ++i) {
                        for (TopologyElement topologyElement2 : DSGAssignmentPanel.this.topology.getElementsMarkedToAddInDSG(i)) {
                            if (i == topologyElement2.getDataSpaceGroup()) continue;
                            object = (HostObject)topologyElement2;
                            this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.modifyingHost"), ((HostObject)object).toString()));
                            GridCommand gridCommand = GridCommand.ASSIGN_HOST_DSG;
                            gridCommand.prepareCommand(((TTGridObject)object).getName(), String.valueOf(i));
                            DSGAssignmentPanel.this.grid.getExecutor().executeCommandGetString(gridCommand, true);
                            this.atLeastOneHostModified = true;
                        }
                    }
                    for (TopologyElement topologyElement : DSGAssignmentPanel.this.topology.getToRemove()) {
                        TopologyElement topologyElement2;
                        topologyElement2 = (HostObject)topologyElement;
                        this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.modifyingHost"), ((HostObject)topologyElement2).toString()));
                        object = GridCommand.ASSIGN_HOST_NODSG;
                        ((GridCommand)((Object)object)).prepareCommand(((TTGridObject)((Object)topologyElement2)).getName());
                        DSGAssignmentPanel.this.grid.getExecutor().executeCommandGetString((GridCommand)((Object)object), true);
                        this.atLeastOneHostModified = true;
                    }
                    if (this.atLeastOneHostModified) {
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.assignedToDSG"));
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                        DSGAssignmentPanel.this.grid.setGridComponents(DSGAssignmentPanel.this.grid.getExecutor().executeCommandGetJson(GridCommand.EXPORT_MODEL, true), false);
                    }
                    this.firePropertyChange("progress", null, 100);
                }
                catch (JsonException | GridCommandException throwable) {
                    _logger.log(Level.SEVERE, throwable.getMessage());
                    this.firePropertyChange("error", null, throwable.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.assignmentCancelled"));
                    DSGAssignmentPanel.this._progressMonitor.finish();
                    DSGAssignmentPanel.this._progressMonitor.updateMessage(Messages.getString("TimesTenGrid.assignmentCancelled"));
                } else {
                    DSGAssignmentPanel.this._progressMonitor.close();
                    DSGAssignmentPanel.this.showModelNeedsApplyWarning();
                    DSGAssignmentPanel.this._dialog.dispose();
                }
            }
        };
        swingWorker.addPropertyChangeListener(this._progressMonitor);
        this._progressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    private void getSuggestions() {
        this._progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.suggestAssignment"), Messages.getString("TimesTenGrid.gettingSuggestions"), null);
        this._progressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    DSGAssignmentPanel.this._progressMonitor.start();
                    DSGAssignmentPanel.this.topology.clearChanges();
                    JsonObject jsonObject = DSGAssignmentPanel.this.grid.getExecutor().executeCommandGetJson(GridCommand.DSG_SUGGEST, true);
                    JsonObject jsonObject2 = jsonObject.getJsonObject("recommendations");
                    for (TopologyElement topologyElement : DSGAssignmentPanel.this.topology.getNotInTopology()) {
                        HostObject hostObject = (HostObject)topologyElement;
                        try {
                            String string = jsonObject2.getString(hostObject.getName());
                            if (string == null) continue;
                            DSGAssignmentPanel.this.topology.markToAdd(topologyElement, Integer.parseInt(string));
                        }
                        catch (Exception exception) {}
                    }
                    this.firePropertyChange("progress", null, 100);
                }
                catch (GridCommandException gridCommandException) {
                    _logger.log(Level.SEVERE, gridCommandException.getMessage());
                    this.firePropertyChange("error", null, gridCommandException.getMessage());
                    this.cancel(true);
                }
                catch (JsonException jsonException) {
                    _logger.log(Level.SEVERE, jsonException.getMessage());
                    this.firePropertyChange("error", null, jsonException.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.isCancelled()) {
                    DSGAssignmentPanel.this._progressMonitor.finish();
                    DSGAssignmentPanel.this._progressMonitor.updateMessage(Messages.getString("TimesTenGrid.suggestionCancelled"));
                } else {
                    DSGAssignmentPanel.this._progressMonitor.close();
                    DSGAssignmentPanel.this._topologyPanel.updateDraw();
                }
            }
        };
        swingWorker.addPropertyChangeListener(this._progressMonitor);
        this._progressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }
}

