/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.SSHChannel;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.MySSHException;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;

public class PasswordlessSSHTestPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = Logger.getLogger(PasswordlessSSHTestPanel.class.getPackage().getName());
    private List<String> hostList;
    private List<String> orderedHostList;
    private String firstHostAddress;
    private String admin;
    private char[] adminPass;
    private List<String> testResultDetailMsgList;
    private List<String> testResultGlobalMsgList;
    private JEWTDialog _containerDialog;
    private JSplitPane _splitPane;
    private int selectedHostIdx;
    private boolean testRunning = false;
    private ConfigurationPanel configPanel;
    private DetailsPanel detailsPanel;

    public void setDialog(JEWTDialog jEWTDialog) {
        this._containerDialog = jEWTDialog;
        this._containerDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PasswordlessSSHTestPanel.this.detailsPanel.cancelWorker();
                super.windowClosing(windowEvent);
            }
        });
        jEWTDialog.setSize(600, 700);
    }

    public PasswordlessSSHTestPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.configPanel = new ConfigurationPanel();
        this.detailsPanel = new DetailsPanel();
        this.testResultDetailMsgList = new ArrayList<String>();
        this.testResultGlobalMsgList = new ArrayList<String>();
        this._splitPane = new JSplitPane(0, this.configPanel, this.detailsPanel);
        this._splitPane.setDividerLocation(0.75);
        this._splitPane.setResizeWeight(0.75);
        this._splitPane.setOneTouchExpandable(true);
        this.add(this._splitPane);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    static /* synthetic */ char[] access$1602(PasswordlessSSHTestPanel passwordlessSSHTestPanel, char[] cArray) {
        passwordlessSSHTestPanel.adminPass = cArray;
        return cArray;
    }

    private class DetailsPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private JTable _detailsTable;
        private JScrollPane _scrollPane;
        private JButton _tryBtn;
        private SwingWorker<Void, Void> wrkr;
        private ResultsTableModel _detailsTableModel;
        private final int FROM_COL = 0;
        private final int TO_COL = 1;
        private final int RES_COL = 2;
        private final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.connFrom"), Messages.getString("TimesTenGrid.connTo"), Messages.getString("TimesTenGrid.resultCol")};

        public DetailsPanel() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this._detailsTableModel = new ResultsTableModel();
            this._detailsTable = new JTable(this._detailsTableModel){
                private static final long serialVersionUID = 1L;

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    String string = "";
                    Point point = mouseEvent.getPoint();
                    int n = this.rowAtPoint(point);
                    int n2 = this.columnAtPoint(point);
                    try {
                        switch (n2) {
                            case 0: 
                            case 1: {
                                string = DetailsPanel.this._detailsTable.getValueAt(n, n2).toString();
                                break;
                            }
                            case 2: {
                                string = n < PasswordlessSSHTestPanel.this.testResultDetailMsgList.size() ? (String)PasswordlessSSHTestPanel.this.testResultDetailMsgList.get(PasswordlessSSHTestPanel.this.selectedHostIdx * PasswordlessSSHTestPanel.this.hostList.size() + n) : null;
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        _logger.log(Level.INFO, runtimeException.getMessage());
                    }
                    return string;
                }
            };
            this._scrollPane = new JScrollPane(this._detailsTable);
            this._tryBtn = new JButton(Messages.getString("TimesTenGrid.test"));
            this._tryBtn.setName(Messages.getString("TimesTenGrid.test"));
            this._scrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.detailsLbl")));
            this.add((Component)this._scrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 15, 5, 15), 0, 0));
            this.add((Component)this._tryBtn, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 22, 0, new Insets(10, 0, 10, 10), 0, 0));
            this._tryBtn.addActionListener(this);
        }

        public boolean isInformationComplete() {
            boolean bl3 = PasswordlessSSHTestPanel.this.hostList.stream().map(string -> !string.isEmpty()).reduce(true, (bl, bl2) -> bl != false && bl2 != false);
            boolean bl4 = PasswordlessSSHTestPanel.this.configPanel.getAdminPass().length > 0 && !PasswordlessSSHTestPanel.this.configPanel.getAdmin().isEmpty() && PasswordlessSSHTestPanel.this.hostList.size() > 0 && bl3;
            PasswordlessSSHTestPanel.this.orderedHostList.clear();
            PasswordlessSSHTestPanel.this.firstHostAddress = (String)PasswordlessSSHTestPanel.this.hostList.get(0);
            for (int i = 0; i < PasswordlessSSHTestPanel.this.hostList.size(); ++i) {
                PasswordlessSSHTestPanel.this.orderedHostList.add(PasswordlessSSHTestPanel.this.hostList.get(i));
            }
            PasswordlessSSHTestPanel.this.admin = PasswordlessSSHTestPanel.this.configPanel.getAdmin();
            PasswordlessSSHTestPanel.access$1602(PasswordlessSSHTestPanel.this, PasswordlessSSHTestPanel.this.configPanel.getAdminPass());
            return bl4;
        }

        private int getUnorderedHostsIdx(int n) {
            for (int i = 0; i < PasswordlessSSHTestPanel.this.hostList.size(); ++i) {
                if (!((String)PasswordlessSSHTestPanel.this.hostList.get(i)).equalsIgnoreCase((String)PasswordlessSSHTestPanel.this.orderedHostList.get(n))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PasswordlessSSHTestPanel.this.testRunning) {
                return;
            }
            if (!this.isInformationComplete()) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.infoEmpty"));
                return;
            }
            this.wrkr = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    int n;
                    DetailsPanel.this._tryBtn.setEnabled(false);
                    PasswordlessSSHTestPanel.this.configPanel.getAddHostBtn().setEnabled(false);
                    PasswordlessSSHTestPanel.this.configPanel.getRemoveHostBtn().setEnabled(false);
                    PasswordlessSSHTestPanel.this.configPanel.clearResultMsgs();
                    PasswordlessSSHTestPanel.this.testRunning = true;
                    ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
                    PasswordlessSSHTestPanel.this.selectedHostIdx = 0;
                    PasswordlessSSHTestPanel.this.testResultDetailMsgList.clear();
                    for (n = 0; n < PasswordlessSSHTestPanel.this.orderedHostList.size() * PasswordlessSSHTestPanel.this.orderedHostList.size(); ++n) {
                        PasswordlessSSHTestPanel.this.testResultDetailMsgList.add(new String(Messages.getString("TimesTenGrid.notTested")));
                    }
                    try {
                        PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(PasswordlessSSHTestPanel.this.selectedHostIdx), MessageFormat.format(Messages.getString("TimesTenGrid.testingFirstHostConn"), PasswordlessSSHTestPanel.this.firstHostAddress));
                        PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                        SSHChannel.tryConnect(PasswordlessSSHTestPanel.this.firstHostAddress, PasswordlessSSHTestPanel.this.admin, PasswordlessSSHTestPanel.this.adminPass);
                        PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(PasswordlessSSHTestPanel.this.selectedHostIdx), Messages.getString("TimesTenGrid.firstHostConnOk"));
                        PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                        arrayList.add(true);
                    }
                    catch (MySSHException mySSHException) {
                        _logger.log(Level.SEVERE, mySSHException.getMessage());
                        PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(PasswordlessSSHTestPanel.this.selectedHostIdx), MessageFormat.format(Messages.getString("TimesTenGrid.cantConnectToHost"), mySSHException.getMessage()));
                        PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                        this.cancel(true);
                        return null;
                    }
                    for (n = 0; n < PasswordlessSSHTestPanel.this.orderedHostList.size() && !this.isCancelled(); ++n) {
                        block21: {
                            try {
                                PasswordlessSSHTestPanel.this.testResultDetailMsgList.set(n, Messages.getString("TimesTenGrid.connectingLbl"));
                                SSHChannel.testPasswordless(PasswordlessSSHTestPanel.this.firstHostAddress, PasswordlessSSHTestPanel.this.admin, PasswordlessSSHTestPanel.this.adminPass, (String)PasswordlessSSHTestPanel.this.orderedHostList.get(n));
                                PasswordlessSSHTestPanel.this.testResultDetailMsgList.set(n, Messages.getString("TimesTenGrid.validAttribute"));
                                if (n != 0) {
                                    arrayList.add(true);
                                }
                            }
                            catch (MySSHException mySSHException) {
                                PasswordlessSSHTestPanel.this.testResultDetailMsgList.set(n, MessageFormat.format(Messages.getString("TimesTenGrid.cantConnectToHost"), mySSHException.getMessage()));
                                if (n == 0) break block21;
                                arrayList.add(false);
                            }
                        }
                        PasswordlessSSHTestPanel.this.detailsPanel.detailsDataChanged();
                    }
                    if (arrayList.stream().reduce(true, (bl, bl2) -> bl != false && bl2 != false).booleanValue()) {
                        PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(PasswordlessSSHTestPanel.this.selectedHostIdx), Messages.getString("TimesTenGrid.validAttribute"));
                    } else {
                        PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(PasswordlessSSHTestPanel.this.selectedHostIdx), Messages.getString("TimesTenGrid.partFailed"));
                    }
                    for (n = 1; n < PasswordlessSSHTestPanel.this.orderedHostList.size(); ++n) {
                        PasswordlessSSHTestPanel.this.selectedHostIdx = n;
                        PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(PasswordlessSSHTestPanel.this.selectedHostIdx), Messages.getString("TimesTenGrid.testingConnOther"));
                        PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                        boolean bl3 = true;
                        for (int i = 0; i < PasswordlessSSHTestPanel.this.orderedHostList.size() && !this.isCancelled(); ++i) {
                            PasswordlessSSHTestPanel.this.testResultDetailMsgList.set(n * PasswordlessSSHTestPanel.this.orderedHostList.size() + i, Messages.getString("TimesTenGrid.connectingLbl"));
                            PasswordlessSSHTestPanel.this.detailsPanel.detailsDataChanged();
                            if (((Boolean)arrayList.get(n)).booleanValue()) {
                                try {
                                    SSHChannel.testPasswordless(PasswordlessSSHTestPanel.this.firstHostAddress, PasswordlessSSHTestPanel.this.admin, PasswordlessSSHTestPanel.this.adminPass, (String)PasswordlessSSHTestPanel.this.orderedHostList.get(n), (String)PasswordlessSSHTestPanel.this.orderedHostList.get(i));
                                    PasswordlessSSHTestPanel.this.testResultDetailMsgList.set(n * PasswordlessSSHTestPanel.this.orderedHostList.size() + i, Messages.getString("TimesTenGrid.validAttribute"));
                                    bl3 = bl3;
                                }
                                catch (MySSHException mySSHException) {
                                    PasswordlessSSHTestPanel.this.testResultDetailMsgList.set(n * PasswordlessSSHTestPanel.this.orderedHostList.size() + i, MessageFormat.format(Messages.getString("TimesTenGrid.cantConnectToHost"), mySSHException.getMessage()));
                                    if (bl3) {
                                        // empty if block
                                    }
                                    bl3 = false;
                                }
                            } else {
                                PasswordlessSSHTestPanel.this.testResultDetailMsgList.set(n * PasswordlessSSHTestPanel.this.orderedHostList.size() + i, MessageFormat.format(Messages.getString("TimesTenGrid.connFirstHostFailed"), PasswordlessSSHTestPanel.this.firstHostAddress));
                                if (bl3) {
                                    // empty if block
                                }
                                bl3 = false;
                            }
                            PasswordlessSSHTestPanel.this.detailsPanel.detailsDataChanged();
                        }
                        if (!((Boolean)arrayList.get(n)).booleanValue()) {
                            PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(PasswordlessSSHTestPanel.this.selectedHostIdx), MessageFormat.format(Messages.getString("TimesTenGrid.connFirstHostFailed"), PasswordlessSSHTestPanel.this.firstHostAddress));
                        } else if (bl3) {
                            PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(PasswordlessSSHTestPanel.this.selectedHostIdx), Messages.getString("TimesTenGrid.validAttribute"));
                        } else {
                            PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(PasswordlessSSHTestPanel.this.selectedHostIdx), Messages.getString("TimesTenGrid.partFailed"));
                        }
                        PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                    }
                    PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                    return null;
                }

                @Override
                protected void done() {
                    DetailsPanel.this._tryBtn.setEnabled(true);
                    PasswordlessSSHTestPanel.this.configPanel.getAddHostBtn().setEnabled(true);
                    PasswordlessSSHTestPanel.this.configPanel.getRemoveHostBtn().setEnabled(true);
                    PasswordlessSSHTestPanel.this.testRunning = false;
                }
            };
            this.wrkr.execute();
        }

        public void cancelWorker() {
            if (this.wrkr != null) {
                this.wrkr.cancel(true);
            }
        }

        public void detailsDataChanged() {
            if (SwingUtilities.isEventDispatchThread()) {
                this._detailsTableModel.fireTableDataChanged();
            } else {
                try {
                    SwingUtilities.invokeAndWait(() -> this._detailsTableModel.fireTableDataChanged());
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    _logger.log(Level.SEVERE, exception.getMessage());
                }
            }
        }

        private class ResultsTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;

            private ResultsTableModel() {
            }

            @Override
            public int getRowCount() {
                return PasswordlessSSHTestPanel.this.orderedHostList.size();
            }

            @Override
            public int getColumnCount() {
                return DetailsPanel.this.HEADER.length;
            }

            @Override
            public String getColumnName(int n) {
                return DetailsPanel.this.HEADER[n];
            }

            @Override
            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return PasswordlessSSHTestPanel.this.orderedHostList.get(PasswordlessSSHTestPanel.this.selectedHostIdx);
                    }
                    case 1: {
                        return PasswordlessSSHTestPanel.this.orderedHostList.get(n % PasswordlessSSHTestPanel.this.orderedHostList.size());
                    }
                    case 2: {
                        return n < PasswordlessSSHTestPanel.this.testResultDetailMsgList.size() ? PasswordlessSSHTestPanel.this.testResultDetailMsgList.get(PasswordlessSSHTestPanel.this.selectedHostIdx * PasswordlessSSHTestPanel.this.orderedHostList.size() + n) : Messages.getString("TimesTenGrid.notTested");
                    }
                }
                return null;
            }
        }
    }

    private class ConfigurationPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final int HOST_IP_COL = 0;
        private static final int HOST_RESULT_COL = 1;
        private final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.hostAddress"), Messages.getString("TimesTenGrid.testResult")};
        private JTable _table;
        private HostsTableModel _model;
        private JButton _addHost;
        private JButton _removeHost;
        private AutoCompleteComponent _instanceAdminTxtFld;
        private JPasswordField _instanceAdminPassTxtFld;
        private JLabel _instanceAdminLbl;
        private JLabel _instanceAdminPassLbl;
        private JScrollPane _scrollPane;

        public ConfigurationPanel() {
            this.init();
        }

        public JButton getAddHostBtn() {
            return this._addHost;
        }

        public JButton getRemoveHostBtn() {
            return this._removeHost;
        }

        public void dataChanged() {
            if (SwingUtilities.isEventDispatchThread()) {
                this._model.fireTableDataChanged();
            } else {
                try {
                    SwingUtilities.invokeAndWait(() -> this._model.fireTableDataChanged());
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    _logger.severe(exception.getMessage());
                }
            }
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            PasswordlessSSHTestPanel.this.hostList = new ArrayList();
            PasswordlessSSHTestPanel.this.orderedHostList = new ArrayList();
            this._instanceAdminTxtFld = new AutoCompleteComponent(15, TTGridRootNode.getStorage().getSuggestion("adminUID"));
            this._instanceAdminPassTxtFld = new JPasswordField(15);
            this._instanceAdminTxtFld.setMinimumSize(this._instanceAdminPassTxtFld.getPreferredSize());
            this._instanceAdminPassTxtFld.setMinimumSize(this._instanceAdminPassTxtFld.getPreferredSize());
            this._instanceAdminLbl = new JLabel(Messages.getString("TimesTenGrid.instanceAdminLabel"));
            this._instanceAdminPassLbl = new JLabel(Messages.getString("TimesTenGrid.passwordLabel"));
            this._model = new HostsTableModel();
            this._table = new JTable(this._model){
                private static final long serialVersionUID = 1L;

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    String string = "";
                    Point point = mouseEvent.getPoint();
                    int n = this.rowAtPoint(point);
                    int n2 = this.columnAtPoint(point);
                    try {
                        string = ConfigurationPanel.this._table.getValueAt(n, n2).toString();
                    }
                    catch (RuntimeException runtimeException) {
                        _logger.log(Level.INFO, runtimeException.getMessage());
                    }
                    return string;
                }
            };
            this._table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this._table.setSelectionMode(0);
            this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    try {
                        for (int i = 0; i < PasswordlessSSHTestPanel.this.orderedHostList.size(); ++i) {
                            if (!((String)PasswordlessSSHTestPanel.this.hostList.get(ConfigurationPanel.this._table.getSelectedRow())).equalsIgnoreCase((String)PasswordlessSSHTestPanel.this.orderedHostList.get(i))) continue;
                            PasswordlessSSHTestPanel.this.selectedHostIdx = i;
                            break;
                        }
                        PasswordlessSSHTestPanel.this.detailsPanel.detailsDataChanged();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this._scrollPane = new JScrollPane(this._table);
            this._addHost = new JButton(Messages.getString("TimesTenGrid.addHost"));
            this._removeHost = new JButton(Messages.getString("TimesTenGrid.remHost"));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)this._instanceAdminLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 15, 5, 0), 0, 0));
            jPanel.add((Component)this._instanceAdminTxtFld, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 15, 5, 15), 0, 0));
            jPanel.add((Component)this._instanceAdminPassLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 15, 5, 0), 0, 0));
            jPanel.add((Component)this._instanceAdminPassTxtFld, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 15, 5, 15), 0, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.instanceAdminCredentials")));
            this.add((Component)jPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 2, new Insets(5, 15, 5, 0), 0, 0));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            jPanel2.add((Component)this._addHost, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 15, 5, 0), 0, 0));
            jPanel2.add((Component)this._removeHost, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 15, 5, 0), 0, 0));
            jPanel2.add((Component)this._scrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 15, 15, 15), 0, 0));
            jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.hostsLabel")));
            this.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 21, 1, new Insets(5, 15, 5, 0), 0, 0));
            this._addHost.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PasswordlessSSHTestPanel.this.hostList.add(new String());
                    PasswordlessSSHTestPanel.this.testResultGlobalMsgList.add(new String());
                    ConfigurationPanel.this.clearResultMsgs();
                    PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                }
            });
            this._removeHost.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = Arrays.copyOf(ConfigurationPanel.this._table.getSelectedRows(), ConfigurationPanel.this._table.getSelectedRows().length);
                    Arrays.sort(nArray);
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        PasswordlessSSHTestPanel.this.hostList.remove(nArray[i]);
                        PasswordlessSSHTestPanel.this.testResultGlobalMsgList.remove(nArray[i]);
                    }
                    ConfigurationPanel.this.clearResultMsgs();
                    PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                }
            });
            this.setNames();
        }

        public void clearResultMsgs() {
            int n;
            for (n = 0; n < PasswordlessSSHTestPanel.this.testResultGlobalMsgList.size(); ++n) {
                PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(n, Messages.getString("TimesTenGrid.notTested"));
            }
            for (n = 0; n < PasswordlessSSHTestPanel.this.testResultDetailMsgList.size(); ++n) {
                PasswordlessSSHTestPanel.this.testResultDetailMsgList.set(n, Messages.getString("TimesTenGrid.notTested"));
            }
        }

        private void setNames() {
            this._addHost.setName(Messages.getString("TimesTenGrid.addHost"));
            this._removeHost.setName(Messages.getString("TimesTenGrid.remHost"));
            this._instanceAdminTxtFld.setName("_instanceAdminTxtFld", "_instanceAdminCmbBox");
            this._instanceAdminPassTxtFld.setName("_instanceAdminPassTxtFld");
            this._instanceAdminLbl.setName(Messages.getString("TimesTenGrid.instanceAdminLabel"));
            this._instanceAdminPassLbl.setName(Messages.getString("TimesTenGrid.passwordLabel"));
        }

        public String getAdmin() {
            return this._instanceAdminTxtFld.getText();
        }

        public char[] getAdminPass() {
            return this._instanceAdminPassTxtFld.getPassword();
        }

        private class HostsTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;

            private HostsTableModel() {
            }

            @Override
            public int getRowCount() {
                return PasswordlessSSHTestPanel.this.hostList.size();
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 < 1 && !PasswordlessSSHTestPanel.this.testRunning;
            }

            @Override
            public int getColumnCount() {
                return ConfigurationPanel.this.HEADER.length;
            }

            @Override
            public String getColumnName(int n) {
                return ConfigurationPanel.this.HEADER[n];
            }

            @Override
            public Object getValueAt(int n, int n2) {
                try {
                    switch (n2) {
                        case 0: {
                            return PasswordlessSSHTestPanel.this.hostList.get(n);
                        }
                        case 1: {
                            return PasswordlessSSHTestPanel.this.testResultGlobalMsgList.get(n);
                        }
                    }
                }
                catch (Exception exception) {
                    _logger.severe("Error get value");
                }
                return null;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                switch (n2) {
                    case 0: {
                        PasswordlessSSHTestPanel.this.hostList.set(n, object.toString());
                        break;
                    }
                }
                this.fireTableDataChanged();
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        }
    }
}

