/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.Element;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.utils.SqlLikeConditionToRegex;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class DBDetailedConnectionsPanel
extends JPanel {
    private String[] COLUMN_TITLES = new String[]{Messages.getString("TimesTenGrid.element"), Messages.getString("TimesTenGrid.connType"), Messages.getString("TimesTenGrid.connName"), "PID"};
    private final int CONN_NAME_COL = 2;
    private final int CONN_TYPE_COL = 1;
    private final int PID_COL = 3;
    private final int EL_ID_COL = 0;
    private JTable _connTable;
    private JComboBox<String> _elementsCmb;
    private JLabel _elementsCmbSelection;
    private JLabel _filterConnectionName;
    private JTextField _connectionName;
    private JPanel _filterPanel;
    private JCheckBox _systemConnections;
    private TableRowSorter<AbstractTableModel> _sorter;

    public static void showDetailedConnections(DatabaseObject databaseObject) {
        GridObject gridObject = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid());
        gridObject.updateDBConnectionsOnSwingWorker(databaseObject, () -> {
            DBDetailedConnectionsPanel dBDetailedConnectionsPanel = new DBDetailedConnectionsPanel(databaseObject);
            JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)dBDetailedConnectionsPanel, (String)databaseObject.getName(), null);
            jEWTDialog.setButtonMask(5);
            Dimension dimension = new Dimension(450, 300);
            jEWTDialog.setSize(dimension);
            jEWTDialog.setMinimumSize(dimension);
            jEWTDialog.setPreferredSize(dimension);
            jEWTDialog.setMaximumSize(dimension);
            jEWTDialog.setDefaultCloseOperation(2);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
            jEWTDialog.setVisible(true);
        });
    }

    public DBDetailedConnectionsPanel(final DatabaseObject databaseObject) {
        this.setLayout(new GridBagLayout());
        this._elementsCmbSelection = new JLabel(Messages.getString("TimesTenGrid.instanceColumn"));
        this._elementsCmb = new JComboBox();
        this._elementsCmb.addItem(Messages.getString("TimesTenGrid.allInstances"));
        for (Element element : databaseObject.getAllElements()) {
            this._elementsCmb.addItem(element.toString());
        }
        this._elementsCmb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ((AbstractTableModel)DBDetailedConnectionsPanel.this._connTable.getModel()).fireTableDataChanged();
            }
        });
        this._systemConnections = new JCheckBox(Messages.getString("TimesTenGrid.systemConnections"));
        this._systemConnections.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ((AbstractTableModel)DBDetailedConnectionsPanel.this._connTable.getModel()).fireTableDataChanged();
            }
        });
        this._connTable = new JTable(new AbstractTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            private List<DatabaseObject.ElementConnection> filterAppConnections(List<DatabaseObject.ElementConnection> list) {
                return list.stream().filter(elementConnection -> elementConnection.isAppConnection()).collect(Collectors.toList());
            }

            private List<DatabaseObject.ElementConnection> getElementsFromSelectedItem() {
                List<DatabaseObject.ElementConnection> list;
                if (DBDetailedConnectionsPanel.this._elementsCmb.getSelectedItem().equals(Messages.getString("TimesTenGrid.allInstances"))) {
                    list = databaseObject.getElementsConnections();
                } else {
                    Element element = databaseObject.getElementByInstanceName(DBDetailedConnectionsPanel.this._elementsCmb.getSelectedItem().toString());
                    list = databaseObject.getElementsConnections(element);
                }
                if (!DBDetailedConnectionsPanel.this._systemConnections.isSelected()) {
                    return this.filterAppConnections(list);
                }
                return list;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 2: {
                        return this.getElementsFromSelectedItem().get(n).getConnectionName();
                    }
                    case 1: {
                        return this.getElementsFromSelectedItem().get(n).getContype();
                    }
                    case 3: {
                        return this.getElementsFromSelectedItem().get(n).getPID();
                    }
                    case 0: {
                        return this.getElementsFromSelectedItem().get(n).getElement().getId();
                    }
                }
                return null;
            }

            @Override
            public int getRowCount() {
                return this.getElementsFromSelectedItem().size();
            }

            @Override
            public String getColumnName(int n) {
                return DBDetailedConnectionsPanel.this.COLUMN_TITLES[n];
            }

            @Override
            public int getColumnCount() {
                return DBDetailedConnectionsPanel.this.COLUMN_TITLES.length;
            }
        }){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                string = DBDetailedConnectionsPanel.this._connTable.getValueAt(n, n2).toString();
                return string;
            }
        };
        AbstractTableModel abstractTableModel = (AbstractTableModel)this._connTable.getModel();
        this._sorter = new TableRowSorter<Object>(abstractTableModel);
        this._connTable.setRowSorter(this._sorter);
        this._filterPanel = new JPanel(new GridBagLayout());
        this._filterConnectionName = new JLabel(Messages.getString("TimesTenGrid.connectionName"));
        this._connectionName = new JTextField();
        this._connectionName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                DBDetailedConnectionsPanel.this.connNameFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                DBDetailedConnectionsPanel.this.connNameFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                DBDetailedConnectionsPanel.this.connNameFilter();
            }
        });
        this.add((Component)this._elementsCmbSelection, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._elementsCmb, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._systemConnections, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JScrollPane(this._connTable), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._filterPanel.add((Component)this._filterConnectionName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._filterPanel.add((Component)this._connectionName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._filterPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.connDetails")));
        this._filterPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.filterConnection")));
        TableColumnSizer.setColumnsWidthToFit(this._connTable, true, true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.DB_CONNECTIONS.toString());
        this.setNames();
    }

    private void connNameFilter() {
        RowFilter rowFilter = null;
        String string = this._connectionName.getText();
        SqlLikeConditionToRegex sqlLikeConditionToRegex = new SqlLikeConditionToRegex();
        string = sqlLikeConditionToRegex.parse(string);
        try {
            rowFilter = RowFilter.regexFilter(string, 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return;
        }
        this._sorter.setRowFilter(rowFilter);
    }

    private void setNames() {
        this._elementsCmb.setName("_elementsCmb");
        this._elementsCmbSelection.setName(Messages.getString("TimesTenGrid.instanceColumn"));
        this._filterConnectionName.setName(Messages.getString("TimesTenGrid.connectionName"));
        this._connectionName.setName("_connectionName");
        this._systemConnections.setName(Messages.getString("TimesTenGrid.systemConnections"));
    }
}

