/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.database.AttributesDefinitionPanel;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttribute;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.ConnectableObject;
import oracle.dbtools.raptor.timesten.grid.object.DBDefObject;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.ide.Ide;

public class NewConnectablePanel
extends TTGUIBasePanel {
    private static final long serialVersionUID = 1L;
    private JButton _importButton;
    private JLabel _connectableLabel;
    private JTextField _connectableTxtField;
    private AttributesDefinitionPanel _attrPanel;
    private JEWTDialog _dialog;
    private boolean isCS;
    private DBDefObject db;
    private JButton _okButton;
    private static final Logger logger = Logger.getLogger(NewConnectablePanel.class.getName());
    private ConnectableObject newConnectableObj;
    private GridObject thisGrid;
    private JLabel _instanceLabel;
    private JComboBox<String> _instanceComboBox;
    private boolean isNewConnectable;

    public NewConnectablePanel(boolean bl, DBDefObject dBDefObject, GridObject gridObject) {
        this.thisGrid = gridObject;
        this.newConnectableObj = new ConnectableObject(gridObject, dBDefObject);
        this.isCS = bl;
        this.db = dBDefObject;
        this.initGUI();
        this.isNewConnectable = true;
    }

    public NewConnectablePanel(ConnectableObject connectableObject, DBDefObject dBDefObject, GridObject gridObject) {
        this.thisGrid = gridObject;
        this.newConnectableObj = connectableObject;
        this.isCS = connectableObject.isCS();
        this.db = dBDefObject;
        this.initGUI();
        this.populateUI(connectableObject);
        this.isNewConnectable = false;
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this._importButton = new JButton(Messages.getString("TimesTenGrid.importDbdef"));
        this._importButton.addActionListener(this);
        this._okButton = new JButton(Messages.getString("TimesTenGrid.okButtonWizard"));
        this._okButton.addActionListener(this);
        this._connectableTxtField = new JTextField(15);
        this._connectableLabel = new JLabel(Messages.getString("TimesTenGrid.connectableName"));
        this._attrPanel = new AttributesDefinitionPanel(false, true, DBDefAttribute.DBDefAttributeType.GENERAL_CONNECTION, this.thisGrid);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._connectableLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(10, 10, 10, 10), 0, 0));
        jPanel.add((Component)this._connectableTxtField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 30, 10, 10), 0, 0));
        jPanel.add((Component)this._importButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(10, 10, 10, 10), 0, 0));
        if (this.isCS) {
            List<String> list = this.thisGrid.getAllDataInstanceNames();
            list.add(0, Messages.getString("TimesTenGrid.anyInstance"));
            this._instanceComboBox = new JComboBox<String>(list.toArray(new String[0]));
            this._instanceComboBox.setEditable(false);
            this._instanceLabel = new JLabel(Messages.getString("TimesTenGrid.onlyConnectTo"));
            this._instanceLabel.setLabelFor(this._instanceComboBox);
            jPanel.add((Component)this._instanceLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 10, 10, 10), 0, 0));
            jPanel.add(this._instanceComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 30, 10, 10), 0, 0));
        }
        this.add((Component)this._attrPanel, "Center");
        this.add((Component)jPanel, "First");
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.connectableDef")));
    }

    private void populateUI(ConnectableObject connectableObject) {
        this._connectableTxtField.setText(connectableObject.getName());
        this._connectableTxtField.setEnabled(false);
        for (DBDefAttribute object : connectableObject.getAttributes()) {
            if (this._attrPanel.setAttributeValue(object.getAttribute(), object.getValueAsString())) continue;
            this._attrPanel.addCustomAttribute(object.getAttribute(), object.getValueAsString());
        }
        if (connectableObject.isCS()) {
            boolean bl = false;
            if (connectableObject.getOnlyInstance() != null && !connectableObject.getOnlyInstance().isEmpty()) {
                for (HostObject hostObject : this.thisGrid.getHosts()) {
                    for (InstanceObject instanceObject : hostObject.getInstances()) {
                        if (!instanceObject.getFullName().equalsIgnoreCase(connectableObject.getOnlyInstance())) continue;
                        this._instanceComboBox.setSelectedItem(instanceObject.getFullName());
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    break;
                }
                if (!bl) {
                    logger.warning("Connectable " + connectableObject.getName() + " is supposed to work only on " + connectableObject.getOnlyInstance() + " but it wasn't found within the grid");
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._importButton) {
            this.importButtonActionPerformed();
        } else if (actionEvent.getSource() == this._okButton) {
            if (this.isNewConnectable) {
                if (this._connectableTxtField.getText().isEmpty()) {
                    Common.displayErrorMsg(null, Messages.getString("TimesTenGrid.noNameError"));
                    return;
                }
                String string = Common.validateName(this._connectableTxtField.getText(), "Connectable");
                if (string != null) {
                    Common.displayErrorMsg(null, string);
                    return;
                }
                for (ConnectableObject connectableObject : this.db.getConnectables()) {
                    if (!this._connectableTxtField.getText().equalsIgnoreCase(connectableObject.getName())) continue;
                    Common.displayErrorMsg(null, Messages.getString("TimesTenGrid.repeatedGridObj"));
                    return;
                }
            }
            if (this._attrPanel.areAttributesValid()) {
                this._dialog.closeDialog(false);
                this.connectableCreate();
            } else {
                Common.displayErrorMsg(null, Messages.getString("TimesTenGrid.invalidAttributes"));
            }
        }
    }

    private void connectableCreate() {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), this.isNewConnectable ? MessageFormat.format(Messages.getString("TimesTenGrid.createConnectable"), this._connectableTxtField.getText()) : MessageFormat.format(Messages.getString("TimesTenGrid.editingConnectable"), this._connectableTxtField.getText()), Messages.getString("TimesTen.common.pleaseWait"), null);
        NewConnectablePanel newConnectablePanel = this;
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            private GridCommandExecutor gridCmdExec;
            private File connectableFile;
            private String msg;
            private Exception ex;

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    GridCommand gridCommand;
                    customProgressMonitor.start();
                    GridMouseListener.expander.getExpansionState();
                    this.gridCmdExec = NewConnectablePanel.this.thisGrid.getExecutor();
                    NewConnectablePanel.this.newConnectableObj.getAttributes().clear();
                    NewConnectablePanel.this.newConnectableObj.getAttributes().addAll(NewConnectablePanel.this._attrPanel.getSelectedAttributes());
                    NewConnectablePanel.this.newConnectableObj.setName(NewConnectablePanel.this._connectableTxtField.getText());
                    NewConnectablePanel.this.newConnectableObj.setCS(NewConnectablePanel.this.isCS);
                    this.connectableFile = this.appendAttributesTempFile();
                    this.msg = Messages.getString("TimesTenGrid.copyConnectable");
                    this.firePropertyChange("message", null, this.msg);
                    logger.log(Level.INFO, this.msg);
                    String string = NewConnectablePanel.this.newConnectableObj.getName() + ".connect";
                    String string2 = NewConnectablePanel.this.thisGrid.getExecutor().getWorkingHost().getInstanceHome();
                    System.out.println(string2);
                    this.gridCmdExec.executeSCP(this.connectableFile, string, string2);
                    if (NewConnectablePanel.this.isNewConnectable) {
                        this.msg = MessageFormat.format(Messages.getString("TimesTenGrid.createConnectable"), string);
                        this.firePropertyChange("message", null, this.msg);
                        logger.log(Level.INFO, this.msg);
                        gridCommand = GridCommand.CREATE_CONNECTABLE;
                        gridCommand.prepareCommand(NewConnectablePanel.this.db.getName(), string2 + "/" + string);
                        if (NewConnectablePanel.this.newConnectableObj.isCS()) {
                            gridCommand.createConnectableWithCSOption((String)NewConnectablePanel.this._instanceComboBox.getSelectedItem());
                        }
                        this.gridCmdExec.executeCommandGetString(gridCommand, true);
                    } else {
                        this.msg = MessageFormat.format(Messages.getString("TimesTenGrid.editingConnectable"), string);
                        this.firePropertyChange("message", null, this.msg);
                        logger.log(Level.INFO, this.msg);
                        gridCommand = GridCommand.MODIFY_CONNECTABLE;
                        gridCommand.prepareCommand(string2 + "/" + string);
                        if (NewConnectablePanel.this.newConnectableObj.isCS()) {
                            gridCommand.createConnectableWithCSOption((String)NewConnectablePanel.this._instanceComboBox.getSelectedItem());
                        }
                        this.gridCmdExec.executeCommandGetString(gridCommand, true);
                    }
                    gridCommand = GridCommand.CUSTOM_COMMAND;
                    gridCommand.prepareCommand("rm -f " + string2 + "/" + string);
                    this.gridCmdExec.executeCommandGetString(gridCommand, true);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.deletingTmpFiles"));
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    NewConnectablePanel.this.thisGrid.refreshGridModels();
                    this.firePropertyChange("progress", null, 100);
                }
                catch (IOException | GridCommandException exception) {
                    this.ex = exception;
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskCancelled"));
                    logger.log(Level.SEVERE, this.ex.getMessage());
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    logger.log(Level.INFO, Messages.getString("TimesTenGrid.taskComplete"));
                    NewConnectablePanel.this.showModelNeedsApplyWarning();
                    GridMouseListener.expander.setExpansionState();
                }
            }

            private File appendAttributesTempFile() throws FileNotFoundException {
                File file = TimesTenUtil.getTemporaryFile(NewConnectablePanel.this.newConnectableObj.getName(), "connect");
                try (PrintWriter printWriter = new PrintWriter(file);){
                    StringBuilder stringBuilder = new StringBuilder();
                    for (DBDefAttribute dBDefAttribute : NewConnectablePanel.this.newConnectableObj.getAttributes()) {
                        stringBuilder.append(dBDefAttribute.getAttribute().toLowerCase());
                        stringBuilder.append("=");
                        stringBuilder.append(dBDefAttribute.getDBDefValue());
                        stringBuilder.append("\n");
                    }
                    printWriter.println(stringBuilder.toString());
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, "While writing in the temporary file:" + iOException.getMessage());
                }
                return file;
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        customProgressMonitor.setCancellable(false);
        swingWorker.execute();
    }

    private void importButtonActionPerformed() {
        JFileChooser jFileChooser = new JFileChooser(TTGridRootNode.getInstance().getCurrentDirectory());
        jFileChooser.setDialogTitle(Messages.getString("TimesTenGrid.importDbdef"));
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Connectable File (.connect)", "connect"));
        jFileChooser.setFileFilter(jFileChooser.getChoosableFileFilters()[1]);
        int n = 0;
        n = jFileChooser.showOpenDialog((Component)Ide.getMainWindow());
        if (n == 0) {
            TTGridRootNode.getInstance().setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = jFileChooser.getSelectedFile();
            try {
                String string;
                Object object;
                if (!file.getAbsolutePath().toLowerCase().endsWith(".connect")) {
                    file = new File(jFileChooser.getSelectedFile().getAbsolutePath() + "." + ((FileNameExtensionFilter)jFileChooser.getFileFilter()).getExtensions()[0]);
                }
                if (this.isNewConnectable) {
                    object = file.getName().substring(0, file.getName().indexOf(46));
                    this._connectableTxtField.setText((String)object);
                }
                object = new BufferedReader(new FileReader(file));
                String string2 = "(\\w+)=(.*)";
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    String[] stringArray;
                    if (!string.trim().matches(string2) || this._attrPanel.setAttributeValue((stringArray = string.split("="))[0], stringArray[1])) continue;
                    this._attrPanel.addCustomAttribute(stringArray[0], stringArray[1]);
                }
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, iOException.getMessage());
            }
        }
    }

    @Override
    public void setDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
    }

    @Override
    public JButton getOkButton() {
        return this._okButton;
    }
}

