/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.database.ConnectablesSummaryPanel;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.ConnectableObject;
import oracle.dbtools.raptor.timesten.grid.object.DBDefObject;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;

public class ConnectablesEditor
extends TTBaseEditor {
    private ConnectablesSummaryPanel summary;
    private DBDefObject currentDBDef;
    private ConnectableObject selectedConnectable = null;
    private static final Logger logger = Logger.getLogger(ConnectablesEditor.class.getName());

    public ConnectablesEditor() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (!this.initialized) {
            this.summary = new ConnectablesSummaryPanel(this.currentGrid);
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.connectableDef"), this.summary);
            this.helpInfo = new HelpInfo(TimesTenHelpID.CONNECTABLE_EDITOR.toString());
            this.initialized = true;
        }
    }

    @Override
    public void updateContent() {
        this.currentDBDef = this.currentGrid.getDBDef(TTGridRootNode.getInstance().getCurrentDB());
        this.selectedConnectable = this.currentDBDef.getConnectable(this.context.getNode().getShortLabel());
        this.viewTabs();
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == REFRESH_ID) {
            this.refreshInfo(this::viewTabs);
            return true;
        }
        return false;
    }

    public void refreshInfo(final Runnable runnable) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){
            StringBuilder errorMessage;
            {
                super(string, bl, iRaptorTaskRunMode);
                this.errorMessage = new StringBuilder("");
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Void doWork() throws TaskException {
                JsonObject jsonObject = null;
                try {
                    jsonObject = ConnectablesEditor.this.currentGrid.getSynchronizedWithModel(true);
                    JsonArray jsonArray = jsonObject.getJsonArray("dbdefs");
                    boolean bl = false;
                    for (JsonObject jsonObject2 : jsonArray.getValuesAs(JsonObject.class)) {
                        String string = jsonObject2.getString("name");
                        if (string == null || string.equalsIgnoreCase("TTGRIDADMIN") || !string.equalsIgnoreCase(ConnectablesEditor.this.currentDBDef.getName())) continue;
                        ConnectablesEditor.this.currentDBDef.setDBDefModel(jsonObject2);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        logger.severe("Cannot find connectable " + ConnectablesEditor.this.currentDBDef.getName());
                    }
                }
                catch (JsonException | GridCommandException throwable) {
                    this.errorMessage.append(throwable.getMessage());
                    for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                        if (!(editor instanceof ConnectablesEditor)) continue;
                        List<Editor> list = Arrays.asList(editor);
                        try {
                            SwingUtilities.invokeAndWait(() -> EditorManager.getEditorManager().closeEditors(list));
                        }
                        catch (InterruptedException | InvocationTargetException exception) {}
                        break;
                    }
                }
                if (!this.errorMessage.toString().isEmpty()) {
                    logger.log(Level.SEVERE, this.errorMessage.toString());
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), this.errorMessage.toString());
                    return null;
                }
                runnable.run();
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(MessageFormat.format(Messages.getString("TimesTenGrid.updateDBInfoTask"), this.currentDBDef.getName()));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void viewTabs() {
        this.selectedConnectable = this.currentDBDef.getConnectable(this.selectedConnectable.getName());
        if (SwingUtilities.isEventDispatchThread()) {
            this.summary.update(this.selectedConnectable);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.summary.update(this.selectedConnectable));
            }
            catch (InterruptedException | InvocationTargetException exception) {
                logger.log(Level.INFO, exception.getMessage());
            }
        }
    }
}

