/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.icons.OracleIcons;

public abstract class TTBaseEditor
extends Editor
implements Controller {
    protected DisplayPanel _panel;
    protected JTabbedPane _tabbedPane;
    protected Toolbar _toolbar;
    protected ToggleToolButton _refreshToggle;
    protected static final int REFRESH_ID = Ide.findOrCreateCmdID((String)"Grid_Editor.Refresh");
    protected IdeAction _refreshAction;
    protected Context context;
    protected HelpInfo helpInfo;
    protected boolean _isPinned;
    protected boolean initialized = false;
    protected GridObject currentGrid;

    protected void init() {
        if (this._panel == null) {
            this._refreshAction = IdeAction.get((int)REFRESH_ID);
            this._refreshAction.addController((Controller)this);
            this._panel = new DisplayPanel(null);
            this._toolbar = this._panel.getToolbar();
            this.buildToolbar();
            this._tabbedPane = new JTabbedPane();
            this._panel.add((Component)this._tabbedPane);
        }
    }

    protected void buildToolbar() {
        if (this._toolbar.getComponentCount() == 0) {
            this._refreshToggle = this._toolbar.addToggleButton((ToggleAction)this._refreshAction);
            this._refreshToggle.setToolTipText(Messages.getString("CGWhere.Refresh"));
            this._refreshToggle.setIcon(OracleIcons.getIcon((String)"refresh.png"));
        }
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.context = context;
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public void open() {
    }

    public abstract void updateContent();

    public void setCurrentGrid(GridObject gridObject) {
        this.currentGrid = gridObject;
    }

    public Component getGUI() {
        return this._panel;
    }

    public boolean getPinned() {
        return this._isPinned;
    }

    public void setPinned(boolean bl) {
        this._isPinned = bl;
    }

    public void close() {
        super.close();
        GridMouseListener.expander.getExpansionState();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GridMouseListener.expander.setExpansionState();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == REFRESH_ID) {
            this.refreshInfo();
            return true;
        }
        return false;
    }

    private void refreshInfo() {
        if (this.currentGrid != null) {
            GridMouseListener.updateGridInfo(this.currentGrid.getGridNode().getCustomTree(), null, this.currentGrid, false, false, this.currentGrid.getShowingVersion());
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public HelpInfo getHelpInfo() {
        return this.helpInfo;
    }
}

