/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.instance;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.json.JsonException;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;

public class EditInstancePanel
extends TTGUIBasePanel {
    private JLabel _nameLabel;
    private JLabel _daemonPortLabel;
    private JLabel _csPortLabel;
    private JLabel _installLabel;
    private JLabel _locationLabel;
    private AutoCompleteComponent _nameTxtField;
    private AutoCompleteComponent _daemonPortTxtField;
    private AutoCompleteComponent _csPortTxtField;
    private AutoCompleteComponent _locationTxtField;
    private JComboBox<InstallationObject> _installComboBox;
    private InstanceObject instance;

    public EditInstancePanel(InstanceObject instanceObject) {
        this.instance = instanceObject;
        this.initGUI();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.INST_EDIT.toString());
    }

    private void initGUI() {
        this._nameTxtField = new AutoCompleteComponent(15, InstanceObject.getInstanceNameSuggestions());
        this._nameTxtField.setEnabled(false);
        this._nameTxtField.setText(this.instance.getName());
        this._locationTxtField = new AutoCompleteComponent(25, InstanceObject.getInstanceHomeSuggestions());
        this._locationTxtField.setText(this.instance.getHome());
        this._locationTxtField.setEnabled(false);
        this._daemonPortTxtField = new AutoCompleteComponent(5, InstanceObject.getInstanceDaemonPortSuggestions());
        this._daemonPortTxtField.setText(Integer.toString(this.instance.getDaemonPort()));
        this._csPortTxtField = new AutoCompleteComponent(5, InstanceObject.getInstanceCSPortSuggestions());
        this._csPortTxtField.setText(Integer.toString(this.instance.getCSPort()));
        this._daemonPortTxtField.setEnabled(false);
        this._csPortTxtField.setEnabled(false);
        this._installComboBox = new JComboBox();
        this._nameLabel = new JLabel(Messages.getString("TimesTenGrid.instanceNameLabel"));
        this._nameLabel.setLabelFor(this._nameTxtField);
        this._locationLabel = new JLabel(Messages.getString("TimesTenGrid.instLocLabel"));
        this._locationLabel.setLabelFor(this._locationTxtField);
        this._daemonPortLabel = new JLabel(Messages.getString("TimesTenGrid.daemonPortLabel"));
        this._daemonPortLabel.setLabelFor(this._daemonPortTxtField);
        this._csPortLabel = new JLabel(Messages.getString("TimesTenGrid.csPortLabel"));
        this._csPortLabel.setLabelFor(this._csPortTxtField);
        this._installLabel = new JLabel(Messages.getString("TimesTenGrid.installationLabel"));
        this._installLabel.setLabelFor(this._installComboBox);
        for (InstallationObject installationObject : this.instance.getHost().getInstallations()) {
            this._installComboBox.addItem(installationObject);
        }
        this._installComboBox.setSelectedItem(this.instance.getInstallation());
        int n = 0;
        this.add((Component)this._nameLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 30, 10, 10), 0, 0));
        this.add((Component)this._nameTxtField, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._locationLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 30, 10, 10), 0, 0));
        this.add((Component)this._locationTxtField, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._daemonPortLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(10, 30, 10, 10), 0, 0));
        this.add((Component)this._daemonPortTxtField, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._csPortLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 30, 10, 10), 0, 0));
        this.add((Component)this._csPortTxtField, new GridBagConstraints(1, n++, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._installLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 30, 10, 10), 0, 0));
        this.add(this._installComboBox, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.instanceInformation")));
        this.setNames();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = ((InstallationObject)this._installComboBox.getSelectedItem()).getName();
        if (!this.informationChanged(Integer.parseInt(this._csPortTxtField.getText().trim()), Integer.parseInt(this._daemonPortTxtField.getText().trim()), string)) {
            this._dialog.dispose();
            return;
        }
        this.editInstance(this._nameTxtField.getText().trim(), Integer.parseInt(this._csPortTxtField.getText().trim()), Integer.parseInt(this._daemonPortTxtField.getText().trim()), string);
        if (!this.validInput()) {
            return;
        }
    }

    private boolean informationChanged(int n, int n2, String string) {
        return n != this.instance.getCSPort() || n2 != this.instance.getDaemonPort() || !string.equals(this.instance.getInstallation().getName());
    }

    private boolean validInput() {
        String string;
        String string2 = this._daemonPortTxtField.getText().trim();
        if (string2.equals(string = this._csPortTxtField.getText().trim())) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.invalidSamePort"));
            return false;
        }
        return this.validPort(string2, true) && this.validPort(string, false);
    }

    private boolean validPort(String string, boolean bl) {
        int n = 0;
        if (string.isEmpty()) {
            if (bl) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noDaemonPortError"));
            } else {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noCSPortError"));
            }
            return false;
        }
        try {
            n = Integer.parseInt(string);
            if (!Common.validPort(n)) {
                throw new NumberFormatException();
            }
            for (HostObject hostObject : this.grid.getHosts()) {
                if (!hostObject.getExternalAddress().equalsIgnoreCase(this.instance.getHost().getExternalAddress())) continue;
                for (InstanceObject instanceObject : hostObject.getInstances()) {
                    if (instanceObject.getFullName().equalsIgnoreCase(this.instance.getFullName()) || instanceObject.getCSPort() != n && instanceObject.getDaemonPort() != n) continue;
                    if (bl) {
                        Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.invaliddPort"));
                    } else {
                        Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.invalidcsPort"));
                    }
                    return false;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (bl) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.invalidDaemonPortError"));
            } else {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.invalidCSPortError"));
            }
            return false;
        }
        return true;
    }

    private void editInstance(final String string, final int n, final int n2, final String string2) {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.editInstance"), MessageFormat.format(Messages.getString("TimesTenGrid.editingInstance"), string, this.instance.getHost().getName()), null);
        customProgressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    customProgressMonitor.start();
                    EditInstancePanel.this._dialog.dispose();
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.executeEditInstance"), string));
                    GridCommand gridCommand = GridCommand.INSTANCE_EDIT;
                    gridCommand.prepareCommand(EditInstancePanel.this.instance.getHost().getName(), string, String.valueOf(n2), String.valueOf(n), string2);
                    EditInstancePanel.this.grid.getExecutor().executeCommandGetString(gridCommand, true);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    EditInstancePanel.this.grid.refreshGridModels();
                    this.firePropertyChange("progress", null, 100);
                }
                catch (JsonException jsonException) {
                    this.firePropertyChange("error", null, jsonException.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.instEditionCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    EditInstancePanel.this.showModelNeedsApplyWarning();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    private void setNames() {
        this._nameLabel.setName(Messages.getString("TimesTenGrid.instanceNameLabel"));
        this._daemonPortLabel.setName(Messages.getString("TimesTenGrid.daemonPortLabel"));
        this._csPortLabel.setName(Messages.getString("TimesTenGrid.csPortLabel"));
        this._installLabel.setName(Messages.getString("TimesTenGrid.installationLabel"));
        this._locationLabel.setName(Messages.getString("TimesTenGrid.instLocLabel"));
        this._nameTxtField.setName("_nameTxtField", "nameCmbBox");
        this._daemonPortTxtField.setName("_daemonPortTxtField", "daemonPortCmbBox");
        this._csPortTxtField.setName("_csPortTxtField", "csPortCmbBox");
        this._locationTxtField.setName("_locationTxtField", "_locationCmbBox");
        this._installComboBox.setName("_installComboBox");
    }
}

