/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.loginspector;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.loginspector.InstanceLogWrapper;
import oracle.dbtools.raptor.timesten.grid.loginspector.LogInspectorMainWindow;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.ide.Ide;

public class UpdateLogsSwingWorker
extends SwingWorker<Void, Void> {
    private CustomProgressMonitor _progressMonitor;
    private GridObject grid;
    public static final String TTMESG = "ttmesg.log";
    public static final String TTMESG_LOC = "diag/ttmesg.log";
    public static final String TTERROR = "tterrors.log";
    public static final String TTERROR_LOC = "diag/tterrors.log";
    private static final Logger logger = Logger.getLogger(UpdateLogsSwingWorker.class.getName());
    private LogInspectorMainWindow.UpdateSelectedInstances onFinishUpdate;
    private List<InstanceObject> instancesToUpdate;
    private boolean forceUpdate;
    private LogInspectorMainWindow.LogViewerType type;

    public UpdateLogsSwingWorker(GridObject gridObject, LogInspectorMainWindow.UpdateSelectedInstances updateSelectedInstances, LogInspectorMainWindow.LogViewerType logViewerType) {
        this.type = logViewerType;
        this._progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.LogUpdate"), Messages.getString("TimesTenGrid.LogUpdate"), null);
        this.grid = gridObject;
        this.onFinishUpdate = updateSelectedInstances;
        this.forceUpdate = false;
        this._progressMonitor.setSwingWorker(this);
        this.addPropertyChangeListener(this._progressMonitor);
    }

    public void setInstancesToUpdate(List<InstanceObject> list) {
        this.instancesToUpdate = list;
    }

    public void setUpdate(boolean bl) {
        this.forceUpdate = bl;
    }

    @Override
    protected Void doInBackground() throws Exception {
        try {
            this._progressMonitor.start();
            String string = null;
            if (this.instancesToUpdate == null) {
                this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.LogNoUpdate"));
                this.cancel(true);
            }
            switch (this.type) {
                case ERROR: {
                    string = TTERROR_LOC;
                    break;
                }
                case MSG: {
                    string = TTMESG_LOC;
                }
            }
            GridCommandExecutor gridCommandExecutor = this.grid.getExecutor();
            for (InstanceObject instanceObject : this.instancesToUpdate) {
                InstanceLogWrapper instanceLogWrapper = instanceObject.getLog();
                if (instanceLogWrapper.isLogLoaded() && !this.forceUpdate) {
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.LogAvailable"), instanceObject.getFullName()));
                } else {
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.LogFetching"), instanceObject.getHome() + string, instanceObject.getFullName()));
                    gridCommandExecutor.executeSCPRemote2Local(instanceObject.getHost().getExternalAddress(), instanceLogWrapper.getLogFile().getCanonicalPath(), instanceObject.getHome() + string);
                    instanceLogWrapper.setLogLoaded(true);
                }
                this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.LogParsing"));
                instanceLogWrapper.parseFirstLines();
            }
            this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.LogFiltering"));
            this.onFinishUpdate.update(this.instancesToUpdate, true);
            this.firePropertyChange("progress", null, 100);
        }
        catch (GridCommandException gridCommandException) {
            this.firePropertyChange("message", null, gridCommandException.getMessage());
            logger.severe("Error while updating logs:" + gridCommandException.getMessage());
            this.cancel(true);
        }
        return null;
    }

    @Override
    protected void done() {
        this._progressMonitor.finish();
        if (this._progressMonitor.successfulExecution() || !this.isCancelled()) {
            this._progressMonitor.close();
        } else {
            this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskCancelled"));
            this._progressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskCancelled"));
        }
    }
}

