/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.management;

import java.awt.Component;
import java.text.MessageFormat;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.ide.Ide;

public class ActiveStandbyPairManagement {
    private GridObject currentGrid;
    private GridCommand cmd;
    private InstanceObject mgmtStandby;
    private String title;
    private String noActiveStandby;
    private String confirmDialog;
    private String commandTitle;
    private String commandMessage;
    private String commandDone;
    private String extAddress;
    private String repState;
    private String instanceHome;
    private String instanceName;
    private boolean switchMgmt;
    private boolean startStandby;

    public ActiveStandbyPairManagement(GridObject gridObject) {
        this.currentGrid = gridObject;
        this.mgmtStandby = null;
    }

    public void activeSwitch() {
        this.title = Messages.getString("TimestenGrid.activeSwitch");
        this.noActiveStandby = Messages.getString("TimestenGrid.noActiveStandby");
        this.confirmDialog = Messages.getString("TimestenGrid.newActive");
        this.commandTitle = Messages.getString("TimestenGrid.becomingActive");
        this.commandMessage = Messages.getString("TimestenGrid.mgmtActiveSwitch");
        this.commandDone = Messages.getString("TimestenGrid.becomingActiveDone");
        this.cmd = GridCommand.MGMT_SWITCH;
        this.switchMgmt = true;
        this.run();
    }

    public void standbyStart() {
        this.title = Messages.getString("TimestenGrid.startStandbyMgmt");
        this.noActiveStandby = Messages.getString("TimestenGrid.noActiveStandbyStart");
        this.confirmDialog = Messages.getString("TimestenGrid.startStanbyMessage");
        this.commandTitle = Messages.getString("TimestenGrid.startingStandby");
        this.commandMessage = Messages.getString("TimestenGrid.mgmtStandbyStart");
        this.commandDone = Messages.getString("TimestenGrid.mgmtStartDone");
        this.cmd = GridCommand.MGMT_STANDBY_START;
        this.startStandby = true;
        this.run();
    }

    public void stopStandby() {
        this.title = Messages.getString("TimestenGrid.stopStandbyMgmt");
        this.noActiveStandby = Messages.getString("TimestenGrid.noActiveStandbyStop");
        this.confirmDialog = Messages.getString("TimestenGrid.stopStanbyMessage");
        this.commandTitle = Messages.getString("TimestenGrid.stoppingStandby");
        this.commandMessage = Messages.getString("TimestenGrid.mgmtStandbyStop");
        this.commandDone = Messages.getString("TimestenGrid.mgmtStopDone");
        this.cmd = GridCommand.MGMT_STANDBY_STOP;
        this.run();
    }

    public void run() {
        this.searchMgmtStandby();
    }

    public void searchMgmtStandby() {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), this.title, Messages.getString("TimestenGrid.searchStandby"), null);
        customProgressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    customProgressMonitor.start();
                    this.firePropertyChange("message", null, Messages.getString("TimestenGrid.mgmtExamine"));
                    GridCommand gridCommand = GridCommand.MGMT_EXAMINE;
                    JsonObject jsonObject = ActiveStandbyPairManagement.this.currentGrid.getExecutor().executeCommandGetJson(gridCommand, true);
                    ActiveStandbyPairManagement.this.currentGrid.updateMgmInstancesModel(jsonObject);
                    if (!ActiveStandbyPairManagement.this.isMgmtStandby(jsonObject)) {
                        throw new GridCommandException(ActiveStandbyPairManagement.this.noActiveStandby);
                    }
                    this.firePropertyChange("progress", null, 100);
                    customProgressMonitor.close();
                }
                catch (JsonException | GridCommandException throwable) {
                    this.firePropertyChange("error", null, throwable.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskCancelled"));
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskComplete"));
                    ActiveStandbyPairManagement.this.showConfirmationDialog();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    private boolean isMgmtStandby() {
        for (InstanceObject instanceObject : this.currentGrid.getAllMgmtInstances()) {
            if (instanceObject.getType() != InstanceObject.ManagementInstanceRole.STANDBY) continue;
            this.mgmtStandby = instanceObject;
            this.instanceName = this.mgmtStandby.getName();
            return true;
        }
        return false;
    }

    private boolean isMgmtStandby(JsonObject jsonObject) throws GridCommandException {
        if (this.startStandby) {
            if (jsonObject.containsKey((Object)"STANDBY".toLowerCase())) {
                JsonObject jsonObject2 = jsonObject.getJsonObject("STANDBY".toLowerCase());
                this.extAddress = jsonObject2.getString("address");
                this.instanceHome = jsonObject2.getString("instanceHome");
                this.instanceName = jsonObject2.getString("instance");
                if (jsonObject2.containsKey((Object)"ttRepStateGet")) {
                    this.repState = jsonObject2.getString("ttRepStateGet");
                    if (this.repState.equals("STANDBY")) {
                        throw new GridCommandException(Messages.getString("TimestenGrid.standbyAlreadyStarted"));
                    }
                }
                return true;
            }
            return false;
        }
        return this.isMgmtStandby();
    }

    private void showConfirmationDialog() {
        if (Common.displayConfirm((Component)Ide.getMainWindow(), MessageFormat.format(this.confirmDialog, this.instanceName), this.title, null, true)) {
            this.executeCommand();
        }
    }

    private void executeCommand() {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), this.title, MessageFormat.format(this.commandTitle, this.instanceName), null);
        customProgressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    String[] stringArray;
                    Object object4;
                    if (ActiveStandbyPairManagement.this.switchMgmt) {
                        object4 = ActiveStandbyPairManagement.this.mgmtStandby.getHost().getExternalAddress();
                        stringArray = ActiveStandbyPairManagement.this.mgmtStandby.getHome();
                        object3 = ActiveStandbyPairManagement.this.currentGrid.getExecutor().getWorkingHost().getInstanceAdmin();
                        object2 = ActiveStandbyPairManagement.this.currentGrid.getExecutor().getWorkingHost().getPwd();
                        object = new GridCommandExecutor((String)object4, (String)stringArray, (String)object3, (char[])object2);
                        ActiveStandbyPairManagement.this.currentGrid.setExecutor((GridCommandExecutor)object);
                    }
                    customProgressMonitor.start();
                    this.firePropertyChange("message", null, MessageFormat.format(ActiveStandbyPairManagement.this.commandMessage, ActiveStandbyPairManagement.this.instanceName));
                    if (ActiveStandbyPairManagement.this.startStandby) {
                        object4 = ActiveStandbyPairManagement.this.currentGrid.getExecutor().getWorkingHost().getInstanceAdmin();
                        stringArray = (String[])ActiveStandbyPairManagement.this.currentGrid.getExecutor().getWorkingHost().getPwd();
                        object3 = new GridCommandExecutor(ActiveStandbyPairManagement.this.extAddress, ActiveStandbyPairManagement.this.instanceHome, (String)object4, (char[])stringArray);
                        ((GridCommandExecutor)object3).executeCommandGetJson(ActiveStandbyPairManagement.this.cmd, true);
                    } else {
                        ActiveStandbyPairManagement.this.currentGrid.getExecutor().executeCommandGetJson(ActiveStandbyPairManagement.this.cmd, true);
                    }
                    this.firePropertyChange("message", null, MessageFormat.format(ActiveStandbyPairManagement.this.commandDone, ActiveStandbyPairManagement.this.instanceName));
                    if (ActiveStandbyPairManagement.this.switchMgmt) {
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.gettingSystemInfo"));
                        object4 = GridCommand.PERL_GET_SYSTEM_INFO;
                        ((GridCommand)((Object)object4)).prepareCommand("");
                        ActiveStandbyPairManagement.this.currentGrid.getExecutor().executePerlScriptCommand((GridCommand)((Object)object4), null);
                        stringArray = ActiveStandbyPairManagement.this.currentGrid.getExecutor().getSSHChannel().getLastCommandOutput().split(";");
                        object3 = stringArray[0];
                        object2 = stringArray[1];
                        object = stringArray[2] + stringArray[3];
                        String string = stringArray[3];
                        ActiveStandbyPairManagement.this.currentGrid.getExecutor().getWorkingHost().updateSystemInfo((String)object3, (String)object2, (String)object, string);
                        TTGridRootNode.getStorage().saveGrid(ActiveStandbyPairManagement.this.currentGrid);
                    }
                    this.firePropertyChange("progress", null, 100);
                }
                catch (JsonException | GridCommandException throwable) {
                    this.firePropertyChange("error", null, throwable.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskCancelled"));
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskComplete"));
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }
}

