/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.object;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BasicDeletable;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.Deletable;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.DifferenceObject;
import oracle.dbtools.raptor.timesten.grid.object.Executable;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.grid.object.PhysicalGroupObject;
import oracle.dbtools.raptor.timesten.grid.object.TTGridObject;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyElement;
import oracle.ide.Ide;

public class HostObject
extends TTGridObject
implements Executable,
TopologyElement,
Deletable {
    private List<InstallationObject> installations;
    private List<InstanceObject> instances;
    private List<PhysicalGroupObject> physicalGroups;
    private int dataSpaceGroup;
    private boolean canEditDSG;
    private static final Logger logger = Logger.getLogger(HostObject.class.getName());
    private String address;
    private String internalAddress;

    public String getExternalAddress() {
        return this.address;
    }

    public void setExternalAddress(String string) {
        this.address = string;
    }

    public HostObject() {
        this.internalAddress = "";
        this.address = "";
        this.name = "";
        this.initialize();
    }

    public HostObject(HostObject hostObject) {
        this.initialize();
        this.setName(hostObject.getName());
        this.setDataSpaceGroup(hostObject.getDataSpaceGroup());
        this.setExternalAddress(hostObject.getExternalAddress());
        this.setInternalAddress(hostObject.getInternalAddress());
        for (PhysicalGroupObject physicalGroupObject : hostObject.getPhysicalGroups()) {
            this.physicalGroups.add(physicalGroupObject);
        }
    }

    public HostObject(String string, String string2) {
        this.name = string;
        this.address = string2;
        this.internalAddress = "";
        this.GUID = string;
        this.initialize();
    }

    private void initialize() {
        this.installations = new ArrayList<InstallationObject>();
        this.instances = new ArrayList<InstanceObject>();
        this.physicalGroups = new ArrayList<PhysicalGroupObject>();
        this.canEditDSG = true;
    }

    public boolean canEditDSG() {
        return this.canEditDSG;
    }

    public void setCanEditDSG(boolean bl) {
        this.canEditDSG = bl;
    }

    public List<InstallationObject> getInstallations() {
        return this.installations;
    }

    public boolean hasInstallationsAvailable() {
        for (InstallationObject installationObject : this.installations) {
            if (!installationObject.isAppliedToCurrent()) continue;
            return true;
        }
        return false;
    }

    public String getInternalAddress() {
        return this.internalAddress;
    }

    public void setInternalAddress(String string) {
        this.internalAddress = string;
    }

    @Override
    public int getDataSpaceGroup() {
        return this.dataSpaceGroup;
    }

    public void setDataSpaceGroup(int n) {
        this.dataSpaceGroup = n;
    }

    public List<PhysicalGroupObject> getPhysicalGroups() {
        return this.physicalGroups;
    }

    public String getPhysicalGroupsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (PhysicalGroupObject physicalGroupObject : this.getPhysicalGroups()) {
            stringBuilder.append(physicalGroupObject.getName() + ",");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        } else {
            stringBuilder.append(Messages.getString("TimesTenGrid.blank"));
        }
        return stringBuilder.toString();
    }

    public void setPhysicalGroups(JsonArray jsonArray, List<PhysicalGroupObject> list) {
        this.physicalGroups = new ArrayList<PhysicalGroupObject>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            String string = ((JsonValue)jsonArray.get(i)).toString().substring(1, ((JsonValue)jsonArray.get(i)).toString().length() - 1);
            for (PhysicalGroupObject physicalGroupObject : list) {
                if (!physicalGroupObject.getName().equalsIgnoreCase(string)) continue;
                this.physicalGroups.add(physicalGroupObject);
            }
        }
    }

    public void addInstallation(InstallationObject installationObject) {
        if (!this.installations.contains(installationObject)) {
            this.installations.add(installationObject);
        }
    }

    public InstallationObject getInstallation(String string) {
        for (InstallationObject installationObject : this.installations) {
            if (!installationObject.getName().equals(string)) continue;
            return installationObject;
        }
        return null;
    }

    public List<InstanceObject> getInstances() {
        return this.instances;
    }

    public List<InstanceObject> getDataInstances() {
        return this.instances.stream().filter(instanceObject -> !instanceObject.isMgmtInstance()).collect(Collectors.toList());
    }

    public List<InstanceObject> getAppliedDataInstances() {
        return this.instances.stream().filter(instanceObject -> !instanceObject.isMgmtInstance() && instanceObject.isAppliedToCurrent()).collect(Collectors.toList());
    }

    public void addInstance(InstanceObject instanceObject) {
        if (!this.instances.contains(instanceObject)) {
            this.instances.add(instanceObject);
        }
    }

    public InstanceObject getInstance(String string) {
        for (InstanceObject instanceObject : this.instances) {
            if (!instanceObject.getName().equals(string)) continue;
            return instanceObject;
        }
        return null;
    }

    public InstanceObject getInstancebyGUID(String string) {
        for (InstanceObject instanceObject : this.instances) {
            if (instanceObject.getGUID() == null || !instanceObject.getGUID().equalsIgnoreCase(string)) continue;
            return instanceObject;
        }
        return null;
    }

    public boolean isMgmtHost() {
        for (InstanceObject instanceObject : this.instances) {
            if (!instanceObject.isMgmtInstance()) continue;
            return true;
        }
        return false;
    }

    public boolean isMgmtHostOnly() {
        boolean bl = false;
        boolean bl2 = false;
        for (InstanceObject instanceObject : this.instances) {
            if (instanceObject.isMgmtInstance()) {
                bl = true;
            } else {
                bl2 = true;
            }
            if (!bl2 || !bl) continue;
            break;
        }
        return bl && !bl2;
    }

    public boolean belongsToPG(PhysicalGroupObject physicalGroupObject) {
        if (physicalGroupObject == null) {
            return false;
        }
        for (PhysicalGroupObject physicalGroupObject2 : this.getPhysicalGroups()) {
            if (!physicalGroupObject.getName().equalsIgnoreCase(physicalGroupObject2.getName())) continue;
            return true;
        }
        return false;
    }

    public void setHostModel(JsonObject jsonObject, List<PhysicalGroupObject> list) {
        this.setName(jsonObject.getString("name"));
        this.setInternalAddress(jsonObject.getString("internalAddress"));
        this.setExternalAddress(jsonObject.getString("externalAddress"));
        try {
            this.setDataSpaceGroup(jsonObject.getInt("dataSpaceGroup"));
        }
        catch (Exception exception) {
            logger.log(Level.INFO, "Host " + this.getName() + " is not assigned to any data space group");
        }
        this.setPhysicalGroups(jsonObject.getJsonArray("physicalGroups"), list);
        JsonArray jsonArray = jsonObject.getJsonArray("installations");
        for (JsonObject jsonObject2 : jsonArray.getValuesAs(JsonObject.class)) {
            InstallationObject installationObject = this.getInstallation(jsonObject2.getString("name"));
            if (installationObject == null) {
                installationObject = new InstallationObject(this, jsonObject2.getString("name"));
                this.addInstallation(installationObject);
            }
            installationObject.setInstallationModel(jsonObject2);
            installationObject.getInstancesUsing().clear();
            JsonArray jsonArray2 = jsonObject2.getJsonArray("instances");
            for (JsonObject jsonObject3 : jsonArray2.getValuesAs(JsonObject.class)) {
                InstanceObject instanceObject = this.getInstance(jsonObject3.getString("name"));
                if (instanceObject == null) {
                    instanceObject = new InstanceObject(this, installationObject);
                    this.addInstance(instanceObject);
                }
                instanceObject.setInstanceModel(jsonObject3);
                installationObject.getInstancesUsing().add(instanceObject);
            }
        }
    }

    public void diff(DifferenceObject differenceObject, HostObject hostObject) {
        boolean bl;
        TTGridObject tTGridObject;
        HostObject hostObject2 = this;
        hostObject2.setAppliedToCurrent(true);
        hostObject.setAppliedToCurrent(true);
        if (!(hostObject2.getName().equalsIgnoreCase(hostObject.getName()) && hostObject2.getDataSpaceGroup() == hostObject.getDataSpaceGroup() && hostObject2.getInternalAddress().equalsIgnoreCase(hostObject.getInternalAddress()) && hostObject2.getExternalAddress().equalsIgnoreCase(hostObject.getExternalAddress()))) {
            differenceObject.gridObjectEdited(hostObject, hostObject2);
        }
        if (hostObject.getDataSpaceGroup() > 0) {
            hostObject.setCanEditDSG(false);
        } else {
            hostObject.setCanEditDSG(true);
        }
        for (InstallationObject tTGridObject2 : hostObject2.getInstallations()) {
            tTGridObject = hostObject.getInstallation(tTGridObject2.getName());
            boolean bl2 = bl = tTGridObject != null;
            if (bl) {
                tTGridObject2.diff(differenceObject, (InstallationObject)tTGridObject);
                continue;
            }
            differenceObject.gridObjectRemoved(tTGridObject2);
        }
        for (InstallationObject installationObject : hostObject.getInstallations()) {
            tTGridObject = hostObject2.getInstallation(installationObject.getName());
            bl = tTGridObject != null;
            if (bl) continue;
            differenceObject.gridObjectAdded(installationObject);
        }
        for (InstanceObject instanceObject : hostObject2.getInstances()) {
            tTGridObject = hostObject.getInstance(instanceObject.getName());
            boolean bl3 = bl = tTGridObject != null;
            if (bl) {
                instanceObject.diff(differenceObject, (InstanceObject)tTGridObject);
                continue;
            }
            differenceObject.gridObjectRemoved(instanceObject);
        }
        for (InstanceObject instanceObject : hostObject.getInstances()) {
            tTGridObject = hostObject2.getInstance(instanceObject.getName());
            bl = tTGridObject != null;
            if (bl) continue;
            differenceObject.gridObjectAdded(instanceObject);
        }
    }

    @Override
    public String getObjectType() {
        return Messages.getString("TimesTenGrid.HostObjectName");
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getTargetName() {
        return this.getName();
    }

    @Override
    public boolean isAvailableForExec() {
        return this.isAppliedToCurrent();
    }

    @Override
    public int getDSG() {
        return this.getDataSpaceGroup();
    }

    public void updateSuggestions() {
        TTGridRootNode.getStorage().saveSuggestion("hostName", this.getName());
        TTGridRootNode.getStorage().saveSuggestion("internalAddress", this.getInternalAddress());
        TTGridRootNode.getStorage().saveSuggestion("externalAddress", this.getExternalAddress());
    }

    public static List<String> getHostNameSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("hostName");
    }

    public static List<String> getHostInternalAddressSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("internalAddress");
    }

    public static List<String> getHostExternalAddressSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("externalAddress");
    }

    @Override
    public int getReplicaSet() {
        return -1;
    }

    @Override
    public boolean isAppliedInTopology() {
        return this.getDataSpaceGroup() != 0;
    }

    @Override
    public boolean hasRS() {
        return false;
    }

    @Override
    public boolean hasDSG() {
        return this.dataSpaceGroup != 0;
    }

    @Override
    public boolean isMarkedToBeAdded() {
        return this.getDataSpaceGroup() != 0 && !this.isAppliedToCurrent();
    }

    @Override
    public boolean isMarkedToBeRemoved() {
        return false;
    }

    @Override
    public boolean isAddableToTopology() {
        return true;
    }

    @Override
    public boolean isSameElement(String string) {
        return this.getName().equals(string);
    }

    @Override
    public String getFailStateMessage() {
        return "";
    }

    @Override
    public boolean isRemovableAfterApply() {
        return false;
    }

    @Override
    public void deleteObject(Runnable runnable) {
        BasicDeletable basicDeletable = new BasicDeletable();
        basicDeletable.setCmd(GridCommand.HOST_DELETE);
        basicDeletable.setCmdArgs(this.name);
        basicDeletable.setDeleteMsg(Messages.getString("TimesTenGrid.deleteHost"));
        basicDeletable.setDeletingObjMsg(MessageFormat.format(Messages.getString("TimesTenGrid.deletingHostPW"), this.name));
        basicDeletable.setDeletingFromModelMsg(MessageFormat.format(Messages.getString("TimesTenGrid.deletingHost"), this.name));
        basicDeletable.setDeleteCancelMsg(Messages.getString("TimesTenGrid.hostDeletionCancelled"));
        basicDeletable.deleteObject(runnable);
    }

    public boolean canBeDeleted(GridObject gridObject) {
        if (this.isMgmtHost()) {
            String string = gridObject.getExecutor().getWorkingHost().getHostName() + "." + gridObject.getExecutor().getWorkingHost().getInstanceName();
            List<InstanceObject> list = gridObject.getAllMgmtInstancesInLatest();
            for (InstanceObject instanceObject : this.instances) {
                if (!this.containsInstance(instanceObject)) continue;
                if (list.size() > 1) {
                    if (instanceObject.getType() == InstanceObject.ManagementInstanceRole.ACTIVE || instanceObject.getFullName().equalsIgnoreCase(string)) {
                        Common.displayErrorMsg((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.deleteHostErrorActiveInst"), this.name));
                        return false;
                    }
                    if (instanceObject.getType() != InstanceObject.ManagementInstanceRole.STANDBY) continue;
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.deleteHostErrorStandbyInst"), this.name));
                    return false;
                }
                Common.displayErrorMsg((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.deleteHostErrorOneMgmtInst"), this.name));
                return false;
            }
        }
        return true;
    }

    private boolean containsInstance(InstanceObject instanceObject) {
        for (InstanceObject instanceObject2 : this.instances) {
            if (!instanceObject2.getName().equalsIgnoreCase(instanceObject.getName()) || !instanceObject2.getHost().getName().equalsIgnoreCase(instanceObject.getHost().getName())) continue;
            return true;
        }
        return false;
    }
}

