/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.start;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BaseTraversablePanel;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.grid.start.StartGridWizardMain;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class MgmtInstTraversablePanel
extends BaseTraversablePanel {
    private static final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.host"), Messages.getString("TimesTenGrid.instanceColumn"), Messages.getString("TimesTenGrid.daemonstatus"), Messages.getString("TimesTenGrid.serverstatus"), Messages.getString("TimesTenGrid.replicationStatus")};
    private static final int DEFAULT_WAIT_TIME = 12000;
    private static final long serialVersionUID = 1L;
    private static final String SLEEP = "sleep";
    private static final String MGMTEXAMINE = "ttGridAdmin mgmtExamine";
    private boolean gridPopulated;
    private List<Instance> mgmtInsts = new ArrayList<Instance>();
    private List<String> commands = new ArrayList<String>();

    public MgmtInstTraversablePanel() {
        super(true);
        this.initGUI();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.model = new MgmtInstancesModel();
        this._objTable = new JTable(this.model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                string = MgmtInstTraversablePanel.this._objTable.getValueAt(n, n2).toString();
                return string;
            }
        };
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this._objTable.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        TableColumnModel tableColumnModel = this._objTable.getColumnModel();
        tableColumnModel.getColumn(MgmtColIdx.HOST.getValue()).setCellRenderer(this.centerRenderer);
        tableColumnModel.getColumn(MgmtColIdx.INSTANCE.getValue()).setCellRenderer(this.centerRenderer);
        tableColumnModel.getColumn(MgmtColIdx.DAEMON.getValue()).setCellRenderer(new IconTextCellRenderer());
        tableColumnModel.getColumn(MgmtColIdx.SERVER.getValue()).setCellRenderer(new IconTextCellRenderer());
        tableColumnModel.getColumn(MgmtColIdx.REPLICATION.getValue()).setCellRenderer(this.centerRenderer);
        this._objTable.setRowHeight(30);
        TableColumnSizer.setColumnsWidthToFit(this._objTable, true, true);
        this.add(new JScrollPane(this._objTable), new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.dataContext = traversableContext;
        this.gridPopulated = this.currentGrid.isPopulated();
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        this.launchUpdater();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        boolean bl = false;
        if (this.gridPopulated) {
            if (this.currentGrid.getAllMgmtInstances().size() > 1) {
                for (InstanceObject instanceObject : this.currentGrid.getAllMgmtInstances()) {
                    if (instanceObject.getType() != InstanceObject.ManagementInstanceRole.ACTIVE) continue;
                    bl = true;
                    if (!this.connectedToActiveInst(instanceObject.getHost().getName(), instanceObject.getHome())) {
                        this.currentGrid.getExecutor().disconnectSSHSession();
                        this.currentGrid.setExecutor(new GridCommandExecutor(instanceObject.getHost().getExternalAddress(), instanceObject.getHome(), this.currentGrid.getExecutor().getWorkingHost().getInstanceAdmin(), this.currentGrid.getExecutor().getWorkingHost().getPwd()));
                    }
                    break;
                }
            } else if (this.currentGrid.getAllMgmtInstances().size() == 1) {
                bl = this.currentGrid.getAllMgmtInstances().get(0).getType() == InstanceObject.ManagementInstanceRole.ACTIVE;
            }
        } else if (this.mgmtInsts.size() > 1) {
            for (Instance instance : this.mgmtInsts) {
                if (!instance.getReplicationRole().equalsIgnoreCase("ACTIVE")) continue;
                bl = true;
                if (!this.connectedToActiveInst(instance.getHost(), instance.getInstanceHome())) {
                    this.currentGrid.getExecutor().disconnectSSHSession();
                    this.currentGrid.setExecutor(new GridCommandExecutor(instance.getAddress(), instance.getInstanceHome(), this.currentGrid.getExecutor().getWorkingHost().getInstanceAdmin(), this.currentGrid.getExecutor().getWorkingHost().getPwd()));
                }
                break;
            }
        } else if (this.mgmtInsts.size() == 1) {
            bl = this.mgmtInsts.get(0).getReplicationRole().equalsIgnoreCase("ACTIVE");
        }
        if (!bl) {
            Common.displayErrorMsg((Component)((Object)this), Messages.getString("TimesTenGrid.noActiveInstFound"));
            StartGridWizardMain.getInstance().getCurrentWizardDialog().dispose();
        }
        this.refreshIntervalCmb.setSelectedIndex(0);
        this.shutdownAutoRefresh();
    }

    public Object getExitTransition() {
        return "Instances";
    }

    private boolean connectedToActiveInst(String string, String string2) {
        GridCommandExecutor.WorkingHost workingHost = this.currentGrid.getExecutor().getWorkingHost();
        return workingHost.getHostName().equalsIgnoreCase(string) && Common.sameDirectories(workingHost.getInstanceHome(), string2);
    }

    @Override
    protected int getWaitTime() {
        return 12000;
    }

    @Override
    protected void executeCommand() {
        try {
            if (this.gridPopulated) {
                if (this.currentGrid.getAllMgmtInstances().size() == 1) {
                    return;
                }
            } else if (this.mgmtInsts.size() == 1) {
                GridCommand gridCommand = GridCommand.START_WORKING_INSTANCE;
                Instance instance = this.mgmtInsts.get(0);
                String string = MessageFormat.format(Messages.getString("TimesTenGrid.startInstanceMessage"), instance.getHost() + "." + instance.getName());
                this.worker.firePropertyChange("message", null, string);
                this.printMessageInPanel(string);
                try {
                    String string2 = this.currentGrid.getExecutor().executeCommandGetString(gridCommand, false);
                    this.printMessageInPanel(string2);
                }
                catch (GridCommandException gridCommandException) {
                    if (Common.forceStart(gridCommandException.getMessage())) {
                        string = MessageFormat.format(Messages.getString("TimesTenGrid.startInstanceForceMessage"), instance.getHost() + "." + instance.getName());
                        this.worker.firePropertyChange("message", null, string);
                        this.printMessageInPanel(string);
                        gridCommand = GridCommand.START_WORKING_INSTANCE_FORCE;
                        String string3 = this.currentGrid.getExecutor().executeCommandGetString(gridCommand, false);
                        this.printMessageInPanel(string3);
                    }
                    this.printMessageInPanel(gridCommandException.getMessage());
                }
                return;
            }
            boolean bl = false;
            Iterator<String> iterator = this.commands.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                String string4 = MessageFormat.format(Messages.getString("TimesTenGrid.executingCommand"), string);
                this.worker.firePropertyChange("message", null, string4);
                this.printMessageInPanel("* " + string4 + this.NEW_LINE);
                if (string.startsWith(SLEEP)) {
                    int n = string.lastIndexOf(SLEEP) + SLEEP.length();
                    int n2 = Integer.parseInt(string.substring(n).trim());
                    try {
                        Thread.sleep(n2 * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    iterator.remove();
                    continue;
                }
                if (string.endsWith(MGMTEXAMINE) && !iterator.hasNext()) {
                    JsonObject jsonObject = this.currentGrid.getExecutor().executeCommandGetJson(GridCommand.MGMT_EXAMINE, true);
                    this.retrieveMgmtInstInfo(jsonObject);
                    this.updateCommands(jsonObject);
                    bl = true;
                    break;
                }
                GridCommand gridCommand = GridCommand.CUSTOM_COMMAND;
                gridCommand.prepareCommand(string);
                this.currentGrid.getExecutor().executeSimpleCommand(gridCommand);
                iterator.remove();
            }
            if (bl) {
                this.executeCommand();
            }
        }
        catch (GridCommandException gridCommandException) {
            this.printMessageInPanel(gridCommandException.getMessage());
        }
    }

    @Override
    protected void updateStatus(boolean bl) throws GridCommandException, JsonException {
        this.allRight = true;
        boolean bl2 = false;
        this.worker.firePropertyChange("message", null, Messages.getString("TimesTenGrid.getMgmtInstStatus"));
        if (this.gridPopulated) {
            GridCommand gridCommand = GridCommand.TT_STATUS_ALL;
            ArrayList<GridCommandExecutor.ExecOutput> arrayList = this.currentGrid.getExecutor().execCommand(this.currentGrid.getAllMgmtInstances(), gridCommand, false, BaseTraversablePanel.InstanceActionPanelInstanceType.MGMT.getExecMode(), 5);
            for (GridCommandExecutor.ExecOutput object : arrayList) {
                object.setInstanceStatus();
            }
            JsonObject jsonObject = this.currentGrid.getExecutor().executeCommandGetJson(GridCommand.MGMT_EXAMINE, true);
            this.currentGrid.updateMgmInstancesModel(jsonObject);
            this.updateCommands(jsonObject);
            for (InstanceObject instanceObject : this.currentGrid.getAllMgmtInstances()) {
                if (!instanceObject.getDaemonStatus() || !instanceObject.getCSState()) {
                    this.allRight = false;
                    break;
                }
                if (instanceObject.getType() != InstanceObject.ManagementInstanceRole.ACTIVE) continue;
                bl2 = true;
            }
        } else {
            JsonObject jsonObject = this.currentGrid.getExecutor().executeCommandGetJson(GridCommand.MGMT_EXAMINE, true);
            this.retrieveMgmtInstInfo(jsonObject);
            this.updateCommands(jsonObject);
            for (Instance instance : this.mgmtInsts) {
                if (!instance.getDaemonStatus() || !instance.getServerStatus()) {
                    this.allRight = false;
                    break;
                }
                if (!instance.getReplicationRole().equalsIgnoreCase("ACTIVE")) continue;
                bl2 = true;
            }
        }
        if (!bl2) {
            this.allRight = false;
        }
        this.updateLastRefresh();
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateGUIComponents();
        } else {
            SwingUtilities.invokeLater(() -> this.updateGUIComponents());
        }
        if (this.allRight && bl) {
            this.printMessageInPanel(Messages.getString("TimesTenGrid.mgmtInstRunning"));
        }
    }

    private void updateCommands(JsonObject jsonObject) {
        this.commands.clear();
        for (int i = 0; i < jsonObject.getJsonArray("cmds").size(); ++i) {
            this.commands.add(jsonObject.getJsonArray("cmds").getString(i));
        }
    }

    private void updateGUIComponents() {
        this.enableWizardButtons();
        this.actionBtn.setEnabled(!this.allRight);
        this.model.fireTableDataChanged();
    }

    @Override
    protected void enableWizardButtons() {
        this.dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(this.allRight), Boolean.valueOf(false));
    }

    private void retrieveMgmtInstInfo(JsonObject jsonObject) throws GridCommandException, JsonException {
        JsonArray jsonArray = jsonObject.getJsonArray("instances");
        JsonArray jsonArray2 = jsonObject.getJsonArray("start");
        int n = -1;
        this.mgmtInsts.clear();
        if (jsonArray.size() == 1) {
            JsonObject jsonObject2 = jsonArray.getJsonObject(0);
            Instance instance = new Instance(jsonObject2.getString("instance"), jsonObject2.getString("host"), jsonObject2.getString("instanceHome"), jsonObject2.getString("instanceGuid"), jsonObject2.getString("address"));
            if (jsonObject2.containsKey((Object)"maxSeq")) {
                n = jsonObject2.getInt("maxSeq");
            }
            if (jsonArray2.size() == 0 && n != -1) {
                String string = jsonObject2.getString("ttRepStateGet");
                instance.setDaemonStatus(true);
                instance.setServerStatus(true);
                if (string.equals("IDLE")) {
                    instance.setReplicationRole("ACTIVE");
                } else {
                    instance.setReplicationRole(string);
                }
            }
            this.mgmtInsts.add(instance);
        } else if (jsonArray.size() == 2) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject jsonObject3 = jsonArray.getJsonObject(i);
                Instance instance = new Instance(jsonObject3.getString("instance"), jsonObject3.getString("host"), jsonObject3.getString("instanceHome"), jsonObject3.getString("instanceGuid"), jsonObject3.getString("address"));
                if (jsonObject3.containsKey((Object)"maxSeq")) {
                    n = jsonObject3.getInt("maxSeq");
                }
                if (!this.foundInStart(instance, jsonArray2) && n != -1) {
                    instance.setDaemonStatus(true);
                    instance.setServerStatus(true);
                    instance.setReplicationRole(jsonObject3.getString("ttRepStateGet"));
                } else {
                    instance.setReplicationRole("Down".toUpperCase());
                }
                this.mgmtInsts.add(instance);
            }
        }
    }

    private boolean foundInStart(Instance instance, JsonArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject jsonObject = jsonArray.getJsonObject(i);
            if (!instance.getGUID().equals(jsonObject.getString("instanceGuid"))) continue;
            return true;
        }
        return false;
    }

    private static class Instance {
        private String name;
        private String host;
        private String instanceHome;
        private String guid;
        String address;
        boolean daemonStatus;
        boolean serverStatus;
        String replicationRole;

        public Instance(String string, String string2, String string3, String string4, String string5) {
            this.name = string;
            this.host = string2;
            this.instanceHome = string3;
            this.guid = string4;
            this.address = string5;
            this.daemonStatus = false;
            this.serverStatus = false;
            this.replicationRole = Messages.getString("TimesTen.common.unknown");
        }

        String getName() {
            return this.name;
        }

        String getHost() {
            return this.host;
        }

        String getInstanceHome() {
            return this.instanceHome;
        }

        String getGUID() {
            return this.guid;
        }

        String getAddress() {
            return this.address;
        }

        void setReplicationRole(String string) {
            this.replicationRole = string;
        }

        String getReplicationRole() {
            return this.replicationRole;
        }

        void setDaemonStatus(boolean bl) {
            this.daemonStatus = bl;
        }

        boolean getDaemonStatus() {
            return this.daemonStatus;
        }

        void setServerStatus(boolean bl) {
            this.serverStatus = bl;
        }

        boolean getServerStatus() {
            return this.serverStatus;
        }
    }

    private class IconTextCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private IconTextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = false;
            if (n2 == MgmtColIdx.DAEMON.getValue() || n2 == MgmtColIdx.SERVER.getValue()) {
                bl3 = (Boolean)object;
                if (MgmtInstTraversablePanel.this.gridPopulated) {
                    if (MgmtInstTraversablePanel.this.currentGrid.getAllMgmtInstances().get(n).isStatusAvailable()) {
                        jLabel.setText(bl3 ? Messages.getString("TimesTenGrid.up") : Messages.getString("TimesTenGrid.down"));
                        jLabel.setIcon(bl3 ? Common.UP_ICON : Common.DOWN_ICON);
                    } else {
                        jLabel.setText(Messages.getString("TimesTen.common.unknown"));
                        jLabel.setIcon(null);
                    }
                } else {
                    jLabel.setText(bl3 ? Messages.getString("TimesTenGrid.up") : Messages.getString("TimesTenGrid.down"));
                    jLabel.setIcon(bl3 ? Common.UP_ICON : Common.DOWN_ICON);
                }
            } else {
                jLabel.setText(object.toString());
                jLabel.setIcon(null);
            }
            jLabel.setHorizontalAlignment(0);
            return jLabel;
        }
    }

    private class MgmtInstancesModel
    extends AbstractTableModel {
        private MgmtInstancesModel() {
        }

        @Override
        public int getRowCount() {
            int n = 0;
            n = MgmtInstTraversablePanel.this.gridPopulated ? MgmtInstTraversablePanel.this.currentGrid.getAllMgmtInstances().size() : MgmtInstTraversablePanel.this.mgmtInsts.size();
            return n;
        }

        @Override
        public int getColumnCount() {
            return HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (MgmtInstTraversablePanel.this.gridPopulated) {
                List<InstanceObject> list = MgmtInstTraversablePanel.this.currentGrid.getAllMgmtInstances();
                if (n2 == MgmtColIdx.HOST.getValue()) {
                    return list.get(n).getHost().getName();
                }
                if (n2 == MgmtColIdx.INSTANCE.getValue()) {
                    return list.get(n).getName();
                }
                if (n2 == MgmtColIdx.DAEMON.getValue()) {
                    return list.get(n).getDaemonStatus();
                }
                if (n2 == MgmtColIdx.SERVER.getValue()) {
                    return list.get(n).getCSState();
                }
                if (n2 == MgmtColIdx.REPLICATION.getValue()) {
                    return list.get(n).getType();
                }
            } else if (MgmtInstTraversablePanel.this.mgmtInsts.size() > 0) {
                if (n2 == MgmtColIdx.HOST.getValue()) {
                    return ((Instance)MgmtInstTraversablePanel.this.mgmtInsts.get(n)).getHost();
                }
                if (n2 == MgmtColIdx.INSTANCE.getValue()) {
                    return ((Instance)MgmtInstTraversablePanel.this.mgmtInsts.get(n)).getName();
                }
                if (n2 == MgmtColIdx.DAEMON.getValue()) {
                    return ((Instance)MgmtInstTraversablePanel.this.mgmtInsts.get(n)).getDaemonStatus();
                }
                if (n2 == MgmtColIdx.SERVER.getValue()) {
                    return ((Instance)MgmtInstTraversablePanel.this.mgmtInsts.get(n)).getServerStatus();
                }
                if (n2 == MgmtColIdx.REPLICATION.getValue()) {
                    return ((Instance)MgmtInstTraversablePanel.this.mgmtInsts.get(n)).getReplicationRole();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    }

    private static enum MgmtColIdx {
        HOST(0),
        INSTANCE(1),
        DAEMON(2),
        SERVER(3),
        REPLICATION(4);

        private final int value;

        private MgmtColIdx(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

