/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor.data;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import oracle.dbtools.raptor.timesten.performancemonitor.PerformanceConstants;

public class DashboardSummaryInfo {
    private double average;
    private int elementCount;
    private double standardDeviation;
    private double variance;
    private double min;
    private double max;
    private ArrayList<DashboadInfo> info = new ArrayList();
    private Timestamp collectionTime;
    private String units;
    private PerformanceConstants.PerformanceChartTypes graphType;
    private Connection connection;
    private int minElementPosition;
    private int maxElementPosition;
    private boolean outOfRange;
    private String title;

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public int getMinElementPosition() {
        return this.minElementPosition;
    }

    public int getMaxElementPosition() {
        return this.maxElementPosition;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setUnits(String string) {
        this.units = string;
    }

    public String getUnits() {
        return this.units;
    }

    public void setCollectiminElementPositiononTime(Timestamp timestamp) {
        this.collectionTime = timestamp;
    }

    public Timestamp getCollectionTime() {
        return this.collectionTime;
    }

    public void addInformation(Integer n, double d) {
        this.info.add(new DashboadInfo(n, d));
    }

    public void addInformation(Integer n, double d, Timestamp timestamp) {
        this.info.add(new DashboadInfo(n, d, timestamp));
    }

    public void calculateInformation() {
        if (this.info != null && this.info.size() > 0) {
            this.min = Double.MAX_VALUE;
            this.max = Double.MIN_VALUE;
            this.elementCount = this.info.size();
            this.average = 0.0;
            int n = 0;
            for (DashboadInfo dashboadInfo : this.info) {
                if (dashboadInfo.value < this.min) {
                    this.min = dashboadInfo.value;
                    this.minElementPosition = n;
                }
                if (dashboadInfo.value > this.max) {
                    this.max = dashboadInfo.value;
                    this.maxElementPosition = n;
                }
                this.average += dashboadInfo.value;
                ++n;
            }
            this.average /= (double)this.elementCount;
            this.variance = 0.0;
            for (DashboadInfo dashboadInfo : this.info) {
                this.variance += (dashboadInfo.value - this.average) * (dashboadInfo.value - this.average);
            }
            this.variance /= (double)this.elementCount;
            this.standardDeviation = Math.sqrt(this.variance);
            double d = this.average - this.standardDeviation;
            double d2 = this.average - this.standardDeviation;
            for (DashboadInfo dashboadInfo : this.info) {
                if (!(dashboadInfo.value < d) && !(dashboadInfo.value > d2)) continue;
                this.outOfRange = true;
                break;
            }
        }
    }

    public boolean areOutOfRangeElements() {
        return this.outOfRange;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public double getAverage() {
        return this.average;
    }

    public double getVariance() {
        return this.variance;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public ArrayList<DashboadInfo> getInfo() {
        return this.info;
    }

    public PerformanceConstants.PerformanceChartTypes getGraphType() {
        return this.graphType;
    }

    public void setGraphType(PerformanceConstants.PerformanceChartTypes performanceChartTypes) {
        this.graphType = performanceChartTypes;
    }

    public class DashboadInfo {
        private Integer elementId;
        private double value;
        private Timestamp collected;

        public DashboadInfo(Integer n, double d) {
            this.elementId = n;
            this.value = d;
        }

        public DashboadInfo(Integer n, double d, Timestamp timestamp) {
            this(n, d);
            this.collected = timestamp;
        }

        public Integer getElementId() {
            return this.elementId;
        }

        public double getValue() {
            return this.value;
        }

        public Timestamp getCollected() {
            return this.collected;
        }
    }
}

