/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor.metrics;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SplitPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.TilePane;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javafx.util.Duration;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.performancemonitor.data.SummaryDataProvider;
import oracle.dbtools.raptor.timesten.performancemonitor.distribution.ElementSelectionListener;
import oracle.dbtools.raptor.timesten.performancemonitor.distribution.TopologyPanel;
import oracle.dbtools.raptor.timesten.performancemonitor.metrics.MetricGroup;
import oracle.dbtools.raptor.timesten.performancemonitor.metrics.MetricInfo;
import oracle.dbtools.raptor.timesten.performancemonitor.metrics.MetricPaneStorage;
import oracle.dbtools.raptor.timesten.performancemonitor.metrics.MetricTreeNode;
import oracle.dbtools.raptor.timesten.performancemonitor.metrics.Metrics;
import oracle.dbtools.raptor.timesten.performancemonitor.metrics.MetricsMessages;
import oracle.dbtools.raptor.timesten.performancemonitor.metrics.SplitGridPane;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.javatools.data.HashStructure;

public class MetricPane
extends BorderPane
implements ElementSelectionListener {
    private final String GRID_SIZE = "gridSize";
    private final String SELECTED_ELEMENTS = "selectedElements";
    private final String PANEL_ENABLED = "panelEnabled";
    private final String METRICS = "metrics";
    private SplitPane innerPane;
    private SplitPane menuPane;
    private TopologyPanel topology;
    private TreeView<MetricTreeNode> tree;
    private ToggleButton metrics;
    private MenuItem twoGridItem;
    private MenuItem threeGridItem;
    private Text text = new Text("");
    private Bounds bounds = this.text.getBoundsInLocal();
    private SplitGridPane gridPane;
    private Connection conn;
    private MenuButton layout;
    private MenuButton openIn;
    private CustomMenuItem twoByTwoItem;
    private CustomMenuItem threeByThreeItem;
    private int poolingInterval;
    private Timeline timeline;
    private MenuButton timeInterval;
    private MenuButton refreshTime;
    private MenuItem thirtySeconds;
    private MenuItem oneMinute;
    private MenuItem fiveMinute;
    private MenuItem manual;
    private EventHandler<ActionEvent> refreshIntervalSelection = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent actionEvent) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            MetricPane.this.refreshTime.setText(menuItem.getText());
            if (actionEvent.getSource() == MetricPane.this.thirtySeconds) {
                MetricPane.this.poolingInterval = 30000;
            } else if (actionEvent.getSource() == MetricPane.this.oneMinute) {
                MetricPane.this.poolingInterval = 60000;
            } else if (actionEvent.getSource() == MetricPane.this.fiveMinute) {
                MetricPane.this.poolingInterval = 300000;
            } else if (actionEvent.getSource() == MetricPane.this.manual) {
                MetricPane.this.poolingInterval = -1;
                if (MetricPane.this.timeline != null) {
                    MetricPane.this.timeline.stop();
                }
                return;
            }
            if (MetricPane.this.timeline == null) {
                MetricPane.this.timeline = new Timeline();
                MetricPane.this.timeline.setCycleCount(-1);
            } else {
                MetricPane.this.timeline.stop();
            }
            KeyFrame keyFrame = new KeyFrame(Duration.millis((double)MetricPane.this.poolingInterval), (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    MetricPane.this.gridPane.refreshAllCharts();
                }
            }, new KeyValue[0]);
            MetricPane.this.timeline.getKeyFrames().add((Object)keyFrame);
            MetricPane.this.timeline.play();
        }
    };
    EventHandler<DragEvent> dragOver = new EventHandler<DragEvent>(){

        public void handle(DragEvent dragEvent) {
            Dragboard dragboard = dragEvent.getDragboard();
            if (dragboard.hasString()) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
            dragEvent.consume();
        }
    };
    private EventHandler<ActionEvent> itemSelection = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent actionEvent) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            MetricPane.this.layout.setText(menuItem.getText());
            ImageView imageView = (ImageView)menuItem.getGraphic();
            ImageView imageView2 = new ImageView(imageView.getImage());
            imageView2.setFitWidth(MetricPane.this.bounds.getHeight());
            imageView2.setFitHeight(MetricPane.this.bounds.getHeight());
            MetricPane.this.layout.setGraphic((Node)imageView2);
            if (menuItem == MetricPane.this.twoGridItem) {
                MetricPane.this.gridPane.setGridSize(2);
                MetricPane.this.setupSeeInMenu(2);
            } else if (menuItem == MetricPane.this.threeGridItem) {
                MetricPane.this.gridPane.setGridSize(3);
                MetricPane.this.setupSeeInMenu(3);
            }
        }
    };
    EventHandler<ActionEvent> gridSelection = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof Button) {
                Button button = (Button)actionEvent.getSource();
                int n = Integer.parseInt(button.getText());
                TreeItem treeItem = (TreeItem)MetricPane.this.tree.getSelectionModel().getSelectedItem();
                if (treeItem.getValue() instanceof MetricInfo) {
                    MetricPane.this.gridPane.insertMetricChart(n - 1, (MetricInfo)treeItem.getValue());
                }
            }
        }
    };

    public MetricPane(Connection connection) {
        TreeItem treeItem;
        MetricGroup metricGroup3;
        this.innerPane = new SplitPane();
        this.menuPane = new SplitPane();
        this.conn = connection;
        MetricGroup metricGroup2 = new MetricGroup();
        metricGroup2.setName("root");
        metricGroup2.setVisibleName(MetricsMessages.getString("all.metrics"));
        TreeItem treeItem2 = new TreeItem((Object)metricGroup2);
        LinkedHashSet<MetricGroup> linkedHashSet = Metrics.getInstance(connection).getAllMetrics();
        for (MetricGroup metricGroup3 : linkedHashSet) {
            treeItem = new TreeItem((Object)metricGroup3);
            LinkedHashSet<MetricInfo> linkedHashSet2 = metricGroup3.getMetrics();
            for (MetricInfo metricInfo : linkedHashSet2) {
                TreeItem treeItem3 = new TreeItem((Object)metricInfo);
                treeItem.getChildren().add((Object)treeItem3);
            }
            treeItem2.getChildren().add((Object)treeItem);
        }
        treeItem2.setExpanded(true);
        this.tree = new TreeView(treeItem2);
        this.tree.setCellFactory((Callback)new Callback<TreeView<MetricTreeNode>, TreeCell<MetricTreeNode>>(){

            public TreeCell<MetricTreeNode> call(TreeView<MetricTreeNode> treeView) {
                TreeCell<MetricTreeNode> treeCell = new TreeCell<MetricTreeNode>(){

                    protected void updateItem(MetricTreeNode metricTreeNode, boolean bl) {
                        super.updateItem((Object)metricTreeNode, bl);
                        if (metricTreeNode != null) {
                            this.setText(metricTreeNode.toString());
                            this.setGraphic(this.getTreeItem().getGraphic());
                        } else {
                            this.setText(null);
                            this.setGraphic(null);
                        }
                    }
                };
                treeCell.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent mouseEvent) {
                        if (mouseEvent.getSource() instanceof TreeCell && ((TreeCell)mouseEvent.getSource()).getItem() instanceof MetricInfo) {
                            Dragboard dragboard = ((TreeCell)mouseEvent.getSource()).startDragAndDrop(TransferMode.COPY_OR_MOVE);
                            dragboard.setDragView((Image)((TreeCell)mouseEvent.getSource()).getParent().snapshot(null, null));
                            ClipboardContent clipboardContent = new ClipboardContent();
                            clipboardContent.putString("TRA");
                            dragboard.setContent((Map)clipboardContent);
                        }
                    }
                });
                return treeCell;
            }
        });
        this.tree.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.topology = new TopologyPanel(new SummaryDataProvider(connection));
        this.topology.setElementSelection(this);
        this.menuPane.setOrientation(Orientation.VERTICAL);
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter(this.tree);
        metricGroup3 = new ToolBar();
        this.openIn = new MenuButton(Messages.getString("TimestenGrid.openSelectedIn"));
        this.openIn.getItems();
        treeItem = new Region();
        HBox.setHgrow((Node)treeItem, (Priority)Priority.ALWAYS);
        metricGroup3.getItems().addAll((Object[])new Node[]{treeItem, this.openIn});
        borderPane.setTop((Node)metricGroup3);
        this.menuPane.getItems().addAll((Object[])new Node[]{borderPane, this.topology});
        this.gridPane = new SplitGridPane(3, connection, this);
        this.innerPane.getItems().addAll((Object[])new Node[]{this.menuPane, this.gridPane});
        this.setCenter((Node)this.innerPane);
        this.setToolbar();
        this.createSeeInMenus();
        this.setupSeeInMenu(3);
        this.loadState();
    }

    public String getElementsIdAsStringList() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (Integer n : this.topology.getSelectedElements()) {
            if (bl) {
                bl = false;
                stringBuffer.append(n);
                continue;
            }
            stringBuffer.append(',');
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    private void setToolbar() {
        MenuItem menuItem2;
        ToolBar toolBar = new ToolBar();
        toolBar.setOrientation(Orientation.HORIZONTAL);
        this.metrics = new ToggleButton(Messages.getString("TimestenGrid.metrics"));
        Region region = new Region();
        HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
        Region region2 = new Region();
        HBox.setHgrow((Node)region2, (Priority)Priority.ALWAYS);
        Button button = new Button(Messages.getString("TimestenGrid.refreshAll"));
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                MetricPane.this.gridPane.refreshAllCharts();
            }
        });
        Button button2 = new Button(Messages.getString("TimestenGrid.saveState"));
        button2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                MetricPane.this.save();
            }
        });
        this.layout = new MenuButton();
        ImageView imageView = new ImageView(new Image(MetricPane.class.getResourceAsStream("twoGrid.png")));
        ImageView imageView2 = new ImageView(new Image(MetricPane.class.getResourceAsStream("threeGrid.png")));
        this.twoGridItem = new MenuItem(Messages.getString("TimestenGrid.twoByTwo"), (Node)imageView);
        this.twoGridItem.setOnAction(this.itemSelection);
        this.threeGridItem = new MenuItem(Messages.getString("TimestenGrid.threeByThree"), (Node)imageView2);
        this.threeGridItem.setOnAction(this.itemSelection);
        this.layout.getItems().addAll((Object[])new MenuItem[]{this.twoGridItem, this.threeGridItem});
        this.layout.setPrefWidth(200.0);
        this.layout.setText(this.threeGridItem.getText());
        ImageView imageView3 = (ImageView)this.threeGridItem.getGraphic();
        ImageView imageView4 = new ImageView(imageView3.getImage());
        imageView4.setFitWidth(this.bounds.getHeight());
        imageView4.setFitHeight(this.bounds.getHeight());
        this.layout.setGraphic((Node)imageView4);
        Button button3 = new Button(Messages.getString("TimestenGrid.resetLayout"));
        button3.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                MetricPane.this.gridPane.doGridLayout();
            }
        });
        this.refreshTime = new MenuButton();
        this.manual = new MenuItem(Messages.getString("TimestenGrid.manual"));
        this.thirtySeconds = new MenuItem(Messages.getString("TimestenGrid.thirtySec"));
        this.oneMinute = new MenuItem(Messages.getString("TimestenGrid.fiveMin"));
        this.fiveMinute = new MenuItem(Messages.getString("TimestenGrid.oneMin"));
        this.refreshTime.getItems().addAll((Object[])new MenuItem[]{this.thirtySeconds, this.oneMinute, this.fiveMinute});
        for (MenuItem menuItem2 : this.refreshTime.getItems()) {
            menuItem2.setOnAction(this.refreshIntervalSelection);
        }
        this.refreshTime.setText(this.manual.getText());
        Iterator iterator = new Label(Messages.getString("TimestenGrid.refreshInterval"));
        toolBar.getItems().addAll((Object[])new Node[]{this.metrics, region, iterator, this.refreshTime, button, region2, button3, button2, this.layout});
        this.metrics.setSelected(true);
        menuItem2 = ((SplitPane.Divider)this.innerPane.getDividers().get(0)).positionProperty();
        menuItem2.set(0.2);
        this.metrics.setOnAction(actionEvent -> this.showHidePane(this.metrics.isSelected()));
        this.setTop((Node)toolBar);
    }

    private void showHidePane(boolean bl) {
        this.innerPane.getItems().remove((Object)this.menuPane);
        if (bl) {
            this.innerPane.getItems().add(0, (Object)this.menuPane);
            DoubleProperty doubleProperty = ((SplitPane.Divider)this.innerPane.getDividers().get(0)).positionProperty();
            doubleProperty.set(0.0);
            KeyValue keyValue = new KeyValue((WritableValue)doubleProperty, (Object)0.2);
            new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.5), new KeyValue[]{keyValue})}).play();
        }
    }

    private void createSeeInMenus() {
        TilePane tilePane = new TilePane(2.0, 2.0);
        tilePane.setPrefColumns(2);
        tilePane.setPrefRows(2);
        for (int i = 0; i < 4; ++i) {
            Button button = new Button(i + 1 + "");
            button.setOnAction(this.gridSelection);
            tilePane.getChildren().add((Object)button);
        }
        TilePane tilePane2 = new TilePane(2.0, 2.0);
        tilePane2.setPrefColumns(3);
        tilePane2.setPrefRows(3);
        for (int i = 0; i < 9; ++i) {
            Button button = new Button(i + 1 + "");
            button.setOnAction(this.gridSelection);
            tilePane2.getChildren().add((Object)button);
        }
        this.twoByTwoItem = new CustomMenuItem((Node)tilePane);
        this.threeByThreeItem = new CustomMenuItem((Node)tilePane2);
    }

    private void setupSeeInMenu(int n) {
        this.openIn.getItems().clear();
        if (n == 2) {
            this.openIn.getItems().add((Object)this.twoByTwoItem);
        } else {
            this.openIn.getItems().add((Object)this.threeByThreeItem);
        }
    }

    @Override
    public void elementSelectionChanged() {
        this.gridPane.refreshAllCharts();
    }

    public HashStructure getHashStructure() {
        HashStructure hashStructure = HashStructure.newInstance();
        hashStructure.putInt("gridSize", this.gridPane.getGridSize());
        hashStructure.putString("selectedElements", this.getElementsIdAsStringList());
        hashStructure.putBoolean("panelEnabled", this.metrics.isSelected());
        HashStructure hashStructure2 = HashStructure.newInstance();
        int n = this.gridPane.getGridSize();
        for (int i = 0; i < n * n; ++i) {
            hashStructure2.putString(Integer.toString(i), this.gridPane.getMetricNamesAt(i));
        }
        hashStructure.putHashStructure("metrics", hashStructure2);
        return hashStructure;
    }

    private void save() {
        String string = Connections.getInstance().getConnectionName(this.conn);
        URL uRL = MetricPaneStorage.getStorageURL();
        MetricPaneStorage metricPaneStorage = MetricPaneStorage.createStorage(uRL);
        try {
            metricPaneStorage.load();
            metricPaneStorage.addMetricPane(string, this.getHashStructure());
        }
        catch (IOException iOException) {
            Logger.severe(MetricPane.class, (Throwable)iOException);
        }
    }

    private void loadState() {
        String string = Connections.getInstance().getConnectionName(this.conn);
        URL uRL = MetricPaneStorage.getStorageURL();
        MetricPaneStorage metricPaneStorage = MetricPaneStorage.createStorage(uRL);
        try {
            metricPaneStorage.load();
            HashStructure hashStructure = metricPaneStorage.getMetricPane(string);
            if (hashStructure != null) {
                this.recover(hashStructure);
            }
        }
        catch (IOException iOException) {
            Logger.severe(MetricPane.class, (Throwable)iOException);
        }
    }

    private void recover(HashStructure hashStructure) {
        int n;
        ImageView imageView;
        Object object;
        int n2 = hashStructure.getInt("gridSize");
        String string = hashStructure.getString("selectedElements");
        boolean bl = hashStructure.getBoolean("panelEnabled");
        HashStructure hashStructure2 = hashStructure.getHashStructure("metrics");
        this.gridPane.setGridSize(n2);
        this.showHidePane(bl);
        if (!string.isEmpty()) {
            ImageView imageView2 = string.split(",");
            object = new TreeSet();
            imageView = imageView2;
            int n3 = ((String[])imageView).length;
            for (int i = 0; i < n3; ++i) {
                String string2 = imageView[i];
                ((TreeSet)object).add(Integer.parseInt(string2));
            }
            this.topology.setSelected((TreeSet<Integer>)object);
        }
        this.metrics.setSelected(bl);
        for (n = 0; n < n2 * n2; ++n) {
            object = hashStructure2.getString(Integer.toString(n));
            for (ImageView imageView3 : imageView = ((String)object).split("\\|")) {
                if (imageView3.isEmpty()) continue;
                MetricInfo metricInfo = new MetricInfo();
                metricInfo.setName((String)imageView3);
                metricInfo.setVisibleName(MetricsMessages.getString((String)imageView3));
                this.gridPane.insertMetricChart(n, metricInfo);
            }
        }
        n = n2 == 2 ? 0 : 1;
        object = (MenuItem)this.layout.getItems().get(n);
        this.layout.setText(object.getText());
        imageView = (ImageView)object.getGraphic();
        ImageView imageView4 = new ImageView(imageView.getImage());
        imageView4.setFitWidth(this.bounds.getHeight());
        imageView4.setFitHeight(this.bounds.getHeight());
        this.layout.setGraphic((Node)imageView4);
        this.gridPane.doGridLayout();
        this.setupSeeInMenu(n2);
    }
}

