/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.ttdbobjects;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Table;

public class TimestenElement
extends AbstractChildDBObject {
    public static final String TYPE = "TIMESTENELEMENT";
    public static final String PARTITION_TYPE_KEY = "timestenPartitionType";
    public static final String FK_NAME = "foreignKeyName";
    public static final String COLUMN_HASH = "columnHash";
    public static final String TABLE_ACTION_KEY = "tableAction";
    public static final String TABLE_KEY = "table";
    private TTPartitionType originalPartition = TTPartitionType.NONE;
    private LinkedHashSet<Column> originalColumnHash = null;
    private String originalFK = null;
    private boolean enableDistEdition;

    public TimestenElement() {
        this.setProperty(PARTITION_TYPE_KEY, (Object)TTPartitionType.NONE);
        this.setProperty(FK_NAME, "");
        this.setProperty(COLUMN_HASH, new LinkedHashSet());
        this.setProperty(TABLE_ACTION_KEY, (Object)TableAction.CREATION);
    }

    public String getType() {
        return TYPE;
    }

    public void setTimestenPartitionType(TTPartitionType tTPartitionType) {
        if (this.enableDistEdition) {
            if (this.hasChangedPartition(tTPartitionType)) {
                this.setProperty(TABLE_ACTION_KEY, (Object)TableAction.EDITION_DIFF_DIST);
            } else {
                this.setProperty(TABLE_ACTION_KEY, (Object)TableAction.EDITION_SAME_DIST);
            }
        }
        this.setProperty(PARTITION_TYPE_KEY, (Object)tTPartitionType);
    }

    public void setOriginalPartitionType(TTPartitionType tTPartitionType) {
        this.originalPartition = tTPartitionType;
    }

    public void setTableAction(TableAction tableAction) {
        this.setProperty(TABLE_ACTION_KEY, (Object)tableAction);
    }

    public void setTable(String string) {
        this.setProperty(TABLE_KEY, string);
    }

    public int getHashColumnCount() {
        this.updateHashColumns();
        return this.getColumnHash().size();
    }

    private void updateHashColumns() {
        Object object;
        Table table = (Table)this.getParent();
        LinkedHashSet<Column> linkedHashSet = this.getColumnHash();
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Object object2 = new ArrayList<Column>();
        for (Column column : table.getColumns()) {
            if (linkedHashSet.contains(column)) {
                object2.add(column);
                continue;
            }
            arrayList.add(column);
        }
        if (linkedHashSet.size() == object2.size()) {
            object2.clear();
            object2.addAll(linkedHashSet);
        } else {
            object = new ArrayList(object2.size());
            for (Column column : linkedHashSet) {
                if (!object2.contains(column)) continue;
                ((ArrayList)object).add(column);
            }
            object2 = object;
        }
        linkedHashSet.clear();
        object = object2.iterator();
        while (object.hasNext()) {
            Column column = (Column)object.next();
            linkedHashSet.add(column);
        }
    }

    public TTPartitionType getTimestenPartitionType() {
        return (TTPartitionType)((Object)this.getProperty(PARTITION_TYPE_KEY));
    }

    public TableAction getTTTableAction() {
        return (TableAction)((Object)this.getProperty(TABLE_ACTION_KEY));
    }

    public String getTable() {
        return (String)this.getProperty(TABLE_KEY);
    }

    public String getForeignKey() {
        return (String)this.getProperty(FK_NAME);
    }

    public void setForeignKey(String string) {
        this.setProperty(FK_NAME, string);
        this.setTimestenPartitionType(this.getTimestenPartitionType());
    }

    public Column[] getColumns() {
        return this.getColumnHash().toArray(new Column[0]);
    }

    public LinkedHashSet<Column> getColumnHash() {
        return (LinkedHashSet)this.getProperty(COLUMN_HASH);
    }

    public void setColumnHash(LinkedHashSet<String> linkedHashSet) {
        this.setProperty(COLUMN_HASH, linkedHashSet);
    }

    protected boolean equalsImpl(AbstractDBObject abstractDBObject) {
        return true;
    }

    protected int compareToImpl(AbstractDBObject abstractDBObject) {
        return 0;
    }

    public String[] getDistributionKeys() {
        String[] stringArray = null;
        if (this.getTimestenPartitionType() == TTPartitionType.HASH) {
            stringArray = new String[this.getHashColumnCount()];
            Column[] columnArray = this.getColumns();
            if (columnArray == null) {
                return stringArray;
            }
            for (int i = 0; i < columnArray.length; ++i) {
                stringArray[i] = columnArray[i].getName();
            }
            return stringArray;
        }
        if (this.getTimestenPartitionType() == TTPartitionType.REFERENCE) {
            Table table;
            DBObject dBObject = this.getParent();
            if (dBObject instanceof Table && (dBObject = (table = (Table)dBObject).getConstraint(this.getForeignKey())) instanceof FKConstraint) {
                FKConstraint fKConstraint = (FKConstraint)table.getConstraint(this.getForeignKey());
                stringArray = new String[fKConstraint.getColumns().length];
                Column[] columnArray = fKConstraint.getColumns();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = columnArray[i].getName();
                }
                return stringArray;
            }
            return stringArray;
        }
        return stringArray;
    }

    public boolean enableDistEdition() {
        return this.enableDistEdition;
    }

    public void setEnableDistEdition(boolean bl) {
        this.enableDistEdition = bl;
    }

    public void setOriginalColumnHash(LinkedHashSet<Column> linkedHashSet) {
        this.originalColumnHash = new LinkedHashSet<Column>(linkedHashSet);
    }

    public void setOriginalFK(String string) {
        this.originalFK = string;
    }

    private boolean hasChangedPartition(TTPartitionType tTPartitionType) {
        if (this.originalPartition != TTPartitionType.NONE) {
            if (this.originalPartition == TTPartitionType.HASH) {
                if (tTPartitionType == TTPartitionType.HASH) {
                    if (this.originalColumnHash != null) {
                        LinkedHashSet<Column> linkedHashSet = this.getColumnHash();
                        if (linkedHashSet != null) {
                            if (this.originalColumnHash.size() != linkedHashSet.size()) {
                                return true;
                            }
                            List<DBObjectID> list = this.getColumnIDs(linkedHashSet);
                            for (Column column : this.originalColumnHash) {
                                if (list.contains(column.getID())) continue;
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }
                    return this.getHashColumnCount() > 0;
                }
                return tTPartitionType != this.originalPartition;
            }
            if (this.originalPartition == TTPartitionType.REFERENCE && tTPartitionType == TTPartitionType.REFERENCE) {
                return !this.getForeignKey().equalsIgnoreCase(this.originalFK);
            }
            return tTPartitionType != this.originalPartition;
        }
        return false;
    }

    private List<DBObjectID> getColumnIDs(LinkedHashSet<Column> linkedHashSet) {
        ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
        for (Column column : linkedHashSet) {
            arrayList.add(column.getID());
        }
        return arrayList;
    }

    public static enum TableAction {
        CREATION,
        EDITION_SAME_DIST,
        EDITION_DIFF_DIST;

    }

    public static enum TTPartitionType {
        HASH,
        DUPLICATE,
        REFERENCE,
        NONE;

    }
}

