/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class AutoCompleteComponent
extends JPanel {
    private JTextField tf;
    private JComboBox combo;
    private final List<String> keywords;
    private boolean hide_flag = false;
    private AutoCompleteDocumentListener autoComplete;

    public AutoCompleteComponent(List<String> list) {
        this(0, list);
    }

    public AutoCompleteComponent(int n, List<String> list) {
        super(new BorderLayout());
        this.keywords = list == null ? Collections.emptyList() : list;
        Collections.sort(this.keywords);
        this.initUI();
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        this.tf.setMinimumSize(dimension);
    }

    private void initUI() {
        this.combo = new JComboBox();
        this.combo.setUI(new BasicComboBoxUI(){

            @Override
            protected JButton createArrowButton() {
                return new JButton(){

                    @Override
                    public int getWidth() {
                        return 0;
                    }
                };
            }
        });
        this.combo.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        for (Component component : this.combo.getComponents()) {
            if (!(component instanceof JButton)) continue;
            component.setVisible(false);
        }
        this.combo.setEditable(true);
        this.tf = (JTextField)this.combo.getEditor().getEditorComponent();
        this.autoComplete = new AutoCompleteDocumentListener();
        this.tf.getDocument().addDocumentListener(this.autoComplete);
        this.tf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string = AutoCompleteComponent.this.tf.getText();
                        if (string.length() == 0) {
                            AutoCompleteComponent.this.combo.hidePopup();
                            AutoCompleteComponent.this.setModel(new DefaultComboBoxModel<Object>(AutoCompleteComponent.this.keywords.toArray()), "");
                        } else {
                            DefaultComboBoxModel defaultComboBoxModel = AutoCompleteComponent.getSuggestedModel(AutoCompleteComponent.this.keywords, string);
                            if (defaultComboBoxModel.getSize() == 0 || AutoCompleteComponent.this.hide_flag) {
                                AutoCompleteComponent.this.combo.hidePopup();
                                AutoCompleteComponent.this.hide_flag = false;
                            } else {
                                AutoCompleteComponent.this.setModel(defaultComboBoxModel, string);
                                AutoCompleteComponent.this.combo.showPopup();
                            }
                        }
                    }
                });
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                String string = AutoCompleteComponent.this.tf.getText();
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    AutoCompleteComponent.this.hide_flag = true;
                    AutoCompleteComponent.this.tf.setCaretPosition(AutoCompleteComponent.this.tf.getText().length());
                } else if (n == 27) {
                    AutoCompleteComponent.this.hide_flag = true;
                } else if (n == 39) {
                    for (int i = 0; i < AutoCompleteComponent.this.keywords.size(); ++i) {
                        String string2 = (String)AutoCompleteComponent.this.keywords.get(i);
                        if (!string2.startsWith(string)) continue;
                        AutoCompleteComponent.this.combo.setSelectedIndex(-1);
                        AutoCompleteComponent.this.tf.setText(string2);
                        return;
                    }
                }
            }
        });
        if (this.keywords != null) {
            this.setModel(new DefaultComboBoxModel<Object>(this.keywords.toArray()), "");
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.combo, "North");
        this.add(jPanel);
    }

    public Document getDocument() {
        return this.tf.getDocument();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.tf.setEnabled(bl);
    }

    @Override
    public synchronized void addFocusListener(FocusListener focusListener) {
        this.tf.addFocusListener(focusListener);
    }

    @Override
    public void requestFocus() {
        this.tf.requestFocus();
    }

    private void setModel(DefaultComboBoxModel defaultComboBoxModel, String string) {
        this.combo.setModel(defaultComboBoxModel);
        this.combo.setSelectedIndex(-1);
        this.tf.setText(string);
    }

    private static DefaultComboBoxModel getSuggestedModel(List<String> list, String string) {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (String string2 : list) {
            if (!string2.startsWith(string)) continue;
            defaultComboBoxModel.addElement(string2);
        }
        return defaultComboBoxModel;
    }

    public String getText() {
        return this.tf.getText();
    }

    public void setText(String string) {
        this.tf.setText(string);
    }

    public void setName(String string, String string2) {
        this.tf.setName(string);
        this.combo.setName(string2);
    }

    private class AutoCompleteDocumentListener
    implements DocumentListener {
        private AutoCompleteDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            String string;
            int n;
            if (documentEvent.getLength() != 1) {
                return;
            }
            int n2 = documentEvent.getOffset();
            String string2 = null;
            try {
                string2 = AutoCompleteComponent.this.tf.getText(0, n2 + 1);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            for (n = n2; n >= 0 && Character.isLetter(string2.charAt(n)); --n) {
            }
            if (n2 - n < 2) {
                return;
            }
            String string3 = string2.substring(n + 1);
            int n3 = Collections.binarySearch(AutoCompleteComponent.this.keywords, string3);
            if (n3 < 0 && -n3 <= AutoCompleteComponent.this.keywords.size() && (string = (String)AutoCompleteComponent.this.keywords.get(-n3 - 1)).startsWith(string3)) {
                String string4 = string.substring(n2 - n);
                SwingUtilities.invokeLater(new CompletionTask(string4, n2 + 1));
            }
        }

        private class CompletionTask
        implements Runnable {
            private String completion;
            private int position;

            CompletionTask(String string, int n) {
                this.completion = string;
                this.position = n;
            }

            @Override
            public void run() {
                StringBuffer stringBuffer = new StringBuffer(AutoCompleteComponent.this.tf.getText());
                stringBuffer.insert(this.position, this.completion);
                AutoCompleteComponent.this.tf.setText(stringBuffer.toString());
                AutoCompleteComponent.this.tf.setCaretPosition(this.position + this.completion.length());
                AutoCompleteComponent.this.tf.moveCaretPosition(this.position);
            }
        }
    }
}

