/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.navigator;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.ObjectFactoryRegistry;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.db.model.DatabaseNode;
import oracle.ide.docking.DockableWindow;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigator.NavigatorManager;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.util.WeakCache;

public class DatabaseNavigatorHelper {
    private static Logger getLogger() {
        return DBLog.getLogger(DatabaseNavigatorHelper.class);
    }

    @Deprecated
    public static NavigatorManager getDatabaseNavigatorManager() {
        throw new UnsupportedOperationException("The Database Navigator no longer has a NavigatorManager");
    }

    public static DockableWindow getDatabaseNavigatorWindow() {
        return DBNavigatorManager.getInstance().getNavigatorWindow();
    }

    public static ViewId getDatabaseNavigatorViewID() {
        return DBNavigatorManager.getInstance().getViewId();
    }

    public static DatabaseNode findConnectionNode(String string, String string2) {
        String string3;
        String string4 = string == null ? string : string + "#" + string2;
        try {
            string3 = URLEncoder.encode(string4, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string3 = string4;
        }
        return DatabaseNavigatorHelper.findConnectionNode(string3);
    }

    private static DatabaseNode findConnectionNode(String string) {
        DatabaseConnection databaseConnection = null;
        URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string);
        if (uRL != null) {
            databaseConnection = DatabaseConnection.findConnectionNode((URL)uRL);
        }
        return databaseConnection;
    }

    public static DatabaseNode findConnectionNode(Database database) {
        if (database != null) {
            return DatabaseNavigatorHelper.findConnectionNode(database.getQualifiedName());
        }
        return null;
    }

    public static DBObjectTypeNode findTypeNode(Database database, Schema schema, String string) {
        DBObjectTypeNode dBObjectTypeNode = null;
        if (database != null) {
            Object object;
            String string2 = schema == null ? null : schema.getName();
            String string3 = null;
            if (database instanceof JdbcDatabase && (object = ObjectFactoryRegistry.getDatabaseNavigatorRegistry().getFactory(database.getQualifiedName(), database.getConnection())) != null && object.isSupportsCatalog()) {
                string3 = ((JdbcDatabase)database).getCatalog();
            }
            if ((object = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)database.getQualifiedName(), string3, (String)string2, (String)string)) != null) {
                try {
                    Field field = DatabaseNavigatorElementFactory.class.getDeclaredField("s_typeFolders");
                    field.setAccessible(true);
                    WeakCache weakCache = (WeakCache)field.get(null);
                    Object object2 = weakCache.get(object);
                    if (object2 instanceof DBObjectTypeNode) {
                        dBObjectTypeNode = (DBObjectTypeNode)object2;
                    }
                }
                catch (Throwable throwable) {
                    DatabaseNavigatorHelper.getLogger().log(Level.FINE, "Failed to get type folder", throwable);
                }
            }
        }
        return dBObjectTypeNode;
    }

    public static DBObjectNode findObjectNode(Database database, SystemObject systemObject) {
        Node node;
        URL uRL = DBURLFactory.getURL((DBObjectProvider)database, (SystemObject)systemObject);
        if (uRL != null && (node = NodeFactory.find((URL)uRL)) instanceof DBObjectNode) {
            return (DBObjectNode)node;
        }
        return null;
    }
}

