/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.common.repeatinterval.RepeatIntervalContext;
import oracle.dbtools.scheduler.panels.common.repeatinterval.RepeatIntervalController;
import oracle.dbtools.scheduler.panels.common.repeatinterval.RepeatIntervalFactory;
import oracle.dbtools.scheduler.panels.common.repeatinterval.RepeatIntervalParseException;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractRepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ByDateClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ByDayClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ByTimeClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseComplexity;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ExtendedFreqClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.FreqClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.RepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.ClausePanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.PropertyBasedPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.TimePanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.CombinedSchedule;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Frequency;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.PreDefinedFrequency;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelListener;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.SortedClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Time;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.UnaryClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.UserDefinedFrequency;
import oracle.javatools.util.ArrayMap;

public class RepeatIntervalEditPanel
extends PropertyBasedPanel
implements LayoutControl {
    protected static final String CLAUSE_TERMS = "=;,";
    protected static final String CLAUSE_TERM_REGEX = "[=;,]";
    protected static final String CLAUSE_ELEMENT_REGEX = "[^\"=;,]";
    protected static final String CLAUSE_CHUNK_REGEX = "((((([\"]([^\"]|([\"][\"]))+[\"])|[^\"=;,])+)|[\"])[=;,]?)";
    protected static final String EOL_TAB = "\n";
    protected static final String INDENT_TAB = "\n    ";
    protected static final String DEFAULT_RI = "FREQ=YEARLY";
    protected RepeatIntervalModel rim;
    protected RepeatIntervalContext riContext;
    protected RepeatIntervalController riController;
    private transient Connection conn;
    protected ClauseComplexity complexity = null;
    private JTextArea repeatIntervalTextArea = new JTextArea();
    private JScrollPane repeatIntervalScrollPane = new JScrollPane();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private CardLayout advClauseCardLayout = new CardLayout(0, 0);
    private JPanel advClauseCardPanel = new JPanel(this.advClauseCardLayout);
    private JPanel advTopClausePanel = new JPanel(new GridBagLayout());
    private JPanel byTopClausePanel = new JPanel(new GridBagLayout());
    private JComboBox advClauseComboBox = new JComboBox();
    private JCheckBox advancedCheckBox = new JCheckBox();
    private CardLayout clauseCardLayout = new CardLayout(0, 0);
    private JPanel clauseCardPanel = new JPanel(this.clauseCardLayout);
    private CardLayout topClauseCardLayout = new CardLayout(0, 0);
    private JPanel topClauseCardPanel = new JPanel(this.topClauseCardLayout);
    protected RepeatIntervalClause[] clauses;
    protected Map<ClauseType, RepeatIntervalClause> clauseMap = new HashMap<ClauseType, RepeatIntervalClause>();
    private transient RepeatIntervalChangeListener repeatIntervalChangeListener = new RepeatIntervalChangeListener();
    private JPanel byClausePanel;
    private CardLayout byClauseCardLayout = new CardLayout(0, 0);
    private JPanel byClauseCardPanel = new JPanel(this.byClauseCardLayout);
    private CardManager cardManager;
    private Title[] combinedTitles;
    private Title[] allTitles;
    private Title[] componentTitles;
    private Title[] notYearTitles;
    protected boolean firstClauseChange = true;

    public RepeatIntervalEditPanel(Properties properties, String string, Connection connection) throws RepeatIntervalParseException {
        super(properties);
        this.conn = connection;
        this.riContext = new RepeatIntervalContext(connection);
        RepeatIntervalFactory repeatIntervalFactory = this.riContext.getFactory();
        this.rim = repeatIntervalFactory.getRepeatIntervalModel();
        this.riController = repeatIntervalFactory.getRepeatIntervalController(this.rim);
        this.clauses = this.riController.getRepeatIntervalClauses();
        this.rim.addRepeatIntervalModelListener(this.repeatIntervalChangeListener);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string == null || string.trim().length() == 0) {
            string = DEFAULT_RI;
        }
        this.setRepeatInterval(string);
    }

    public RepeatIntervalEditPanel(String string, Connection connection) throws RepeatIntervalParseException {
        this(null, string, connection);
    }

    public void setRepeatInterval(String string) throws RepeatIntervalParseException {
        this.riController.setRepeatInterval(string);
        this.refreshRepeatIntervalText();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.repeatIntervalTextArea.setEditable(false);
        this.repeatIntervalScrollPane.getViewport().add((Component)this.repeatIntervalTextArea, null);
        this.advancedCheckBox.setText(SchedulerArb.getString("REPEAT_INTERVAL_PANEL_ADVANCED"));
        this.advancedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RepeatIntervalEditPanel.this.advanceCheckBox_actionPerformed(actionEvent);
            }
        });
        ArrayList<Title> arrayList = new ArrayList<Title>();
        ArrayList<Title> arrayList2 = new ArrayList<Title>();
        ArrayList<Title> arrayList3 = new ArrayList<Title>();
        ArrayList<Title> arrayList4 = new ArrayList<Title>();
        ArrayMap arrayMap = new ArrayMap();
        for (int i = 0; i < this.clauses.length; ++i) {
            ClauseType[] clauseTypeArray = this.clauses[i];
            ClauseType object = clauseTypeArray.getClauseType();
            this.clauseMap.put(object, (RepeatIntervalClause)clauseTypeArray);
            arrayMap.put(object, clauseTypeArray);
        }
        new FreqPanel((Map<ClauseType, Object>)arrayMap);
        ArrayMap arrayMap2 = new ArrayMap();
        for (Map.Entry entry : arrayMap.entrySet()) {
            if (entry.getValue() == null) continue;
            arrayMap2.put(entry.getKey(), entry.getValue());
        }
        arrayMap = arrayMap2;
        for (ClauseType clauseType : arrayMap.keySet().toArray(new ClauseType[arrayMap.size()])) {
            JPanel jPanel = null;
            Object v = arrayMap.get((Object)clauseType);
            jPanel = v instanceof AbstractRepeatIntervalClause ? ((RepeatIntervalClause)v).getPanel() : (JPanel)v;
            if (jPanel == null) continue;
            Title title = new Title(this.getCardLabel(clauseType));
            switch (clauseType) {
                case FREQ: {
                    arrayList.add(0, title);
                    arrayList2.add(0, title);
                    arrayList3.add(0, title);
                    arrayList4.add(0, title);
                    break;
                }
                case BYWEEKNO: {
                    arrayList.add(title);
                    arrayList2.add(title);
                    break;
                }
                case EMBEDDEDSCHED: {
                    arrayList.add(title);
                    arrayList2.add(title);
                    arrayList3.add(title);
                    arrayList4.add(title);
                    break;
                }
                case BYTIME: {
                    arrayList.add(title);
                    Version version = this.riContext.getVersion();
                    int[] nArray = version.toIntArray();
                    if (nArray[0] < 12) break;
                    arrayList2.add(title);
                    arrayList3.add(title);
                    break;
                }
                default: {
                    arrayList.add(title);
                    arrayList2.add(title);
                    arrayList3.add(title);
                }
            }
            jPanel.setToolTipText(SchedulerArb.getString(this.getCardToolTip(clauseType)));
            arrayMap.put(clauseType, jPanel);
        }
        this.componentTitles = arrayList.toArray(new Title[arrayList.size()]);
        this.allTitles = arrayList2.toArray(new Title[arrayList2.size()]);
        this.combinedTitles = arrayList4.toArray(new Title[arrayList4.size()]);
        this.notYearTitles = arrayList3.toArray(new Title[arrayList3.size()]);
        this.cardManager = new CardManager(this.componentTitles, arrayMap.values().toArray(new JComponent[arrayMap.size()]));
        this.cardManager.setCards(this.combinedTitles);
        this.createByClausePanel();
        this.advTopClausePanel.add((Component)this.advClauseComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.topClauseCardPanel.add((Component)this.byTopClausePanel, ClauseComplexity.BASIC.toString());
        this.topClauseCardPanel.add((Component)this.advTopClausePanel, ClauseComplexity.ADVANCED.toString());
        this.clauseCardPanel.add((Component)this.byClausePanel, ClauseComplexity.BASIC.toString());
        this.clauseCardPanel.add((Component)this.advClauseCardPanel, ClauseComplexity.ADVANCED.toString());
        this.clauseCardPanel.setBorder(this.repeatIntervalScrollPane.getBorder());
        this.add((Component)this.topClauseCardPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.advancedCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.clauseCardPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.repeatIntervalScrollPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.switchComplexity(ClauseComplexity.ADVANCED);
    }

    private int getOrdinal(Frequency frequency) {
        if (frequency instanceof PreDefinedFrequency) {
            return ((PreDefinedFrequency)frequency).ordinal();
        }
        return -1;
    }

    private void createByClausePanel() {
        this.byClausePanel = new JPanel();
        this.byClausePanel.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.clauseMap.get((Object)ClauseType.INTERVAL).getPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        jPanel.add((Component)((FreqClause)this.clauseMap.get((Object)ClauseType.FREQ)).getPreDefinedSimplePanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        jPanel.setBorder(new TitledBorder(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_FREQ_PANEL_TITLE")));
        this.byClausePanel.add((Component)jPanel, new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 11, 3, new Insets(4, 4, 4, 0), 0, 0));
        this.createByClauseSubPanel();
        this.byClausePanel.add((Component)this.byClauseCardPanel, new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 11, 3, new Insets(4, 0, 4, 4), 0, 0));
    }

    private void createByClauseSubPanel() {
        for (PreDefinedFrequency preDefinedFrequency : PreDefinedFrequency.values()) {
            this.createByClauseSubPanel(preDefinedFrequency);
        }
    }

    private void createByClauseSubPanel(Frequency frequency) {
        JPanel jPanel;
        Object object;
        int n = this.getOrdinal(frequency);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 11, 3, new Insets(0, 4, 0, 0), 0, 0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        if (n > -1 && n < this.getOrdinal(PreDefinedFrequency.MONTHLY)) {
            object = (ByDateClause)this.clauseMap.get((Object)ClauseType.BYDATE);
            if (object != null) {
                jPanel = ((ByDateClause)object).getNoYearPanel();
                jPanel.setAlignmentY(0.0f);
                jPanel.setBorder(new TitledBorder(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_BYDATE_PANEL_TITLE")));
                jPanel2.add((Component)jPanel, gridBagConstraints);
            } else if (n == this.getOrdinal(PreDefinedFrequency.YEARLY)) {
                jPanel = this.clauseMap.get((Object)ClauseType.BYMONTH).getPanel();
                jPanel.setAlignmentY(0.0f);
                jPanel.setBorder(new TitledBorder(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_BYMONTH_PANEL_TITLE")));
                jPanel2.add((Component)jPanel, gridBagConstraints);
                JPanel jPanel3 = this.clauseMap.get((Object)ClauseType.BYMONTHDAY).getPanel();
                jPanel3.setAlignmentY(0.0f);
                jPanel3.setBorder(new TitledBorder(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_BYMONTHYDAY_PANEL_TITLE")));
                jPanel2.add((Component)jPanel3, gridBagConstraints);
            }
        }
        if (n == this.getOrdinal(PreDefinedFrequency.MONTHLY)) {
            object = this.clauseMap.get((Object)ClauseType.BYMONTHDAY).getPanel();
            ((JComponent)object).setAlignmentY(0.0f);
            ((JComponent)object).setBorder(new TitledBorder(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_BYMONTHYDAY_PANEL_TITLE")));
            jPanel2.add((Component)object, gridBagConstraints);
            jPanel = this.clauseMap.get((Object)ClauseType.BYDAY).getPanel();
            jPanel.setAlignmentY(0.0f);
            jPanel.setBorder(new TitledBorder(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_BYDAY_PANEL_TITLE")));
            jPanel2.add((Component)jPanel, gridBagConstraints);
        }
        if (n >= this.getOrdinal(PreDefinedFrequency.WEEKLY)) {
            object = ((ByDayClause)this.clauseMap.get((Object)ClauseType.BYDAY)).getCheckBoxPanel();
            ((JComponent)object).setAlignmentY(0.0f);
            ((JComponent)object).setBorder(new TitledBorder(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_BYDAY_PANEL_TITLE")));
            jPanel2.add((Component)object, gridBagConstraints);
        }
        if (n > -1 && n <= this.getOrdinal(PreDefinedFrequency.DAILY)) {
            object = (ByTimeClause)this.clauseMap.get((Object)ClauseType.BYTIME);
            jPanel = object != null ? ((ByTimeClause)object).getHourPanel() : new HourPanel();
            jPanel.setAlignmentY(0.0f);
            jPanel.setBorder(new TitledBorder(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_BYTIME_PANEL_TITLE")));
            jPanel2.add((Component)jPanel, gridBagConstraints);
        }
        if (n == this.getOrdinal(PreDefinedFrequency.HOURLY)) {
            object = (ByTimeClause)this.clauseMap.get((Object)ClauseType.BYTIME);
            jPanel = object != null ? ((ByTimeClause)object).getNoHourPanel() : new NoHourPanel();
            jPanel.setAlignmentY(0.0f);
            jPanel.setBorder(new TitledBorder(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_BYTIME_PANEL_TITLE")));
            jPanel2.add((Component)jPanel, gridBagConstraints);
        }
        jPanel2.add(Box.createRigidArea(new Dimension(0, 200)), new GridBagConstraints(-1, -1, 1, 1, 1.0, 0.0, 11, 3, new Insets(0, 4, 0, 0), 0, 0));
        this.byClauseCardPanel.add((Component)jPanel2, frequency.toString());
    }

    private void updateByClausePanel(Frequency frequency) {
        if (frequency instanceof PreDefinedFrequency) {
            this.byClauseCardLayout.show(this.byClauseCardPanel, frequency.toString());
        }
    }

    protected void switchComplexity(ClauseComplexity clauseComplexity) {
        if (this.complexity != clauseComplexity) {
            this.complexity = clauseComplexity;
            this.topClauseCardLayout.show(this.topClauseCardPanel, this.complexity.toString());
            this.clauseCardLayout.show(this.clauseCardPanel, this.complexity.toString());
            this.advancedCheckBox.getModel().setSelected(this.complexity == ClauseComplexity.ADVANCED);
        }
    }

    protected void advanceCheckBox_actionPerformed(ActionEvent actionEvent) {
        JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
        if (jCheckBox != null) {
            this.switchComplexity(jCheckBox.isSelected() ? ClauseComplexity.ADVANCED : ClauseComplexity.BASIC);
        }
    }

    private Time sparseTime(ClauseType clauseType, Integer n) {
        return new Time(clauseType == ClauseType.BYSECOND ? n : null, clauseType == ClauseType.BYMINUTE ? n : null, clauseType == ClauseType.BYHOUR ? n : null);
    }

    private Time.ComponentType getComponentType(ClauseType clauseType) {
        switch (clauseType) {
            case BYHOUR: {
                return Time.ComponentType.HOUR;
            }
            case BYMINUTE: {
                return Time.ComponentType.MINUTE;
            }
            case BYSECOND: {
                return Time.ComponentType.SECOND;
            }
        }
        throw new IllegalArgumentException();
    }

    public String getRepeatInterval() {
        return this.riController.getRepeatInterval();
    }

    protected void refreshRepeatIntervalText() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.riController.getRepeatInterval();
        Pattern pattern = Pattern.compile(CLAUSE_CHUNK_REGEX);
        Matcher matcher = pattern.matcher(string);
        boolean bl = false;
        while (matcher.find()) {
            String string2 = string.substring(matcher.start(), matcher.end());
            if (string2 == null) continue;
            stringBuilder.append(string2);
            if (string2.endsWith("=") || string2.endsWith(",")) {
                stringBuilder.append(INDENT_TAB);
                continue;
            }
            if (!string2.endsWith(";")) continue;
            stringBuilder.append(EOL_TAB);
        }
        this.repeatIntervalTextArea.setText(stringBuilder.toString());
        this.validate();
    }

    protected String getCardLabel(ClauseType clauseType) {
        return "REPEAT_INTERVAL_CLAUSE_" + (Object)((Object)clauseType) + "_TAB";
    }

    protected String getCardToolTip(ClauseType clauseType) {
        return this.getCardLabel(clauseType) + "_TOOLTIP";
    }

    static /* synthetic */ Title[] access$300(RepeatIntervalEditPanel repeatIntervalEditPanel) {
        return repeatIntervalEditPanel.allTitles;
    }

    static /* synthetic */ CardManager access$400(RepeatIntervalEditPanel repeatIntervalEditPanel) {
        return repeatIntervalEditPanel.cardManager;
    }

    static /* synthetic */ Title[] access$500(RepeatIntervalEditPanel repeatIntervalEditPanel) {
        return repeatIntervalEditPanel.notYearTitles;
    }

    static /* synthetic */ Title[] access$600(RepeatIntervalEditPanel repeatIntervalEditPanel) {
        return repeatIntervalEditPanel.combinedTitles;
    }

    protected class RepeatIntervalChangeListener
    implements RepeatIntervalModelListener {
        protected RepeatIntervalChangeListener() {
        }

        @Override
        public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
            switch (repeatIntervalModelEvent.getClauseType()) {
                case FREQ: {
                    if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                    RepeatIntervalEditPanel.this.updateByClausePanel(RepeatIntervalEditPanel.this.rim.getFreq());
                }
            }
            if (!(repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE || repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.CLEAR && RepeatIntervalEditPanel.this.firstClauseChange)) {
                ClauseComplexity clauseComplexity = RepeatIntervalEditPanel.this.rim.getClauseComplexity();
                if (clauseComplexity == ClauseComplexity.ADVANCED) {
                    RepeatIntervalEditPanel.this.switchComplexity(ClauseComplexity.ADVANCED);
                    RepeatIntervalEditPanel.this.advancedCheckBox.setEnabled(false);
                } else {
                    if (RepeatIntervalEditPanel.this.firstClauseChange) {
                        RepeatIntervalEditPanel.this.switchComplexity(ClauseComplexity.BASIC);
                    }
                    RepeatIntervalEditPanel.this.advancedCheckBox.setEnabled(true);
                }
                RepeatIntervalEditPanel.this.firstClauseChange = false;
            }
            RepeatIntervalEditPanel.this.refreshRepeatIntervalText();
        }
    }

    protected class HourPanel
    extends NoHourPanel {
        public HourPanel() {
            this(null);
        }

        public HourPanel(Properties properties) {
            this(properties, true, false, null);
        }

        protected HourPanel(Properties properties, boolean bl, boolean bl2, Time[] timeArray) {
            super(properties, bl, bl2, timeArray);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            String string = actionEvent.getActionCommand();
            if (string.equals("Add")) {
                Time time = this.getClauseElement();
                SortedClauseModel sortedClauseModel = (SortedClauseModel)RepeatIntervalEditPanel.this.rim.getClauseModel(ClauseType.BYHOUR);
                if (sortedClauseModel != null) {
                    sortedClauseModel.add(time.getHour());
                }
            } else if (string.equals("Del")) {
                Time time = this.getClauseElement();
                SortedClauseModel sortedClauseModel = (SortedClauseModel)RepeatIntervalEditPanel.this.rim.getClauseModel(ClauseType.BYHOUR);
                if (sortedClauseModel != null) {
                    sortedClauseModel.remove(time.getHour());
                }
            } else if (string.equals("Clear")) {
                RepeatIntervalEditPanel.this.rim.clear(ClauseType.BYHOUR);
            }
        }
    }

    protected class NoHourPanel
    extends TimePanel {
        public NoHourPanel() {
            this(null);
        }

        public NoHourPanel(Properties properties) {
            this(properties, false, false, null);
        }

        protected NoHourPanel(Properties properties, boolean bl, boolean bl2, Time[] timeArray) {
            super(properties, bl, bl2, true, timeArray);
            RepeatIntervalEditPanel.this.rim.addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            String string = actionEvent.getActionCommand();
            if (string.equals("Add")) {
                SortedClauseModel sortedClauseModel;
                Time time = this.getClauseElement();
                SortedClauseModel sortedClauseModel2 = (SortedClauseModel)RepeatIntervalEditPanel.this.rim.getClauseModel(ClauseType.BYSECOND);
                if (sortedClauseModel2 != null) {
                    sortedClauseModel2.add(time.getSecond());
                }
                if ((sortedClauseModel = (SortedClauseModel)RepeatIntervalEditPanel.this.rim.getClauseModel(ClauseType.BYMINUTE)) != null) {
                    sortedClauseModel.add(time.getMinute());
                }
            } else if (string.equals("Del")) {
                SortedClauseModel sortedClauseModel;
                Time time = this.getClauseElement();
                SortedClauseModel sortedClauseModel3 = (SortedClauseModel)RepeatIntervalEditPanel.this.rim.getClauseModel(ClauseType.BYSECOND);
                if (sortedClauseModel3 != null) {
                    sortedClauseModel3.remove(time.getSecond());
                }
                if ((sortedClauseModel = (SortedClauseModel)RepeatIntervalEditPanel.this.rim.getClauseModel(ClauseType.BYMINUTE)) != null) {
                    sortedClauseModel.remove(time.getMinute());
                }
            } else if (string.equals("Clear")) {
                RepeatIntervalEditPanel.this.rim.clear(ClauseType.BYSECOND);
                RepeatIntervalEditPanel.this.rim.clear(ClauseType.BYMINUTE);
            }
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
                switch (repeatIntervalModelEvent.getClauseType()) {
                    case BYHOUR: 
                    case BYMINUTE: 
                    case BYSECOND: {
                        Object object;
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                        Object object2 = repeatIntervalModelEvent.getNewValue();
                        Object object3 = repeatIntervalModelEvent.getOldValue();
                        if (object3 != null && !object3.getClass().isArray()) {
                            object = RepeatIntervalEditPanel.this.sparseTime(repeatIntervalModelEvent.getClauseType(), (Integer)repeatIntervalModelEvent.getOldValue());
                            NoHourPanel.this.changeSelection((Time)object, false);
                        }
                        if (object2 == null) break;
                        if (object2.getClass().isArray()) {
                            object = (Integer[])object2;
                            Time[] timeArray = new Time[((Integer[])object).length];
                            for (int i = 0; i < timeArray.length; ++i) {
                                timeArray[i] = RepeatIntervalEditPanel.this.sparseTime(repeatIntervalModelEvent.getClauseType(), object[i]);
                            }
                            NoHourPanel.this.resetSelections(timeArray, RepeatIntervalEditPanel.this.getComponentType(repeatIntervalModelEvent.getClauseType()));
                            break;
                        }
                        object = RepeatIntervalEditPanel.this.sparseTime(repeatIntervalModelEvent.getClauseType(), (Integer)repeatIntervalModelEvent.getNewValue());
                        NoHourPanel.this.changeSelection((Time)object, true);
                    }
                }
            }
        }
    }

    protected class FreqPanel
    extends PropertyBasedPanel {
        protected JPanel preDefinedFreqPanel;
        protected JPanel userDefinedFreqPanel;
        protected JPanel combinedSchedulePanel;
        protected JPanel intervalPanel;
        protected JPanel setPosPanel;
        protected JRadioButton preDefinedFreqRadioButton;
        protected JRadioButton userDefinedFreqRadioButton;
        protected JRadioButton combinedScheduleRadioButton;
        ButtonGroup freqGroup;

        public FreqPanel(Properties properties, Map<ClauseType, Object> map) {
            super(properties);
            this.preDefinedFreqPanel = null;
            this.userDefinedFreqPanel = null;
            this.combinedSchedulePanel = null;
            this.intervalPanel = null;
            this.setPosPanel = null;
            this.preDefinedFreqRadioButton = null;
            this.userDefinedFreqRadioButton = null;
            this.combinedScheduleRadioButton = null;
            this.freqGroup = null;
            Object object = map.get((Object)ClauseType.FREQ);
            Object object2 = map.get((Object)ClauseType.COMBINEDSCHED);
            Object object3 = map.get((Object)ClauseType.INTERVAL);
            Object object4 = map.get((Object)ClauseType.BYSETPOS);
            map.put(ClauseType.COMBINEDSCHED, null);
            map.put(ClauseType.INTERVAL, null);
            map.put(ClauseType.BYSETPOS, null);
            this.preDefinedFreqPanel = ((RepeatIntervalClause)object).getPanel(properties);
            if (object instanceof ExtendedFreqClause) {
                this.userDefinedFreqPanel = ((ExtendedFreqClause)object).getUserDefinedPanel(properties);
            }
            this.combinedSchedulePanel = object2 != null ? ((RepeatIntervalClause)object2).getPanel(properties) : null;
            this.intervalPanel = ((RepeatIntervalClause)object3).getPanel(properties);
            this.setPosPanel = object4 != null ? ((RepeatIntervalClause)object4).getPanel(properties) : null;
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            RepeatIntervalEditPanel.this.rim.addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
            map.put(ClauseType.FREQ, this);
        }

        public FreqPanel(Map<ClauseType, Object> map) {
            this(null, map);
        }

        protected void jbInit() throws Exception {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            if (this.userDefinedFreqPanel != null) {
                this.userDefinedFreqRadioButton = new JRadioButton();
                this.userDefinedFreqRadioButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_FREQ_TAB_USER_DEFINED"));
                this.userDefinedFreqRadioButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FreqPanel.this.freqRadioButton_actionPerformed(actionEvent);
                    }
                });
                if (this.freqGroup == null) {
                    this.freqGroup = new ButtonGroup();
                }
            }
            if (this.combinedSchedulePanel != null) {
                this.combinedScheduleRadioButton = new JRadioButton();
                this.combinedScheduleRadioButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_FREQ_TAB_COMBINED"));
                this.combinedScheduleRadioButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FreqPanel.this.freqRadioButton_actionPerformed(actionEvent);
                    }
                });
                if (this.freqGroup == null) {
                    this.freqGroup = new ButtonGroup();
                }
            }
            if (this.freqGroup != null) {
                this.preDefinedFreqRadioButton = new JRadioButton();
                this.preDefinedFreqRadioButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_FREQ_TAB_PREDEFINED"));
                this.preDefinedFreqRadioButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FreqPanel.this.freqRadioButton_actionPerformed(actionEvent);
                    }
                });
                this.freqGroup.add(this.preDefinedFreqRadioButton);
                if (this.userDefinedFreqRadioButton != null) {
                    this.freqGroup.add(this.userDefinedFreqRadioButton);
                }
                if (this.combinedScheduleRadioButton != null) {
                    this.freqGroup.add(this.combinedScheduleRadioButton);
                }
            }
            int n = 0;
            this.add((Component)new JLabel(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_INTERVAL_TAB")), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.intervalPanel, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            if (this.setPosPanel != null) {
                this.add((Component)new JLabel(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_BYSETPOS_TAB")), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
                this.add((Component)this.setPosPanel, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            }
            if (this.freqGroup != null) {
                this.add((Component)this.preDefinedFreqRadioButton, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
                this.add((Component)this.preDefinedFreqPanel, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
                if (this.userDefinedFreqRadioButton != null) {
                    this.add((Component)this.userDefinedFreqRadioButton, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
                    this.add((Component)this.userDefinedFreqPanel, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
                }
                if (this.combinedScheduleRadioButton != null) {
                    this.add((Component)this.combinedScheduleRadioButton, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
                    this.add((Component)this.combinedSchedulePanel, new GridBagConstraints(1, n++, 1, 1, 1.0, 1.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
                }
            } else {
                this.add((Component)new JLabel(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_FREQ_TAB_PREDEFINED")), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
                this.add((Component)this.preDefinedFreqPanel, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            }
            if (this.setPosPanel != null) {
                this.setPosPanel.setEnabled(false);
            }
        }

        protected void enableComponents() {
            if (this.preDefinedFreqRadioButton != null) {
                this.preDefinedFreqPanel.setEnabled(this.preDefinedFreqRadioButton.getModel().isSelected());
            }
            if (this.userDefinedFreqRadioButton != null) {
                this.userDefinedFreqPanel.setEnabled(this.userDefinedFreqRadioButton.getModel().isSelected());
            }
            if (this.combinedScheduleRadioButton != null) {
                this.combinedSchedulePanel.setEnabled(this.combinedScheduleRadioButton.getModel().isSelected());
            }
        }

        protected void freqRadioButton_actionPerformed(ActionEvent actionEvent) {
            ClausePanel clausePanel = (ClausePanel)((Object)this.preDefinedFreqPanel);
            ClausePanel clausePanel2 = (ClausePanel)((Object)this.userDefinedFreqPanel);
            UnaryClauseModel unaryClauseModel = (UnaryClauseModel)clausePanel.getClauseModel();
            this.enableComponents();
            if (this.preDefinedFreqRadioButton.getModel().isSelected()) {
                unaryClauseModel.set(clausePanel.getSelectedClauseElement());
            } else if (this.userDefinedFreqRadioButton != null && this.userDefinedFreqRadioButton.getModel().isSelected()) {
                unaryClauseModel.set(clausePanel2.getSelectedClauseElement());
            } else {
                unaryClauseModel.set(null);
            }
            if (this.combinedScheduleRadioButton != null) {
                ClausePanel clausePanel3 = (ClausePanel)((Object)this.combinedSchedulePanel);
                SortedClauseModel sortedClauseModel = (SortedClauseModel)clausePanel3.getClauseModel();
                sortedClauseModel.clear();
            }
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent var1_1) {
                switch (2.$SwitchMap$oracle$dbtools$scheduler$panels$common$repeatinterval$model$ClauseType[var1_1.getClauseType().ordinal()]) {
                    case 1: {
                        if (var1_1.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                        var2_2 = var1_1.getNewValue();
                        if (var2_2 == null) ** GOTO lbl39
                        if (!(var2_2 instanceof PreDefinedFrequency)) ** GOTO lbl30
                        var3_4 = (PreDefinedFrequency)var2_2;
                        if (FreqPanel.this.preDefinedFreqRadioButton != null) {
                            FreqPanel.this.preDefinedFreqRadioButton.getModel().setSelected(true);
                        }
                        switch (2.$SwitchMap$oracle$dbtools$scheduler$panels$common$repeatinterval$model$PreDefinedFrequency[var3_4.ordinal()]) {
                            case 1: {
                                RepeatIntervalEditPanel.access$400(RepeatIntervalEditPanel.this).setCards(RepeatIntervalEditPanel.access$300(RepeatIntervalEditPanel.this));
                                if (FreqPanel.this.setPosPanel != null) {
                                    FreqPanel.this.setPosPanel.setEnabled(true);
                                    break;
                                }
                                ** GOTO lbl41
                            }
                            case 2: {
                                RepeatIntervalEditPanel.access$400(RepeatIntervalEditPanel.this).setCards(RepeatIntervalEditPanel.access$500(RepeatIntervalEditPanel.this));
                                if (FreqPanel.this.setPosPanel != null) {
                                    FreqPanel.this.setPosPanel.setEnabled(true);
                                    break;
                                }
                                ** GOTO lbl41
                            }
                            default: {
                                RepeatIntervalEditPanel.access$400(RepeatIntervalEditPanel.this).setCards(RepeatIntervalEditPanel.access$500(RepeatIntervalEditPanel.this));
                                if (FreqPanel.this.setPosPanel != null) {
                                    FreqPanel.this.setPosPanel.setEnabled(false);
                                    break;
                                }
                                ** GOTO lbl41
                            }
                        }
                        ** GOTO lbl41
lbl30:
                        // 1 sources

                        if (var2_2 instanceof UserDefinedFrequency) {
                            if (FreqPanel.this.userDefinedFreqRadioButton != null) {
                                FreqPanel.this.userDefinedFreqRadioButton.getModel().setSelected(true);
                            }
                            RepeatIntervalEditPanel.access$400(RepeatIntervalEditPanel.this).setCards(RepeatIntervalEditPanel.access$500(RepeatIntervalEditPanel.this));
                        } else {
                            RepeatIntervalEditPanel.access$400(RepeatIntervalEditPanel.this).setCards(RepeatIntervalEditPanel.access$300(RepeatIntervalEditPanel.this));
                        }
                        if (FreqPanel.this.setPosPanel != null) {
                            FreqPanel.this.setPosPanel.setEnabled(false);
                        }
                        ** GOTO lbl41
lbl39:
                        // 1 sources

                        if (FreqPanel.this.setPosPanel != null) {
                            FreqPanel.this.setPosPanel.setEnabled(false);
                        }
lbl41:
                        // 8 sources

                        FreqPanel.this.enableComponents();
                        break;
                    }
                    case 5: {
                        if (FreqPanel.this.combinedScheduleRadioButton == null || var1_1.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE || (var2_3 = var1_1.getNewValue()) == null || var2_3.getClass().isArray() && (var3_5 = (CombinedSchedule[])var2_3).length == 0) break;
                        FreqPanel.this.combinedScheduleRadioButton.getModel().setSelected(true);
                        RepeatIntervalEditPanel.access$400(RepeatIntervalEditPanel.this).setCards(RepeatIntervalEditPanel.access$600(RepeatIntervalEditPanel.this));
                        if (FreqPanel.this.setPosPanel == null) break;
                        FreqPanel.this.setPosPanel.setEnabled(false);
                    }
                }
            }
        }
    }

    class CardManager {
        Title[] titles;
        JComponent[] components;
        ItemListener listener;

        public CardManager(Title[] titleArray, JComponent[] jComponentArray) {
            this.titles = titleArray;
            this.components = jComponentArray;
            for (int i = 0; i < jComponentArray.length; ++i) {
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.add(jComponentArray[i]);
                RepeatIntervalEditPanel.this.advClauseCardPanel.add((Component)jPanel, titleArray[i].getKey());
            }
            DefaultComboBoxModel<Title> defaultComboBoxModel = new DefaultComboBoxModel<Title>(titleArray);
            RepeatIntervalEditPanel.this.advClauseComboBox.setModel(defaultComboBoxModel);
            RepeatIntervalEditPanel.this.advClauseComboBox.setMaximumRowCount(titleArray.length);
            this.listener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (1 == itemEvent.getStateChange()) {
                        Title title = (Title)itemEvent.getItem();
                        RepeatIntervalEditPanel.this.advClauseCardLayout.show(RepeatIntervalEditPanel.this.advClauseCardPanel, title.getKey());
                    }
                }
            };
            RepeatIntervalEditPanel.this.advClauseComboBox.addItemListener(this.listener);
        }

        public void setCards(Title[] titleArray) {
            Object object = RepeatIntervalEditPanel.this.advClauseComboBox.getSelectedItem();
            RepeatIntervalEditPanel.this.advClauseComboBox.removeItemListener(this.listener);
            DefaultComboBoxModel<Title> defaultComboBoxModel = new DefaultComboBoxModel<Title>(titleArray);
            RepeatIntervalEditPanel.this.advClauseComboBox.setModel(defaultComboBoxModel);
            defaultComboBoxModel.setSelectedItem(object);
            RepeatIntervalEditPanel.this.advClauseComboBox.addItemListener(this.listener);
        }
    }

    class Title {
        String key;

        public Title(String string) {
            this.key = string;
        }

        public String toString() {
            return SchedulerArb.getString(this.key);
        }

        public String getKey() {
            return this.key;
        }
    }
}

