/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.clause;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractRepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractScheduleClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseSyntaxHandler;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.ClausePanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.PropertyBasedPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DateModifier;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.EmbeddedSchedule;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ExcludeSchedule;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IncludeSchedule;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IntersectSchedule;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ListClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ModifierType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.NamedSchedule;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.OffsetModifier;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ScheduleClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ScheduleType;

public class EmbeddedScheduleClause
extends AbstractScheduleClause<EmbeddedSchedule, ListClauseModel<EmbeddedSchedule>> {
    public EmbeddedScheduleClause(RepeatIntervalModel repeatIntervalModel) {
        this(EmbeddedSchedule.class, repeatIntervalModel);
    }

    public EmbeddedScheduleClause(ListClauseModel<EmbeddedSchedule> listClauseModel) {
        super(listClauseModel);
    }

    protected EmbeddedScheduleClause(Class<EmbeddedSchedule> clazz, RepeatIntervalModel repeatIntervalModel) {
        this(new ListClauseModel<EmbeddedSchedule>(clazz, ClauseType.EMBEDDEDSCHED, repeatIntervalModel));
    }

    @Override
    public JPanel getPanel() {
        return this.getPanel(null);
    }

    @Override
    public JPanel getPanel(Properties properties) {
        return new Panel(properties);
    }

    @Override
    public ClauseSyntaxHandler getSyntaxHandler() {
        return new SyntaxHandler();
    }

    protected class SyntaxHandler
    extends AbstractRepeatIntervalClause.AbstractSyntaxHandler {
        protected SyntaxHandler() {
        }

        @Override
        public void initialise(String string) {
            if (string != null) {
                int n;
                String string2 = null;
                ScheduleType scheduleType = null;
                String string3 = string.toUpperCase();
                if (string3.startsWith("INCLUDE")) {
                    string2 = string;
                    scheduleType = ScheduleType.INCLUDE;
                } else if (string3.startsWith("EXCLUDE")) {
                    string2 = string;
                    scheduleType = ScheduleType.EXCLUDE;
                } else if (string3.startsWith("INTERSECT")) {
                    string2 = string;
                    scheduleType = ScheduleType.INTERSECT;
                }
                if (string2 != null && (n = string2.indexOf("=")) >= 0 && n != string2.length() - 1) {
                    String[] stringArray;
                    String string4 = string2.substring(n + 1).trim();
                    for (String string5 : stringArray = string4.split(",")) {
                        string5 = string5.trim();
                        try {
                            ArrayList<DateModifier> arrayList = new ArrayList<DateModifier>();
                            string5 = EmbeddedScheduleClause.this.initialiseDateModifiers(string5, arrayList);
                            OffsetModifier offsetModifier = (OffsetModifier)DateModifier.getDataModifier(arrayList, ModifierType.OFFSET);
                            ScheduleClause scheduleClause = new ScheduleClause(new NamedSchedule(string5), offsetModifier);
                            EmbeddedSchedule embeddedSchedule = null;
                            switch (scheduleType) {
                                case INCLUDE: {
                                    embeddedSchedule = new IncludeSchedule(scheduleClause);
                                    break;
                                }
                                case EXCLUDE: {
                                    embeddedSchedule = new ExcludeSchedule(scheduleClause);
                                    break;
                                }
                                case INTERSECT: {
                                    embeddedSchedule = new IntersectSchedule(scheduleClause);
                                }
                            }
                            if (embeddedSchedule == null) continue;
                            ((ListClauseModel)EmbeddedScheduleClause.this.clauseModel).add(embeddedSchedule);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StringBuilder buildClause(StringBuilder stringBuilder, String string) {
            ScheduleType scheduleType = null;
            for (EmbeddedSchedule embeddedSchedule : (EmbeddedSchedule[])((ListClauseModel)EmbeddedScheduleClause.this.clauseModel).getAll()) {
                int n;
                int n2 = n = stringBuilder.length();
                try {
                    String string2 = string;
                    if (embeddedSchedule.getScheduleType() != scheduleType) {
                        scheduleType = embeddedSchedule.getScheduleType();
                        if (string2 == ",") {
                            string2 = ";";
                        }
                        string2 = string2 + scheduleType.getClauseHeader();
                    }
                    if (string2 != null && string2.length() > 0) {
                        stringBuilder.append(string2);
                        n2 = stringBuilder.length();
                    }
                    embeddedSchedule.buildClause(stringBuilder);
                }
                finally {
                    if (n2 == stringBuilder.length() && n < n2) {
                        stringBuilder.delete(n, n2);
                    } else {
                        string = ",";
                    }
                }
            }
            return stringBuilder;
        }
    }

    protected class Panel
    extends PropertyBasedPanel
    implements ClausePanel<EmbeddedSchedule> {
        protected GridBagLayout gridBagLayout1;
        protected transient JComboBox embeddedScheduleComboBox;
        protected transient ComboBoxModel embeddedScheduleModel;
        protected transient JComboBox embeddedTypeComboBox;
        protected transient ComboBoxModel embeddedTypeModel;
        protected JButton addButton;
        protected JButton removeButton;
        protected JButton clearButton;

        public Panel(Properties properties) {
            super(properties);
            this.gridBagLayout1 = new GridBagLayout();
            this.embeddedScheduleComboBox = new JComboBox();
            this.embeddedTypeComboBox = new JComboBox();
            this.addButton = new JButton();
            this.removeButton = new JButton();
            this.clearButton = new JButton();
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        protected void jbInit() throws Exception {
            this.setLayout(this.gridBagLayout1);
            NamedSchedule[] namedScheduleArray = EmbeddedScheduleClause.this.getRepeatIntervalModel().getNamedScheduleList();
            this.embeddedScheduleModel = new DefaultComboBoxModel<NamedSchedule>(namedScheduleArray);
            this.embeddedScheduleComboBox.setModel(this.embeddedScheduleModel);
            ScheduleType[] scheduleTypeArray = new ScheduleType[]{ScheduleType.INCLUDE, ScheduleType.EXCLUDE, ScheduleType.INTERSECT};
            this.embeddedTypeModel = new DefaultComboBoxModel<ScheduleType>(scheduleTypeArray);
            this.embeddedTypeComboBox.setModel(this.embeddedTypeModel);
            this.embeddedTypeComboBox.setSelectedIndex(0);
            this.addButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_ADD"));
            this.addButton.setActionCommand("Add");
            this.addButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_ADD_TOOLTIP"));
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.addButton_actionPerformed(actionEvent);
                }
            });
            this.addButton.setMargin(new Insets(0, 0, 0, 0));
            this.removeButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_REMOVE"));
            this.removeButton.setActionCommand("Del");
            this.removeButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_REMOVE_TOOLTIP"));
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.removeButton_actionPerformed(actionEvent);
                }
            });
            this.removeButton.setMargin(new Insets(0, 0, 0, 0));
            this.clearButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL"));
            this.clearButton.setActionCommand("Clear");
            this.clearButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL_TOOLTIP"));
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.clearButton_actionPerformed(actionEvent);
                }
            });
            this.clearButton.setMargin(new Insets(0, 0, 0, 0));
            this.add((Component)this.embeddedTypeComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.embeddedScheduleComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.addButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.removeButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.clearButton, new GridBagConstraints(4, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        }

        @Override
        public EmbeddedSchedule getSelectedClauseElement() {
            NamedSchedule namedSchedule = (NamedSchedule)this.embeddedScheduleComboBox.getSelectedItem();
            ScheduleType scheduleType = (ScheduleType)this.embeddedTypeComboBox.getSelectedItem();
            if (namedSchedule != null && scheduleType != null) {
                switch (scheduleType) {
                    case INCLUDE: {
                        return new IncludeSchedule(new ScheduleClause(namedSchedule));
                    }
                    case EXCLUDE: {
                        return new ExcludeSchedule(new ScheduleClause(namedSchedule));
                    }
                    case INTERSECT: {
                        return new IntersectSchedule(new ScheduleClause(namedSchedule));
                    }
                }
                return null;
            }
            return null;
        }

        @Override
        public ClauseModel<EmbeddedSchedule> getClauseModel() {
            return EmbeddedScheduleClause.this.clauseModel;
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.embeddedScheduleComboBox.setEnabled(bl);
            this.addButton.setEnabled(bl);
            this.removeButton.setEnabled(bl);
            this.clearButton.setEnabled(bl);
        }

        protected void addButton_actionPerformed(ActionEvent actionEvent) {
            EmbeddedSchedule embeddedSchedule = this.getSelectedClauseElement();
            ((ListClauseModel)EmbeddedScheduleClause.this.clauseModel).add(embeddedSchedule);
        }

        protected void removeButton_actionPerformed(ActionEvent actionEvent) {
            EmbeddedSchedule embeddedSchedule = this.getSelectedClauseElement();
            ((ListClauseModel)EmbeddedScheduleClause.this.clauseModel).remove(embeddedSchedule);
        }

        protected void clearButton_actionPerformed(ActionEvent actionEvent) {
            ((ListClauseModel)EmbeddedScheduleClause.this.clauseModel).clear();
        }
    }
}

