/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseElement;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DurationUnit;

public class DurationValue
implements Comparable<DurationValue>,
ClauseElement {
    protected final Integer scale;
    protected final DurationUnit unit;

    private static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public DurationValue(DurationUnit durationUnit, Integer n) {
        this.scale = n;
        this.unit = durationUnit;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        DurationValue durationValue = (DurationValue)object;
        return DurationValue.areEqual(this.unit, durationValue.unit) && DurationValue.areEqual(this.scale, durationValue.scale);
    }

    @Override
    public int compareTo(DurationValue durationValue) {
        int n = 0;
        if (this != durationValue) {
            if (this.unit != durationValue.unit) {
                n = this.unit == null && durationValue.unit != null ? -1 : (this.unit != null && durationValue.unit == null ? 1 : this.unit.compareTo(durationValue.unit));
            }
            if (n == 0 && this.scale != durationValue.scale) {
                n = this.scale == null && durationValue.scale != null ? -1 : (this.scale != null && durationValue.scale == null ? 1 : this.scale.compareTo(durationValue.scale));
            }
        }
        return n;
    }

    public int hashCode() {
        int n = 7;
        n = n * 31 + (this.unit == null ? 0 : this.unit.hashCode());
        n = n * 31 + (this.scale == null ? 0 : this.scale.hashCode());
        return n;
    }

    public Integer getScale() {
        return this.scale;
    }

    public DurationUnit getUnit() {
        return this.unit;
    }

    @Override
    public StringBuilder buildClause(StringBuilder stringBuilder) {
        if (this.scale != null && this.scale != 0 && this.unit != null) {
            stringBuilder.append(this.scale);
            this.unit.buildClause(stringBuilder);
        }
        return stringBuilder;
    }
}

