/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.e1pdb;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import oracle.dbtools.raptor.cloud.CloudResources;
import oracle.dbtools.raptor.cloud.e1pdb.CloudConfigurationException;
import oracle.dbtools.raptor.connections.OracleConnectionProcessor;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Resource;
import oracle.ide.net.FileNativeHelper;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;

public class CloudProcessor
extends OracleConnectionProcessor {
    private static final String TNS_FILE = "tnsnames.ora";
    private static final String KEYSTORE_FILE = "keystore.jks";
    private static final String TRUSTSTORE_FILE = "truststore.jks";
    static final String CONFIG_FILE = "sqldev.cloud.configfile";
    static final String KEYSTORE_PWD = "sqldev.cloud.keystore-password";
    static final URLFilter ZIPFILE_FILE = new WildcardURLFilter("*.zip", URLFileSystem.isLocalFileSystemCaseSensitive(), CloudResources.getString("LABEL_ZIP_FILES"));
    private static Map<String, CloudConfig> sConfigMapping = new HashMap<String, CloudConfig>();

    static CloudConfig getCloudConfigForZip(File file) throws CloudConfigurationException {
        if (file == null || !file.exists()) {
            return null;
        }
        String string = file.getAbsolutePath();
        long l = CloudProcessor.lastModified(file);
        CloudConfig cloudConfig = sConfigMapping.get(string);
        if (cloudConfig == null || l > cloudConfig.timestamp) {
            cloudConfig = CloudProcessor.createCloudConfig(file);
            sConfigMapping.put(string, cloudConfig);
        }
        return cloudConfig;
    }

    private static CloudConfig createCloudConfig(File file) throws CloudConfigurationException {
        CloudConfig cloudConfig = null;
        long l = CloudProcessor.lastModified(file);
        File file2 = CloudProcessor.expandZip(file);
        List list = null;
        File file3 = new File(file2, TNS_FILE);
        if (file3.exists()) {
            try {
                list = TNSHelper.parseTnsFile((File)file3);
            }
            catch (IOException iOException) {
                throw new CloudConfigurationException(CloudResources.format("ERROR_INVALID_CONFIG", CloudResources.getString("ERROR_REASON_INVALID_TNS"), file.getAbsolutePath()), iOException);
            }
        }
        if (list == null || list.size() == 0) {
            throw new CloudConfigurationException(CloudResources.format("ERROR_INVALID_CONFIG", CloudResources.getString("ERROR_REASON_INVALID_TNS"), file.getAbsolutePath()));
        }
        File file4 = new File(file2, KEYSTORE_FILE);
        File file5 = new File(file2, TRUSTSTORE_FILE);
        if (!file4.exists()) {
            throw new CloudConfigurationException(CloudResources.format("ERROR_INVALID_CONFIG", CloudResources.getString("ERROR_REASON_MISSING_KEYSTORE"), file.getAbsolutePath()));
        }
        cloudConfig = file5.exists() ? new InternalCloudConfig(l, list, file4, file5) : new CloudConfig(l, list, file4);
        if (!CloudProcessor.testJCE()) {
            throw new CloudConfigurationException(CloudResources.format("ERROR_INVALID_JCE_CONFIG", System.getProperty("java.home"), CloudResources.getString("JCE_INSTALL_LOCATION")));
        }
        return cloudConfig;
    }

    private static long lastModified(File file) {
        FileNativeHelper fileNativeHelper = FileNativeHelper.getInstance();
        if (fileNativeHelper.isLoaded()) {
            return fileNativeHelper.lastModified(file);
        }
        long l = file.lastModified();
        return l != 0L ? l : -1L;
    }

    private static File expandZip(File file) throws CloudConfigurationException {
        File file2 = null;
        try {
            Path path = Files.createTempDirectory(Resource.RAPTOR_USER_TEMP.toPath(), "cloudConfig", new FileAttribute[0]);
            File file3 = path.toFile();
            file3.deleteOnExit();
            try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));){
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    File file4 = new File(file3, zipEntry.getName());
                    if (zipEntry.isDirectory()) {
                        file4.mkdir();
                    } else {
                        try (FileOutputStream fileOutputStream = new FileOutputStream(file4);
                             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                            int n = 0;
                            byte[] byArray = new byte[4096];
                            while ((n = zipInputStream.read(byArray, 0, byArray.length)) > 0) {
                                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                            }
                        }
                    }
                    zipInputStream.closeEntry();
                    zipEntry = zipInputStream.getNextEntry();
                }
            }
            file2 = file3;
        }
        catch (IOException iOException) {
            throw new CloudConfigurationException(CloudResources.format("ERROR_INVALID_CONFIG", file.getPath()), iOException);
        }
        return file2;
    }

    static boolean testJCE() {
        int n = 0;
        try {
            n = Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return n > 128;
    }

    public Properties finalizeProperties(Properties properties) {
        Properties properties2 = new Properties();
        String string = properties.getProperty(CONFIG_FILE);
        if (string != null) {
            File file = new File(string);
            try {
                CloudConfig cloudConfig = CloudProcessor.getCloudConfigForZip(file);
                if (cloudConfig != null) {
                    String string2 = properties.getProperty(KEYSTORE_PWD);
                    properties2.putAll((Map<?, ?>)cloudConfig.getConfigProperties(string2));
                }
            }
            catch (CloudConfigurationException cloudConfigurationException) {
                Logger.severe(CloudProcessor.class, (Throwable)cloudConfigurationException);
            }
        }
        return properties2;
    }

    public boolean shouldEncrypt(String string) {
        return KEYSTORE_PWD.equals(string) || "oss.password".equals(string);
    }

    public Properties preprocessProperties(Properties properties) throws SQLException {
        File file;
        CloudConfig cloudConfig;
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        String string = properties.getProperty("customUrl");
        String string2 = properties.getProperty(CONFIG_FILE);
        if (string2 != null && (cloudConfig = CloudProcessor.getCloudConfigForZip(file = new File(string2))) != null) {
            properties2.setProperty("customUrl", cloudConfig.getConnectionURL(string));
        }
        return properties2;
    }

    private static class InternalCloudConfig
    extends CloudConfig {
        private final File truststore;

        InternalCloudConfig(long l, Collection<TCPTNSEntry> collection, File file, File file2) {
            super(l, collection, file);
            this.truststore = file2;
        }

        @Override
        Properties getConfigProperties(String string) {
            Properties properties = super.getConfigProperties(string);
            properties.setProperty("javax.net.ssl.trustStorePassword", string);
            properties.setProperty("javax.net.ssl.trustStore", this.truststore.getAbsolutePath());
            return properties;
        }
    }

    static class CloudConfig {
        private final long timestamp;
        private final Map<String, TCPTNSEntry> tnsEntryMap = new HashMap<String, TCPTNSEntry>();
        private final File keystore;
        private final Properties props = new Properties();

        CloudConfig(long l, Collection<TCPTNSEntry> collection, File file) {
            this.timestamp = l;
            this.keystore = file;
            for (TCPTNSEntry tCPTNSEntry : collection) {
                this.tnsEntryMap.put(tCPTNSEntry.getName(), tCPTNSEntry);
            }
            this.props.setProperty("oracle.net.ssl_server_dn_match", "true");
            this.props.setProperty("oracle.net.ssl_version", "1.2");
        }

        Collection<String> getConnectionNames() {
            return this.tnsEntryMap.keySet();
        }

        String getConnectionURL(String string) {
            TCPTNSEntry tCPTNSEntry = this.tnsEntryMap.get(string);
            return tCPTNSEntry != null ? tCPTNSEntry.getJDBCUrl() : null;
        }

        Properties getConfigProperties(String string) {
            Properties properties = new Properties();
            properties.setProperty("javax.net.ssl.keyStorePassword", string);
            properties.setProperty("javax.net.ssl.keyStore", this.keystore.getAbsolutePath());
            properties.putAll((Map<?, ?>)this.props);
            return properties;
        }
    }
}

