/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.Component;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import oracle.bali.ewt.chooser.color.ColorEditor;
import oracle.bali.share.nls.LocaleUtils;

public abstract class BaseColorEditor
extends JPanel
implements ColorEditor {
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _ACCESS_RESOURCE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private Color _color;
    private boolean _initialized = true;

    @Override
    public void setColor(Color color) {
        if (color == null) {
            color = Color.white;
        }
        if (this._color != color) {
            this._color = color;
            this.colorChanged(color);
            this.repaint();
        }
    }

    @Override
    public Color getColor() {
        if (this._color == null) {
            this._color = Color.white;
        }
        return this._color;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateLabels(this.getLocale());
    }

    protected void storeColor(Color color) {
        Color old = this.getColor();
        this._color = color;
        this.fireColorPropertyChange(old, this._color);
    }

    protected void colorChanged(Color newColor) {
    }

    protected void fireColorPropertyChange(Color oldColor, Color newColor) {
        this.firePropertyChange("color", oldColor, newColor);
    }

    protected void updateLabels(Locale newLocale) {
    }

    protected void updateAccessibleNames() {
    }

    @Override
    public void setLocale(Locale newLocale) {
        super.setLocale(newLocale);
        if (this._initialized) {
            this.updateLabels(this.getLocale());
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.updateAccessibleNames();
        }
        return super.getAccessibleContext();
    }

    static String __getTranslatedString(Locale locale, String key) {
        ResourceBundle b = ResourceBundle.getBundle(_RESOURCE, locale);
        return b.getString(key);
    }

    String __getTranslatedString(String key) {
        return BaseColorEditor.__getTranslatedString(LocaleUtils.getDefaultableLocale((Component)this), key);
    }

    String __getAccessTranslatedString(String key) {
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle b = ResourceBundle.getBundle(_ACCESS_RESOURCE, locale);
        return b.getString(key);
    }
}

