/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

public class OraclePageItemPainter
extends AbstractBorderPainter {
    private static BorderPainter _sBorderPainter;
    private static final ImmInsets _sInsets;

    private OraclePageItemPainter() {
    }

    public static BorderPainter getBorderPainter() {
        if (_sBorderPainter == null) {
            _sBorderPainter = new OraclePageItemPainter();
        }
        return _sBorderPainter;
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 2;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        return _sInsets;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        Object data = context.getPaintData("PageItem.drawRaised");
        boolean raised = Boolean.TRUE.equals(data);
        this._paintBorder(context, g, x, y, width, height, raised);
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }

    private void _paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height, boolean raised) {
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color control = defaults.getColor("control");
        Color shadow = defaults.getColor("normalIntensity");
        Color dark = defaults.getColor("darkIntensity");
        Color darkShadow = defaults.getColor("controlShadowDark");
        if ((state & 0x20) != 0) {
            g.setColor(dark);
            g.drawLine(x, y, right, y);
            g.drawLine(x, y, x, bottom);
        } else {
            g.setColor(dark);
            g.drawLine(x, bottom, right, bottom);
            g.drawLine(right, y, right, bottom);
            boolean reallyRaised = raised && (state & 4) == 0;
            g.setColor(reallyRaised ? Color.white : dark);
            g.drawLine(x, y, right, y);
            if (reallyRaised) {
                g.drawLine(x, y, x, bottom);
            }
            if (reallyRaised) {
                g.setColor(control);
            } else {
                g.setColor(dark);
            }
            g.drawLine(x, bottom, x, bottom);
            g.drawLine(right, y, right, y);
        }
    }

    static {
        _sInsets = new ImmInsets(1, 1, 1, 1);
    }
}

