/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.hGrid;

import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.hGrid.AbstractCellHandler;
import oracle.bali.ewt.grid.hGrid.HArrayTwoDModel;
import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.grid.hGrid.HTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;

public class HCellHandler
extends AbstractCellHandler {
    public HCellHandler() {
    }

    public HCellHandler(Painter painter) {
        super(painter);
    }

    public HCellHandler(CellInputHandler input) {
        super(input);
    }

    public HCellHandler(Painter painter, CellInputHandler input) {
        super(painter, input);
    }

    @Override
    protected boolean setCellExpansionState(TwoDModel model, int columnIndex, int rowIndex, boolean doExpand) {
        if (this.cellHasChildren(model, columnIndex, rowIndex)) {
            HTwoDModel hModel = (HTwoDModel)model;
            if (doExpand) {
                HArrayTwoDModel hArraymodel;
                if (hModel instanceof HArrayTwoDModel && (hArraymodel = (HArrayTwoDModel)hModel).isRowExpanded(columnIndex, rowIndex)) {
                    return false;
                }
                hModel.expandRow(columnIndex, rowIndex);
            } else {
                HArrayTwoDModel hArraymodel;
                if (hModel instanceof HArrayTwoDModel && !(hArraymodel = (HArrayTwoDModel)hModel).isRowExpanded(columnIndex, rowIndex)) {
                    return false;
                }
                hModel.collapseRow(columnIndex, rowIndex);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean cellHasChildren(TwoDModel model, int columnIndex, int rowIndex) {
        HDataObject hData = this.getCellHData(model, columnIndex, rowIndex);
        return hData != null && hData.hasChildren();
    }

    @Override
    protected int getCellDepth(TwoDModel model, int columnIndex, int rowIndex) {
        HDataObject hData = this.getCellHData(model, columnIndex, rowIndex);
        if (hData != null) {
            return hData.getDepth();
        }
        return 0;
    }

    @Override
    protected boolean isCellExpanded(TwoDModel model, int columnIndex, int rowIndex) {
        HDataObject hData = this.getCellHData(model, columnIndex, rowIndex);
        if (hData != null) {
            return hData.isExpanded();
        }
        return false;
    }

    @Override
    public Object getWrappedData(Object sourceData) {
        if (sourceData instanceof HDataObject) {
            sourceData = ((HDataObject)sourceData).getData();
        }
        return sourceData;
    }

    protected HDataObject getCellHData(TwoDModel model, int columnIndex, int rowIndex) {
        Object data = model.getData(columnIndex, rowIndex);
        if (data instanceof HDataObject) {
            return (HDataObject)data;
        }
        return null;
    }
}

