/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.olaf.AlignedPainterJoiner;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.ViewPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.MarginBorderPainter;
import oracle.bali.share.util.IntegerUtils;

class AbstractButtonPaintContext
extends JPaintContext
implements SwingConstants {
    private AbstractButton _ab;
    private boolean _interior;
    private static JButton _sFocusedButton;

    public AbstractButtonPaintContext(AbstractButton ab) {
        this(ab, false);
    }

    public AbstractButtonPaintContext(AbstractButton ab, boolean interior) {
        super(ab);
        this._ab = ab;
        this._interior = interior;
    }

    @Override
    public Color getSurroundingColor() {
        if (this._interior) {
            return this.getPaintBackground();
        }
        return super.getSurroundingColor();
    }

    @Override
    public int getPaintState() {
        int state = super.getPaintState();
        state &= 0xFFFFFFFE;
        AbstractButton ab = this._ab;
        ButtonModel bm = ab.getModel();
        boolean enabled = bm.isEnabled();
        if (!enabled) {
            state |= 1;
        }
        if (ab.isRolloverEnabled() && bm.isRollover()) {
            state |= 0x10;
        }
        if (bm.isSelected()) {
            state |= 8;
        }
        if (bm.isArmed() && (ab instanceof JMenuItem || bm.isPressed())) {
            state |= 2;
        }
        if (ab instanceof JButton) {
            if (ab.hasFocus()) {
                state |= 0x80;
            } else {
                JButton focused;
                JRootPane root = SwingUtilities.getRootPane(ab);
                if (root != null && root.getDefaultButton() == ab && ((focused = AbstractButtonPaintContext._getFocusedButton()) == null || SwingUtilities.getRootPane(focused) != root)) {
                    state |= 0x80;
                }
            }
        }
        if (!ab.isFocusPainted()) {
            state &= 0xFFFFFFBF;
        }
        if (!ab.isContentAreaFilled()) {
            state |= 0x100;
        }
        return state;
    }

    @Override
    public Object getPaintData(Object key) {
        AbstractButton ab = this._ab;
        if (LABEL_KEY.equals(key)) {
            return ab.getText();
        }
        if (ICON_KEY.equals(key)) {
            boolean isSet;
            Icon icon = null;
            int state = this.getPaintState();
            boolean bl = isSet = (state & 8) != 0;
            if ((state & 1) != 0) {
                if (isSet) {
                    icon = ab.getDisabledSelectedIcon();
                }
                if (icon == null) {
                    icon = ab.getDisabledIcon();
                }
                if (icon != null) {
                    return icon;
                }
            }
            if ((state & 2) != 0) {
                icon = ab.getPressedIcon();
            }
            if (icon == null && (state & 0x10) != 0) {
                if (isSet && (icon = ab.getRolloverSelectedIcon()) == null) {
                    icon = ab.getSelectedIcon();
                }
                if (icon == null) {
                    icon = ab.getRolloverIcon();
                }
            }
            if (icon == null && isSet) {
                icon = ab.getSelectedIcon();
            }
            if (icon == null) {
                icon = ab.getIcon();
            }
            return icon;
        }
        if (ViewPainter.VIEW_KEY.equals(key)) {
            return ViewPainter.getHTMLView(ab);
        }
        if (AlignedPainterJoiner.HORIZONTAL_TEXT_POSITION.equals(key)) {
            return IntegerUtils.getInteger((int)ab.getHorizontalTextPosition());
        }
        if (AlignedPainterJoiner.VERTICAL_TEXT_POSITION.equals(key)) {
            return IntegerUtils.getInteger((int)ab.getVerticalTextPosition());
        }
        if (MNEMONIC_INDEX_KEY.equals(key)) {
            return AbstractButtonPaintContext.getMnemonicIndex(ab.getText(), ab.getMnemonic());
        }
        if (MarginBorderPainter.MARGIN_KEY.equals(key)) {
            return ab.getMargin();
        }
        return null;
    }

    @Override
    public float getInteriorAlignmentX() {
        int hAlign = OracleUIUtils.getActualHorizontalAlignment(this, this._ab.getHorizontalAlignment());
        return (float)(hAlign == 2 ? 0.0 : (hAlign == 4 ? 1.0 : 0.5));
    }

    @Override
    public float getInteriorAlignmentY() {
        int vAlign = this._ab.getVerticalAlignment();
        return (float)(vAlign == 1 ? 0.0 : (vAlign == 3 ? 1.0 : 0.5));
    }

    static void __setFocusedButton(AbstractButton focused) {
        if (!(focused instanceof JButton)) {
            focused = null;
        }
        if (focused == null) {
            AbstractButtonPaintContext._repaintRealDefault(_sFocusedButton);
        } else {
            AbstractButtonPaintContext._repaintRealDefault(focused);
        }
        _sFocusedButton = (JButton)focused;
    }

    private static void _repaintRealDefault(AbstractButton focused) {
        JButton defaultButton;
        JRootPane root;
        if (focused != null && (root = SwingUtilities.getRootPane(focused)) != null && (defaultButton = root.getDefaultButton()) != null) {
            defaultButton.repaint();
        }
    }

    private static JButton _getFocusedButton() {
        JButton focused = _sFocusedButton;
        if (focused != null && !focused.hasFocus()) {
            focused = null;
            _sFocusedButton = null;
        }
        return focused;
    }
}

