/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.olaf.OracleCaret;

class OracleFieldCaret
extends OracleCaret
implements UIResource {
    private transient boolean _temporaryLoss;
    private transient int _tempDot;
    private transient int _tempMark;

    OracleFieldCaret() {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.positionCaret(e);
            JTextComponent component = this.getComponent();
            if (component.isEnabled() && !component.hasFocus()) {
                if (component.isEditable()) {
                    this._tempDot = this.getDot();
                    this._tempMark = this.getMark();
                    component.requestFocus();
                    this.setDot(this._tempMark);
                    this.moveDot(this._tempDot);
                } else {
                    component.requestFocus();
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        int length = this.getComponent().getDocument().getLength();
        if (!this._temporaryLoss) {
            this.setDot(0);
            this.moveDot(length);
        } else {
            this.setDot(Math.min(this._tempMark, length));
            this.moveDot(Math.min(this._tempDot, length));
            this._temporaryLoss = false;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e != null) {
            this._temporaryLoss = e.isTemporary();
            if (this._temporaryLoss) {
                this._tempDot = this.getDot();
                this._tempMark = this.getMark();
            }
        } else {
            this._temporaryLoss = false;
        }
        this.setDot(this.getDot());
        this.setVisible(false);
    }

    @Override
    protected void adjustVisibility(Rectangle r) {
        JTextField field = (JTextField)this.getComponent();
        BoundedRangeModel vis = field.getHorizontalVisibility();
        int x = r.x + vis.getValue();
        int quarterSpan = vis.getExtent() / 4;
        if (x < vis.getValue()) {
            vis.setValue(x - quarterSpan);
        } else if (x > vis.getValue() + vis.getExtent()) {
            vis.setValue(x - 3 * quarterSpan);
        }
    }
}

