/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.graphics.FontUtils;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class OracleOptionPaneUI
extends BasicOptionPaneUI {
    private static final Insets _sMESSAGE_INSETS = new Insets(15, 25, 15, 15);
    private static final Insets _sPANE_INSETS = new Insets(6, 6, 8, 6);
    private static final int _sICON_DELTA = 20;
    private static final String _YES_KEY = "OPTIONPANE.YES";
    private static final String _NO_KEY = "OPTIONPANE.NO";
    private static final String _OK_KEY = "COMMON.OK";
    private static final String _CANCEL_KEY = "COMMON.CANCEL";
    private static final String _HELP_KEY = "COMMON.HELP";

    public static ComponentUI createUI(JComponent x) {
        return new OracleOptionPaneUI();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        Window w = SwingUtilities.getWindowAncestor(c);
        Insets i = w == null ? new Insets(0, 0, 0, 0) : w.getInsets();
        int horzonInsets = i.left + i.right;
        int verticalInsets = i.top + i.bottom;
        int widthPlusInsets = d.width + horzonInsets;
        int heightPlusInsets = d.height + verticalInsets;
        if (widthPlusInsets > WindowUtils.DIALOG_MAXIMUM_WIDTH) {
            d.width = WindowUtils.DIALOG_MAXIMUM_WIDTH - horzonInsets;
        }
        if (heightPlusInsets > WindowUtils.DIALOG_MAXIMUM_HEIGHT) {
            d.height = WindowUtils.DIALOG_MAXIMUM_HEIGHT - verticalInsets;
        }
        return d;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.optionPane.setBorder(new EmptyBorder(_sPANE_INSETS));
    }

    @Override
    protected void uninstallDefaults() {
        this.optionPane.setBorder(null);
    }

    @Override
    protected void installComponents() {
        this.optionPane.add("South", this.createButtonArea());
        this.optionPane.add("Center", this.createMessageArea());
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BorderLayout(0, 8);
    }

    @Override
    protected void addIcon(Container top) {
        Icon sideIcon = this.getIcon();
        if (sideIcon != null) {
            JLabel iconLabel = new JLabel(sideIcon);
            iconLabel.setVerticalAlignment(1);
            top.add("icon", iconLabel);
        }
    }

    @Override
    protected Container createMessageArea() {
        JPanel messagePane = new JPanel();
        messagePane.setLayout(new OptionPaneLayout());
        messagePane.setBorder(new EmptyBorder(_sMESSAGE_INSETS));
        this.addIcon(messagePane);
        this.addMessageComponents(messagePane, this.getMessage(), null, false);
        return new GrayPane(messagePane);
    }

    protected void addMessageComponents(Container container, Object msg, Object constraint, boolean internallyCreated) {
        if (msg == null) {
            return;
        }
        if (msg instanceof Component) {
            container.add((Component)msg, constraint);
            if (!internallyCreated) {
                this.hasCustomComponents = true;
            }
        } else if (msg instanceof Object[]) {
            Object[] msgs = (Object[])msg;
            for (int i = 0; i < msgs.length; ++i) {
                this.addMessageComponents(container, msgs[i], null, false);
            }
        } else if (msg instanceof Icon) {
            JLabel label = new JLabel((Icon)msg, 0);
            Color c = UIManager.getColor("OptionPane.messageForeground");
            label.setForeground(c);
            this.addMessageComponents(container, label, null, true);
        } else {
            String s = msg.toString();
            MultiLineLabel label = new MultiLineLabel(WordWrapper.getTextWrapper(), s);
            label.setMaximumColumns(this.getMaxCharactersPerLineCount());
            this.addMessageComponents(container, label, "label", true);
        }
    }

    @Override
    protected Container createButtonArea() {
        DialogButtonBar bottom = new DialogButtonBar();
        this.addButtonComponents(bottom, this.getButtons(), this.getInitialValueIndex());
        return bottom;
    }

    @Override
    protected void addButtonComponents(Container container, Object[] buttons, int initialIndex) {
        DialogButtonBar buttonBar;
        if (buttons == null || buttons.length == 0) {
            return;
        }
        if (container instanceof DialogButtonBar) {
            buttonBar = (DialogButtonBar)container;
        } else {
            buttonBar = new DialogButtonBar();
            container.setLayout(new BorderLayout());
            container.add("Center", buttonBar);
        }
        int numButtons = buttons.length;
        for (int counter = 0; counter < numButtons; ++counter) {
            Component newComponent;
            Object button = buttons[counter];
            if (button instanceof Component) {
                Object constraint = DialogButtonBar.CONSTRAINT_NULL;
                newComponent = (Component)button;
                boolean bl = this.hasCustomComponents = !(button instanceof Extra);
                if (button instanceof Extra) {
                    Extra extra = (Extra)button;
                    ActionListener buttonListener = this.createButtonActionListener(counter);
                    if (buttonListener != null) {
                        extra.addActionListener(buttonListener);
                    }
                    constraint = extra.getConstraint();
                }
                buttonBar.add(newComponent, constraint);
            } else {
                PushButton aButton = button instanceof Icon ? new PushButton((Icon)button) : new PushButton(button.toString());
                buttonBar.add((Component)aButton, DialogButtonBar.CONSTRAINT_NULL);
                ActionListener buttonListener = this.createButtonActionListener(counter);
                if (buttonListener != null) {
                    aButton.addActionListener(buttonListener);
                }
                newComponent = aButton;
            }
            if (counter != initialIndex) continue;
            this.initialFocusComponent = newComponent;
            if (!(this.initialFocusComponent instanceof JButton)) continue;
            JButton defaultB = (JButton)this.initialFocusComponent;
            defaultB.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent e) {
                    JButton defaultButton = (JButton)e.getComponent();
                    JRootPane root = SwingUtilities.getRootPane(defaultButton);
                    if (root != null) {
                        root.setDefaultButton(defaultButton);
                    }
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            });
        }
    }

    @Override
    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] suppliedOptions = this.optionPane.getOptions();
            if (suppliedOptions == null) {
                Object[] defaultOptions;
                int type = this.optionPane.getOptionType();
                ResourceBundle alertBundle = ResourceBundle.getBundle("oracle.bali.ewt.olaf.resource.OLAFBundle", LocaleUtils.getDefaultableLocale((Component)this.optionPane));
                switch (type) {
                    case 0: {
                        defaultOptions = new Object[2];
                        String text = alertBundle.getString(_YES_KEY);
                        String label = StringUtils.stripMnemonic((String)text);
                        int mnemonicKeyCode = StringUtils.getMnemonicKeyCode((String)text);
                        Extra button = new Extra(label, DialogButtonBar.CONSTRAINT_YES);
                        defaultOptions[0] = button;
                        button.setMnemonic(mnemonicKeyCode);
                        text = alertBundle.getString(_NO_KEY);
                        label = StringUtils.stripMnemonic((String)text);
                        mnemonicKeyCode = StringUtils.getMnemonicKeyCode((String)text);
                        button = new Extra(label, DialogButtonBar.CONSTRAINT_NO);
                        defaultOptions[1] = button;
                        button.setMnemonic(mnemonicKeyCode);
                        break;
                    }
                    case 1: {
                        defaultOptions = new Object[3];
                        String text = alertBundle.getString(_YES_KEY);
                        String label = StringUtils.stripMnemonic((String)text);
                        int mnemonicKeyCode = StringUtils.getMnemonicKeyCode((String)text);
                        Extra button = new Extra(label, DialogButtonBar.CONSTRAINT_YES);
                        defaultOptions[0] = button;
                        button.setMnemonic(mnemonicKeyCode);
                        text = alertBundle.getString(_NO_KEY);
                        label = StringUtils.stripMnemonic((String)text);
                        mnemonicKeyCode = StringUtils.getMnemonicKeyCode((String)text);
                        button = new Extra(label, DialogButtonBar.CONSTRAINT_NO);
                        defaultOptions[1] = button;
                        button.setMnemonic(mnemonicKeyCode);
                        label = StringUtils.stripMnemonic((String)alertBundle.getString(_CANCEL_KEY));
                        button = new Extra(label, DialogButtonBar.CONSTRAINT_CANCEL);
                        defaultOptions[2] = button;
                        break;
                    }
                    case 2: {
                        defaultOptions = new Object[2];
                        String label = StringUtils.stripMnemonic((String)alertBundle.getString(_OK_KEY));
                        Extra button = new Extra(label, DialogButtonBar.CONSTRAINT_YES);
                        defaultOptions[0] = button;
                        label = StringUtils.stripMnemonic((String)alertBundle.getString(_CANCEL_KEY));
                        button = new Extra(label, DialogButtonBar.CONSTRAINT_CANCEL);
                        defaultOptions[1] = button;
                        break;
                    }
                    default: {
                        defaultOptions = new Object[1];
                        String label = StringUtils.stripMnemonic((String)alertBundle.getString(_OK_KEY));
                        Extra button = new Extra(label, DialogButtonBar.CONSTRAINT_YES);
                        defaultOptions[0] = button;
                    }
                }
                return defaultOptions;
            }
            return suppliedOptions;
        }
        return null;
    }

    private class OptionPaneLayout
    implements LayoutManager {
        private Component _icon;
        private Component _label;

        private OptionPaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if ("icon".equals(name)) {
                this._icon = comp;
            } else if ("label".equals(name)) {
                this._label = comp;
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp == this._icon) {
                this._icon = null;
            } else if (comp == this._label) {
                this._label = null;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this._getSize(parent, true);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this._getSize(parent, false);
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            Dimension size = parent.getSize();
            int x = 0;
            int y = 0;
            if (insets != null) {
                size.width -= insets.left + insets.right;
                size.height -= insets.top + insets.bottom;
                x = insets.left;
                y = insets.top;
            }
            if (this._icon != null) {
                Dimension iconSize = this._icon.getPreferredSize();
                this._icon.setBounds(x, y, iconSize.width, iconSize.height);
                x += iconSize.width + 20;
                size.width -= iconSize.width + 20;
                if (y + iconSize.height > size.height) {
                    size.height = y + iconSize.height;
                }
            }
            int vOffset = this._getVOffset(parent);
            int count = parent.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component c = parent.getComponent(i);
                if (c == this._icon) continue;
                Dimension d = c.getPreferredSize();
                if (i == count - 1 && c == this._label) {
                    d.height = size.height - (y - insets.top);
                }
                c.setBounds(x, y, size.width, d.height);
                y += d.height + vOffset;
            }
        }

        private Dimension _getSize(Container parent, boolean usePrefSize) {
            Dimension iconSize;
            Insets insets = parent.getInsets();
            Dimension dimension = this._icon == null ? new Dimension() : (iconSize = usePrefSize ? this._icon.getPreferredSize() : this._icon.getMinimumSize());
            if (this._icon != null) {
                iconSize.width += 20;
            }
            int count = parent.getComponentCount();
            int width = 0;
            int height = 0;
            Dimension d = null;
            for (int i = 0; i < count; ++i) {
                Component c = parent.getComponent(i);
                if (c == this._icon) continue;
                if (usePrefSize && c instanceof MultiLineLabel) {
                    MultiLineLabel mll = (MultiLineLabel)c;
                    mll.setPreferredAspectRatio(4.0f);
                    d = mll.getPreferredSize();
                    Font font = mll.getFont();
                    if (font != null) {
                        int minMLLWidth;
                        Insets inset;
                        int sub = iconSize.width + insets.left + insets.right;
                        for (Container comp = parent.getParent(); comp != null; comp = comp.getParent()) {
                            inset = comp.getInsets();
                            sub += inset.left + inset.right;
                            if (comp == OracleOptionPaneUI.this.optionPane) break;
                        }
                        if (d.width < (minMLLWidth = 262 - sub)) {
                            FontMetrics metrics = mll.getFontMetrics(font);
                            int avgwidth = FontUtils.getAverageWidth(metrics);
                            mll.setPreferredColumns(minMLLWidth / avgwidth);
                            d = mll.getPreferredSize();
                        } else {
                            int maxMLLWidth;
                            Window w = SwingUtilities.getWindowAncestor(parent);
                            if (w != null) {
                                inset = w.getInsets();
                                sub += inset.left + inset.right;
                            }
                            if (d.width > (maxMLLWidth = WindowUtils.DIALOG_MAXIMUM_WIDTH - sub)) {
                                FontMetrics metrics = mll.getFontMetrics(font);
                                int avgwidth = FontUtils.getAverageWidth(metrics);
                                mll.setPreferredColumns(maxMLLWidth / avgwidth);
                                d = mll.getPreferredSize();
                            }
                        }
                    }
                } else {
                    Dimension dimension2 = d = usePrefSize ? c.getPreferredSize() : c.getMinimumSize();
                }
                if (d.width > width) {
                    width = d.width;
                }
                height += d.height;
            }
            if (count != 0) {
                height += this._getVOffset(parent) * (count -= this._icon == null ? 1 : 2);
            }
            width += iconSize.width;
            if (iconSize.height > height) {
                height = iconSize.height;
            }
            if (insets != null) {
                width += insets.left + insets.right;
                height += insets.top + insets.bottom;
            }
            return new Dimension(width, height);
        }

        private int _getVOffset(Component c) {
            Font font = c.getFont();
            int fontSize = font == null ? 0 : c.getFontMetrics(font).getHeight();
            return Math.min(15, fontSize);
        }
    }

    private class Extra
    extends PushButton {
        private Object _constraint;

        public Extra(String s, Object constraint) {
            super(s);
            this._constraint = constraint;
        }

        public Object getConstraint() {
            return this._constraint;
        }
    }
}

