/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

class OracleTabPainter
extends AbstractBorderPainter {
    public static final int ORIENTATION_TOP = 1;
    public static final int ORIENTATION_LEFT = 2;
    public static final int ORIENTATION_BOTTOM = 3;
    public static final int ORIENTATION_RIGHT = 4;
    public static final int POSITION_CENTER = 0;
    public static final int POSITION_LEFTMOST = 1;
    public static final int POSITION_RIGHTMOST = 2;
    public static final int POSITION_TOPMOST = 1;
    public static final int POSITION_BOTTOMMOST = 2;
    private static final int _INNER_INSETS = 6;
    private static final int _EDGE_INSETS = 3;
    private int _orientation;
    private int _position;
    private final ImmInsets[] _sHorizInsetsArr = new ImmInsets[]{new ImmInsets(3, 6, 3, 6), new ImmInsets(3, 3, 3, 6), new ImmInsets(3, 6, 3, 3)};
    private final ImmInsets[] _sVertInsetsArr = new ImmInsets[]{new ImmInsets(6, 3, 6, 3), new ImmInsets(3, 3, 6, 3), new ImmInsets(6, 3, 3, 3)};

    public OracleTabPainter(Painter wrappedPainter, int orientation, int position) {
        super(wrappedPainter);
        this._orientation = orientation;
        this._position = position;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        if (this._orientation == 1 || this._orientation == 3) {
            return this._sHorizInsetsArr[this._position];
        }
        return this._sVertInsetsArr[this._position];
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 0x400;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color shadow;
        Color light;
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color back = context.getPaintBackground();
        Color normal = defaults.getColor("TabbedPane.normalColor");
        Color dark = defaults.getColor("TabbedPane.darkShadow");
        if ((state & 4) != 0) {
            light = dark;
            shadow = dark;
        } else {
            light = defaults.getColor("TabbedPane.lightBorder");
            shadow = normal;
        }
        if (this._orientation == 1) {
            if ((state & 0x20) == 0) {
                if (this._position != 1) {
                    x += 3;
                    width -= 3;
                }
                if (this._position != 2) {
                    right -= 3;
                    width -= 3;
                }
                g.setColor(back);
                g.fillRect(x, y + 3, width, height - 3);
                g.fillRect(x + 1, y + 1, width - 2, 2);
                g.drawLine(x + 3, y, right - 3, y);
            } else {
                g.setColor(light);
                if (this._position == 1) {
                    g.drawLine(x, y + 3, x, bottom);
                } else {
                    g.drawLine(x, bottom, x + 1, bottom);
                    g.drawLine(x + 2, bottom - 2, x + 2, bottom - 1);
                    g.drawLine(x + 3, y + 3, x + 3, bottom - 3);
                    g.setColor(back);
                    g.drawLine(x + 2, bottom, x + 2, bottom);
                    g.drawLine(x + 3, bottom - 2, x + 3, bottom);
                    g.setColor(light);
                    x += 3;
                    width -= 3;
                }
                if (this._position == 2) {
                    g.setColor(dark);
                    g.drawLine(right, y + 3, right, bottom);
                } else {
                    g.drawLine(right - 1, bottom, right, bottom);
                    g.setColor(dark);
                    g.drawLine(right - 2, bottom - 1, right - 2, bottom - 2);
                    g.drawLine(right - 3, y + 3, right - 3, bottom - 3);
                    g.setColor(back);
                    g.drawLine(right - 2, bottom, right - 2, bottom);
                    g.drawLine(right - 3, bottom - 2, right - 3, bottom);
                    right -= 3;
                    width -= 3;
                }
                g.setColor(light);
                g.drawLine(x + 1, y + 1, x + 1, y + 2);
                g.drawLine(x + 2, y + 1, x + 2, y + 1);
                g.drawLine(x + 3, y, right - 3, y);
                g.drawLine(right - 2, y + 1, right - 1, y + 1);
                g.setColor(shadow);
                g.drawLine(right - 1, y + 1, right - 1, y + 1);
                g.setColor(dark);
                g.drawLine(right - 1, y + 2, right - 1, y + 2);
                g.setColor(back);
                g.fillRect(x + 1, y + 3, width - 2, height - 3);
                g.drawLine(x + 2, y + 2, right - 2, y + 2);
                g.drawLine(x + 3, y + 1, right - 3, y + 1);
            }
        } else if (this._orientation == 3) {
            if ((state & 0x20) == 0) {
                if (this._position != 1) {
                    x += 3;
                    width -= 3;
                }
                if (this._position != 2) {
                    right -= 3;
                    width -= 3;
                }
                g.setColor(back);
                g.fillRect(x, y, width, height - 3);
                g.fillRect(x + 1, bottom - 2, width - 2, 2);
                g.drawLine(x + 3, bottom, right - 3, bottom);
            } else {
                g.setColor(light);
                if (this._position == 1) {
                    g.drawLine(x, y, x, bottom - 3);
                } else {
                    g.drawLine(x + 2, y + 1, x + 2, y + 2);
                    g.drawLine(x + 3, y + 3, x + 3, bottom - 3);
                    g.setColor(dark);
                    g.drawLine(x, y, x + 1, y);
                    g.setColor(back);
                    g.drawLine(x + 2, y, x + 2, y);
                    g.drawLine(x + 3, y, x + 3, y + 2);
                    x += 3;
                }
                g.setColor(dark);
                if (this._position == 2) {
                    g.drawLine(right, y, right, bottom - 3);
                } else {
                    g.drawLine(right - 1, y, right, y);
                    g.drawLine(right - 2, y + 1, right - 2, y + 2);
                    g.drawLine(right - 3, y + 3, right - 3, bottom - 3);
                    g.setColor(back);
                    g.drawLine(right - 2, y, right - 2, y);
                    g.drawLine(right - 3, y, right - 3, y + 2);
                    right -= 3;
                }
                g.setColor(back);
                g.fillRect(x + 1, y, right - x - 1, bottom - y);
                g.setColor(light);
                g.drawLine(x + 1, bottom - 2, x + 1, bottom - 2);
                g.setColor(shadow);
                g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
                g.setColor(dark);
                g.drawLine(x + 2, bottom - 1, x + 2, bottom - 1);
                g.setColor(dark);
                g.drawLine(x + 3, bottom, right - 3, bottom);
                g.drawLine(right - 2, bottom - 1, right - 1, bottom - 1);
                g.drawLine(right - 1, bottom - 2, right - 1, bottom - 2);
                g.setColor(back);
                g.fillRect(x + 1, y - 3, right - 1, 3 - height);
                g.drawLine(x + 2, y - 2, right - 2, y - 2);
                g.drawLine(x + 3, y - 1, right - 3, y - 1);
            }
        } else if (this._orientation == 2) {
            if ((state & 0x20) == 0) {
                if (this._position != 1) {
                    y += 3;
                    height -= 3;
                }
                if (this._position != 2) {
                    bottom -= 3;
                    height -= 3;
                }
                g.setColor(back);
                g.fillRect(x + 3, y, width - 3, height);
                g.fillRect(x + 1, y + 1, 2, height - 2);
                g.drawLine(x, y + 3, x, bottom - 3);
            } else {
                g.setColor(light);
                if (this._position == 1) {
                    g.drawLine(x + 3, y, right, y);
                } else {
                    g.drawLine(right, y, right, y + 1);
                    g.drawLine(right - 2, y + 2, right - 1, y + 2);
                    g.drawLine(x + 3, y + 3, right - 3, y + 3);
                    g.setColor(back);
                    g.drawLine(right, y + 2, right, y + 2);
                    g.drawLine(right - 2, y + 3, right, y + 3);
                    g.setColor(light);
                    y += 3;
                    height -= 3;
                }
                if (this._position == 2) {
                    g.setColor(dark);
                    g.drawLine(x + 3, bottom, right, bottom);
                } else {
                    g.drawLine(right, bottom - 1, right, bottom);
                    g.setColor(dark);
                    g.drawLine(right - 2, bottom - 2, right - 1, bottom - 2);
                    g.drawLine(x + 3, bottom - 3, right - 3, bottom - 3);
                    g.setColor(back);
                    g.drawLine(right, bottom - 2, right, bottom - 2);
                    g.drawLine(right - 2, bottom - 3, right, bottom - 3);
                    bottom -= 3;
                    height -= 3;
                }
                g.setColor(light);
                g.drawLine(x + 1, y + 1, x + 2, y + 1);
                g.drawLine(x + 1, y + 2, x + 1, y + 2);
                g.drawLine(x, y + 3, x, bottom - 3);
                g.drawLine(x + 1, bottom - 2, x + 1, bottom - 2);
                g.setColor(shadow);
                g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
                g.setColor(dark);
                g.drawLine(x + 2, bottom - 1, x + 2, bottom - 1);
                g.setColor(back);
                g.fillRect(x + 3, y + 1, width - 3, height - 2);
                g.drawLine(x + 2, y + 2, x + 2, bottom - 2);
                g.drawLine(x + 1, y + 3, x + 1, bottom - 3);
            }
        } else if ((state & 0x20) == 0) {
            if (this._position != 1) {
                y += 3;
                height -= 3;
            }
            if (this._position != 2) {
                bottom -= 3;
                height -= 3;
            }
            g.setColor(back);
            g.fillRect(x, y, width - 3, height);
            g.fillRect(right - 2, y + 1, 2, height - 2);
            g.drawLine(right, y + 3, right, bottom - 3);
        } else {
            g.setColor(light);
            if (this._position == 1) {
                g.drawLine(x, y, right - 3, y);
                g.setColor(dark);
            } else {
                g.drawLine(x + 1, y + 2, x + 2, y + 2);
                g.drawLine(x + 3, y + 3, right - 3, y + 3);
                g.setColor(back);
                g.drawLine(x, y + 2, x, y + 2);
                g.drawLine(x, y + 3, x + 2, y + 3);
                g.setColor(dark);
                g.drawLine(x, y, x, y + 1);
                y += 3;
                height -= 3;
            }
            if (this._position == 2) {
                g.drawLine(x, bottom, right - 3, bottom);
            } else {
                g.drawLine(x + 3, bottom - 3, right - 3, bottom - 3);
                g.drawLine(x + 1, bottom - 2, x + 2, bottom - 2);
                g.drawLine(x, bottom - 1, x, bottom);
                g.setColor(back);
                g.drawLine(x, bottom - 2, x, bottom - 2);
                g.drawLine(x, bottom - 3, x + 2, bottom - 3);
                g.setColor(dark);
                bottom -= 3;
                height -= 3;
            }
            g.drawLine(right - 2, bottom - 1, right - 1, bottom - 1);
            g.drawLine(right - 1, bottom - 2, right - 1, bottom - 2);
            g.drawLine(right, y + 3, right, bottom - 3);
            g.drawLine(right - 1, y + 2, right - 1, y + 2);
            g.setColor(shadow);
            g.drawLine(right - 1, y + 1, right - 1, y + 1);
            g.setColor(light);
            g.drawLine(right - 2, y + 1, right - 2, y + 1);
            g.setColor(back);
            g.fillRect(x, y + 1, width - 3, height - 2);
            g.drawLine(right - 2, y + 2, right - 2, bottom - 2);
            g.drawLine(right - 1, y + 3, right - 1, bottom - 3);
        }
        g.setColor(savedColor);
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }
}

