/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.olaf.OracleFieldCaret;
import oracle.bali.ewt.olaf.OracleUIUtils;

public class OracleTextFieldUI
extends BasicTextFieldUI {
    private static final String _UNEDITABLE_BACKGROUND = "control";

    public static ComponentUI createUI(JComponent component) {
        return new OracleTextFieldUI();
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        component.setOpaque(true);
        OracleTextFieldUI.__initializeBackground(component);
        OracleUIUtils.putPaintContext(component);
    }

    @Override
    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        OracleUIUtils.removePaintContext(component);
    }

    @Override
    public void update(Graphics g, JComponent component) {
        if (component.isOpaque()) {
            OracleUIUtils.fillBackground(g, component);
        }
        this.paint(g, component);
    }

    @Override
    public Dimension getMinimumSize(JComponent component) {
        Dimension minimumSize = super.getMinimumSize(component);
        minimumSize.width += component.getFontMetrics(component.getFont()).charWidth('m');
        return minimumSize;
    }

    @Override
    protected void propertyChange(PropertyChangeEvent e) {
        OracleTextFieldUI.__fixBackground(e, "TextField.background");
    }

    @Override
    protected void paintBackground(Graphics g) {
    }

    private OracleTextFieldUI() {
    }

    static void __initializeBackground(JComponent component) {
        JTextComponent tc = (JTextComponent)component;
        if (!(!(component.getBackground() instanceof UIResource) || tc.isEditable() && tc.isEnabled())) {
            component.setBackground(UIManager.getColor(_UNEDITABLE_BACKGROUND));
        }
    }

    static void __fixBackground(PropertyChangeEvent event, String defaultBG) {
        if ("editable".equals(event.getPropertyName()) || "enabled".equals(event.getPropertyName())) {
            JComponent c = (JComponent)event.getSource();
            boolean editableOrEnabled = Boolean.TRUE.equals(event.getNewValue());
            if (c.getBackground() instanceof UIResource) {
                UIDefaults defaults = OracleUIUtils.getUIDefaults(c);
                c.setBackground(defaults.getColor(editableOrEnabled ? defaultBG : _UNEDITABLE_BACKGROUND));
            }
        }
    }

    @Override
    protected Caret createCaret() {
        return new OracleFieldCaret();
    }
}

