/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.bigCell.BigCellPainter;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.AbstractWrappingPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.WrappingTextPainter;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.ImmInsets;

public class PivotHeaderPainter
extends AbstractWrappingPainter {
    PivotHeader _header;
    private Painter _painter;
    private boolean _outline;

    public PivotHeaderPainter(PivotHeader header) {
        this(header, null);
    }

    public PivotHeaderPainter(PivotHeader header, Painter wrappedPainter) {
        super(new BorderLessBigCellPainter());
        this._painter = wrappedPainter;
        this._header = header;
        this._getBigCellPainter().setPainter(new TotalP());
    }

    public void setCellBorderVisible(boolean visible) {
        this._getBigCellPainter().setCellBorderVisible(visible);
        this._getBigCellPainter().setHorizontalSeparatorsVisible(visible);
        this._getBigCellPainter().setVerticalSeparatorsVisible(visible);
    }

    public boolean isCellBorderVisible() {
        return this._getBigCellPainter().isCellBorderVisible();
    }

    public void dispose() {
        if (this._header == null) {
            return;
        }
        this._getBigCellPainter().setPainter(null);
        this._painter = null;
        this._header = null;
    }

    public Painter getPainter() {
        if (this._painter == null) {
            this._painter = new WrappingTextPainter();
        }
        return this._painter;
    }

    public void setPainter(Painter painter) {
        if (this._painter != painter) {
            this._painter = painter;
            this._header.repaint();
        }
    }

    public void setOutline(boolean outline) {
        if (this._outline != outline) {
            this._outline = outline;
            this._header.repaint();
        }
    }

    public boolean isOutline() {
        return this._outline;
    }

    public void setKeepHeaderCellsVisible(boolean dynamic) {
        if (this.getKeepHeaderCellsVisible() != dynamic) {
            this._getBigCellPainter().setKeepCellsVisible(dynamic);
            this._header.repaint();
        }
    }

    public boolean getKeepHeaderCellsVisible() {
        return this._getBigCellPainter().isKeepCellsVisible();
    }

    private BorderLessBigCellPainter _getBigCellPainter() {
        return (BorderLessBigCellPainter)this.getWrappedPainter(null);
    }

    private static class BorderLessBigCellPainter
    extends BigCellPainter {
        private boolean _borderVisible = true;

        private BorderLessBigCellPainter() {
        }

        @Override
        public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
            if (!this._borderVisible) {
                Appearance appearance = (Appearance)context.getPaintData("Appearance");
                BorderPainter bp = appearance.getBorderPainter();
                appearance.setBorderPainter(null);
                super.paint(context, g, x, y, width, height);
                appearance.setBorderPainter(bp);
            } else {
                super.paint(context, g, x, y, width, height);
            }
        }

        public void setCellBorderVisible(boolean visible) {
            this._borderVisible = visible;
        }

        public boolean isCellBorderVisible() {
            return this._borderVisible;
        }
    }

    private class TotalP
    extends AbstractPainter {
        private ImmInsets _insets;
        private ImageP _imagePainter = new ImageP();

        public TotalP() {
            this._insets = new ImmInsets(0, 1, 0, 1);
        }

        @Override
        public Dimension getMinimumSize(PaintContext context) {
            return PivotHeaderPainter.this.getPainter().getMinimumSize(context);
        }

        @Override
        public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
            TwoDModel ds;
            Object data;
            Cell cell = (Cell)context.getPaintData("Cell");
            Image image = PivotHeaderPainter.this._header.getDrillImage(cell.column, cell.row);
            if (image != null && PivotHeaderPainter.this._header.getDrillImagesDisplayed()) {
                FontMetrics metrics;
                this._imagePainter.setImage(image);
                Dimension d = this._imagePainter.getPreferredSize(context);
                int savedY = y;
                float align = context.getInteriorAlignmentY();
                Font f = context.getPaintFont();
                int fontSize = 0;
                if (f == null) {
                    f = PivotHeaderPainter.this._header.getFont();
                }
                if (f != null && (metrics = context.getFontMetrics(f)) != null) {
                    fontSize = metrics.getHeight();
                }
                int temp = height;
                if (height < fontSize) {
                    temp = fontSize;
                }
                y = (int)((float)y + (float)(temp - fontSize) * align + (float)((fontSize - d.height) / 2));
                this._imagePainter.paint(context, g, x, y, d.width, height);
                y = savedY;
                x += d.width;
                width -= d.width;
            }
            x += this._insets.left;
            y += this._insets.top;
            width -= this._insets.left + this._insets.right;
            height -= this._insets.top + this._insets.bottom;
            if (PivotHeaderPainter.this.isOutline() && (data = (ds = (TwoDModel)context.getPaintData("Model")).getData(cell.column, cell.row)) instanceof AbstractPivotHeaderCell) {
                AbstractPivotHeaderCell phCell = (AbstractPivotHeaderCell)data;
                Grid grid = (Grid)context.getPaintData("Grid");
                int indent = phCell.getIndent();
                for (int i = 0; i < indent; ++i) {
                    int cWidth = grid.getColumnWidth(i);
                    x += cWidth;
                    width -= cWidth;
                }
            }
            PivotHeaderPainter.this.getPainter().paint(context, g, x, y, width, height);
        }
    }

    private static class ImageP
    extends ImagePainter {
        private Image _image;

        public ImageP() {
            super(0);
        }

        public void setImage(Image image) {
            this._image = image;
        }

        @Override
        protected Image getImageData(PaintContext context) {
            return this._image;
        }
    }
}

