/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.postgresql;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdEnumColumn;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdSetColumn;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.AbstractOfflineCapturer;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.plugin.postgresql.PostgreSQLConstraintDetails;
import oracle.dbtools.migration.workbench.plugin.postgresql.PostgreSQLUniqueKeyDetails;
import oracle.dbtools.migration.workbench.postgresql.BlackMessages;
import oracle.dbtools.migration.workbench.postgresql.PostgreSQLColumnHelper;
import oracle.dbtools.migration.workbench.postgresql.PostgreSQLConstraintExtractor;
import oracle.dbtools.migration.workbench.postgresql.PostgreSQLOfflineUtils;
import oracle.dbtools.migration.workbench.postgresql.PostgreSQLUniqueKeyExtractor;

public class PostgreSQLOfflineCapturer
extends AbstractOfflineCapturer {
    public static final String MY_LANGUAGE_ID = "PostgreSQL";
    protected String m_inputDirectory;
    protected Properties m_properties;
    protected static final String ENUM_DATA_TYPE = "ENUM";
    protected static final String SET_DATA_TYPE = "SET";
    protected static final String PRIMARY_KEY_INDICATOR = "PRI";
    protected HashMap<String, String> m_columnIndexKey = new HashMap();
    protected int m_minorVersion;
    protected HashMap<String, Integer> m_getMaxOfColumn;
    protected String m_dbName = null;
    private ArrayList<String> m_dblist = null;

    public String captureInitializeImpl(String string, Properties properties) throws OfflineCaptureException {
        this.m_inputDirectory = string;
        this.m_properties = properties;
        PostgreSQLOfflineUtils.setEncoding(this.getEncoding());
        this.m_dblist = this.getSelectedDatabaseList();
        for (String string2 : this.m_dblist) {
            this.addDatabaseToCapture(string2);
        }
        return "PostgreSQLOffline";
    }

    public void captureStarting() {
        this.m_dbName = this.getNextDatabase();
    }

    public void cleanUp() throws OfflineCaptureException {
    }

    public String[] generateScripts(String string, int n) throws OfflineCaptureException {
        return null;
    }

    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        if (string.equals("MD_CATALOGS")) {
            this.storeDefaultCatalog(captureContext);
            String string2 = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("max_column_info"));
            this.m_getMaxOfColumn = PostgreSQLOfflineUtils.getMaxOfColumn(string2);
        } else if (string.equals("MD_SCHEMAS")) {
            this.captureSchema(captureContext);
            this.captureColumns(captureContext);
            this.captureIndexes(captureContext);
            this.captureConstraints(captureContext);
        }
    }

    protected void storeDefaultCatalog(CaptureContext captureContext) throws PersistenceException {
        DBObjectId dBObjectId;
        String string = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("version_info"));
        this.m_minorVersion = PostgreSQLOfflineUtils.getMinorVersion(string);
        MdCatalog mdCatalog = (MdCatalog)captureContext.getContextVariable("CATALOG");
        if (mdCatalog == null) {
            dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
            mdCatalog = new MdCatalog(dBObjectId);
            mdCatalog.setDummyFlag("Y");
            mdCatalog.setCatalogName(MY_LANGUAGE_ID);
        }
        dBObjectId = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CATALOGS"), MY_LANGUAGE_ID);
        captureContext.getAudience().fireListeners((CaptureEvent)dBObjectId);
        mdCatalog = (MdCatalog)this.getStorer().storeObject((PersistableObject)mdCatalog);
        dBObjectId.setEventId(4);
        captureContext.getAudience().fireListeners((CaptureEvent)dBObjectId);
    }

    protected void captureSchema(CaptureContext captureContext) throws PersistenceException {
        try {
            String string = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("table_info").trim());
            HashMap<String, ArrayList<String>> hashMap = PostgreSQLOfflineUtils.getSchemaAndTables(string);
            Set<String> set = hashMap.keySet();
            for (String string2 : set) {
                if (!this.m_dbName.equals(string2)) continue;
                CaptureAudience captureAudience = captureContext.getAudience();
                DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CATALOGID");
                MdSchema mdSchema = new MdSchema(dBObjectId);
                mdSchema.setName(string2);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_SCHEMAS"), mdSchema.getName());
                captureAudience.fireListeners(captureEvent);
                mdSchema = (MdSchema)this.getStorer().storeObject((PersistableObject)mdSchema);
                captureEvent.setEventId(4);
                captureAudience.fireListeners(captureEvent);
                captureContext.setContextVariable("SCHEMAID", (Object)mdSchema.getKey());
                ArrayList<String> arrayList = hashMap.get(string2);
                for (String string3 : arrayList) {
                    DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
                    String string4 = "";
                    MdCatalog mdCatalog = (MdCatalog)captureContext.getContextVariable("CATALOG");
                    if (mdCatalog != null && !mdCatalog.getDummyFlag().equals("Y")) {
                        string4 = mdCatalog.getCatalogName() + ".";
                    }
                    string4 = string4 + string2 + ".";
                    string4 = string4 + string3;
                    MdTable mdTable = new MdTable(dBObjectId2, string3, string4);
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TABLES"), mdTable.getTableName());
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdTable = (MdTable)this.getStorer().storeObject((PersistableObject)mdTable);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    protected void captureColumns(CaptureContext captureContext) throws PersistenceException {
        try {
            String string = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("column_table_info"));
            HashMap<String, ArrayList<String>> hashMap = PostgreSQLOfflineUtils.getColumns(string);
            Set<String> set = hashMap.keySet();
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
            DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CATALOGID");
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            DBObjectId dBObjectId3 = null;
            DBObjectId dBObjectId4 = null;
            for (String string2 : set) {
                CaptureAudience captureAudience = captureContext.getAudience();
                String string3 = string2.substring(0, string2.indexOf(".")).trim();
                String string4 = string2.substring(string2.indexOf(".") + 1).trim();
                dBObjectId3 = persistenceUtility.getIdForSchema(dBObjectId2, string3);
                if (dBObjectId3 == null || !this.m_dbName.equals(string3)) continue;
                dBObjectId4 = persistenceUtility.getIdForTable(dBObjectId3, string4);
                ArrayList<String> arrayList = hashMap.get(string2);
                for (String string5 : arrayList) {
                    Integer n;
                    String string6;
                    Object object = null;
                    int n2 = 1;
                    boolean bl = false;
                    String[] stringArray = null;
                    String string7 = "";
                    String string8 = "";
                    int n3 = 1;
                    StringTokenizer stringTokenizer = new StringTokenizer(string5, ";");
                    while (stringTokenizer.hasMoreElements()) {
                        string6 = stringTokenizer.nextToken();
                        if (n3 == 1) {
                            string7 = string6;
                        } else if (n3 == 2) {
                            string8 = string6;
                        }
                        ++n3;
                    }
                    string6 = "`" + string3 + "`.`" + string4 + "`.`" + string7 + "`";
                    PostgreSQLColumnHelper postgreSQLColumnHelper = new PostgreSQLColumnHelper(string8);
                    String string9 = postgreSQLColumnHelper.getDataTypeName();
                    if ((string9.equals(ENUM_DATA_TYPE) || string9.equals(SET_DATA_TYPE)) && (stringArray = this.getAllValues(string8)) != null) {
                        object = string9.equals(ENUM_DATA_TYPE) ? new MdEnumColumn(dBObjectId4, string7, Integer.valueOf(n2++), stringArray, dBObjectId) : new MdSetColumn(dBObjectId4, string7, Integer.valueOf(n2++), stringArray, dBObjectId);
                        bl = true;
                    }
                    if (string5.endsWith("auto_increment") && this.m_getMaxOfColumn.containsKey(string6) && !bl) {
                        n = this.m_getMaxOfColumn.get(string6);
                        object = new MdIdentityColumn(dBObjectId4, string7, Integer.valueOf(n2++), 0L, 1L, (long)n.intValue(), dBObjectId);
                        bl = true;
                    }
                    if (!bl) {
                        object = new MdColumn(dBObjectId4, string7, Integer.valueOf(n2++));
                    }
                    object.setColumnType(string9);
                    object.setPrecision(Integer.valueOf(postgreSQLColumnHelper.getPrecision()));
                    if (postgreSQLColumnHelper.hasPrecisionAndScale()) {
                        object.setScale(Integer.valueOf(postgreSQLColumnHelper.getScale()));
                    }
                    if (string5.contains("YES")) {
                        object.setNullable("Y");
                    } else {
                        object.setNullable("N");
                    }
                    if (string5.contains(PRIMARY_KEY_INDICATOR)) {
                        this.m_columnIndexKey.put(string6, PRIMARY_KEY_INDICATOR);
                    } else if (string5.contains("MUL")) {
                        this.m_columnIndexKey.put(string6, "MUL");
                    } else if (string5.contains("UNI")) {
                        this.m_columnIndexKey.put(string6, "UNI");
                    }
                    n = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_COLUMNS"), object.getColumnName());
                    captureAudience.fireListeners((CaptureEvent)n);
                    object = (MdColumn)this.getStorer().storeObject((PersistableObject)object);
                    n.setEventId(4);
                    captureAudience.fireListeners((CaptureEvent)n);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    protected String[] getAllValues(String string) {
        String string2 = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "'");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = (String)stringTokenizer.nextElement();
            if (string3.equals(",")) continue;
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void captureIndexes(CaptureContext captureContext) throws PersistenceException {
        try {
            String string = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("index_info"));
            HashMap<String, ArrayList<String>> hashMap = PostgreSQLOfflineUtils.getIndexes(string);
            Set<String> set = hashMap.keySet();
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CATALOGID");
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            DBObjectId dBObjectId2 = null;
            DBObjectId dBObjectId3 = null;
            for (String string2 : set) {
                String string3 = string2.substring(0, string2.indexOf(".")).trim();
                String string4 = string2.substring(string2.indexOf(".") + 1).trim();
                dBObjectId2 = persistenceUtility.getIdForSchema(dBObjectId, string3);
                if (dBObjectId2 == null) continue;
                dBObjectId3 = persistenceUtility.getIdForTable(dBObjectId2, string4);
                ArrayList<String> arrayList = hashMap.get(string2);
                if (!this.m_dbName.equals(string3)) continue;
                MdIndexe mdIndexe = null;
                MdConstraint mdConstraint = null;
                boolean bl = false;
                boolean bl2 = false;
                for (String string5 : arrayList) {
                    MdIndexe mdIndexe2 = null;
                    MdConstraint mdConstraint2 = null;
                    String[] stringArray = this.retreiveIndexDetails(string5, this.getIndexDetailsSize());
                    if (stringArray[3].equals("1")) {
                        CaptureEvent captureEvent;
                        String string6 = stringArray[2];
                        String string7 = "`" + string3 + "`.`" + string4 + "`.`" + stringArray[4] + "`";
                        String string8 = this.m_columnIndexKey.get(string7);
                        if (string8.startsWith(PRIMARY_KEY_INDICATOR) && stringArray[1].equals("0") && stringArray[2].equals("PRIMARY")) {
                            bl = false;
                            bl2 = true;
                            mdConstraint2 = new MdConstraint(dBObjectId3, MY_LANGUAGE_ID);
                            mdConstraint2.setName(string6);
                            mdConstraint2.setConstraintType("PK");
                            mdConstraint = mdConstraint2;
                            captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), string6);
                            captureContext.getAudience().fireListeners(captureEvent);
                            mdConstraint2 = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint2);
                            captureEvent.setEventId(4);
                            captureContext.getAudience().fireListeners(captureEvent);
                        } else {
                            bl = true;
                            bl2 = false;
                            mdIndexe2 = new MdIndexe(dBObjectId3);
                            mdIndexe2.setIndexName(string6);
                            mdIndexe = mdIndexe2;
                            if (string8.startsWith("UNI")) {
                                mdIndexe2.setIndexType("UNIQUE");
                            } else {
                                mdIndexe2.setIndexType("NON_UNIQUE");
                            }
                            if (stringArray.length == 11 && stringArray[10] != null && stringArray[11].trim().length() > 0) {
                                captureEvent = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
                                mdIndexe2.addProperty(new AdditionalProperty("INDEX_TYPE", stringArray[11]), (DBObjectId)captureEvent);
                            }
                            captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEXES"), mdIndexe2.getIndexName());
                            captureContext.getAudience().fireListeners(captureEvent);
                            mdIndexe2 = (MdIndexe)this.getStorer().storeObject((PersistableObject)mdIndexe2);
                            captureEvent.setEventId(4);
                            captureContext.getAudience().fireListeners(captureEvent);
                        }
                    }
                    if (bl && !bl2) {
                        this.createIndexDetails(captureContext, mdIndexe, stringArray[4], stringArray[7], stringArray[3]);
                        continue;
                    }
                    if (bl || !bl2) continue;
                    this.createConstraintIndexDetails(captureContext, mdConstraint, stringArray[4], stringArray[3]);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    protected int getIndexDetailsSize() {
        return 10;
    }

    private String[] retreiveIndexDetails(String string, int n) {
        int n2 = 0;
        String[] stringArray = new String[n];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreElements()) {
            String string2;
            stringArray[n2] = string2 = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    protected void createConstraintIndexDetails(CaptureContext captureContext, MdConstraint mdConstraint, String string, String string2) throws PersistenceException {
        MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), new Integer(string2));
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string));
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getObjectName());
        captureContext.getAudience().fireListeners(captureEvent);
        mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
    }

    protected void createIndexDetails(CaptureContext captureContext, MdIndexe mdIndexe, String string, String string2, String string3) throws PersistenceException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        MdIndexDetail mdIndexDetail = new MdIndexDetail(mdIndexe.getKey(), persistenceUtility.getIdForColumn(mdIndexe.getTableId(), string), new Integer(string3));
        if (!string2.equals("NULL")) {
            mdIndexDetail.setIndexPortion(new Integer(string2));
        }
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEX_DETAILS"), mdIndexe.getIndexName());
        captureContext.getAudience().fireListeners(captureEvent);
        mdIndexDetail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)mdIndexDetail);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
    }

    protected void captureConstraints(CaptureContext captureContext) throws PersistenceException {
        try {
            String string = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("constraint_table_info"));
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            HashMap<String, String> hashMap = PostgreSQLOfflineUtils.getConstraints(string);
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CATALOGID");
            DBObjectId dBObjectId2 = null;
            DBObjectId dBObjectId3 = null;
            Set<String> set = hashMap.keySet();
            int n = 1;
            for (String string2 : set) {
                PostgreSQLUniqueKeyDetails[] postgreSQLUniqueKeyDetailsArray;
                Object object;
                String string3 = hashMap.get(string2);
                string2 = string2.trim();
                int n2 = string2.indexOf(".");
                String string4 = string2.substring(1, n2 - 1);
                String string5 = string2.substring(n2 + 2, string2.length() - 1);
                dBObjectId2 = persistenceUtility.getIdForSchema(dBObjectId, string4);
                if (dBObjectId2 == null) continue;
                dBObjectId3 = persistenceUtility.getIdForTable(dBObjectId2, string5);
                if (!this.m_dbName.equals(string4)) continue;
                PostgreSQLConstraintExtractor postgreSQLConstraintExtractor = new PostgreSQLConstraintExtractor(string3);
                PostgreSQLConstraintDetails[] postgreSQLConstraintDetailsArray = postgreSQLConstraintExtractor.getConstraintDetails();
                for (PostgreSQLConstraintDetails postgreSQLConstraintDetails : postgreSQLConstraintDetailsArray) {
                    if (captureContext.shouldCancel()) {
                        CaptureEvent captureEvent = new CaptureEvent(-1, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), "");
                        captureContext.getAudience().fireListeners(captureEvent);
                        return;
                    }
                    MdConstraint mdConstraint = new MdConstraint(dBObjectId3, MY_LANGUAGE_ID);
                    mdConstraint.setConstraintType("FOREIGN KEY");
                    mdConstraint.setName(postgreSQLConstraintDetails.getName());
                    String string6 = postgreSQLConstraintDetails.getReferencedTableName();
                    PostgreSQLUniqueKeyDetails postgreSQLUniqueKeyDetails = persistenceUtility.getIdForTable(dBObjectId2, string6);
                    if (postgreSQLUniqueKeyDetails == null) {
                        object = BlackMessages.getString("PostgreSQLCapturer.75") + postgreSQLConstraintDetails.getName();
                        object = (String)object + BlackMessages.getString("PostgreSQLCapturer.76") + string6 + BlackMessages.getString("PostgreSQLCapturer.77");
                        Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "Capture.EXCEPTION", object);
                        continue;
                    }
                    mdConstraint.setReftableId((DBObjectId)postgreSQLUniqueKeyDetails);
                    object = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                    captureContext.getAudience().fireListeners(object);
                    mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                    n = this.createConstraintDetails(dBObjectId3, mdConstraint, postgreSQLConstraintDetails.getColumnNames(), "N", 1, captureContext);
                    this.createConstraintDetails((DBObjectId)postgreSQLUniqueKeyDetails, mdConstraint, postgreSQLConstraintDetails.getReferencedColumnNames(), "Y", n, captureContext);
                    object.setEventId(4);
                    captureContext.getAudience().fireListeners(object);
                }
                PostgreSQLUniqueKeyExtractor postgreSQLUniqueKeyExtractor = new PostgreSQLUniqueKeyExtractor(string3);
                for (PostgreSQLUniqueKeyDetails postgreSQLUniqueKeyDetails : postgreSQLUniqueKeyDetailsArray = postgreSQLUniqueKeyExtractor.getConstraintDetails()) {
                    if (captureContext.shouldCancel()) {
                        object = new CaptureEvent(-1, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), "");
                        captureContext.getAudience().fireListeners(object);
                        return;
                    }
                    MdConstraint mdConstraint = new MdConstraint(dBObjectId3, MY_LANGUAGE_ID);
                    mdConstraint.setConstraintType("UNIQUE");
                    mdConstraint.setName(postgreSQLUniqueKeyDetails.getName());
                    object = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                    captureContext.getAudience().fireListeners(object);
                    mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                    n = this.createConstraintDetails(dBObjectId3, mdConstraint, postgreSQLUniqueKeyDetails.getColumnNames(), "N", n, captureContext);
                    object.setEventId(4);
                    captureContext.getAudience().fireListeners(object);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    protected int createConstraintDetails(DBObjectId dBObjectId, MdConstraint mdConstraint, String[] stringArray, String string, int n, CaptureContext captureContext) throws PersistenceException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        int n2 = n;
        for (String string2 : stringArray) {
            MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n2++));
            DBObjectId dBObjectId2 = persistenceUtility.getIdForColumn(dBObjectId, string2);
            mdConstraintDetail.setColumnId(dBObjectId2);
            mdConstraintDetail.setRefFlag(string);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
            captureContext.getAudience().fireListeners(captureEvent);
            mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
        return n2;
    }

    public String getModelName() throws CaptureException {
        return MY_LANGUAGE_ID;
    }

    public String getSourceURL() throws CaptureException {
        return null;
    }

    public String[] getScriptFiles(int n) throws OfflineCaptureException {
        String[] stringArray = new String[7];
        Package package_ = PostgreSQLOfflineCapturer.class.getPackage();
        String string = "";
        if (package_ != null) {
            string = "/" + package_.getName().replaceAll("\\.", "/") + "/";
        }
        stringArray[0] = string + "master.";
        stringArray[1] = string + "get_table.";
        stringArray[2] = string + "get_col_table.";
        stringArray[3] = string + "get_max_col.";
        stringArray[4] = string + "get_index_table.";
        stringArray[5] = string + "get_constraint.";
        stringArray[6] = string + "mysql3.ocp";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringArray[i] = n == 2 ? stringArray[i].concat("sh") : stringArray[i].concat("bat");
        }
        return stringArray;
    }

    public String getInputDirectory() {
        return this.m_inputDirectory;
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public String putInViewPrefix(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (!string.trim().split("\n")[0].toLowerCase().startsWith("create")) {
            string = "CREATE VIEW `" + string2 + "` AS " + string;
        }
        return string;
    }
}

