/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.bus;

import ilog.views.IlvGraphic;
import ilog.views.IlvNamedProperty;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutNodeProperty;
import ilog.views.graphlayout.IlvGrapherPropertyAdapter;
import ilog.views.graphlayout.bus.IlvBusLayout;
import ilog.views.graphlayout.internalutil.AlignmentOptions;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvBusLayoutNodeProperty
extends IlvGraphLayoutNodeProperty {
    static final long serialVersionUID = 2242922329015925988L;
    private boolean a;
    private int b;
    private int c;

    public IlvBusLayoutNodeProperty(String string, IlvBusLayout ilvBusLayout, IlvGraphic ilvGraphic, boolean bl) {
        super(string, ilvBusLayout, ilvGraphic, bl);
        try {
            this.a = ilvGraphic == ilvBusLayout.getBus();
        }
        catch (Exception exception) {
            this.a = false;
        }
        try {
            this.b = ilvBusLayout.getIndex(ilvGraphic);
        }
        catch (Exception exception) {
            this.b = -1;
        }
        try {
            this.c = ilvBusLayout.getVerticalAlignment(ilvGraphic);
        }
        catch (Exception exception) {
            this.c = 3;
        }
    }

    public IlvBusLayoutNodeProperty(IlvBusLayoutNodeProperty ilvBusLayoutNodeProperty) {
        super(ilvBusLayoutNodeProperty);
        this.a = ilvBusLayoutNodeProperty.a;
        this.b = ilvBusLayoutNodeProperty.b;
        this.c = ilvBusLayoutNodeProperty.c;
    }

    public IlvBusLayoutNodeProperty(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        this(ilvInputStream, false);
    }

    protected IlvBusLayoutNodeProperty(IlvInputStream ilvInputStream, boolean bl) throws IOException, IlvReadFileException {
        super(ilvInputStream, true);
        this.a = false;
        this.b = -1;
        this.c = 3;
        if (!bl) {
            boolean bl2 = true;
            while (bl2) {
                bl2 = this.readProperties(ilvInputStream);
            }
        }
    }

    @Override
    protected boolean readProperties(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        boolean bl = super.readProperties(ilvInputStream);
        try {
            this.a = ilvInputStream.readBoolean("bus");
            bl = true;
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.b = ilvInputStream.readInt("index");
            bl = true;
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.c = AlignmentOptions.valueOf(ilvInputStream.readString("verticalAlignment"));
            bl = true;
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public IlvNamedProperty copy() {
        return new IlvBusLayoutNodeProperty(this);
    }

    @Override
    public boolean isPersistent() {
        if (super.isPersistent()) {
            return true;
        }
        if (this.a) {
            return true;
        }
        if (this.b != -1) {
            return true;
        }
        return this.c != 3;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        block11: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                super.write(ilvOutputStream);
                                if (this.a) break block6;
                                if (this.omitDefaults()) break block7;
                            }
                            ilvOutputStream.write("bus", this.a);
                        }
                        if (this.b != -1) break block8;
                        if (this.omitDefaults()) break block9;
                    }
                    ilvOutputStream.write("index", this.b);
                }
                if (this.c != 3) break block10;
                if (this.omitDefaults()) break block11;
            }
            ilvOutputStream.write("verticalAlignment", AlignmentOptions.toString(this.c));
        }
    }

    @Override
    public void transfer(IlvGraphLayout ilvGraphLayout, IlvGraphic ilvGraphic) {
        if (ilvGraphLayout == null) {
            return;
        }
        super.transfer(ilvGraphLayout, ilvGraphic);
        IlvBusLayout ilvBusLayout = (IlvBusLayout)ilvGraphLayout;
        try {
            if (this.a) {
                ilvBusLayout.setBus((IlvPolyPointsInterface)ilvGraphic);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ilvBusLayout.setIndex(ilvGraphic, this.b);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ilvBusLayout.setVerticalAlignment(ilvGraphic, this.c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dispose(IlvGrapherPropertyAdapter ilvGrapherPropertyAdapter) {
        super.dispose(ilvGrapherPropertyAdapter);
    }
}

