/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.random;

import ilog.views.IlvRect;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphLayoutGrapherProperty;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.basic.IlvBasicLinkStyleLayout;
import ilog.views.graphlayout.internalutil.LogResUtil;
import ilog.views.graphlayout.internalutil.ReshapeLinkUtil;
import ilog.views.graphlayout.random.IlvRandomLayoutGrapherProperty;
import java.util.Enumeration;
import java.util.Random;

public class IlvRandomLayout
extends IlvBasicLinkStyleLayout {
    public static final int STRAIGHT_LINE_STYLE = 1;
    public static final int NO_RESHAPE_STYLE = 0;

    public IlvRandomLayout() {
    }

    @Override
    protected void init() {
        super.init();
    }

    public IlvRandomLayout(IlvRandomLayout ilvRandomLayout) {
        super(ilvRandomLayout);
    }

    @Override
    public IlvGraphLayout copy() {
        return new IlvRandomLayout(this);
    }

    @Override
    public void copyParameters(IlvGraphLayout ilvGraphLayout) {
        super.copyParameters(ilvGraphLayout);
    }

    @Override
    protected void internalLayout(boolean bl) throws IlvGraphLayoutException {
        this.checkAppropriateLinks();
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        int n = ilvGraphModel.getNodesCount();
        int n2 = 1;
        IlvRect ilvRect = this.getCalcLayoutRegion();
        float f = ilvRect.x;
        float f2 = ilvRect.y;
        float f3 = ilvRect.x + ilvRect.width;
        float f4 = ilvRect.y + ilvRect.height;
        Random random = this.isUseSeedValueForRandomGenerator() ? new Random(this.getSeedValueForRandomGenerator()) : new Random();
        Enumeration enumeration = ilvGraphModel.getNodes();
        boolean bl2 = this.isPreserveFixedNodes();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null) {
                LogResUtil.logAndThrowRuntimeExc(IlvRandomLayout.class, "graphlayout.expert.message.6460E");
            }
            if (bl2 && this.isFixed(e)) continue;
            IlvRect ilvRect2 = ilvGraphModel.boundingBox(e);
            float f5 = random.nextFloat();
            float f6 = f + Math.max(0.0f, f3 - ilvRect2.width - f) * f5;
            f5 = random.nextFloat();
            float f7 = f2 + Math.max(0.0f, f4 - ilvRect2.height - f2) * f5;
            ilvGraphModel.moveNode(e, f6, f7, bl);
            this.increasePercentageComplete(5 + n2++ * 90 / n);
            this.callLayoutStepPerformedIfNeeded();
            if (!this.isLayoutTimeElapsed() && !this.isStoppedImmediately()) continue;
            break;
        }
        if (!this.isLayoutTimeElapsed() && !this.isStoppedImmediately() && this.getLinkStyle() == 1) {
            ReshapeLinkUtil.deleteIntermediatePointsOnLinks(ilvGraphModel, this, bl);
        }
    }

    @Override
    protected int[] getPercentagesOfCompletion() {
        return new int[]{5, 95, 97, 100};
    }

    @Override
    public final boolean supportsLayoutRegion() {
        return true;
    }

    @Override
    public final boolean supportsRandomGenerator() {
        return true;
    }

    @Override
    protected IlvGraphLayoutGrapherProperty createLayoutGrapherProperty(String string, boolean bl) {
        return new IlvRandomLayoutGrapherProperty(string, this, bl);
    }
}

