/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph.interactor;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicFilter;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.hypergraph.IlvHyperGrapher;
import ilog.views.hypergraph.edgeconnector.IlvHyperEdgeConnector;
import ilog.views.hypergraph.edgeconnector.IlvHyperEdgePinConnector;
import ilog.views.hypergraph.edgeconnector.IlvHyperGrapherPin;
import ilog.views.hypergraph.internal.IlvHyperGrapherUtil;
import ilog.views.interactor.IlvPermanentInteractorInterface;
import java.awt.Cursor;

public class IlvMakeHyperEdgeBaseInteractor
extends IlvManagerViewInteractor
implements IlvPermanentInteractorInterface {
    private boolean a = true;
    private boolean b = false;
    private Cursor c = Cursor.getPredefinedCursor(1);
    private Cursor d = Cursor.getDefaultCursor();
    private Cursor e;
    private boolean f = true;
    private IlvGraphic g;
    private IlvRect h;
    private IlvHyperGrapherPin i;
    private float j = 2.0f;

    protected IlvMakeHyperEdgeBaseInteractor() {
    }

    public boolean isGridMode() {
        return this.a;
    }

    public final void setGridMode(boolean bl) {
        this.a = bl;
    }

    public float getPinMargin() {
        return this.j;
    }

    public final void setPinMargin(float f) {
        this.j = Math.max(f, 0.0f);
    }

    public final boolean isPermanent() {
        return this.b;
    }

    public final void setPermanent(boolean bl) {
        this.b = bl;
    }

    public boolean isCreationInSubManagersAllowed() {
        return this.f;
    }

    public void setCreationInSubManagersAllowed(boolean bl) {
        this.f = bl;
    }

    public Cursor getCursor() {
        return this.c;
    }

    public void setCursor(Cursor cursor) {
        this.c = cursor;
    }

    public Cursor getPinCursor() {
        return this.d;
    }

    public void setPinCursor(Cursor cursor) {
        this.d = cursor;
    }

    protected void attach(IlvManagerView ilvManagerView) {
        super.attach(ilvManagerView);
        this.e = ilvManagerView.isCursorSet() ? ilvManagerView.getCursor() : null;
        ilvManagerView.setCursor(this.getCursor());
        this.reInitialize();
    }

    protected void detach() {
        this.getManagerView().setCursor(this.e);
        this.e = null;
        this.a(this.g, false);
        this.setPinSelected(this.i, false);
        this.h = null;
        this.reInitialize();
        super.detach();
    }

    protected void reInitialize() {
    }

    protected void setPinSelected(IlvHyperGrapherPin ilvHyperGrapherPin, boolean bl) {
        if (ilvHyperGrapherPin == null) {
            return;
        }
        IlvHyperEdgePinConnector ilvHyperEdgePinConnector = ilvHyperGrapherPin.getHyperEdgeConnector();
        if (ilvHyperEdgePinConnector == null) {
            return;
        }
        if (bl) {
            ilvHyperEdgePinConnector.selectAllPins(false, false);
        }
        ilvHyperGrapherPin.setSelected(bl);
        IlvManager ilvManager = (IlvManager)ilvHyperEdgePinConnector.getGraphicBag();
        if (ilvManager != null) {
            ilvManager.initReDraws();
            ilvManager.invalidateRegion((IlvGraphic)ilvHyperEdgePinConnector);
            ilvManager.reDrawViews();
        }
    }

    protected IlvHyperGrapherPin getPin(IlvPoint ilvPoint) {
        IlvManagerView ilvManagerView = this.getManagerView();
        boolean bl = this.isCreationInSubManagersAllowed();
        return IlvHyperGrapherUtil.getHyperGrapherPin(ilvManagerView, ilvPoint, bl, false);
    }

    protected void highlightPin(IlvPoint ilvPoint) {
        IlvHyperGrapherPin ilvHyperGrapherPin = this.getPin(ilvPoint);
        if (ilvHyperGrapherPin != this.i) {
            this.setPinSelected(this.i, false);
            this.i = ilvHyperGrapherPin;
            this.setPinSelected(this.i, true);
        }
        if (this.i != null) {
            if (this.getManagerView().getCursor() != this.getPinCursor()) {
                this.getManagerView().setCursor(this.getPinCursor());
            }
        } else if (this.getManagerView().getCursor() != this.getCursor()) {
            this.getManagerView().setCursor(this.getCursor());
        }
    }

    protected IlvHyperGrapherPin getHighlightedPin() {
        return this.i;
    }

    protected IlvGraphic getObjectToBeHighlighted(final IlvPoint ilvPoint, final boolean bl, final boolean bl2) {
        if (this.g instanceof IlvManager ? this.isManagerToBeHighlighted(ilvPoint, (IlvManager)this.g) : this.h != null && this.h.inside(ilvPoint.x, ilvPoint.y)) {
            return this.g;
        }
        IlvGraphicFilter ilvGraphicFilter = new IlvGraphicFilter(){

            public boolean accept(IlvGraphic ilvGraphic) {
                if (bl && IlvMakeHyperEdgeBaseInteractor.this.isNode(ilvGraphic)) {
                    if (ilvGraphic instanceof IlvManager) {
                        return IlvMakeHyperEdgeBaseInteractor.this.isManagerToBeHighlighted(ilvPoint, (IlvManager)ilvGraphic);
                    }
                    return true;
                }
                return bl2 && IlvMakeHyperEdgeBaseInteractor.this.isHyperEdge(ilvGraphic);
            }
        };
        IlvManager ilvManager = this.getManager();
        IlvGraphic ilvGraphic = IlvHyperGrapherUtil.getObject(ilvManager, ilvPoint, this.getManagerView().getTransformer(), ilvGraphicFilter, this.isCreationInSubManagersAllowed());
        if (ilvGraphic == null || ilvGraphic instanceof IlvSelection || ilvGraphic instanceof IlvHyperEdgeConnector || ilvGraphic instanceof IlvManager && !this.isManagerToBeHighlighted(ilvPoint, (IlvManager)ilvGraphic)) {
            return null;
        }
        return ilvGraphic;
    }

    protected void highlightObject(IlvGraphic ilvGraphic) {
        if (ilvGraphic != this.g) {
            if (this.g != null) {
                this.a(this.g, false);
            }
            this.g = ilvGraphic;
            this.h = null;
            this.a(this.g, true);
            if (this.isNode(this.g)) {
                this.h = this.g.boundingBox(this.getObjectDrawingTransformer(this.g));
                this.h.expand(this.getPinMargin());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvGraphic ilvGraphic, boolean bl) {
        IlvManager ilvManager;
        if (ilvGraphic == null) {
            return;
        }
        if (ilvGraphic.getGraphicBag() == null) {
            return;
        }
        IlvManager ilvManager2 = (IlvManager)ilvGraphic.getGraphicBag();
        if (ilvManager2 != (ilvManager = this.getManager())) {
            ilvManager2.setContentsAdjusting(true, true);
            ilvManager.setSelectionAdjusting(true);
        }
        try {
            if (bl) {
                ilvManager.deSelectAll(true, true);
            }
            ilvManager2.setSelected(ilvGraphic, bl, true);
        }
        finally {
            if (ilvManager2 != ilvManager) {
                ilvManager.setSelectionAdjusting(false);
                ilvManager2.setContentsAdjusting(false, true);
            }
        }
    }

    protected IlvGraphic getHighlightedGraphic() {
        return this.g;
    }

    protected boolean isNode(IlvGraphic ilvGraphic) {
        if (ilvGraphic == null) {
            return false;
        }
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        if (!(ilvGraphicBag instanceof IlvHyperGrapher)) {
            return false;
        }
        return ((IlvHyperGrapher)ilvGraphicBag).isNode(ilvGraphic);
    }

    protected boolean isHyperEdge(IlvGraphic ilvGraphic) {
        if (ilvGraphic == null) {
            return false;
        }
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        if (!(ilvGraphicBag instanceof IlvHyperGrapher)) {
            return false;
        }
        return ((IlvHyperGrapher)ilvGraphicBag).isHyperEdge(ilvGraphic);
    }

    protected boolean isManagerToBeHighlighted(IlvPoint ilvPoint, IlvManager ilvManager) {
        IlvPoint ilvPoint2;
        IlvTransformer ilvTransformer;
        boolean bl = true;
        if (!this.isCreationInSubManagersAllowed()) {
            bl = false;
        }
        if (ilvManager.isCollapsed()) {
            bl = false;
        }
        if (ilvManager.getCardinal() == 0) {
            bl = false;
        }
        if ((ilvTransformer = this.getObjectDrawingTransformer((IlvGraphic)ilvManager)) != null && !ilvTransformer.isIdentity()) {
            ilvPoint2 = new IlvPoint(ilvPoint.x, ilvPoint.y);
            ilvTransformer.inverse(ilvPoint2);
        } else {
            ilvPoint2 = ilvPoint;
        }
        if (!bl) {
            return ilvManager.contains(ilvPoint2, ilvPoint, ilvTransformer);
        }
        return ilvManager.containsFrame(ilvPoint2, ilvPoint, ilvTransformer);
    }

    protected IlvTransformer getObjectDrawingTransformer(IlvGraphic ilvGraphic) {
        if (ilvGraphic == null) {
            return this.getManagerView().getTransformer();
        }
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        if (ilvGraphicBag == null) {
            return this.getManagerView().getTransformer();
        }
        if (ilvGraphicBag instanceof IlvManager) {
            return ((IlvManager)ilvGraphicBag).getDrawingTransformer(this.getManagerView());
        }
        throw new RuntimeException("object: " + ilvGraphic + " is inside a bag which is not IlvManager: " + ilvGraphicBag);
    }
}

