/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.beans.editor;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvTexture;
import ilog.views.io.IlvOutputStream;
import ilog.views.sdm.beans.editor.EnumPropertyEditor;
import ilog.views.sdm.graphic.IlvGeneralLink;
import ilog.views.util.beans.editor.IlvArrayPropertyEditor;
import ilog.views.util.beans.editor.IlvTaggedIntValueEditor;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class GeneralLinkEditors {

    static class DecoAttChooser
    extends JPanel
    implements ActionListener {
        DecoAttEditor a;
        JCheckBox b;
        JCheckBox c;
        JCheckBox d;
        JCheckBox e;
        JCheckBox f;
        JCheckBox g;
        JCheckBox h;
        JCheckBox i;
        JCheckBox j;
        JCheckBox k;
        int l;

        public DecoAttChooser(DecoAttEditor decoAttEditor) {
            this.setLayout(new GridLayout(0, 2, 4, 4));
            this.a = decoAttEditor;
            this.b = new JCheckBox("Animate");
            this.b.setActionCommand(String.valueOf(1));
            this.b.addActionListener(this);
            this.c = new JCheckBox("Rotate");
            this.c.setActionCommand(String.valueOf(2));
            this.c.addActionListener(this);
            this.d = new JCheckBox("Fixed Size");
            this.d.setActionCommand(String.valueOf(4));
            this.d.addActionListener(this);
            this.e = new JCheckBox("Anchor Top");
            this.e.setActionCommand(String.valueOf(8));
            this.e.addActionListener(this);
            this.f = new JCheckBox("Anchor Bottom");
            this.f.setActionCommand(String.valueOf(16));
            this.f.addActionListener(this);
            this.g = new JCheckBox("Anchor Left");
            this.g.setActionCommand(String.valueOf(32));
            this.g.addActionListener(this);
            this.h = new JCheckBox("Anchor Right");
            this.h.setActionCommand(String.valueOf(64));
            this.h.addActionListener(this);
            this.i = new JCheckBox("Over");
            this.i.setActionCommand(String.valueOf(128));
            this.i.addActionListener(this);
            this.j = new JCheckBox("Proportional Angle");
            this.j.setActionCommand(String.valueOf(4096));
            this.j.addActionListener(this);
            this.k = new JCheckBox("Right Side Up Angle");
            this.k.setActionCommand(String.valueOf(8192));
            this.k.addActionListener(this);
            this.add(this.b);
            this.add(this.i);
            this.add(this.d);
            this.add(this.e);
            this.add(this.c);
            this.add(this.f);
            this.add(this.j);
            this.add(this.g);
            this.add(this.k);
            this.add(this.h);
        }

        public void updateValue(int n) {
            this.b.setSelected((n & 1) != 0);
            this.c.setSelected((n & 2) != 0);
            this.d.setSelected((n & 4) != 0);
            this.e.setSelected((n & 8) != 0);
            this.f.setSelected((n & 0x10) != 0);
            this.g.setSelected((n & 0x20) != 0);
            this.h.setSelected((n & 0x40) != 0);
            this.i.setSelected((n & 0x80) != 0);
            this.j.setSelected((n & 0x1000) != 0);
            this.k.setSelected((n & 0x2000) != 0);
            this.j.setEnabled(this.c.isSelected());
            this.k.setEnabled(this.c.isSelected());
            this.l = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
            int n = Integer.parseInt(actionEvent.getActionCommand());
            int n2 = this.l = bl ? this.l | n : this.l & ~n;
            if (actionEvent.getSource() == this.j && this.j.isSelected()) {
                this.k.setSelected(false);
                this.l &= 0xFFFFDFFF;
            }
            if (actionEvent.getSource() == this.k && this.k.isSelected()) {
                this.j.setSelected(false);
                this.l &= 0xFFFFEFFF;
            }
            if (actionEvent.getSource() == this.e && this.e.isSelected()) {
                this.f.setSelected(false);
                this.l &= 0xFFFFFFEF;
            }
            if (actionEvent.getSource() == this.f && this.f.isSelected()) {
                this.e.setSelected(false);
                this.l &= 0xFFFFFFF7;
            }
            if (actionEvent.getSource() == this.g && this.g.isSelected()) {
                this.h.setSelected(false);
                this.l &= 0xFFFFFFBF;
            }
            if (actionEvent.getSource() == this.h && this.h.isSelected()) {
                this.g.setSelected(false);
                this.l &= 0xFFFFFFDF;
            }
            if (actionEvent.getSource() == this.c) {
                this.j.setEnabled(this.c.isSelected());
                this.k.setEnabled(this.c.isSelected());
            }
            this.a.firePropertyChange();
        }
    }

    public static class DecoAttEditor
    extends PropertyEditorSupport {
        private DecoAttChooser a = null;

        int a() {
            return super.getValue() != null ? (Integer)super.getValue() : 0;
        }

        @Override
        public String getAsText() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.a();
            if ((n & 1) != 0) {
                stringBuffer.append("|DECORATION_ANIMATE");
            }
            if ((n & 2) != 0) {
                stringBuffer.append("|DECORATION_ROTATE");
            }
            if ((n & 0x1000) != 0) {
                stringBuffer.append("|DECORATION_PROPORTIONAL_ANGLE");
            }
            if ((n & 0x2000) != 0) {
                stringBuffer.append("|DECORATION_RIGHT_SIDE_UP_ANGLE");
            }
            if ((n & 0x20) != 0) {
                stringBuffer.append("|DECORATION_ANCHOR_LEFT");
            }
            if ((n & 4) != 0) {
                stringBuffer.append("|DECORATION_FIXED_SIZE");
            }
            if ((n & 8) != 0) {
                stringBuffer.append("|DECORATION_ANCHOR_TOP");
            }
            if ((n & 0x10) != 0) {
                stringBuffer.append("|DECORATION_ANCHOR_BOTTOM");
            }
            if ((n & 0x40) != 0) {
                stringBuffer.append("|DECORATION_ANCHOR_RIGHT");
            }
            if ((n & 0x80) != 0) {
                stringBuffer.append("|DECORATION_OVER");
            }
            if ((n & 0x100) != 0) {
                stringBuffer.append("|DECORATION_ABSOLUTE");
            }
            return stringBuffer.length() > 0 ? stringBuffer.substring(1) : "";
        }

        @Override
        public Object getValue() {
            if (this.a != null) {
                return new Integer(this.a.l);
            }
            return super.getValue();
        }

        @Override
        public void setValue(Object object) {
            super.setValue(object);
            if (this.a != null) {
                this.a.updateValue(this.a());
            }
        }

        @Override
        public Component getCustomEditor() {
            if (this.a == null) {
                this.a = new DecoAttChooser(this);
                this.a.updateValue(this.a());
            }
            return this.a;
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }
    }

    public static class DecoAttArrayPropertyEditor
    extends IlvArrayPropertyEditor {
        public DecoAttArrayPropertyEditor() {
            this.setPropertyEditorClass(DecoAttEditor.class);
        }

        public String getJavaInitializationString() {
            return "new int[] {" + this.getAsText() + "}";
        }

        protected Object objectArrayFrom(String[] stringArray) {
            int[] nArray = new int[stringArray.length];
            block2: for (int i = 0; i < stringArray.length; ++i) {
                try {
                    nArray[i] = Integer.parseInt(stringArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    while (true) {
                        int n;
                        if (stringArray[i].startsWith("DECORATION_ANIMATE")) {
                            int n2 = i;
                            nArray[n2] = nArray[n2] | 1;
                        } else if (stringArray[i].startsWith("DECORATION_ROTATE")) {
                            int n3 = i;
                            nArray[n3] = nArray[n3] | 2;
                        } else if (stringArray[i].startsWith("DECORATION_PROPORTIONAL_ANGLE")) {
                            int n4 = i;
                            nArray[n4] = nArray[n4] | 0x1000;
                        } else if (stringArray[i].startsWith("DECORATION_RIGHT_SIDE_UP_ANGLE")) {
                            int n5 = i;
                            nArray[n5] = nArray[n5] | 0x2000;
                        } else if (stringArray[i].startsWith("DECORATION_FIXED_SIZE")) {
                            int n6 = i;
                            nArray[n6] = nArray[n6] | 4;
                        } else if (stringArray[i].startsWith("DECORATION_ANCHOR_TOP")) {
                            int n7 = i;
                            nArray[n7] = nArray[n7] | 8;
                        } else if (stringArray[i].startsWith("DECORATION_ANCHOR_BOTTOM")) {
                            int n8 = i;
                            nArray[n8] = nArray[n8] | 0x10;
                        } else if (stringArray[i].startsWith("DECORATION_ANCHOR_LEFT")) {
                            int n9 = i;
                            nArray[n9] = nArray[n9] | 0x20;
                        } else if (stringArray[i].startsWith("DECORATION_ANCHOR_RIGHT")) {
                            int n10 = i;
                            nArray[n10] = nArray[n10] | 0x40;
                        } else if (stringArray[i].startsWith("DECORATION_OVER")) {
                            int n11 = i;
                            nArray[n11] = nArray[n11] | 0x80;
                        } else if (stringArray[i].startsWith("DECORATION_ABSOLUTE")) {
                            int n12 = i;
                            nArray[n12] = nArray[n12] | 0x100;
                        } else if (stringArray[i].startsWith("DECORATION_FULL_RETRACT_AT_END")) {
                            int n13 = i;
                            nArray[n13] = nArray[n13] | 0x200;
                        } else if (stringArray[i].startsWith("DECORATION_HALF_RETRACT_AT_END")) {
                            int n14 = i;
                            nArray[n14] = nArray[n14] | 0x400;
                        } else {
                            if (!stringArray[i].startsWith("DECORATION_NO_RETRACT_AT_END")) continue block2;
                            int n15 = i;
                            nArray[n15] = nArray[n15] | 0x800;
                        }
                        if ((n = stringArray[i].indexOf("|")) == -1) continue block2;
                        stringArray[i] = stringArray[i].substring(n + 1).trim();
                    }
                }
            }
            return nArray;
        }
    }

    public static class PointArrayPropertyEditor
    extends IlvArrayPropertyEditor {
        public String getJavaInitializationString() {
            StringBuffer stringBuffer = new StringBuffer("new IlvPoint[] {");
            IlvPoint[] ilvPointArray = (IlvPoint[])this.getValue();
            for (int i = 0; i < ilvPointArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("new IlvPoint(").append(ilvPointArray[i].x).append(",").append(ilvPointArray[i].y).append(")");
            }
            stringBuffer.append("};");
            return stringBuffer.toString();
        }

        protected Object objectArrayFrom(String[] stringArray) {
            if (stringArray.length % 2 == 1) {
                throw new IllegalArgumentException("odd number of float");
            }
            IlvPoint[] ilvPointArray = new IlvPoint[stringArray.length / 2];
            for (int i = 0; i < ilvPointArray.length; ++i) {
                ilvPointArray[i] = new IlvPoint(Float.parseFloat(stringArray[2 * i]), Float.parseFloat(stringArray[2 * i + 1]));
            }
            return ilvPointArray;
        }
    }

    public static class GraphicArrayPropertyEditor
    extends PropertyEditorSupport
    implements Serializable {
        @Override
        public String getJavaInitializationString() {
            return "too complex";
        }

        @Override
        public String getAsText() {
            if (this.getValue() == null) {
                return "";
            }
            try {
                IlvGraphic[] ilvGraphicArray = (IlvGraphic[])this.getValue();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IlvOutputStream ilvOutputStream = new IlvOutputStream((OutputStream)byteArrayOutputStream);
                IlvManager ilvManager = new IlvManager();
                for (int i = 0; i < ilvGraphicArray.length; ++i) {
                    ilvManager.addObject(ilvGraphicArray[i], false);
                }
                ilvManager.write(ilvOutputStream);
                ilvOutputStream.flush();
                return byteArrayOutputStream.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "Error";
            }
        }

        @Override
        public void setAsText(String string) throws IllegalArgumentException {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                IlvManager ilvManager = new IlvManager();
                ilvManager.read((InputStream)byteArrayInputStream);
                IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getObjects();
                int n = 0;
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ++n;
                    ilvGraphicEnumeration.nextElement();
                }
                IlvGraphic[] ilvGraphicArray = new IlvGraphic[n];
                ilvGraphicEnumeration = ilvManager.getObjects();
                n = 0;
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ilvGraphicArray[n++] = ilvGraphicEnumeration.nextElement();
                }
                this.setValue(ilvGraphicArray);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    public static class TexturePropertyEditor
    extends PropertyEditorSupport
    implements Serializable {
        @Override
        public String getJavaInitializationString() {
            return "new ilog.views.IlvTexture(new java.net.URL(\"" + this.getAsText() + "\"))";
        }

        @Override
        public String getAsText() {
            if (this.getValue() == null) {
                return "";
            }
            try {
                return ((IlvTexture)this.getValue()).getImageURL().toString();
            }
            catch (Exception exception) {
                return "Error";
            }
        }

        @Override
        public void setAsText(String string) throws IllegalArgumentException {
            try {
                this.setValue(new IlvTexture(new URL(string)));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    public static class LineJoinPropertyEditor
    extends IlvTaggedIntValueEditor {
        protected String[] createTags() {
            String[] stringArray = new String[3];
            stringArray[0] = "JOIN_BEVEL";
            stringArray[1] = "JOIN_MITER";
            stringArray[2] = "JOIN_ROUND";
            return stringArray;
        }

        protected String[] createStringValues() {
            String[] stringArray = new String[3];
            stringArray[0] = "ilog.views.IlvStroke.JOIN_BEVEL";
            stringArray[1] = "ilog.views.IlvStroke.JOIN_MITER";
            stringArray[2] = "ilog.views.IlvStroke.JOIN_ROUND";
            return stringArray;
        }

        protected int[] createIntValues() {
            return new int[]{0, 1, 2};
        }
    }

    public static class ModePropertyEditor
    extends EnumPropertyEditor {
        public ModePropertyEditor() {
            String[] stringArray = new String[4];
            stringArray[0] = "MODE_TEXTURE";
            stringArray[1] = "MODE_UNICOLOR";
            stringArray[2] = "MODE_GRADIENT";
            stringArray[3] = "MODE_NEON";
            super(IlvGeneralLink.class, stringArray);
        }
    }

    public static class ArrowModePropertyEditor
    extends EnumPropertyEditor {
        public ArrowModePropertyEditor() {
            String[] stringArray = new String[4];
            stringArray[0] = "ARROW_FILL";
            stringArray[1] = "ARROW_OPEN";
            stringArray[2] = "ARROW_GRADIENT";
            stringArray[3] = "ARROW_DECORATION";
            super(IlvGeneralLink.class, stringArray);
        }
    }
}

