/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.util.ArrayList;
import oracle.dss.util.DataAccess;
import oracle.dss.util.ErrorHandler;
import oracle.javatools.annotations.Concealed;

@Concealed
public class DataUpdateCache {
    private ArrayList m_rowMembers;
    private ArrayList m_colMembers;
    private Object[][] m_dataValues;
    private ErrorHandler m_eh;

    public DataUpdateCache(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public void cache(DataAccess da) {
        try {
            int i;
            int rowExtent = da.getEdgeExtent(1);
            int colExtent = da.getEdgeExtent(0);
            this.m_rowMembers = new ArrayList(rowExtent);
            this.m_colMembers = new ArrayList(colExtent);
            this.m_dataValues = new Object[rowExtent][colExtent];
            for (i = 0; i < rowExtent; ++i) {
                this.m_rowMembers.add(da.getSliceLabel(1, i, "value"));
            }
            for (int j = 0; j < colExtent; ++j) {
                this.m_colMembers.add(da.getSliceLabel(0, j, "value"));
            }
            for (i = 0; i < rowExtent; ++i) {
                for (int j = 0; j < colExtent; ++j) {
                    this.m_dataValues[i][j] = da.getValue(i, j, "dataValue");
                }
            }
        }
        catch (Exception e) {
            this.m_eh.trace(e.toString(), DataUpdateCache.class.toString(), "cache");
        }
    }

    public ArrayList getRowIds() {
        return this.m_rowMembers;
    }

    public ArrayList getColumnIds() {
        return this.m_colMembers;
    }

    public Object[][] getDataValues() {
        return this.m_dataValues;
    }
}

