/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.GaugeRenderer;
import oracle.dss.presutil.GradientObj;
import oracle.dss.presutil.GradientStopObj;
import oracle.dss.presutil.SVGWriter;
import oracle.dss.util.ErrorHandler;
import oracle.javatools.annotations.Concealed;

public class GaugeSVGWriter
extends SVGWriter
implements GaugeRenderer {
    private static final String GRADIENT_ID_BASE = "grad";
    private int m_gradientCount = 0;
    private Map m_map = null;
    private int m_compType = 0;
    private int _svgMode = 1;
    private ErrorHandler m_errorHandler;

    public GaugeSVGWriter(OutputStream os, ErrorHandler eh, String charEnc) {
        super(os, eh, charEnc);
        this.m_errorHandler = eh;
    }

    public GaugeSVGWriter(OutputStream os, ErrorHandler eh) {
        this(os, eh, null);
    }

    public GaugeSVGWriter(Writer writer, ErrorHandler eh, String charEnc) {
        super(writer, eh, charEnc);
    }

    public GaugeSVGWriter(Writer writer, ErrorHandler eh) {
        this(writer, eh, null);
    }

    protected int getSvgMode() {
        return this._svgMode;
    }

    public void setSvgMode(int mode) {
        this._svgMode = mode;
    }

    public void setCompType(int type) {
        this.m_compType = type;
    }

    public void setMap(Map map) {
        this.m_map = map;
    }

    @Override
    public void drawShape(Shape shape, Color c) {
        this._writeShape(shape, c, null, null, null);
    }

    @Override
    public void fillShape(Shape shape, Color c, GradientObj gradient, Map sfxMap) {
        this._writeShape(shape, null, c, gradient, sfxMap);
    }

    @Override
    public void drawAndFillShape(Shape shape, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        this._writeShape(shape, borderColor, fillColor, gradient, sfxMap);
    }

    @Override
    public void drawArc(Arc2D arc, Color c) {
        this._writeShape(arc, c, null, null, null);
    }

    @Override
    public void fillArc(Arc2D arc, Color c, GradientObj gradient, Map sfxMap) {
        this._writeShape(arc, null, c, gradient, sfxMap);
    }

    @Override
    public void drawAndFillArc(Arc2D arc, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        this._writeShape(arc, borderColor, fillColor, gradient, sfxMap);
    }

    @Override
    public void drawArea(Area area, Color c) {
        this._writeShape(area, c, null, null, null);
    }

    @Override
    public void fillArea(Area area, Color c, GradientObj gradient, Map sfxMap) {
        this._writeShape(area, null, c, gradient, sfxMap);
    }

    @Override
    public void drawAndFillArea(Area area, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        this._writeShape(area, borderColor, fillColor, gradient, sfxMap);
    }

    @Override
    public void drawPolygon(Polygon poly, Color c) {
        this._writeShape(poly, c, null, null, null);
    }

    @Override
    public void fillPolygon(Polygon poly, Color c, GradientObj gradient, Map sfxMap) {
        this._writeShape(poly, null, c, gradient, sfxMap);
    }

    @Override
    public void drawAndFillPolygon(Polygon polygon, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        this._writeShape(polygon, borderColor, fillColor, gradient, sfxMap);
    }

    @Override
    public void drawRect(Rectangle rect, Color c) {
        this._writeShape(rect, c, null, null, null);
    }

    @Override
    public void fillRect(Rectangle rect, Color c, GradientObj gradient, Map sfxMap) {
        this._writeShape(rect, null, c, gradient, sfxMap);
    }

    @Override
    public void drawAndFillRect(Rectangle rect, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        this._writeShape(rect, borderColor, fillColor, gradient, sfxMap);
    }

    @Override
    public void drawAndFillRoundedRect(RoundRectangle2D roundRect, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        if (borderColor == null && fillColor == null && sfxMap == null) {
            return;
        }
        try {
            String fillAttr = this.getFillAttribute(roundRect, fillColor, gradient);
            boolean ret = this.startRoundedRectElement(roundRect.getBounds(), (int)roundRect.getArcWidth(), (int)roundRect.getArcHeight());
            if (ret) {
                if (borderColor != null) {
                    this.writeAttribute("stroke", borderColor);
                }
                this.writeAttribute("fill", fillAttr);
                if (fillColor != null) {
                    this.writeOpacityAttribute(fillColor, "fill-opacity");
                }
                this.endElement();
            }
        }
        catch (Exception ioe) {
            this.m_errorHandler.log(ioe.getMessage(), this.getClass().getName(), "drawAndFillRoundedRect(Rectangle rect, Color borderColor, Color fillColor, int arcWidth, int arcHeight, Hashmap sfxMap)");
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2, int thickness, Color c) {
        try {
            boolean ret = this.startLineElement(x1, y1, x2, y2);
            if (ret) {
                if (thickness != 1) {
                    this.writeAttribute("stroke-width", thickness);
                }
                if (c != null) {
                    this.writeAttribute("stroke", c);
                }
                this.endElement();
            }
        }
        catch (Exception e) {
            this.m_errorHandler.log(e.getMessage(), this.getClass().getName(), "drawLine(int x1, int y1, int x2, int y2, int thickness, Color c)");
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2, Color c) {
        this.drawLine(x1, y1, x2, y2, 1, c);
    }

    @Override
    public void drawString(DrawableObject.Label labelObj, int x, int y, Font f, Color c, double angle) {
        String label = labelObj.getTruncatedText();
        if (label == null) {
            label = labelObj.getText();
        }
        try {
            if (this.startTextElement(x, y)) {
                this.writeFontAttributes(f);
                this.writeAttribute("fill", c);
                this.writeText(label, f);
                this.endElement();
            }
        }
        catch (Exception e) {
            this.m_errorHandler.log(e.getMessage(), this.getClass().getName(), "drawString(String label, int x, int y, Font f, Color c)");
        }
    }

    @Override
    public void drawImage(String imgURL, Image image, int x, int y, int width, int height, ImageObserver imgObs) {
        try {
            this.writeImageElement(x, y, width, height, imgURL);
        }
        catch (Exception e) {
            this.m_errorHandler.log(e.getMessage(), this.getClass().getName(), "drawImage(String imgURL, int x, int y, int width, int height, ImageObserver imgObs)");
        }
    }

    @Override
    public void applyTransform(AffineTransform transform) {
    }

    @Override
    public AffineTransform getTransform() {
        return null;
    }

    @Override
    public void setTransform(AffineTransform transform) {
    }

    private boolean _writeShape(Shape shape, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        boolean ret = true;
        try {
            boolean bStartA;
            boolean bOnMouseOverOutPresent;
            boolean bOnClickPresent;
            boolean bTooltips = (this._svgMode & 2) != 0;
            String[] tooltipsArray = null;
            if (bTooltips) {
                tooltipsArray = null;
            }
            boolean bShapeAttributes = (this._svgMode & 0x10) != 0;
            String clickEventJS = null;
            boolean bl = bOnClickPresent = bShapeAttributes && this.isOnClickPresent();
            if (bShapeAttributes && !bOnClickPresent) {
                clickEventJS = this.getClickEventJS();
            }
            boolean bl2 = bOnMouseOverOutPresent = bShapeAttributes && this.isOnMouseOverOutPresent();
            if (bOnMouseOverOutPresent) {
                bTooltips = false;
            }
            String saAlt = null;
            String saTitle = null;
            String saHRef = null;
            String saTarget = null;
            if (bShapeAttributes) {
                saAlt = this.getShapeAttributesAlt();
                saTitle = this.getShapeAttributesTitle();
                if (!bOnClickPresent) {
                    saHRef = this.getShapeAttributesHRef();
                }
                saTarget = this.getShapeAttributesTarget();
            }
            boolean bDrilling = (this._svgMode & 4) != 0;
            bDrilling = false;
            boolean bLink = false;
            String link = null;
            String id = null;
            if (this.m_compType == 11 && this.m_map != null && this.m_map.get("Link") != null) {
                bLink = true;
                link = (String)this.m_map.get("Link");
                Object rowObj = this.m_map.get("DS_ROW");
                int row = rowObj != null ? (Integer)rowObj : -1;
                Object colObj = this.m_map.get("DS_COLUMN");
                int column = colObj != null ? (Integer)colObj : -1;
                bTooltips = true;
                id = row + "," + column;
            }
            if (bTooltips) {
                if (bLink) {
                    tooltipsArray = new String[]{((Double)this.m_map.get("Metric")).toString()};
                }
                if (saAlt != null) {
                    tooltipsArray = new String[]{saAlt};
                } else if (saTitle != null) {
                    tooltipsArray = new String[]{saTitle};
                }
            }
            bTooltips = bTooltips && tooltipsArray != null && tooltipsArray.length > 0;
            boolean bl3 = bStartA = bDrilling || bOnClickPresent || clickEventJS != null || saHRef != null || bLink;
            if (bStartA) {
                this.startElement("a");
                String href = "";
                if (clickEventJS == null && !bDrilling && saHRef != null) {
                    href = saHRef;
                } else if (clickEventJS == null && !bDrilling && bLink) {
                    href = link;
                }
                this.writeAttribute("xlink:href", href);
                if (saTarget != null) {
                    this.writeAttribute("target", saTarget);
                }
                if (clickEventJS != null) {
                    this.writeAttribute("onclick", clickEventJS);
                }
            }
            String fillAttr = this.getFillAttribute(shape, fillColor, gradient);
            boolean bElementStarted = false;
            if (shape instanceof Rectangle) {
                Rectangle rect = (Rectangle)shape;
                bElementStarted = this.startRectElement(rect.x, rect.y, rect.width, rect.height);
            } else {
                bElementStarted = shape instanceof Polygon ? this.startPolygonElement((Polygon)shape) : this.startPathElement(shape);
            }
            if (bElementStarted) {
                this.writeAttribute("fill", fillAttr);
                if (fillColor != null) {
                    this.writeOpacityAttribute(fillColor, "fill-opacity");
                }
                if (bShapeAttributes) {
                    this.writeShapeAttributes();
                } else if (saTitle != null) {
                    this.writeTitleElement(saTitle);
                }
                if (borderColor != null && borderColor.getAlpha() != 0) {
                    this.writeAttribute("stroke", borderColor);
                }
                if (bTooltips && bLink) {
                    String onMouseOverJS = "bi_link_show_mOver(evt,'" + id + "');";
                    String onMouseOutJS = "bi_link_hide_mOut(evt,'" + id + "');";
                    this.writeTooltip(tooltipsArray, onMouseOverJS, onMouseOutJS);
                }
                this.endElement();
            }
            if (bStartA) {
                this.endElement();
            }
            if (bLink) {
                this._writeLinkBorder(shape, Color.blue, id);
            }
        }
        catch (Exception e) {
            this.m_errorHandler.log(e.getMessage(), this.getClass().getName(), "_writeShape(Shape shape, Color borderColor, Color fillColor)");
            ret = false;
        }
        return ret;
    }

    private void _writeLinkBorder(Shape shape, Color borderColor, String id) {
        try {
            boolean bElementStarted = false;
            if (shape instanceof Rectangle) {
                Rectangle rect = (Rectangle)shape;
                bElementStarted = this.startRectElement(rect.x, rect.y, rect.width, rect.height);
            } else {
                bElementStarted = shape instanceof Polygon ? this.startPolygonElement((Polygon)shape) : this.startPathElement(shape);
            }
            if (bElementStarted) {
                this.writeAttribute("stroke", borderColor);
                this.writeAttribute("visibility", "hidden");
                this.writeAttribute("id", id);
                this.writeAttribute("fill", "none");
                this.writeAttribute("stroke-width", "2");
                this.endElement();
            }
        }
        catch (Exception e) {
            this.m_errorHandler.log(e.getMessage(), this.getClass().getName(), "_writeLinkBorder(Shape shape, Color borderColor, Color fillColor)");
        }
    }

    @Override
    @Concealed
    public String getBeanName() {
        if (this.m_id != null) {
            return this.m_id;
        }
        return "bigauge1";
    }

    @Override
    @Concealed
    public String getFilteredBeanName() {
        String name = this.getBeanName();
        if (name != null && name.length() > 0) {
            name = name.replace(':', '_');
        }
        return name;
    }

    @Override
    @Concealed
    public String getSimpleBeanName() {
        int i;
        String name = this.getBeanName();
        if (name != null && name.length() > 0 && (i = name.lastIndexOf(58)) > -1 && i < name.length() - 1) {
            name = name.substring(i + 1, name.length());
        }
        return name;
    }

    public String getClickEventJS() {
        return null;
    }

    public boolean isOnClickPresent() {
        return false;
    }

    public boolean isOnMouseOverOutPresent() {
        return false;
    }

    public String getShapeAttributesAlt() {
        return null;
    }

    public String getShapeAttributesTitle() {
        return null;
    }

    public String getShapeAttributesHRef() {
        return null;
    }

    public String getShapeAttributesTarget() {
        return null;
    }

    public void writeShapeAttributes() throws IOException, Exception {
    }

    public void writeShapeAttributesScript() throws IOException, Exception {
        this.startElement("defs");
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_shape_attributes");
        if (scriptId != null) {
            this.writeAttribute("id", scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("function bi_onClick(evt, snglClick, dblClick)");
        this.println("{");
        this.println("  if ((evt.detail == 2) && (dblClick != null))");
        this.println("    eval(dblClick);");
        this.println("  else");
        this.println("  {");
        this.println("    if (snglClick != null)");
        this.println("      eval(snglClick);");
        this.println("  }");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
    }

    public void writeLinkScript() throws IOException, Exception {
        this.startElement("defs");
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_gauge_link");
        if (scriptId != null) {
            this.writeAttribute("id", scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("function bi_link_show_mOver(evt, id)");
        this.println("{");
        this.println("       var rect = document.getElementById(id);");
        this.println("       rect.setAttributeNS(null, \"visibility\", \"visible\");");
        this.println("}");
        this.println("function bi_link_hide_mOut(evt, id)");
        this.println("{");
        this.println("       var rect = document.getElementById(id);");
        this.println("       rect.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
    }

    protected String getFillAttribute(Shape shape, Color fillColor, GradientObj gradient) throws IOException, Exception {
        String fillAttr = null;
        if (gradient != null) {
            String gradientName = this._writeGradientElement(shape, gradient);
            if (gradientName != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("url(#");
                sb.append(gradientName);
                sb.append(')');
                fillAttr = sb.toString();
            } else {
                if (this.m_eh != null) {
                    this.m_eh.log("gradient name null", this.getClass().getName(), "protected String getFillAttribute");
                }
                fillAttr = fillColor != null ? GaugeSVGWriter.colorToHex(fillColor) : "none";
            }
        } else {
            fillAttr = fillColor != null ? GaugeSVGWriter.colorToHex(fillColor) : "none";
        }
        return fillAttr;
    }

    protected void writeOpacityAttribute(Color color, String attr) throws IOException, Exception {
        int alpha = color.getAlpha();
        if (alpha < 255) {
            double opacity = (double)alpha / 255.0;
            if (opacity < 0.0) {
                opacity = 0.0;
            } else if (opacity > 255.0) {
                opacity = 255.0;
            }
            this.writeAttribute(attr, opacity);
        }
    }

    private String _writeGradientElement(Shape shape, GradientObj gradient) throws IOException, Exception {
        String elemID = this.getNextGradientID();
        this.startElement("defs");
        int direction = gradient.getDirectionConstant();
        switch (direction) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 20: {
                this._writeLinearGradientElement(shape, elemID, gradient);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                this._writeRadialGradientElement(shape, elemID, gradient);
            }
        }
        this.endElement();
        return elemID;
    }

    private void _writeLinearGradientElement(Shape shape, String elemID, GradientObj gradient) throws IOException, Exception {
        this.startElement("linearGradient");
        this.writeAttribute("id", elemID);
        this.writeAttribute("gradientUnits", "userSpaceOnUse");
        GradientObj.LinearGradientDef linear = gradient.getLinearGradientDef(shape);
        this.writeAttribute("x1", linear.x1);
        this.writeAttribute("y1", linear.y1);
        this.writeAttribute("x2", linear.x2);
        this.writeAttribute("y2", linear.y2);
        this._writeGradientStopElements(gradient);
        this.endElement();
    }

    private void _writeRadialGradientElement(Shape shape, String elemID, GradientObj gradient) throws IOException, Exception {
        this.startElement("radialGradient");
        this.writeAttribute("id", elemID);
        this.writeAttribute("gradientUnits", "userSpaceOnUse");
        GradientObj.RadialGradientDef radial = gradient.getRadialGradientDef(shape);
        this.writeAttribute("cx", radial.cx);
        this.writeAttribute("cy", radial.cy);
        this.writeAttribute("r", radial.radius);
        this._writeGradientStopElements(gradient);
        this.endElement();
    }

    private void _writeGradientStopElements(GradientObj gradient) throws IOException, Exception {
        for (GradientStopObj stop : gradient.getStopList()) {
            this.startElement("stop");
            double offset = stop.getPosition();
            this.writeAttribute("offset", offset);
            Color color = stop.getColor();
            this.writeAttribute("stop-color", color);
            if (color != null) {
                this.writeOpacityAttribute(color, "stop-opacity");
            }
            this.endElement();
        }
    }

    private String getNextGradientID() {
        return this.getFilteredBeanName() + "_" + GRADIENT_ID_BASE + this.m_gradientCount++;
    }

    @Override
    @Concealed
    protected String constructId(String id) {
        if (id == null || id.length() < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFilteredBeanName());
        sb.append("_");
        sb.append(id);
        return sb.toString();
    }
}

