/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dss.gauge.BaseGaugeComponent;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.SFX;
import oracle.dss.gauge.ThresholdSFX;
import oracle.javatools.annotations.Concealed;

public class Threshold
extends BaseGaugeComponent {
    @Concealed
    private ArrayList m_sfxList = null;

    public Threshold(CommonGauge gauge) {
        super(gauge, 15);
    }

    public Color getFillColor(int index) {
        Color tColor = null;
        ArrayList tList = (ArrayList)this.m_commonGauge.getAttribute("THRESHOLD_ATTRIBUTES");
        if (tList == null) {
            Color[] obj = GaugeDefaultValues.getThresholdColors();
            if (index < obj.length) {
                tColor = obj[index];
            } else {
                this.m_commonGauge.getErrorHandler().error((Throwable)new ArrayIndexOutOfBoundsException(index), this.getClass().getName(), "getFillColor");
            }
        } else if (index < tList.size()) {
            HashMap tMap = (HashMap)tList.get(index);
            if (tMap != null) {
                tColor = (Color)tMap.get("ThresholdFillColor");
            }
        } else {
            this.m_commonGauge.getErrorHandler().error((Throwable)new ArrayIndexOutOfBoundsException(index), this.getClass().getName(), "setFillColor");
        }
        return tColor;
    }

    public void setFillColor(int index, Color color) {
        ArrayList tList = (ArrayList)this.m_commonGauge.getAttribute("THRESHOLD_ATTRIBUTES");
        if (tList == null) {
            tList = new ArrayList(10);
            this.m_commonGauge.setAttribute("THRESHOLD_ATTRIBUTES", tList);
        }
        if (index >= tList.size()) {
            for (int i = tList.size(); i <= index; ++i) {
                tList.add(new HashMap(2));
            }
        }
        HashMap tMap = (HashMap)tList.get(index);
        Object oldValue = tMap.get("ThresholdFillColor");
        tMap.put("ThresholdFillColor", color);
        this.m_commonGauge.setRecalcState(1);
        this.m_commonGauge.firePropertyChange(this, "ThresholdFillColor", oldValue, color);
    }

    public Color getBorderColor(int index) {
        Color tColor = null;
        ArrayList tList = (ArrayList)this.m_commonGauge.getAttribute("THRESHOLD_ATTRIBUTES");
        if (tList == null) {
            tColor = GaugeDefaultValues.getThresholdBorderColor();
        } else if (index < tList.size()) {
            HashMap tMap = (HashMap)tList.get(index);
            if (tMap != null) {
                tColor = (Color)tMap.get("ThresholdBorderColor");
            }
        } else {
            this.m_commonGauge.getErrorHandler().error((Throwable)new ArrayIndexOutOfBoundsException(index), this.getClass().getName(), "setBorderColor");
        }
        return tColor;
    }

    public void setBorderColor(int index, Color color) {
        ArrayList tList = (ArrayList)this.m_commonGauge.getAttribute("THRESHOLD_ATTRIBUTES");
        if (tList == null) {
            tList = new ArrayList(10);
            this.m_commonGauge.setAttribute("THRESHOLD_ATTRIBUTES", tList);
        }
        if (index >= tList.size()) {
            for (int i = tList.size(); i <= index; ++i) {
                tList.add(new HashMap(2));
            }
        }
        HashMap tMap = (HashMap)tList.get(index);
        Object oldValue = tMap.get("ThresholdBorderColor");
        tMap.put("ThresholdBorderColor", color);
        this.m_commonGauge.setRecalcState(1);
        this.m_commonGauge.firePropertyChange(this, "ThresholdBorderColor", oldValue, color);
    }

    public String getText(int index) {
        String tstr = null;
        ArrayList tList = (ArrayList)this.m_commonGauge.getAttribute("THRESHOLD_ATTRIBUTES");
        if (tList != null) {
            if (index < tList.size()) {
                HashMap tMap = (HashMap)tList.get(index);
                if (tMap != null) {
                    tstr = (String)tMap.get("ThresholdText");
                }
            } else {
                this.m_commonGauge.getErrorHandler().error((Throwable)new ArrayIndexOutOfBoundsException(index), this.getClass().getName(), "setBorderColor");
            }
        }
        return tstr;
    }

    public void setText(int index, String str) {
        ArrayList tList = (ArrayList)this.m_commonGauge.getAttribute("THRESHOLD_ATTRIBUTES");
        if (tList == null) {
            tList = new ArrayList(10);
            this.m_commonGauge.setAttribute("THRESHOLD_ATTRIBUTES", tList);
        }
        if (index >= tList.size()) {
            for (int i = tList.size(); i <= index; ++i) {
                tList.add(new HashMap(2));
            }
        }
        HashMap tMap = (HashMap)tList.get(index);
        Object oldValue = tMap.get("ThresholdText");
        tMap.put("ThresholdText", str);
        this.m_commonGauge.setRecalcState(1);
        this.m_commonGauge.firePropertyChange(this, "ThresholdText", oldValue, str);
    }

    public SFX getSFX(int index) {
        if (this.m_sfxList == null) {
            this.m_sfxList = new ArrayList(index + 1);
        }
        if (index >= this.m_sfxList.size()) {
            for (int i = this.m_sfxList.size(); i <= index; ++i) {
                this.m_sfxList.add(new ThresholdSFX(this.m_commonGauge, i));
            }
        }
        return (SFX)this.m_sfxList.get(index);
    }

    public int size() {
        ArrayList tList = (ArrayList)this.m_commonGauge.getAttribute("THRESHOLD_ATTRIBUTES");
        int tCount = tList != null ? tList.size() : 0;
        return tCount;
    }
}

