/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class PieFeeler
extends BaseGraphComponent {
    @Concealed
    public PieFeeler(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getPieFeelerLine();
    }

    @Override
    public boolean selectObject(int series, int group) {
        if (series >= 0 && group >= 0) {
            IdentObj identObj = this.m_identObj;
            identObj.setSeriesID(series);
            identObj.setGroupID(group);
            this.m_pfj.setSelection(identObj);
            if (identObj.equals(this.m_pfj.getSelectionID())) {
                return true;
            }
        }
        return false;
    }

    public Color getLineColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    public void setLineColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setLineColor( Color newColor )");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, newColor);
    }

    public int getLineWidth() {
        return this.m_pfj.getLineWidth(this.m_identObj);
    }

    public void setLineWidth(int width) {
        if (width < 0) {
            this.m_commonGraph.getErrorHandler().log("invalid line width", this.getClass().getName(), "setLineWidth (int width)");
        } else {
            this.m_pfj.setLineWidth(this.m_identObj, width);
        }
    }

    public int getLineStyle() {
        return this.m_pfj.getLineStyle(this.m_identObj);
    }

    public void setLineStyle(int style) {
        if (style < 0 || style > 3) {
            this.m_commonGraph.getErrorHandler().log("invalid line style", this.getClass().getName(), "setLineStyle (int style)");
        } else {
            this.m_pfj.setLineStyle(this.m_identObj, style);
        }
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean styleOverridden = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getLineWidthObj(this.m_identObj);
        if (val != null) {
            node.addProperty("lineWidth", ((Integer)val).intValue());
            styleOverridden = true;
        }
        if ((val = this.getLineColor()) != null) {
            node.addProperty("lineColor", PieFeeler.toHexString(((Color)val).getRGB()));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getLineStyleObj(this.m_identObj)) != null) {
            node.addProperty("lineStyle", PieFeeler.convertLineStyleToString((Integer)val));
            styleOverridden = true;
        }
        return styleOverridden;
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("lineWidth");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("lineWidth", new Integer(pNode.getValueAsInteger()));
            } else {
                this.setLineWidth(pNode.getValueAsInteger());
            }
        }
        if ((pNode = node.getProperty("lineStyle")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("lineStyle", new Integer(PieFeeler.convertLineStyleToInt(pNode.getValueAsString())));
            } else {
                this.setLineStyle(PieFeeler.convertLineStyleToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("lineColor")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("lineColor", new Color(PieFeeler.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setLineColor(new Color(PieFeeler.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "PieFeeler";
    }
}

