/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.managers;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.ViewStyleHandle;
import oracle.dss.dataView.managers.RuleManager;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.DataFilterImpl;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphStyleManager;
import oracle.dss.graph.managers.GraphStyle;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.ResolutionService;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.RuleContext;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.EdgeComponentInfo;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.GroupComponentInfo;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.SeriesComponentInfo;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.javatools.annotations.Concealed;

@Concealed
public class GraphRuleStyles
extends RuleManager
implements GraphStyleManager,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected transient EdgeComponentInfo einfo = new EdgeComponentInfo(0, 0, 0);
    private static final boolean DEBUG = false;
    private static final String m_getMetadataStyle = "getMetadataStyle";

    @Override
    public void dataSourceChanged() {
    }

    @Override
    public void setBundles(DataviewCommon view, Vector bundles) {
        super.setBundles(view, bundles);
        if (view != null) {
            view.metadataStyleChanged();
            if (view instanceof Graph) {
                ((Graph)view).getPFJ().needRecalc();
            }
        }
    }

    @Override
    @Concealed
    public ViewStyle getMetadataStyle(Graph view, Object metaData, ViewStyle initStyle, int edge, int depth, int index) {
        ViewStyleHandle vsHandle;
        Object obj;
        boolean bRunRules = true;
        boolean bClonedInitStyle = false;
        DataAccess baseDataAccess = null;
        if (view.getModel() != null) {
            baseDataAccess = view.getModel().getDataAccess();
        }
        if (baseDataAccess == null) {
            baseDataAccess = view.getCommonGraph().getDataAccess();
        }
        if (view.isLayerMetaViewStyleSupported()) {
            obj = null;
            try {
                obj = baseDataAccess.getLayerMetadata(edge, depth, "viewStyle");
            }
            catch (EdgeOutOfRangeException coore) {
                view.getErrorHandler().log("edge out of range", this.getClass().getName(), m_getMetadataStyle);
            }
            catch (LayerOutOfRangeException roore) {
                view.getErrorHandler().log("layer out of range", this.getClass().getName(), m_getMetadataStyle);
            }
            vsHandle = null;
            if (obj != null) {
                if (obj instanceof ViewStyleHandle) {
                    vsHandle = (ViewStyleHandle)obj;
                } else {
                    view.getErrorHandler().log("object not ViewStyleHandle type", this.getClass().getName(), m_getMetadataStyle);
                }
            }
            if (vsHandle != null) {
                if (vsHandle.getViewStyle() != null) {
                    if (!bClonedInitStyle) {
                        initStyle = (ViewStyle)initStyle.clone();
                        bClonedInitStyle = true;
                    }
                    initStyle.merge((Mergeable)vsHandle.getViewStyle());
                }
                if (vsHandle.getRunRulesForViewStyle() == 0) {
                    bRunRules = false;
                } else if (vsHandle.getRunRulesForViewStyle() == 1) {
                    bRunRules = true;
                }
            }
        }
        if (view.isMetadataViewStyleSupported()) {
            obj = null;
            try {
                obj = baseDataAccess.getMemberMetadata(edge, depth, index, "viewStyle");
            }
            catch (EdgeOutOfRangeException coore) {
                view.getErrorHandler().log("edge out of range", this.getClass().getName(), m_getMetadataStyle);
            }
            catch (LayerOutOfRangeException roore) {
                view.getErrorHandler().log("layer out of range", this.getClass().getName(), m_getMetadataStyle);
            }
            catch (SliceOutOfRangeException soore) {
                view.getErrorHandler().log("slice out of range", this.getClass().getName(), m_getMetadataStyle);
            }
            vsHandle = null;
            if (obj != null) {
                if (obj instanceof ViewStyleHandle) {
                    vsHandle = (ViewStyleHandle)obj;
                } else {
                    view.getErrorHandler().log("object not ViewStyleHandle type", this.getClass().getName(), m_getMetadataStyle);
                }
            }
            if (vsHandle != null) {
                if (vsHandle.getViewStyle() != null) {
                    if (!bClonedInitStyle) {
                        initStyle = (ViewStyle)initStyle.clone();
                        bClonedInitStyle = true;
                    }
                    initStyle.merge((Mergeable)vsHandle.getViewStyle());
                }
                if (vsHandle.getRunRulesForViewStyle() == 0) {
                    bRunRules = false;
                } else if (vsHandle.getRunRulesForViewStyle() == 1) {
                    bRunRules = true;
                }
            }
        }
        if (!bRunRules) {
            return initStyle;
        }
        this.einfo.setEdgeDepthIndex(edge, depth, index);
        RuleContext location = new RuleContext();
        String type = metaData instanceof Number ? "NUMBER_VALUE" : (metaData instanceof Date ? "DATE_VALUE" : "STRING_VALUE");
        location.put((Object)"POSITION", (Object)this.einfo);
        if (metaData != null) {
            location.put((Object)type, metaData);
        }
        String layerName = null;
        try {
            QDR qdr = null;
            qdr = baseDataAccess.getLayerQDR(edge, depth, 0);
            if (qdr != null) {
                location.put((Object)"DIMENSIONQDR", (Object)qdr);
                Enumeration layers = qdr.getDimensions();
                if (layers.hasMoreElements()) {
                    layerName = layers.nextElement().toString();
                }
            }
        }
        catch (NullPointerException e) {
            view.getErrorHandler().log("DataProvider is null", this.getClass().getName(), m_getMetadataStyle);
        }
        catch (EdgeOutOfRangeException ee) {
            view.getErrorHandler().log("edge out of range when getting layer QDR", this.getClass().getName(), m_getMetadataStyle);
        }
        catch (LayerOutOfRangeException le) {
            view.getErrorHandler().log("layer out of range when getting layer QDR", this.getClass().getName(), m_getMetadataStyle);
        }
        QDR memberQDR = null;
        memberQDR = this.einfo.getQDR(baseDataAccess, 1);
        if (memberQDR != null) {
            if (layerName != null) {
                memberQDR.setTarget(new QDRMember(layerName));
            }
            location.put((Object)"QDR", (Object)memberQDR);
        }
        if (edge == 2) {
            location.put((Object)"COMPONENT_TYPE", (Object)new Integer(3));
        }
        ViewStyle style = initStyle;
        try {
            if (this.m_bundles != null) {
                initStyle = style = (ViewStyle)ResolutionService.resolveRules((RuleContext)location, (Mergeable)initStyle, (Vector)this.m_bundles);
            }
            if (this.m_uiBundle != null && initStyle != null) {
                style = (ViewStyle)ResolutionService.resolveRules((RuleContext)location, (Mergeable)initStyle, (RuleBundle)this.m_uiBundle);
            }
        }
        catch (ClassCastException e) {
            view.getErrorHandler().log("Class cast exception of ResolutionService", this.getClass().getName(), m_getMetadataStyle);
            return null;
        }
        if (style == null) {
            view.getErrorHandler().log("Error in resolving rules", this.getClass().getName(), m_getMetadataStyle);
            return null;
        }
        return style;
    }

    @Override
    public GraphStyle getGraphComponentStyle(CommonGraph graph, int series, int group) {
        GraphStyle style = null;
        if (graph == null || series == -3 && group == -3) {
            return null;
        }
        int rawRowID = graph.isDataRowShownAsASeries() ? series : group;
        int rawColID = graph.isDataRowShownAsASeries() ? group : series;
        int rowID = graph.getDataFilter().getDataAccessRow(rawRowID);
        int colID = graph.getDataFilter().getDataAccessColumn(rawColID);
        RuleContext context = new RuleContext();
        SeriesComponentInfo ci = null;
        if (colID == -3) {
            ci = new SeriesComponentInfo(rowID);
        } else if (rowID == -3) {
            ci = new GroupComponentInfo(colID);
        } else {
            ci = new DataComponentInfo(rowID, colID);
            Object data = ((DataFilterImpl)graph.getDataFilter()).getValue(rawRowID, rawColID);
            if (data instanceof Number) {
                context.put((Object)"NUMBER_VALUE", data);
            }
        }
        context.put((Object)"POSITION", (Object)ci);
        DataAccess baseDataAccess = null;
        if (graph.getModel() != null) {
            baseDataAccess = graph.getModel().getDataAccess();
        }
        if (baseDataAccess == null) {
            baseDataAccess = graph.getDataAccess();
        }
        context.put((Object)"DATA_ACCESS", (Object)baseDataAccess);
        QDR qdr = null;
        qdr = ci.getQDR(baseDataAccess, 1);
        if (qdr != null) {
            context.put((Object)"QDR", (Object)qdr);
        }
        GraphStyle initStyle = new GraphStyle(graph);
        if (this.m_bundles != null) {
            style = (GraphStyle)ResolutionService.resolveRules((RuleContext)context, (Mergeable)initStyle, (Vector)this.m_bundles);
        }
        return style;
    }

    @Concealed
    public ObjectNode getXML(boolean allProperties, DataviewCommon dataview) {
        return this.getXML(allProperties, "StyleManager", dataview);
    }

    @Override
    @Concealed
    public void setXML(ContainerNode node, DataviewCommon dataview, String version, int reset) {
        super.setXML(node, dataview, version, reset);
        if (dataview instanceof CommonGraph) {
            ((CommonGraph)dataview).updatePageItems();
        }
    }

    @Override
    public void setUIBundle(DataviewCommon view, RuleBundle bundle) {
        super.setUIBundle(view, bundle);
        if (view != null) {
            view.metadataStyleChanged();
            view.repaint();
        }
    }
}

