/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.PieFrameObj;
import oracle.dss.graph.pfj.PieSliceObj;
import oracle.dss.graph.pfj.ReversePathIterator;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetArea;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetMetadata;
import oracle.dss.graph.pfj.draw.DetPolyline;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.DetShape;
import oracle.dss.graph.pfj.draw.DetSlice;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.presutil.PresUtils;

public class JChart_2D_Pie
extends JChart_2D {
    private static final long serialVersionUID = 1L;
    public static final boolean DEBUG_2D_PIE = false;
    public static final int DRILL_LABEL_MARGIN = 10;
    double m_fRingPct;
    double m_fPieTilt;
    double m_fThickness;
    double m_maxStrLength;
    int m_nPiesPerRow;
    int m_bPieLabelDisplay;
    int m_nFeelerTextFormat;
    String m_strFeelerTextFormatPattern;
    int m_nPieFeelerTextDisplay;
    boolean m_bSliceLabelVisibility;
    boolean m_bGTHasRing;
    boolean m_bGTProportional;
    boolean m_bGTMultiple;
    boolean m_bShowPieTotal;
    boolean m_bReverseGroups;
    int m_nKissingFeelers;
    int m_nThickOffset;
    int m_nRadius;
    int m_nSaveRadius;
    int m_temp;
    double m_fPieTotal;
    double m_fHighestGroupTotal;
    Rectangle m_rPieFrame;
    Rectangle m_rPieSliceLabelFrame;
    List<PieSliceObj> m_slices;
    int m_nSliceCount;
    int m_nLabelHeight;
    int m_nPieLabelHeight;
    int m_nXCenter;
    int m_nYCenter;
    int m_sliceLabelLeftEdge;
    int m_sliceLabelRightEdge;
    int[] m_stringWidths;
    String[] m_fullSliceLabels;
    int m_maxLabelWidthDest;
    Vector m_vectStrLabels;
    Vector m_leftSliceLabels;
    Vector m_rightSliceLabels;
    FontMetrics m_sliceLabelFM;
    Dimension m_labelDimVC;
    int m_nLineWidthFeeler;
    int m_nLineStyleFeeler;
    int m_pivotLineVirt;
    int m_pivotLineDest;
    int m_feelerTextGapVirt;
    int m_feelerTextGapDest;
    Rectangle m_rOPI_PieFrame;
    int m_nPieBarSlice;
    Point2D m_ptTopSlice;
    Point2D m_ptBottomSlice;
    TextStyleObj m_textStyleFeelers;
    boolean[][] m_bSeriesPartOfOther;
    boolean[][] m_bSeriesDrawn;
    boolean m_bOtherPercentage;
    boolean m_bLabelsAtTopOrBottom;
    boolean m_sliceLabelTruncated;
    boolean m_DetachPresent;
    Rectangle2D m_arc2DBounds;
    BlackBoxObj m_borderGradientBB;
    Rectangle2D m_pieBoundary;
    Rectangle2D m_pieNewBoundary;
    Dimension2D m_pieLabelMargin;
    double m_widthOfM;
    double m_fontHeightVC;
    double m_fontHeightDest;
    double m_fXSquashRatio;
    double m_fYSquashRatio;
    int m_numCols = 1;
    int m_numRows = 1;
    Dimension m_numberOfPies;
    double m_pieLabelMarginValue = 0.0;
    double m_pieMostDetatchDouble = 0.0;
    public static final int INFINITE_WIDTH = -1;
    public static final int MAX_LINES_WRAP = 3;
    public static final int PIE_LABEL_MARGIN_VALUE = 4;
    public static final double PIE_LABEL_MARGIN_EXPLODE_RATIO = 0.7;
    public static final double PIE_LABEL_MARGIN_PIESIZE_RATIO = 0.05;
    public static final double PIE_PACKED_OCCUPANCY = 0.9;
    public static final int PIE_LABEL_ON_TOP = 0;
    public static final int PIE_LABEL_ON_MID = 1;
    public static final int PIE_LABEL_ON_BOT = 2;
    public static final int PIE_FEELER_ON_TOP = 0;
    public static final int PIE_FEELER_ON_MID = 1;
    public static final int PIE_FEELER_ON_BOT = 2;
    public static final int PIE_OPTIMAL = 0;
    public static final int PIE_CLUSTER = 1;
    public static final int PIE_PACKED = 2;
    public static final double SINGLE_PIE_MOST_EXPLODED = 1500.0;
    public static final double MULTI_PIE_MOST_EXPLODED = 2000.0;
    Rectangle m_drillLabelRect;
    IdentObj m_drillLabel;
    IdentObj m_drillLabelBox;
    TextStyleObj m_pieLabelTextStyleObj;
    VC m_VC;
    int m_leftMostPointOfPie;
    int m_rightMostPointOfPie;
    int m_sliceLabelFontHeight;
    int m_virtMarginHeight;
    int m_virtMarginWidth;
    int m_sliceLabelGap;
    public static final double SLIGHTLY_SHADED = 0.8;
    public static final double MORE_SHADED = 0.6;
    public static final double MOST_SHADED = 0.4;
    public static final double UNKNOWN_ANGLE = -7.0;
    public static final int TYPE_TOP = 1000;
    public static final int TYPE_LEFT = 2000;
    public static final int TYPE_RIGHT = 3000;
    public static final int TYPE_CRUST = 4000;
    public static final int TYPE_RING = 5000;
    public static final int TYPE_BORDER = 6000;
    public static final int TYPE_CRUST_BACK = 7000;
    public static final int RADIAL_FEELER = 100;
    public static final int PIVOT_FEELER = 200;
    public static final int PPR_AUTOMATIC = 0;
    public static final int MAX_PIELABELHEIGHT = 2500;
    public static final int LABEL_COMPENSATION = 2;
    public static final int AVG_PIELABEL_SIZE = 4;
    public static final int MARGIN = 5;
    public static final int MAX_PIVOT_LINE = 5;
    public static final int MIN_PIVOT_LINE = 2;
    public static final int MAX_FEELER_TEXT_GAP = 3;
    public static final int MIN_FEELER_TEXT_GAP = 1;
    public static final int ADDITIONAL_SPACE = 26;
    public static final int COLLISION_NONE = 0;
    public static final int COLLISION_BOTH = 1;
    public static final int COLLISION_TOP = 2;
    public static final int COLLISION_BOTTOM = 3;
    public static final int kPENETRATING_FEELER = 0;
    public static final int kKISSING_FEELER = 1;
    public static final double FONT_GAP = 0.33;
    public static final double MIN_RADIUS = 0.25;
    private static final int PIE_BAR_MARGIN = 3;
    private Vector m_boundingRects;
    private boolean m_collision = false;
    private boolean m_no_collision = false;
    private boolean m_circular = false;
    protected int m_nBarThickCoord;
    private ArrayList m_topRightSlices = new ArrayList();
    private ArrayList m_topLeftSlices = new ArrayList();
    private ArrayList m_botRightSlices = new ArrayList();
    private ArrayList m_botLeftSlices = new ArrayList();

    @Override
    public void calc() {
        this.m_numberOfPies = new Dimension(1, 1);
        this.calcCommon(false);
        if (this.m_bGTMultiple) {
            this.m_numberOfPies = this.calcMultiplePies();
        } else {
            this.calcSinglePie();
        }
        this.calcDrillLabel();
        if (this.m_sliceLabelTruncated) {
            this.m_Perspective.setSliceLabelsTruncated(this.m_sliceLabelTruncated, new IdentObj(295));
        } else {
            this.m_Perspective.setSliceLabelsTruncated(this.m_sliceLabelTruncated, null);
        }
        this.fireInapropriateDataEvent();
    }

    private void calcCommon(boolean al) {
        if (!al) {
            super.calc();
        }
        this.calcHighestGroupTotal();
        boolean bOtherSeries = this.m_Perspective.getOtherSeries();
        if (bOtherSeries) {
            this.createSeriesPartOfOther(this.m_nTotalSeries, this.m_nTotalGroups);
            this.createSeriesDrawn(this.m_nTotalSeries, this.m_nTotalGroups);
        }
        this.m_bOtherPercentage = false;
        this.m_VC = this.m_Perspective.getVC();
        this.m_vectStrLabels = null;
        this.m_sliceLabelTruncated = false;
        this.m_fullSliceLabels = null;
        this.m_nPieLabelHeight = 0;
        this.m_collision = false;
        this.m_no_collision = false;
        this.m_circular = false;
        this.m_DetachPresent = false;
        this.m_sliceLabelFM = null;
        this.m_virtMarginHeight = this.m_VC.destToVirtHeight(5);
        this.m_virtMarginWidth = this.m_VC.destToVirtWidth(5);
        if (this.m_Perspective.getDisplay(296)) {
            this.m_nPieLabelHeight = this.calcPieLabelHeight();
        }
        this.createFeelerTextStyle();
        this.m_sliceLabelGap = (int)((double)this.m_VC.destToVirtHeight(TextStyleObj.getFontHeight(this.getSliceLabelFontMetrics(), this.m_Perspective.getFontMetricsResolver())) * 0.33);
        this.m_boundingRects = new Vector();
    }

    @Override
    public void calcDataScrollers() {
    }

    private void calcHighestGroupTotal() {
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        this.m_fHighestGroupTotal = 0.0;
        if (this.m_bGTProportional) {
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                double fThisTotal = this.getGroupTotal(g);
                if (!(fThisTotal > this.m_fHighestGroupTotal)) continue;
                this.m_fHighestGroupTotal = fThisTotal;
            }
        }
    }

    private Dimension calcMultiplePies() {
        int nNumPiesLeftOver;
        int nNumRowsY;
        double fSumTotal = 0.0;
        int nNumColsX = this.m_nPiesPerRow;
        if (nNumColsX == 0) {
            int numRowsAfter;
            int numRowsBefore;
            nNumColsX = (int)Math.sqrt(this.m_nGroups);
            int destPieFrameHeight = this.m_VC.virtToDestHeight(this.m_rOPI_PieFrame.height);
            int destPieFrameWidth = this.m_VC.virtToDestWidth(this.m_rOPI_PieFrame.width);
            if (destPieFrameWidth < (int)((double)destPieFrameHeight * 0.2) && nNumColsX > 1) {
                --nNumColsX;
            }
            if (destPieFrameWidth < (int)((double)destPieFrameHeight * 0.4) && nNumColsX > 1) {
                --nNumColsX;
            }
            if (destPieFrameWidth > (int)((double)destPieFrameHeight * 1.3) && (numRowsBefore = (this.m_nGroups - 1) / nNumColsX + 1) == (numRowsAfter = (this.m_nGroups - 1) / ++nNumColsX + 1)) {
                --nNumColsX;
            }
            if (destPieFrameWidth > (int)((double)destPieFrameHeight * 2.3) && (numRowsBefore = (this.m_nGroups - 1) / nNumColsX + 1) == (numRowsAfter = (this.m_nGroups - 1) / ++nNumColsX + 1)) {
                --nNumColsX;
            }
            if (nNumColsX < 1) {
                nNumColsX = 1;
            }
        }
        if (nNumColsX > this.m_nGroups) {
            this.m_Perspective.getErrorHandler().log("Attempted using PiesPerRow greater than number of groups.", this.getClass().getName(), "calcMultiplePies()");
            nNumRowsY = 1;
            nNumColsX = this.m_nGroups;
            nNumPiesLeftOver = 0;
        } else {
            nNumRowsY = (this.m_nGroups - 1) / nNumColsX + 1;
            nNumPiesLeftOver = this.m_nGroups % nNumColsX;
        }
        this.m_numCols = nNumColsX;
        this.m_numRows = nNumRowsY;
        Rectangle rectSubPie = new Rectangle(this.m_rOPI_PieFrame.x, this.m_rOPI_PieFrame.y, this.m_rOPI_PieFrame.width / nNumColsX, this.m_rOPI_PieFrame.height / nNumRowsY);
        this.m_nRadius = this.calcSinglePieRadius(rectSubPie, false);
        if (!this.m_bSliceLabelVisibility || this.m_nPieFeelerTextDisplay == 3) {
            int radiusDest;
            int rectSubPieDestHt = this.m_VC.virtToDestHeight(rectSubPie.height - this.m_nPieLabelHeight);
            int rectSubPieDestWd = this.m_VC.virtToDestWidth(rectSubPie.width);
            Rectangle destRect = this.m_VC.getDestCoords();
            double fYSquashRatio = (double)Math.abs(destRect.width) / (double)destRect.height;
            double fXSquashRatio = 1.0;
            if (fYSquashRatio > 1.0) {
                fXSquashRatio = 1.0 / fYSquashRatio;
                fYSquashRatio = 1.0;
            }
            if ((radiusDest = (int)this.m_VC.virtToDestWidth((double)this.m_nRadius * fXSquashRatio)) * 2 > (int)((double)rectSubPieDestWd * 0.9)) {
                radiusDest = (int)((double)rectSubPieDestWd * 0.9 / 2.0);
            }
            if (radiusDest * 2 > (int)((double)rectSubPieDestHt * 0.9)) {
                radiusDest = (int)((double)rectSubPieDestHt * 0.9 / 2.0);
            }
            this.m_nRadius = this.calcVirtRadius(radiusDest, destRect);
        }
        this.m_nSaveRadius = this.m_nRadius;
        int nTopX = this.m_rOPI_PieFrame.x;
        int nTopY = this.m_rOPI_PieFrame.y + this.m_rOPI_PieFrame.height - rectSubPie.height;
        this.calcPivotLineAndGap(rectSubPie.width, rectSubPie.height);
        boolean isBIDI = this.m_Perspective.isBIDILocale();
        if (isBIDI) {
            int nCurrentGroup = nNumColsX - 1;
            for (int nRowY = 0; nRowY < nNumRowsY; ++nRowY) {
                int nCenterLeftOverPieXOffset;
                nCurrentGroup = (nRowY + 1) * nNumColsX - 1;
                if (this.m_nGroups <= nCurrentGroup) {
                    nNumColsX -= nCurrentGroup - this.m_nGroups + 1;
                    nCurrentGroup = this.m_nGroups - 1;
                    nCenterLeftOverPieXOffset = this.m_rOPI_PieFrame.width / 2 - nNumPiesLeftOver * rectSubPie.width / 2;
                } else {
                    nCenterLeftOverPieXOffset = 0;
                }
                for (int nColX = 0; nColX < nNumColsX; ++nColX) {
                    if (nCurrentGroup < this.m_nGroups) {
                        rectSubPie.x = nTopX + nColX * rectSubPie.width + nCenterLeftOverPieXOffset;
                        rectSubPie.y = nTopY - nRowY * rectSubPie.height;
                        this.m_rPieFrame = rectSubPie;
                        double total = this.drawPie(nCurrentGroup--);
                        fSumTotal += total;
                        continue;
                    }
                    --nCurrentGroup;
                }
            }
        } else {
            int nCurrentGroup = 0;
            for (int nRowY = 0; nRowY < nNumRowsY; ++nRowY) {
                int nCenterLeftOverPieXOffset = this.m_nGroups < nCurrentGroup + nNumColsX ? this.m_rOPI_PieFrame.width / 2 - nNumPiesLeftOver * rectSubPie.width / 2 : 0;
                for (int nColX = 0; nColX < nNumColsX; ++nColX) {
                    if (nCurrentGroup >= this.m_nGroups) continue;
                    rectSubPie.x = nTopX + nColX * rectSubPie.width + nCenterLeftOverPieXOffset;
                    rectSubPie.y = nTopY - nRowY * rectSubPie.height;
                    this.m_rPieFrame = rectSubPie;
                    double total = this.drawPie(nCurrentGroup++);
                    fSumTotal += total;
                }
            }
        }
        return new Dimension(nNumColsX, nNumRowsY);
    }

    protected void calcSinglePie() {
        this.m_rPieFrame = this.m_rOPI_PieFrame;
        this.m_nLabelHeight = Math.min(2000, this.m_rOPI_PieFrame.height / 4);
        this.m_nRadius = this.calcSinglePieRadius(this.m_rPieFrame, false);
        if (this.m_nRadius <= 0) {
            return;
        }
        this.m_nSaveRadius = this.m_nRadius;
        this.drawPie(0);
    }

    protected Vector getPieRingBounds() {
        return this.m_boundingRects;
    }

    private void drawNoPositiveData(Rectangle pieFrame) {
        IdentObj id = this.m_Perspective.getNoDataErrorText();
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.getFontCache(), this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), true, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), 0, 0, this.m_Perspective.getAutofit(id), false, true, this.m_Perspective.getLocale());
        textStyleObj.setHorizAlign(0);
        BlackBoxObj bbText = new BlackBoxObj(this.m_Perspective, id);
        String message = this.m_Perspective.getIntlString("af_dvt_graph.LABEL_NO_POSITIVE_DATA", this.m_Perspective.getResourceBundle());
        new DetLabel(this.m_Detectiv, id, message, pieFrame, textStyleObj, bbText);
    }

    public int calcReqWidth(Rectangle pieFrame) {
        this.calcCommon(true);
        return this.calcSinglePieRadius(pieFrame, true);
    }

    private int calcSinglePieRadius(Rectangle pieFrame, boolean al) {
        int numLinesPerLabelOnRight;
        int numLinesPerLabelOnLeft;
        int numLinesPerLabel;
        int maxRadiusDest;
        int maxRadius;
        int radiusDest = 0;
        int availWidth = pieFrame.width;
        int availHeight = pieFrame.height;
        this.m_maxLabelWidthDest = 0;
        this.m_bLabelsAtTopOrBottom = false;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int group = 0;
        int g = gEnum.getAbsoluteGroup(group);
        if (this.m_gt.isPieBarType() && this.isPieBarSliceOK()) {
            availWidth -= this.m_nBarThickCoord + this.m_Perspective.getVC().destToVirtWidth(this.m_Perspective.updateMargin(3, false));
            availWidth = (int)((double)availWidth * 0.9);
        }
        if ((availHeight -= this.m_nPieLabelHeight) < 200 || availWidth < 200) {
            return -1;
        }
        this.calcPivotLineAndGap(availWidth, availHeight);
        Rectangle rect = this.m_VC.getDestCoords();
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        int maxDetach = 0;
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            double fValue = this.m_gt.isPieBarType() ? this.getSeriesTotal(s) : this.getDataValue((int)s, (int)g).m_fValue;
            if (!(fValue > 0.0) || !this.m_bSmallDataSet) continue;
            double fDetach = (double)this.m_Perspective.getPieSliceDetach(s, g) / 100.0;
            int nDetach = 0;
            nDetach = (int)(fDetach * 1500.0);
            if (nDetach <= maxDetach) continue;
            maxDetach = nDetach;
        }
        int nTipX = 0;
        int nTipY = 0;
        if (maxDetach > 0) {
            double fXSquashRatio = 1.0;
            double fYSquashRatio = (double)Math.abs(rect.width) / (double)rect.height;
            if (fYSquashRatio > 1.0) {
                fXSquashRatio = 1.0 / fYSquashRatio;
                fYSquashRatio = 1.0;
            }
            fYSquashRatio -= fYSquashRatio * this.m_fPieTilt;
            double f12OClock = -1.5707963267948966;
            double fAngle = f12OClock + 4.71238898038469;
            nTipX = 0 + (int)(Math.cos(fAngle) * fXSquashRatio * (double)maxDetach / (double)this.m_numCols);
            fAngle = f12OClock + 0.0;
            nTipY = 0 - (int)(Math.sin(fAngle) * fYSquashRatio * (double)maxDetach / (double)this.m_numRows);
        }
        if (this.m_gt.isPieBarType()) {
            this.m_fHighestGroupTotal = this.getSumTotal();
            this.m_fPieTotal = this.getSumTotal();
        } else {
            this.m_fPieTotal = this.getGroupTotal(g);
        }
        if (!this.m_bGTMultiple && this.m_fPieTotal <= 0.0) {
            this.drawNoPositiveData(pieFrame);
            return -1;
        }
        FontMetrics fm = this.getSliceLabelFontMetrics();
        int fontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
        this.getSliceLabels(g, fm);
        int availWidthDest = this.m_VC.virtToDestWidth(availWidth - Math.abs(nTipX) * 2);
        int availHeightDest = this.m_VC.virtToDestHeight(availHeight - Math.abs(nTipY) * 2);
        if (!this.m_bSliceLabelVisibility || this.m_nPieFeelerTextDisplay == 3) {
            radiusDest = availWidthDest < availHeightDest ? availWidthDest / 2 - 5 : availHeightDest / 2 - 5;
            if (al) {
                return (radiusDest + 5) * 2;
            }
            return this.calcVirtRadius(radiusDest, rect);
        }
        boolean bAnimationSupported = this.m_Perspective.m_bAnimationSupported && !this.m_bGTMultiple;
        int radiusByHt = availHeight / 2;
        radiusByHt = this.m_bLabelsAtTopOrBottom || bAnimationSupported ? (radiusByHt -= this.m_VC.destToVirtHeight(fontHeight)) : (radiusByHt -= this.m_VC.destToVirtHeight(fontHeight / 2));
        radiusByHt = this.m_bLabelsAtTopOrBottom || bAnimationSupported ? (int)((double)radiusByHt / 1.125) : (int)((double)radiusByHt / 1.0625);
        int radiusByHtDest = this.m_VC.virtToDestHeight(radiusByHt);
        int minRadiusByWdDest = (int)this.m_VC.virtToDestWidth((double)availWidth * 0.25);
        int minRadiusDest = 0;
        if (radiusByHtDest < minRadiusByWdDest) {
            int minRadius = this.calcVirtRadius(radiusByHtDest, rect);
            if (al) {
                return this.m_maxLabelWidthDest * 2 + radiusByHtDest * 2 + 26;
            }
            return minRadius;
        }
        int minRadius = this.calcVirtRadius(minRadiusByWdDest, rect);
        minRadiusDest = minRadiusByWdDest;
        int maxRadiusByWd = availWidth / 2;
        int maxRadiusByWdDest = this.m_VC.virtToDestWidth(maxRadiusByWd);
        if (radiusByHtDest < maxRadiusByWdDest) {
            maxRadius = this.calcVirtRadius(radiusByHtDest, rect);
            maxRadiusDest = radiusByHtDest;
        } else {
            maxRadius = this.calcVirtRadius(maxRadiusByWdDest, rect);
            maxRadiusDest = maxRadiusByWdDest;
        }
        if (bAnimationSupported) {
            minRadiusDest = maxRadiusDest = (minRadiusDest + maxRadiusDest) / 2;
            maxRadius = this.calcVirtRadius(maxRadiusDest, rect);
            minRadius = this.calcVirtRadius(minRadiusDest, rect);
        }
        int maxSliceLabelWidthDest = (availWidthDest - minRadiusDest * 2) / 2;
        int minSliceLabelWidthDest = (availWidthDest - maxRadiusDest * 2) / 2;
        maxSliceLabelWidthDest -= this.m_feelerTextGapDest;
        minSliceLabelWidthDest -= this.m_feelerTextGapDest;
        if ((this.m_nPieFeelerTextDisplay == 1 || this.m_nPieFeelerTextDisplay == 4) && this.m_bSliceLabelVisibility) {
            maxSliceLabelWidthDest -= this.m_pivotLineDest;
            minSliceLabelWidthDest -= this.m_pivotLineDest;
        }
        maxSliceLabelWidthDest -= 5;
        if (this.m_maxLabelWidthDest < (minSliceLabelWidthDest -= 5)) {
            if (al) {
                return this.m_maxLabelWidthDest * 2 + maxRadiusDest * 2 + 26;
            }
            return this.calcVirtRadius(maxRadiusDest, rect);
        }
        if (this.m_nPieFeelerTextDisplay == 2 && this.m_bSliceLabelVisibility) {
            if (this.m_maxLabelWidthDest < maxSliceLabelWidthDest) {
                int newRadius = minRadiusDest + (maxSliceLabelWidthDest - this.m_maxLabelWidthDest);
                if (newRadius > maxRadiusDest) {
                    newRadius = maxRadiusDest;
                }
                if (al) {
                    return this.m_maxLabelWidthDest * 2 + newRadius * 2 + 26;
                }
                return this.calcVirtRadius(newRadius, rect);
            }
            if (al) {
                return this.m_maxLabelWidthDest * 2 + minRadiusDest * 2 + 26;
            }
            return this.calcVirtRadius(minRadiusDest, rect);
        }
        if (al) {
            return -1;
        }
        double maxNumLines = (double)availHeightDest / (double)fontHeight;
        int numLabelsOnLeft = this.m_leftSliceLabels.size();
        int numLabelsOnRight = this.m_rightSliceLabels.size();
        double minNumWrapLinesReqOnLeft = (double)(numLabelsOnLeft * 2) + (double)(numLabelsOnLeft + 1) * 0.33;
        double minNumWrapLinesReqOnRight = (double)(numLabelsOnRight * 2) + (double)(numLabelsOnRight + 1) * 0.33;
        if (minNumWrapLinesReqOnLeft > maxNumLines || minNumWrapLinesReqOnRight > maxNumLines) {
            if (this.m_maxLabelWidthDest < maxSliceLabelWidthDest) {
                int newRadius = minRadiusDest + (maxSliceLabelWidthDest - this.m_maxLabelWidthDest);
                if (newRadius > maxRadiusDest) {
                    newRadius = maxRadiusDest;
                }
                return this.calcVirtRadius(newRadius, rect);
            }
            return this.calcVirtRadius(minRadiusDest, rect);
        }
        Dimension dimLen = this.getLongestStringWidth(fm);
        int widthOfLongestWord = dimLen.width;
        int widthOfLongestString = dimLen.height;
        if (widthOfLongestWord != widthOfLongestString && availWidthDest / widthOfLongestWord > 6) {
            widthOfLongestWord = availWidthDest / 6;
        }
        int n = numLinesPerLabel = (numLinesPerLabelOnLeft = (int)(Math.floor(maxNumLines - (double)(numLabelsOnLeft + 1) * 0.33) / (double)numLabelsOnLeft)) < (numLinesPerLabelOnRight = (int)(Math.floor(maxNumLines - (double)(numLabelsOnRight + 1) * 0.33) / (double)numLabelsOnRight)) ? numLinesPerLabelOnLeft : numLinesPerLabelOnRight;
        if (this.m_maxLabelWidthDest / numLinesPerLabel < widthOfLongestWord && widthOfLongestWord < maxSliceLabelWidthDest) {
            int newRadius = minRadiusDest + (maxSliceLabelWidthDest - widthOfLongestWord);
            if (newRadius > maxRadiusDest) {
                newRadius = maxRadiusDest;
            }
            return this.calcVirtRadius(newRadius, rect);
        }
        return this.calcVirtRadius(minRadiusDest, rect);
    }

    private Dimension getLongestStringWidth(FontMetrics fm) {
        int maxWdLen = 0;
        int maxStrLen = 0;
        for (int i = 0; i < this.m_vectStrLabels.size(); ++i) {
            String label = (String)this.m_vectStrLabels.elementAt(i);
            int strLen = this.m_Perspective.getFontMetricsResolver().stringWidth(label, fm);
            if (strLen > maxStrLen) {
                maxStrLen = strLen;
            }
            if (label == null) continue;
            StringTokenizer tokens = new StringTokenizer(label, " ");
            while (tokens.hasMoreTokens()) {
                String word = tokens.nextToken();
                int wdLen = this.m_Perspective.getFontMetricsResolver().stringWidth(word, fm);
                if (wdLen <= maxWdLen) continue;
                maxWdLen = wdLen;
            }
        }
        return new Dimension(maxWdLen, maxStrLen);
    }

    private int calcVirtRadius(int radiusDest, Rectangle rect) {
        if (rect.width < rect.height) {
            return this.m_VC.destToVirtWidth(radiusDest);
        }
        return this.m_VC.destToVirtHeight(radiusDest);
    }

    private FontMetrics getSliceLabelFontMetrics() {
        if (this.m_sliceLabelFM == null) {
            Graphics graphics = this.m_Perspective.getGraphicsContext();
            Font font = this.m_textStyleFeelers.getFont(this.m_VC);
            this.m_sliceLabelFM = graphics.getFontMetrics(font);
            return this.m_sliceLabelFM;
        }
        return this.m_sliceLabelFM;
    }

    private void calcPivotLineAndGap(int width, int height) {
        int minDiameter;
        int availWidthDest = this.m_VC.virtToDestWidth(width);
        int availHeightDest = this.m_VC.virtToDestHeight(height);
        if (availHeightDest < (minDiameter = availWidthDest / 2)) {
            minDiameter = availHeightDest;
        }
        this.m_pivotLineDest = (int)((double)minDiameter * 0.04);
        if (this.m_pivotLineDest > 5) {
            this.m_pivotLineDest = 5;
        } else if (this.m_pivotLineDest < 2) {
            this.m_pivotLineDest = 2;
        }
        this.m_pivotLineVirt = this.m_VC.destToVirtWidth(this.m_pivotLineDest);
        this.m_feelerTextGapDest = (int)((double)minDiameter * 0.02);
        if (this.m_feelerTextGapDest > 3) {
            this.m_feelerTextGapDest = 3;
        } else if (this.m_feelerTextGapDest < 1) {
            this.m_feelerTextGapDest = 1;
        }
        this.m_feelerTextGapVirt = this.m_VC.destToVirtWidth(this.m_feelerTextGapDest);
    }

    private void getSliceLabels(int g, FontMetrics fm) {
        int[] newArray;
        int labelWidth;
        String slabel;
        double fAngleAvg;
        double fAngleStart;
        double fDist;
        double fSliceEnd;
        double fSlicePct;
        double fValue;
        int s;
        double fOtherPct = 0.0;
        double firstAngle = -1.0;
        int leftInsertPos = 0;
        int rightInsertPos = 0;
        int nSeriesCount = 0;
        boolean bOtherSeries = this.m_Perspective.getOtherSeries();
        boolean sliceDeleted = false;
        this.m_leftSliceLabels = new Vector();
        this.m_rightSliceLabels = new Vector();
        this.m_vectStrLabels = new Vector();
        this.m_stringWidths = new int[40];
        this.m_sliceLabelFontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
        double fOtherPercentage = this.m_Perspective.getOtherPercentage() / 100.0;
        double fCurrAngle = this.getPieRotation();
        this.m_maxLabelWidthDest = 0;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        if (this.m_Perspective.isBIDILocale()) {
            sEnum = this.getResetSeriesEnumerator(false);
        }
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            fValue = this.m_gt.isPieBarType() ? this.getSeriesTotal(s) : this.getDataValue((int)s, (int)g).m_fValue;
            if (!(fValue > 0.0) && (fValue != 0.0 || !this.m_bShowingZeroLabels)) continue;
            fSlicePct = fValue / this.m_fPieTotal;
            if (bOtherSeries && fSlicePct < fOtherPercentage) {
                fOtherPct += fSlicePct;
                continue;
            }
            fSliceEnd = fCurrAngle + fSlicePct;
            if (fCurrAngle == 0.125) {
                fCurrAngle += 1.0E-12;
            }
            if (fCurrAngle == 0.375) {
                fCurrAngle -= 1.0E-12;
            }
            if (fCurrAngle == 0.625) {
                fCurrAngle -= 1.0E-12;
            }
            if (fCurrAngle == 0.875) {
                fCurrAngle -= 1.0E-12;
            }
            fDist = fSliceEnd - fCurrAngle;
            fAngleStart = fCurrAngle - Math.floor(fCurrAngle);
            fAngleAvg = fAngleStart + fDist / 2.0;
            fAngleAvg -= Math.floor(fAngleAvg);
            slabel = this.getLabel(s, g, fValue, fSlicePct);
            if (fValue == 0.0 && this.m_bShowingZeroLabels) {
                slabel = this.getDataValue((int)s, (int)g).m_bOK ? this.m_Perspective.getIntlString("af_dvt_graph.ZERO_TEXT", null) : this.m_Perspective.getIntlString("af_dvt_graph.NULL_TEXT", null);
            }
            this.m_vectStrLabels.addElement(slabel);
            labelWidth = this.m_Perspective.getFontMetricsResolver().stringWidth(slabel, fm);
            if (labelWidth > this.m_maxLabelWidthDest) {
                this.m_maxLabelWidthDest = labelWidth;
            }
            if ((double)slabel.length() > this.m_maxStrLength) {
                this.m_maxStrLength = slabel.length();
            }
            if (this.m_stringWidths.length <= nSeriesCount) {
                newArray = new int[this.m_stringWidths.length * 2];
                System.arraycopy(this.m_stringWidths, 0, newArray, 0, this.m_stringWidths.length);
                this.m_stringWidths = newArray;
            }
            this.m_stringWidths[nSeriesCount] = labelWidth;
            if (fAngleAvg < 0.08 || fAngleAvg > 0.92 || fAngleAvg > 0.42 && fAngleAvg < 0.58) {
                this.m_bLabelsAtTopOrBottom = true;
            }
            if (firstAngle < 0.0) {
                firstAngle = fAngleAvg;
            }
            if (!(sliceDeleted = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(s) || this.m_Perspective.getPieSliceDelete(s, g) : false)) {
                if (fAngleAvg > 0.0 && fAngleAvg <= 0.5) {
                    if (fAngleAvg < firstAngle) {
                        this.m_rightSliceLabels.insertElementAt(slabel, rightInsertPos++);
                    } else {
                        this.m_rightSliceLabels.addElement(slabel);
                    }
                } else if (fAngleAvg < firstAngle && fAngleAvg != 0.0) {
                    this.m_leftSliceLabels.insertElementAt(slabel, leftInsertPos++);
                } else {
                    this.m_leftSliceLabels.addElement(slabel);
                }
            }
            fCurrAngle = fSliceEnd;
            ++nSeriesCount;
        }
        if (fOtherPct > 0.0) {
            s = -1;
            fValue = fOtherPct * this.m_fPieTotal;
            fSlicePct = fOtherPct;
            fSliceEnd = fCurrAngle + fSlicePct;
            if (fCurrAngle == 0.125) {
                fCurrAngle += 1.0E-12;
            }
            if (fCurrAngle == 0.375) {
                fCurrAngle -= 1.0E-12;
            }
            if (fCurrAngle == 0.625) {
                fCurrAngle -= 1.0E-12;
            }
            if (fCurrAngle == 0.875) {
                fCurrAngle -= 1.0E-12;
            }
            fDist = fSliceEnd - fCurrAngle;
            fAngleStart = fCurrAngle - Math.floor(fCurrAngle);
            fAngleAvg = fAngleStart + fDist / 2.0;
            fAngleAvg -= Math.floor(fAngleAvg);
            slabel = this.getLabel(s, g, fValue, fSlicePct);
            this.m_vectStrLabels.addElement(slabel);
            labelWidth = this.m_Perspective.getFontMetricsResolver().stringWidth(slabel, fm);
            if (labelWidth > this.m_maxLabelWidthDest) {
                this.m_maxLabelWidthDest = labelWidth;
            }
            if ((double)slabel.length() > this.m_maxStrLength) {
                this.m_maxStrLength = slabel.length();
            }
            if (this.m_stringWidths.length <= nSeriesCount) {
                newArray = new int[this.m_stringWidths.length * 2];
                System.arraycopy(this.m_stringWidths, 0, newArray, 0, this.m_stringWidths.length);
                this.m_stringWidths = newArray;
            }
            this.m_stringWidths[nSeriesCount] = labelWidth;
            if (fAngleAvg < 0.08 || fAngleAvg > 0.92 || fAngleAvg > 0.42 && fAngleAvg < 0.58) {
                this.m_bLabelsAtTopOrBottom = true;
            }
            if (firstAngle < 0.0) {
                firstAngle = fAngleAvg;
            }
            if (!(sliceDeleted = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(s) || this.m_Perspective.getPieSliceDelete(s, g) : false)) {
                if (fAngleAvg > 0.0 && fAngleAvg <= 0.5) {
                    if (fAngleAvg < firstAngle) {
                        this.m_rightSliceLabels.insertElementAt(slabel, rightInsertPos++);
                    } else {
                        this.m_rightSliceLabels.addElement(slabel);
                    }
                } else if (fAngleAvg < firstAngle) {
                    this.m_leftSliceLabels.insertElementAt(slabel, leftInsertPos++);
                } else {
                    this.m_leftSliceLabels.addElement(slabel);
                }
            }
        }
        this.m_fullSliceLabels = new String[this.m_vectStrLabels.size()];
    }

    private String getLabel(int s, int g, double fValue, double fSlicePct) {
        String str;
        switch (this.m_bPieLabelDisplay) {
            case 0: {
                if (this.m_Perspective.isNumberFormatCallBack()) {
                    this.m_Perspective.getNumberFormatCallBack().setState(1, s, g, -1, -3);
                    str = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                    break;
                }
                str = TDGNumberFormat.toString(this.m_Perspective, this.m_nFeelerTextFormat, fValue, this.m_strFeelerTextFormatPattern);
                break;
            }
            case 1: {
                if (this.m_Perspective.isNumberFormatCallBack()) {
                    this.m_Perspective.getNumberFormatCallBack().setState(1, s, g, -1, -3);
                    str = this.m_Perspective.getNumberFormatCallBack().toString(fSlicePct);
                    break;
                }
                str = TDGNumberFormat.toString(this.m_Perspective, this.m_nFeelerTextFormat, fSlicePct, this.m_strFeelerTextFormatPattern);
                break;
            }
            case 2: {
                if (s == -1) {
                    str = "Other";
                    break;
                }
                str = this.m_Perspective.getSeriesLabel(s);
                break;
            }
            case 3: {
                str = s == -1 ? "Other" : this.m_Perspective.getSeriesLabel(s);
                if (this.m_Perspective.isNumberFormatCallBack()) {
                    this.m_Perspective.getNumberFormatCallBack().setState(1, s, g, -1, -3);
                    str = str + ", " + this.m_Perspective.getNumberFormatCallBack().toString(fSlicePct);
                    break;
                }
                str = str + " (" + TDGNumberFormat.toString(this.m_Perspective, this.m_nFeelerTextFormat, fSlicePct, this.m_strFeelerTextFormatPattern) + ")";
                break;
            }
            case 4: {
                str = s == -1 ? "Other" : this.m_Perspective.getSeriesLabel(s);
                if (this.m_Perspective.isNumberFormatCallBack()) {
                    this.m_Perspective.getNumberFormatCallBack().setState(1, s, g, -1, -3);
                    str = str + ", " + this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                    break;
                }
                str = str + ", " + TDGNumberFormat.toString(this.m_Perspective, this.m_nFeelerTextFormat, fValue, this.m_strFeelerTextFormatPattern);
                break;
            }
            default: {
                str = "!";
            }
        }
        str = this.m_Perspective.getCustomDataText(str, new IdentObj(295, s, g));
        return str;
    }

    private int calcPieLabelHeight() {
        IdentObj id;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        GroupsEnumerator gEnumRev = this.getResetGroupsEnumerator(false);
        int group = 0;
        int g = gEnum.getAbsoluteGroup(group);
        int gReverse = this.m_bReverseGroups ? gEnumRev.getAbsoluteGroup(group) : g;
        Dimension dimTitleVC = new Dimension(0, 0);
        String szPieLabel = null;
        szPieLabel = this.m_gt.isPieBarType() ? (this.m_Perspective.getPieBarLabelDisplay() ? this.m_Perspective.getPieBarLabelString() : "") : this.m_Perspective.getGroupLabel(gReverse);
        if (!(this.m_bGTMultiple || szPieLabel != null && szPieLabel.length() > 0)) {
            return 0;
        }
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(296);
            id.setMiscID(gReverse);
        } else {
            id = new IdentObj(296, -3, gReverse);
        }
        boolean bPieGroupLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
        this.m_pieLabelTextStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bPieGroupLabelFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), this.m_Perspective.getAutofit(id), false, this.m_Perspective.getTextWrap(id), this.m_Perspective.getLocale());
        Graphics graphics = this.m_Perspective.getGraphicsContext();
        Font font = this.m_pieLabelTextStyleObj.getFont(this.m_VC);
        FontMetrics fm = graphics.getFontMetrics(font);
        dimTitleVC.height = this.m_VC.destToVirtHeight(TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver()) + 5);
        return dimTitleVC.height;
    }

    @Override
    public void createFrame() {
        this.m_Frame = new PieFrameObj(this.m_Perspective);
    }

    private void calcFeelerLabels(int group) {
        FontMetrics fm;
        if (this.m_bGTMultiple) {
            fm = this.getSliceLabelFontMetrics();
            this.getSliceLabels(group, fm);
        }
        fm = this.getSliceLabelFontMetrics();
        int fontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
        this.m_labelDimVC = new Dimension(this.m_VC.destToVirtWidth(this.m_maxLabelWidthDest), this.m_VC.destToVirtHeight(fontHeight));
    }

    private void createFeelerTextStyle() {
        IdentObj idFeeler = this.m_Perspective.getPieSliceLabel();
        this.m_textStyleFeelers = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(idFeeler), this.m_Perspective.getFontStyle(idFeeler), this.m_Perspective.getFontSizeAbsolute(idFeeler), this.m_Perspective.getFontSize(idFeeler), this.m_Perspective.getFontSizeVC(idFeeler), 0, 0, this.m_Perspective.getTextJustVert(idFeeler), false, false, this.m_Perspective.getTextWrap(idFeeler), this.m_Perspective.getLocale());
    }

    @Override
    protected void copyParams() {
        super.copyParams();
        this.m_bGTHasRing = this.m_gt.toString().equals("PIE_RING") || this.m_gt.toString().equals("PIE_RINGMULT") || this.m_gt.toString().equals("PIE_RINGMULTPROP") || this.m_gt.toString().equals("PIE_BAR_RING");
        this.m_bGTProportional = this.m_gt.toString().equals("PIE_MULTPROP") || this.m_gt.toString().equals("PIE_RINGMULTPROP");
        boolean bl = this.m_bGTMultiple = this.m_bGTProportional || this.m_gt.toString().equals("PIE_MULT") || this.m_gt.toString().equals("PIE_RINGMULT");
        if (!this.m_bSmallDataSet && !this.m_bGTMultiple) {
            this.m_bSmallDataSet = this.m_nSeries < 899;
        }
        this.m_nKissingFeelers = 1;
        this.m_fThickness = (double)this.m_Perspective.getPieDepth() / 100.0;
        this.m_bShowPieTotal = this.m_Perspective.getPieRingTotalDisplay();
        this.m_nPiesPerRow = this.m_Perspective.getPiesPerRow();
        this.m_fPieTilt = (double)this.m_Perspective.getPieTilt() / 100.0;
        this.m_nPieFeelerTextDisplay = this.m_Perspective.getPieFeelerTextDisplay();
        this.m_bSliceLabelVisibility = this.m_Perspective.getDisplay(this.m_Perspective.getPieSliceLabel());
        this.m_bPieLabelDisplay = this.m_Perspective.getPieLabelDisplay();
        this.m_bReverseGroups = this.m_Perspective.getReverseGroups();
        this.m_nFeelerTextFormat = this.m_Perspective.getPieFeelerTextFormat();
        this.m_strFeelerTextFormatPattern = this.m_Perspective.getPieFeelerTextFormatPattern();
        this.m_fRingPct = this.m_bGTHasRing ? (double)this.m_Perspective.getPieRingSize() / 100.0 : 0.0;
        this.m_nLineWidthFeeler = this.m_Perspective.getLineWidth(this.m_Perspective.getPieFeelerLine());
        this.m_nLineStyleFeeler = this.m_Perspective.getLineStyle(this.m_Perspective.getPieFeelerLine());
        this.m_rOPI_PieFrame = this.m_Perspective.getRect(new IdentObj(302));
        this.m_nPieBarSlice = this.m_Perspective.getPieBarSeries();
        PfjAssert.pfjAssert(this.m_nPieBarSlice >= 0);
        if (this.m_nPieBarSlice >= this.m_nTotalSeries) {
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            this.m_nPieBarSlice = sEnum.getFirstSeries();
            this.m_Perspective.setPieBarSeries(this.m_nPieBarSlice);
        }
    }

    private Shape _createTopShape(PieSliceObj theSlice) {
        if (theSlice.m_nSeriesID == this.m_nPieBarSlice) {
            if (theSlice.m_fPiePct < 1.0) {
                this.m_ptTopSlice = this.m_VC.destToVirt(theSlice.m_outerArc.getEndPoint());
                this.m_ptBottomSlice = this.m_VC.destToVirt(theSlice.m_outerArc.getStartPoint());
            } else {
                this.m_ptTopSlice = this.m_VC.destToVirt(new Point2D.Double(theSlice.m_outerArc.getCenterX(), theSlice.m_outerArc.getMinY()));
                this.m_ptBottomSlice = this.m_VC.destToVirt(new Point2D.Double(theSlice.m_outerArc.getCenterX(), theSlice.m_outerArc.getMaxY()));
            }
        }
        if (this.m_fRingPct <= 0.0) {
            Arc2D pieTop = (Arc2D)theSlice.m_outerArc.clone();
            if (theSlice.m_fPiePct < 1.0) {
                pieTop.setArcType(2);
            }
            return pieTop;
        }
        return JChart_2D_Pie._convertShapeToArea(theSlice.m_outerArc, theSlice.m_ringArc);
    }

    public static Area _convertShapeToArea(Arc2D shape, Arc2D shape2) {
        PathIterator pi2;
        if (shape == null || shape2 == null) {
            return null;
        }
        if (shape.getAngleExtent() >= 360.0 && shape2.getAngleExtent() >= 360.0) {
            Area outer = new Area(shape);
            outer.subtract(new Area(shape2));
            return outer;
        }
        GeneralPath path = new GeneralPath();
        PathIterator pi = shape.getPathIterator(null);
        if (pi != null) {
            path.append(pi, false);
        }
        if ((pi2 = ReversePathIterator.getReversePathIterator(shape2)) != null) {
            path.append(pi2, true);
        }
        return new Area(path);
    }

    private Area _createLeftSide(PieSliceObj theSlice) {
        GeneralPath path = new GeneralPath();
        path.moveTo(theSlice.m_ptCrustLeft.getX(), theSlice.m_ptCrustLeft.getY());
        path.lineTo(theSlice.m_ptRingLeft.getX(), theSlice.m_ptRingLeft.getY());
        path.lineTo(theSlice.m_ptRingLeft.getX(), theSlice.m_ptRingLeft.getY() + (double)this.m_VC.virtToDestHeight(this.m_nThickOffset));
        path.lineTo(theSlice.m_ptCrustLeft.getX(), theSlice.m_ptCrustLeft.getY() + (double)this.m_VC.virtToDestHeight(this.m_nThickOffset));
        path.lineTo(theSlice.m_ptCrustLeft.getX(), theSlice.m_ptCrustLeft.getY());
        return new Area(path);
    }

    private Area _createRightSide(PieSliceObj theSlice) {
        GeneralPath path = new GeneralPath();
        path.moveTo(theSlice.m_ptRingRight.getX(), theSlice.m_ptRingRight.getY());
        path.lineTo(theSlice.m_ptCrustRight.getX(), theSlice.m_ptCrustRight.getY());
        path.lineTo(theSlice.m_ptCrustRight.getX(), theSlice.m_ptCrustRight.getY() + (double)this.m_VC.virtToDestHeight(this.m_nThickOffset));
        path.lineTo(theSlice.m_ptRingRight.getX(), theSlice.m_ptRingRight.getY() + (double)this.m_VC.virtToDestHeight(this.m_nThickOffset));
        path.lineTo(theSlice.m_ptRingRight.getX(), theSlice.m_ptRingRight.getY());
        return new Area(path);
    }

    private Area _createRingArea(PieSliceObj theSlice) {
        return JChart_2D_Pie._convertShapeToArea(theSlice.m_ringArc, theSlice.m_ringArc3D);
    }

    private Point[] calcArcPointsForTestPolygon() {
        Point[] points = new Point[100];
        double fPos = 0.0;
        double fXSquashRatio = 1.0;
        double fTilt = this.m_fPieTilt;
        Rectangle destRect = this.m_VC.getDestCoords();
        double fYSquashRatio = (double)Math.abs(destRect.width) / (double)destRect.height;
        if (fYSquashRatio > 1.0) {
            fXSquashRatio = 1.0 / fYSquashRatio;
            fYSquashRatio = 1.0;
        }
        fYSquashRatio -= fYSquashRatio * fTilt;
        double f12OClock = -1.5707963267948966;
        for (int i = 0; i < 100; ++i) {
            double fAngle = f12OClock + fPos * (Math.PI * 2);
            int nPosX = this.m_nXCenter + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * (double)this.m_nRadius);
            int nPosY = this.m_nYCenter - (int)(Math.sin(fAngle) * fYSquashRatio * (double)this.m_nRadius);
            if (this.m_nThickOffset > 0 && fPos > 0.25 && fPos < 0.75) {
                nPosY -= this.m_nThickOffset;
            }
            points[i] = new Point(nPosX, nPosY);
            fPos += 0.01;
        }
        return points;
    }

    private PieSliceObj createSliceObj(int nCenterX, int nCenterY, int nRadius, double fStart, double fEnd, int nDetatch, double fAngleDet, double fTilt, double fRing, VC vc) {
        double fAngle;
        PieSliceObj theSlice = new PieSliceObj();
        double fXSquashRatio = 1.0;
        Rectangle destRect = vc.getDestCoords();
        double fYSquashRatio = (double)Math.abs(destRect.width) / (double)destRect.height;
        if (fYSquashRatio > 1.0) {
            fXSquashRatio = 1.0 / fYSquashRatio;
            fYSquashRatio = 1.0;
        }
        fYSquashRatio -= fYSquashRatio * fTilt;
        theSlice.m_xRadius = vc.virtToDestWidth((double)nRadius * fXSquashRatio);
        theSlice.m_yRadius = vc.virtToDestHeight((double)nRadius * fYSquashRatio);
        if (fStart == 0.125) {
            fStart += 1.0E-12;
        }
        if (fStart == 0.375) {
            fStart -= 1.0E-12;
        }
        if (fStart == 0.625) {
            fStart -= 1.0E-12;
        }
        if (fStart == 0.875) {
            fStart -= 1.0E-12;
        }
        int nTipX = nCenterX;
        int nTipY = nCenterY;
        double fDist = fEnd - fStart;
        double f12OClock = -1.5707963267948966;
        theSlice.m_bSliceSplit = false;
        theSlice.m_fAngleStart = fStart - Math.floor(fStart);
        theSlice.m_fAngleEnd = fEnd - Math.floor(fEnd);
        theSlice.m_fAngleAvg = fStart + fDist / 2.0;
        theSlice.m_fAngleAvg -= Math.floor(theSlice.m_fAngleAvg);
        this.calcSlicePositionAndOrient(theSlice);
        theSlice.m_nDetatch = nDetatch;
        if (nDetatch > 0) {
            fAngle = fAngleDet == -7.0 ? f12OClock + (fStart + fDist / 2.0) * (Math.PI * 2) : fAngleDet;
            theSlice.m_fAngleDet = fAngle;
            nTipX = nCenterX + (int)(Math.cos(fAngle) * fXSquashRatio * (double)nDetatch);
            nTipY = nCenterY - (int)(Math.sin(fAngle) * fYSquashRatio * (double)nDetatch);
        }
        theSlice.m_ptTip = new Point(nTipX, nTipY);
        fAngle = f12OClock + theSlice.m_fAngleAvg * (Math.PI * 2);
        this.calcFeelerPoints(theSlice, nTipX, nTipY, nRadius, fAngle, fRing, fXSquashRatio, fYSquashRatio);
        this.calcLeftAndRightMostPoints(nCenterX, nCenterY, nRadius, f12OClock, nDetatch, fXSquashRatio, fYSquashRatio);
        this.calcArcPoints(theSlice);
        return theSlice;
    }

    private double _calcAngleStart(PieSliceObj theSlice) {
        double startAngle = 360.0 - theSlice.m_fAngleEnd * 360.0 + 90.0;
        if (startAngle > 360.0) {
            startAngle -= 360.0;
        }
        return startAngle;
    }

    private double _calcAngleExtent(PieSliceObj theSlice) {
        if (theSlice.m_fAngleEnd == 0.0) {
            double d = 360.0 - theSlice.m_fAngleStart * 360.0;
        }
        double diff = theSlice.m_fAngleStart == theSlice.m_fAngleEnd ? 360.0 - theSlice.m_fAngleStart * 360.0 + theSlice.m_fAngleEnd * 360.0 : (theSlice.m_fAngleEnd > theSlice.m_fAngleStart ? theSlice.m_fAngleEnd * 360.0 - theSlice.m_fAngleStart * 360.0 : 360.0 - theSlice.m_fAngleStart * 360.0 + theSlice.m_fAngleEnd * 360.0);
        return diff;
    }

    private void calcArcPoints(PieSliceObj theSlice) {
        Point2D ptTipDest = this.m_VC.virtToDest(theSlice.m_ptTip);
        double startAngle = this._calcAngleStart(theSlice);
        double diff = this._calcAngleExtent(theSlice);
        double cornerX = ptTipDest.getX() - theSlice.m_xRadius;
        double cornerY = ptTipDest.getY() - theSlice.m_yRadius;
        double width = theSlice.m_xRadius * 2.0;
        double height = theSlice.m_yRadius * 2.0;
        theSlice.m_outerArc = new Arc2D.Double(cornerX, cornerY, width, height, startAngle, diff, 0);
        theSlice.m_outerArc3D = new Arc2D.Double(cornerX, cornerY + (double)this.m_VC.virtToDestHeight(this.m_nThickOffset), width, height, startAngle, diff, 0);
        theSlice.m_ptCrustLeft = theSlice.m_outerArc.getEndPoint();
        theSlice.m_ptCrustRight = theSlice.m_outerArc.getStartPoint();
        if (this.m_fRingPct > 0.0) {
            double ringCornerX = ptTipDest.getX() - theSlice.m_xRadius * this.m_fRingPct;
            double ringCornerY = ptTipDest.getY() - theSlice.m_yRadius * this.m_fRingPct;
            double ringWidth = theSlice.m_xRadius * this.m_fRingPct * 2.0;
            double ringHeight = theSlice.m_yRadius * this.m_fRingPct * 2.0;
            theSlice.m_ringArc = new Arc2D.Double(ringCornerX, ringCornerY, ringWidth, ringHeight, startAngle, diff, 0);
            theSlice.m_ringArc3D = new Arc2D.Double(ringCornerX, ringCornerY + (double)this.m_VC.virtToDestHeight(this.m_nThickOffset), ringWidth, ringHeight, startAngle, diff, 0);
            theSlice.m_ptRingLeft = theSlice.m_ringArc.getEndPoint();
            theSlice.m_ptRingRight = theSlice.m_ringArc.getStartPoint();
        } else {
            theSlice.m_ptRingLeft = ptTipDest;
            theSlice.m_ptRingRight = ptTipDest;
        }
    }

    private void calcFeelerPoints(PieSliceObj theSlice, int nTipX, int nTipY, double fRadius, double fAngle, double fRing, double fXSquashRatio, double fYSquashRatio) {
        double fAttach;
        int nPosX = nTipX + (int)(Math.cos(fAngle) * fXSquashRatio * fRadius);
        int nPosY = nTipY - (int)(Math.sin(fAngle) * fYSquashRatio * fRadius);
        theSlice.m_ptCenter = new Point(nPosX, nPosY);
        if (this.m_nKissingFeelers == 1) {
            nPosX = nTipX + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * fRadius);
            nPosY = nTipY - (int)(Math.sin(fAngle) * fYSquashRatio * fRadius);
            theSlice.m_ptCenter = new Point(nPosX, nPosY);
        } else {
            fAttach = fRadius * (fRing + (1.0 - fRing) / 1.5);
            nPosX = nTipX + (int)(Math.cos(fAngle) * fXSquashRatio * fAttach);
            nPosY = nTipY - (int)(Math.sin(fAngle) * fYSquashRatio * fAttach);
            theSlice.m_ptCenter = new Point(nPosX, nPosY);
        }
        double fBloom = 0.25 - Math.abs(0.5 - theSlice.m_fAngleAvg);
        if (fBloom < 0.0) {
            fBloom = 0.0;
        }
        fBloom *= 4.0;
        double fExtend = 0.125;
        if (theSlice.m_fAngleAvg > 0.125 && theSlice.m_fAngleAvg < 0.375) {
            fExtend *= Math.abs(0.25 - theSlice.m_fAngleAvg) / 0.125;
        } else if (theSlice.m_fAngleAvg > 0.625 && theSlice.m_fAngleAvg < 0.875) {
            fExtend *= Math.abs(0.75 - theSlice.m_fAngleAvg) / 0.125;
        }
        fAttach = fRadius + fRadius * (fExtend + fBloom * (0.3 * this.m_fThickness + 0.5 * this.m_fPieTilt));
        nPosX = nTipX + (int)(Math.cos(fAngle) * fXSquashRatio * fAttach);
        nPosY = nTipY - (int)(Math.sin(fAngle) * fYSquashRatio * fAttach);
        theSlice.m_ptFeelerJoint = new Point(nPosX, nPosY);
    }

    private void calcLeftAndRightMostPoints(int nCenterX, int nCenterY, double fRadius, double f12OClock, int nDetatch, double fXSquashRatio, double fYSquashRatio) {
        int leftMostPointOfPie;
        double fAngle;
        int nTipX;
        int rightMostPointOfPie;
        if (nDetatch > 0) {
            this.m_DetachPresent = true;
        }
        if ((rightMostPointOfPie = (nTipX = nCenterX + (int)(Math.cos(fAngle = f12OClock + 1.5707963267948966) * fXSquashRatio * (double)nDetatch)) + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * fRadius)) > this.m_rightMostPointOfPie) {
            this.m_rightMostPointOfPie = rightMostPointOfPie;
        }
        if ((leftMostPointOfPie = (nTipX = nCenterX + (int)(Math.cos(fAngle = f12OClock + 4.71238898038469) * fXSquashRatio * (double)nDetatch)) + (int)Math.rint(Math.cos(fAngle) * fXSquashRatio * fRadius)) < this.m_leftMostPointOfPie) {
            this.m_leftMostPointOfPie = leftMostPointOfPie;
        }
    }

    private void calcSlicePositionAndOrient(PieSliceObj theSlice) {
        theSlice.m_nSliceSide = theSlice.m_fAngleAvg > 0.0 && theSlice.m_fAngleAvg <= 0.5 ? 1 : 0;
    }

    private double drawPie(int nPieGroupRel) {
        this.m_leftMostPointOfPie = 50000;
        this.m_rightMostPointOfPie = -50000;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        GroupsEnumerator gEnumRev = this.getResetGroupsEnumerator(false);
        int g = gEnum.getAbsoluteGroup(nPieGroupRel);
        this.m_nThickOffset = (int)(this.m_fThickness * (double)(this.m_rPieFrame.height / 10));
        this.m_nXCenter = this.m_rPieFrame.x + this.m_rPieFrame.width / 2;
        this.m_nYCenter = this.m_rPieFrame.y + (this.m_rPieFrame.height + this.m_nPieLabelHeight + this.m_nThickOffset) / 2;
        if (this.m_gt.isPieBarType() && this.isPieBarSliceOK()) {
            this.m_nXCenter = this.m_rPieFrame.x + (this.m_rPieFrame.width - this.m_nBarThickCoord - this.m_Perspective.getVC().destToVirtWidth(this.m_Perspective.updateMargin(3, false))) / 2;
            if (this.m_Perspective.isBIDILocale()) {
                this.m_rPieFrame.x += 3 * this.m_Perspective.getVC().destToVirtWidth(this.m_Perspective.updateMargin(3, false));
                this.m_nXCenter = this.m_rPieFrame.x + this.m_nBarThickCoord + (this.m_rPieFrame.width - this.m_Perspective.getVC().destToVirtWidth(this.m_Perspective.updateMargin(3, false))) / 2;
            }
        }
        this.m_sliceLabelLeftEdge = (int)this.m_rPieFrame.getMinX();
        this.m_sliceLabelRightEdge = (int)this.m_rPieFrame.getMaxX();
        this.m_slices = new ArrayList<PieSliceObj>();
        if (this.m_gt.isPieBarType()) {
            this.m_fHighestGroupTotal = this.m_fPieTotal = this.getSumTotal();
        } else {
            this.m_fPieTotal = this.getGroupTotal(g);
        }
        if (this.m_fPieTotal <= 0.0) {
            this.drawNoPositiveData(this.m_rPieFrame);
        } else {
            if (this.m_bGTProportional && this.m_fHighestGroupTotal > 0.0) {
                double fPct = this.m_fPieTotal / this.m_fHighestGroupTotal;
                this.m_nRadius = (int)((double)this.m_nSaveRadius * fPct);
            }
            int radius = 0;
            Rectangle r = this.m_VC.getDestCoords();
            radius = r.width < r.height ? this.m_VC.virtToDestWidth(this.m_nRadius) : this.m_VC.virtToDestHeight(this.m_nRadius);
            int side = radius * 2;
            int x = this.m_VC.virtToDestX(this.m_nXCenter) - radius;
            int y = this.m_VC.virtToDestY(this.m_nYCenter) - radius;
            this.m_boundingRects.add(new Rectangle(x, y, side, side));
            if (this.isRenderingClientPie()) {
                double fXSquashRatio = 1.0;
                Rectangle destRect = this.m_VC.getDestCoords();
                double fYSquashRatio = (double)Math.abs(destRect.width) / (double)destRect.height;
                if (fYSquashRatio > 1.0) {
                    fXSquashRatio = 1.0 / fYSquashRatio;
                    fYSquashRatio = 1.0;
                }
                fYSquashRatio -= fYSquashRatio * this.m_fPieTilt;
                double destXRadius = this.m_VC.virtToDestWidth((double)this.m_nRadius * fXSquashRatio);
                double destYRadius = this.m_VC.virtToDestHeight((double)this.m_nRadius * fYSquashRatio);
                double destX = (double)this.m_VC.virtToDestX(this.m_nXCenter) - destXRadius;
                double destY = (double)this.m_VC.virtToDestY(this.m_nYCenter) - destYRadius;
                Rectangle2D.Double pieBounds = new Rectangle2D.Double(destX, destY, 2.0 * destXRadius, 2.0 * destYRadius);
                double depth = this.m_VC.virtToDestHeight(this.m_nThickOffset);
                double rotate = (90.0 - this.getPieRotation() * 360.0 + 360.0) % 360.0;
                DetMetadata.newPieMetadata(this.m_Detectiv, pieBounds, depth, rotate);
            }
            int gradientSide = (int)((double)side * 1.34);
            int gradientX = this.m_VC.virtToDestX(this.m_nXCenter) - gradientSide / 2;
            int gradientY = this.m_VC.virtToDestY(this.m_nYCenter) - gradientSide / 2;
            this.createSliceObjects(g);
            if (this.m_bSliceLabelVisibility) {
                this.calcFeelerLabels(g);
            }
            if (this.m_Perspective.getPieDepth() == 0 && this.m_Perspective.getVisualEffects() != 0 && !this.m_Perspective.m_bExportingToSVG && !this.m_Perspective.m_bExportingToXML) {
                boolean bExploded = false;
                for (PieSliceObj slice : this.m_slices) {
                    if (slice.m_nDetatch <= 0) continue;
                    bExploded = true;
                    break;
                }
                if (!bExploded) {
                    IdentObj id = new IdentObj(337);
                    int glowRectSide = (int)((double)side * Math.sqrt(2.0));
                    x = (int)((double)this.m_VC.virtToDestX(this.m_nXCenter) - (double)glowRectSide * 0.492);
                    y = (int)((double)this.m_VC.virtToDestY(this.m_nYCenter) - (double)glowRectSide * 0.492);
                    if (!this.m_bGTHasRing) {
                        this.m_Perspective.setGradientPinPosition(id, 0.0, 1);
                        this.m_Perspective.setGradientPinPosition(id, 0.47, 2);
                        this.m_Perspective.setGradientPinPosition(id, 0.5, 3);
                    } else {
                        this.m_Perspective.setGradientPinPosition(id, 0.12, 0);
                        this.m_Perspective.setGradientPinPosition(id, 0.15, 1);
                        this.m_Perspective.setGradientPinPosition(id, 0.47, 2);
                        this.m_Perspective.setGradientPinPosition(id, 0.5, 3);
                    }
                    BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, id);
                    new DetRect(this.m_Perspective.getDetectiv(), id, this.m_VC.destToVirtX(x), this.m_VC.destToVirtY(y + glowRectSide), this.m_VC.destToVirtWidth(glowRectSide), this.m_VC.destToVirtHeight(glowRectSide), bb, false, false);
                }
            }
            if (this.isRenderingClientPie()) {
                for (PieSliceObj slice : this.m_slices) {
                    this.drawSliceTop(slice);
                }
            } else {
                if (this.m_nThickOffset > 0) {
                    this.drawSlices();
                }
                this.drawAllSliceTops();
            }
            if (this.m_Perspective.getVisualEffects() != 0 && this.m_Perspective.m_bExportingToXML && this.m_Perspective.getPieDepth() == 0) {
                int i;
                Color[] color;
                IdentObj id = new IdentObj(339);
                if (!this.m_bGTHasRing) {
                    this.m_Perspective.setGradientNumPins(id, 5);
                    this.m_Perspective.setGradientPinPosition(id, 0.0, 0);
                    this.m_Perspective.setGradientPinPosition(id, 0.25, 1);
                    this.m_Perspective.setGradientPinPosition(id, 0.35, 2);
                    this.m_Perspective.setGradientPinPosition(id, 0.5, 3);
                    this.m_Perspective.setGradientPinPosition(id, 1.0, 4);
                    color = new Color[]{new Color(255, 255, 255, 60), new Color(255, 255, 255, 50), new Color(255, 255, 255, 40), new Color(255, 255, 255, 30), new Color(50, 50, 50, 0)};
                    for (i = 0; i < 5; ++i) {
                        this.m_Perspective.setGradientPinRightColor(id, color[i], i);
                        this.m_Perspective.setGradientPinLeftColor(id, color[i], i);
                    }
                } else {
                    this.m_Perspective.setGradientNumPins(id, 5);
                    this.m_Perspective.setGradientPinPosition(id, 0.25, 0);
                    this.m_Perspective.setGradientPinPosition(id, 0.55, 1);
                    this.m_Perspective.setGradientPinPosition(id, 0.65, 2);
                    this.m_Perspective.setGradientPinPosition(id, 0.75, 3);
                    this.m_Perspective.setGradientPinPosition(id, 1.0, 4);
                    color = new Color[]{new Color(0, 0, 0, 0), new Color(255, 255, 255, 30), new Color(255, 255, 255, 40), new Color(255, 255, 255, 30), new Color(0, 0, 0, 0)};
                    for (i = 0; i < 5; ++i) {
                        this.m_Perspective.setGradientPinRightColor(id, color[i], i);
                        this.m_Perspective.setGradientPinLeftColor(id, color[i], i);
                    }
                }
                BlackBoxObj gb = new BlackBoxObj(this.m_Perspective, id);
                Ellipse2D.Double outer = new Ellipse2D.Double(gradientX, gradientY, gradientSide, gradientSide);
                Ellipse2D.Double inner = new Ellipse2D.Double(x, y, side, side);
                Area gradientArea = new Area(outer);
                gradientArea.intersect(new Area(inner));
                new DetArea(this.m_Perspective.getDetectiv(), id, gradientArea, gb, 1.0, false);
            }
            this.drawAllSliceLabels();
            int gReverse = this.m_bReverseGroups ? gEnumRev.getAbsoluteGroup(nPieGroupRel) : g;
            if (this.m_bShowPieTotal && this.m_bGTHasRing) {
                this.drawRingLabel(gReverse);
            }
            if (this.m_Perspective.getDisplay(296)) {
                this.drawPieGroupLabel(gReverse);
            }
        }
        return this.m_fPieTotal;
    }

    private void createSliceObjects(int g) {
        PieSliceObj slice;
        double fSliceEnd;
        double fSlicePct;
        double fDetach;
        double fValue;
        int s;
        int nDetach = 0;
        double fOtherPct = 0.0;
        double fRatioPieFrameToGraphFrame = 1.0;
        if (this.m_bGTMultiple) {
            double height;
            double width = this.m_Perspective.getVC().virtToDestWidth(this.m_rPieFrame.getWidth());
            fRatioPieFrameToGraphFrame = width < (height = this.m_Perspective.getVC().virtToDestHeight(this.m_rPieFrame.getHeight())) ? this.m_rPieFrame.getWidth() / 32000.0 : this.m_rPieFrame.getHeight() / 32000.0;
        }
        boolean bOtherSeries = this.m_Perspective.getOtherSeries();
        double fOtherPercentage = this.m_Perspective.getOtherPercentage() / 100.0;
        double fCurrAngle = this.getPieRotation();
        this.m_nSliceCount = 0;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        if (this.m_Perspective.isBIDILocale()) {
            sEnum = this.getResetSeriesEnumerator(false);
        }
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            fValue = this.m_gt.isPieBarType() ? this.getSeriesTotal(s) : this.getDataValue((int)s, (int)g).m_fValue;
            if (fValue > 0.0 || fValue == 0.0 && this.m_bShowingZeroLabels) {
                fDetach = this.m_bSmallDataSet ? (double)this.m_Perspective.getPieSliceDetach(s, g) / 100.0 : 0.0;
                nDetach = !this.m_bGTMultiple ? (int)(fDetach * 1500.0) : (int)(fDetach * 2000.0 * fRatioPieFrameToGraphFrame);
                fSlicePct = fValue / this.m_fPieTotal;
                if (bOtherSeries && fSlicePct < fOtherPercentage) {
                    fOtherPct += fSlicePct;
                    this.setSeriesPartOfOther(s, g, true);
                    continue;
                }
                fSliceEnd = fCurrAngle + fSlicePct;
                if (fSliceEnd == fCurrAngle && fSlicePct < 0.01 && !this.m_bShowingZeroLabels) continue;
                slice = this.createSliceObj(this.m_nXCenter, this.m_nYCenter, this.m_nRadius, fCurrAngle, fSliceEnd, nDetach, -7.0, this.m_fPieTilt, this.m_fRingPct, this.m_VC);
                slice.m_nSeriesID = s;
                slice.m_nSliceIdx = this.m_nSliceCount;
                slice.m_nGroupID = g;
                slice.m_fPiePct = fSlicePct;
                slice.m_fSliceValue = fValue;
                if (nDetach > 0 && this.m_nSliceCount > 0) {
                    this.m_slices.get((int)(this.m_nSliceCount - 1)).m_nDetatchAdj = 1;
                }
                if (this.m_nSliceCount > 0 && this.m_slices.get((int)(this.m_nSliceCount - 1)).m_nDetatch > 0) {
                    slice.m_nDetatchAdj = 1;
                }
                slice.m_bSliceDeleted = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(s) || this.m_Perspective.getPieSliceDelete(s, g) : false;
                fCurrAngle = fSliceEnd;
                this.m_slices.add(slice);
                ++this.m_nSliceCount;
                if (!bOtherSeries) continue;
                this.setSeriesDrawn(s, g, true);
                continue;
            }
            if (fValue == 0.0) {
                if (!bOtherSeries) continue;
                this.setSeriesDrawn(s, g, false);
                continue;
            }
            if (!bOtherSeries) continue;
            this.setSeriesDrawn(s, g, false);
        }
        if (fOtherPct > 0.0) {
            s = -1;
            fValue = fOtherPct * this.m_fPieTotal;
            fDetach = this.m_bSmallDataSet ? (double)this.m_Perspective.getPieSliceDetach(s, g) / 100.0 : 0.0;
            nDetach = !this.m_bGTMultiple ? (int)(fDetach * 1500.0) : (int)(fDetach * 2000.0 * fRatioPieFrameToGraphFrame);
            fSlicePct = fOtherPct;
            fSliceEnd = fCurrAngle + fSlicePct;
            slice = this.createSliceObj(this.m_nXCenter, this.m_nYCenter, this.m_nRadius, fCurrAngle, fSliceEnd, nDetach, -7.0, this.m_fPieTilt, this.m_fRingPct, this.m_VC);
            slice.m_nSeriesID = s;
            slice.m_nSliceIdx = this.m_nSliceCount;
            slice.m_nGroupID = g;
            slice.m_fPiePct = fSlicePct;
            slice.m_fSliceValue = fValue;
            slice.m_bSliceDeleted = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(s) || this.m_Perspective.getPieSliceDelete(s, g) : false;
            fCurrAngle = fSliceEnd;
            this.m_slices.add(slice);
            ++this.m_nSliceCount;
        }
        if (this.m_nSliceCount > 1) {
            if (this.m_slices.get((int)(this.m_nSliceCount - 1)).m_nDetatch > 0) {
                this.m_slices.get((int)0).m_nDetatchAdj = 1;
            }
            if (this.m_slices.get((int)0).m_nDetatch > 0) {
                this.m_slices.get((int)(this.m_nSliceCount - 1)).m_nDetatchAdj = 1;
            }
        }
    }

    private void drawAllSliceTops() {
        if (this.m_Perspective.m_bExportingToXML && this.m_Perspective.getPieDepth() > 0) {
            IdentObj id = new IdentObj(340);
            int numPins = 3;
            this.m_Perspective.setFillType(id, 2);
            this.m_Perspective.setGradientDirection(id, 1);
            this.m_Perspective.setGradientNumPins(id, numPins);
            this.m_Perspective.setGradientPinPosition(id, 0.0, 0);
            this.m_Perspective.setGradientPinPosition(id, 0.4, 1);
            this.m_Perspective.setGradientPinPosition(id, 1.0, 1);
            Color[] color = new Color[numPins];
            color[0] = new Color(255, 255, 255, 160);
            color[1] = new Color(0, 0, 0, 120);
            color[2] = new Color(0, 0, 0, 80);
            for (int i = 0; i < numPins; ++i) {
                this.m_Perspective.setGradientPinRightColor(id, color[i], i);
                this.m_Perspective.setGradientPinLeftColor(id, color[i], i);
            }
            this.m_borderGradientBB = new BlackBoxObj(this.m_Perspective, id);
            if (this.m_borderGradientBB.getFillObj() instanceof FillGradientObj) {
                this.m_borderGradientBB.setBorderGradientObj((FillGradientObj)this.m_borderGradientBB.getFillObj());
                this.m_borderGradientBB.setTransparentFillColor(true);
            }
        }
        for (PieSliceObj slice : this.m_slices) {
            if (slice.m_bSliceDeleted || slice.m_bSliceSplit) continue;
            this.drawSliceTop(slice);
        }
    }

    private void drawSlices() {
        ArrayList<PieSliceObj> sliceList = new ArrayList<PieSliceObj>(this.m_nSliceCount + 2);
        for (PieSliceObj slice : this.m_slices) {
            if (slice.m_bSliceDeleted) continue;
            if (slice.containsAngle(0.0) && (slice.containsAngle(0.25) || slice.containsAngle(0.75))) {
                double fCurr = slice.m_fAngleStart;
                double fNext = 1.0;
                PieSliceObj newSlice = this.createSliceObj(this.m_nXCenter, this.m_nYCenter, this.m_nRadius, fCurr, fNext, slice.m_nDetatch, slice.m_fAngleDet, this.m_fPieTilt, this.m_fRingPct, this.m_VC);
                newSlice.m_nSliceIdx = this.m_nSliceCount;
                newSlice.m_nSeriesID = slice.m_nSeriesID;
                newSlice.m_nGroupID = slice.m_nGroupID;
                newSlice.m_fPiePct = fNext - fCurr;
                newSlice.m_fSliceValue = slice.m_fSliceValue;
                newSlice.m_bSliceDeleted = slice.m_bSliceDeleted;
                newSlice.m_nDetatchAdj = slice.m_nDetatchAdj;
                newSlice.m_bSliceSplit = true;
                sliceList.add(newSlice);
                fCurr = 1.0;
                fNext = slice.m_fAngleEnd + 1.0;
                newSlice = this.createSliceObj(this.m_nXCenter, this.m_nYCenter, this.m_nRadius, fCurr, fNext, slice.m_nDetatch, slice.m_fAngleDet, this.m_fPieTilt, this.m_fRingPct, this.m_VC);
                newSlice.m_nSliceIdx = this.m_nSliceCount;
                newSlice.m_nSeriesID = slice.m_nSeriesID;
                newSlice.m_nGroupID = slice.m_nGroupID;
                newSlice.m_fPiePct = fNext - fCurr;
                newSlice.m_fSliceValue = slice.m_fSliceValue;
                newSlice.m_bSliceDeleted = slice.m_bSliceDeleted;
                newSlice.m_nDetatchAdj = slice.m_nDetatchAdj;
                newSlice.m_bSliceSplit = true;
                sliceList.add(newSlice);
                continue;
            }
            sliceList.add(slice);
        }
        for (int i = 0; i < sliceList.size() - 1; ++i) {
            for (int j = i + 1; j < sliceList.size(); ++j) {
                double iStartAngle = ((PieSliceObj)sliceList.get((int)i)).m_fAngleStart;
                double iEndAngle = ((PieSliceObj)sliceList.get((int)i)).m_fAngleEnd;
                double jStartAngle = ((PieSliceObj)sliceList.get((int)j)).m_fAngleStart;
                double jEndAngle = ((PieSliceObj)sliceList.get((int)j)).m_fAngleEnd;
                double iExtent = iStartAngle < iEndAngle ? iEndAngle - iStartAngle : iEndAngle + 1.0 - iStartAngle;
                double jExtent = jStartAngle < jEndAngle ? jEndAngle - jStartAngle : jEndAngle + 1.0 - jStartAngle;
                iStartAngle = iStartAngle >= 0.5 || iEndAngle == 0.0 && iStartAngle < 0.5 ? 1.0 - iStartAngle : iStartAngle;
                double d = jStartAngle = jStartAngle >= 0.5 || jEndAngle == 0.0 && jStartAngle < 0.5 ? 1.0 - jStartAngle : jStartAngle;
                if (iEndAngle >= 0.5 && iEndAngle - iExtent >= 0.5) {
                    iEndAngle = 1.0 - iEndAngle;
                }
                if (jEndAngle >= 0.5 && jEndAngle - jExtent >= 0.5) {
                    jEndAngle = 1.0 - jEndAngle;
                }
                double iDist = Math.max(iStartAngle, iEndAngle);
                double jDist = Math.max(jStartAngle, jEndAngle);
                if (!(jDist <= iDist)) continue;
                PieSliceObj tempObj = (PieSliceObj)sliceList.get(i);
                sliceList.set(i, (PieSliceObj)sliceList.get(j));
                sliceList.set(j, tempObj);
            }
        }
        for (PieSliceObj slice : sliceList) {
            if (slice.m_bSliceDeleted) continue;
            Point2D pt = this.m_VC.virtToDest(slice.m_ptTip);
            double cornerX = pt.getX() - slice.m_xRadius;
            double cornerY = pt.getY() - slice.m_yRadius;
            double width = slice.m_xRadius * 2.0;
            double height = slice.m_yRadius * 2.0;
            this.m_arc2DBounds = new Rectangle2D.Double(cornerX, cornerY, width, height);
            if ((slice.m_fAngleStart >= 0.75 || slice.m_fAngleStart <= 0.25) && (slice.m_fAngleEnd >= 0.75 || slice.m_fAngleEnd <= 0.25) && (slice.m_fAngleAvg <= 0.25 || slice.m_fAngleAvg >= 0.75)) {
                this.drawSliceCrust(slice);
                if (this.m_bSmallDataSet) {
                    if (slice.m_nSliceSide == 1) {
                        this.drawSliceLeftEdge(slice);
                        this.drawSliceRightEdge(slice);
                    } else {
                        this.drawSliceRightEdge(slice);
                        this.drawSliceLeftEdge(slice);
                    }
                }
                this.drawSliceRing(slice);
                continue;
            }
            if (slice.m_fAngleStart >= 0.25 && slice.m_fAngleStart <= 0.75 && slice.m_fAngleEnd >= 0.25 && slice.m_fAngleEnd <= 0.75 && slice.m_fAngleAvg >= 0.25 && slice.m_fAngleAvg <= 0.75) {
                this.drawSliceRing(slice);
                if (this.m_bSmallDataSet) {
                    if (slice.m_nSliceSide == 1) {
                        this.drawSliceLeftEdge(slice);
                        this.drawSliceRightEdge(slice);
                    } else {
                        this.drawSliceRightEdge(slice);
                        this.drawSliceLeftEdge(slice);
                    }
                }
                this.drawSliceCrust(slice);
                continue;
            }
            if (slice.m_fAngleStart <= slice.m_fAngleEnd) {
                if (slice.m_fAngleStart <= 0.25) {
                    if (slice.m_fAngleEnd <= 0.5) {
                        this.drawSliceLeftEdge(slice);
                        this.drawSliceRing(slice);
                        this.drawSliceCrust(slice);
                        this.drawSliceRightEdge(slice);
                        continue;
                    }
                    this.drawSliceLeftEdge(slice);
                    this.drawSliceRightEdge(slice);
                    this.drawSliceRing(slice);
                    this.drawSliceCrust(slice);
                    continue;
                }
                this.drawSliceRightEdge(slice);
                this.drawSliceRing(slice);
                this.drawSliceLeftEdge(slice);
                this.drawSliceCrust(slice);
                continue;
            }
            if (slice.m_fAngleEnd <= 0.25) {
                this.drawSliceRightEdge(slice);
                this.drawSliceRing(slice);
                this.drawSliceLeftEdge(slice);
                this.drawSliceCrust(slice);
                continue;
            }
            if (slice.m_fAngleEnd <= 0.5) {
                this.drawSliceRightEdge(slice);
                this.drawSliceRing(slice);
                this.drawSliceCrust(slice);
                this.drawSliceLeftEdge(slice);
                continue;
            }
            this.drawSliceLeftEdge(slice);
            this.drawSliceRing(slice);
            this.drawSliceRightEdge(slice);
            this.drawSliceCrust(slice);
        }
    }

    private void drawPieGroupLabel(int nPieGroup) {
        IdentObj id;
        String szPieLabel;
        if (this.m_gt.isPieBarType()) {
            szPieLabel = this.m_Perspective.getPieBarLabelDisplay() ? this.m_Perspective.getPieBarLabelString() : "";
        } else {
            szPieLabel = this.m_Perspective.getPieBarLabelString();
            if (szPieLabel == null || "".equals(szPieLabel)) {
                szPieLabel = this.m_Perspective.getGroupLabel(nPieGroup);
            }
        }
        if (szPieLabel == null || szPieLabel.length() <= 0) {
            return;
        }
        int nLowestY = this.m_rPieFrame.y;
        int nLabelSize = (int)((double)this.m_rPieFrame.width / 1.2);
        Rectangle rGroupLabel = new Rectangle(this.m_nXCenter - nLabelSize / 2, nLowestY, nLabelSize, this.m_nPieLabelHeight);
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(296);
            id.setMiscID(nPieGroup);
        } else {
            id = new IdentObj(296, -3, nPieGroup);
        }
        Graphics graphics = this.m_Perspective.getGraphicsContext();
        Font font = this.m_pieLabelTextStyleObj.getFont(this.m_VC);
        FontMetrics fm = graphics.getFontMetrics(font);
        int pieLabelWidth = this.m_VC.destToVirtWidth(this.m_Perspective.getFontMetricsResolver().stringWidth(szPieLabel, fm));
        ArrayList stringList = new ArrayList();
        if (pieLabelWidth > nLabelSize) {
            this.m_pieLabelTextStyleObj.setTextTruncated(true);
            this.m_pieLabelTextStyleObj.setTextTruncate(true, 1, 0);
            this.m_pieLabelTextStyleObj.setWordWrap(true);
            this.m_pieLabelTextStyleObj.extractLinesWordWrap(szPieLabel, stringList, nLabelSize, fm, this.m_Perspective.getFontMetricsResolver());
            this.m_Perspective.setTitleTruncated(true, 296);
            this.m_Perspective.setTextString(id, szPieLabel);
        }
        String truncatedLabel = szPieLabel;
        String fullText = null;
        if (stringList.size() > 0) {
            truncatedLabel = (String)stringList.get(0);
            fullText = szPieLabel;
        }
        BlackBoxObj blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        if (this.m_Perspective.getDrillCallback().isDrillingEnabled()) {
            int underline = this.m_Perspective.getFontStyle(id) & 4;
            this.m_pieLabelTextStyleObj.setFontStyle(this.m_pieLabelTextStyleObj.getFontStyle() & 0xFFFFFFFB | underline);
        }
        new DetLabel(this.m_Detectiv, id, truncatedLabel, fullText, rGroupLabel, this.m_pieLabelTextStyleObj, blackBoxLabel, false);
    }

    private void drawRingLabel(int nPieGroup) {
        String str;
        double fDataTextValue;
        String szFormatPattern = this.m_Perspective.getPieRingTotalFormatPattern();
        int nFormat = this.m_Perspective.getPieRingTotalFormat();
        double fLabelSize = (double)this.m_nRadius * 1.5;
        int nLabelSize = (int)fLabelSize;
        Dimension labelDim = new Dimension(nLabelSize, nLabelSize);
        double d = fDataTextValue = TDGNumberFormat.isPercentFormat(nFormat) ? 1.0 : this.m_fPieTotal;
        if (this.m_Perspective.isNumberFormatCallBack()) {
            this.m_Perspective.getNumberFormatCallBack().setState(2, -3, -3, -1, -3);
            str = this.m_Perspective.getNumberFormatCallBack().toString(fDataTextValue);
        } else {
            str = TDGNumberFormat.toString(this.m_Perspective, nFormat, fDataTextValue, szFormatPattern);
        }
        IdentObj id = this.m_Perspective.getPieRingLabel();
        BlackBoxObj blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        boolean bPieRingLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bPieRingLabelFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), 0, 0, false, false, this.m_Perspective.getTextWrap(id), this.m_Perspective.getLocale());
        Graphics gx = this.m_Perspective.getGraphicsContext();
        Vector<String> vStrRingLabels = new Vector<String>();
        vStrRingLabels.addElement(str);
        int nFontSizeVC = bPieRingLabelFontSizeAbsolute ? this.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
        textStyleObj.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(id), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, vStrRingLabels, labelDim, this.m_VC);
        Rectangle rRingLabel = new Rectangle(this.m_nXCenter - labelDim.width / 2, this.m_nYCenter - labelDim.height / 2, labelDim.width, labelDim.height);
        id = new IdentObj(id.getObjectID(), -3, nPieGroup);
        new DetLabel(this.m_Detectiv, id, str, rRingLabel, textStyleObj, blackBoxLabel, false);
    }

    private void drawAllSliceLabels() {
        if ((this.m_nPieFeelerTextDisplay == 1 || this.m_nPieFeelerTextDisplay == 4) && this.m_bSliceLabelVisibility) {
            ArrayList<PieSliceObj> pieSliceObjAllLeftV = new ArrayList<PieSliceObj>();
            ArrayList<PieSliceObj> pieSliceObjAllRightV = new ArrayList<PieSliceObj>();
            Object atZero = null;
            int sliceID = 0;
            String labelText = null;
            block0: for (PieSliceObj slice : this.m_slices) {
                int i;
                PieSliceObj prevSlice;
                if (slice.m_bSliceDeleted || slice.m_bSliceSplit) continue;
                labelText = this.m_vectStrLabels.get(slice.m_nSliceIdx).toString();
                ++sliceID;
                if (slice.m_nSliceSide == 0) {
                    if (pieSliceObjAllLeftV.size() > 0) {
                        prevSlice = (PieSliceObj)pieSliceObjAllLeftV.get(pieSliceObjAllLeftV.size() - 1);
                        if (prevSlice.m_fAngleAvg > slice.m_fAngleAvg) {
                            pieSliceObjAllLeftV.add(slice);
                            continue;
                        }
                        for (i = 0; i < pieSliceObjAllLeftV.size(); ++i) {
                            prevSlice = (PieSliceObj)pieSliceObjAllLeftV.get(i);
                            if (!(prevSlice.m_fAngleAvg < slice.m_fAngleAvg)) continue;
                            pieSliceObjAllLeftV.add(i, slice);
                            continue block0;
                        }
                        continue;
                    }
                    pieSliceObjAllLeftV.add(slice);
                    continue;
                }
                if (pieSliceObjAllRightV.size() > 0) {
                    prevSlice = (PieSliceObj)pieSliceObjAllRightV.get(pieSliceObjAllRightV.size() - 1);
                    if (prevSlice.m_fAngleAvg < slice.m_fAngleAvg) {
                        pieSliceObjAllRightV.add(slice);
                        continue;
                    }
                    for (i = 0; i < pieSliceObjAllRightV.size(); ++i) {
                        prevSlice = (PieSliceObj)pieSliceObjAllRightV.get(i);
                        if (!(prevSlice.m_fAngleAvg > slice.m_fAngleAvg)) continue;
                        pieSliceObjAllRightV.add(i, slice);
                        continue block0;
                    }
                    continue;
                }
                pieSliceObjAllRightV.add(slice);
            }
            if (atZero != null) {
                pieSliceObjAllLeftV.add(0, (PieSliceObj)atZero);
            }
            PieSliceObj[] pieSliceObjAllLeft = null;
            PieSliceObj[] pieSliceObjAllRight = null;
            if (pieSliceObjAllLeftV.size() > 0) {
                pieSliceObjAllLeft = new PieSliceObj[pieSliceObjAllLeftV.size()];
                for (int i = 0; i < pieSliceObjAllLeft.length; ++i) {
                    pieSliceObjAllLeft[i] = (PieSliceObj)pieSliceObjAllLeftV.get(i);
                }
            }
            if (pieSliceObjAllRightV.size() > 0) {
                pieSliceObjAllRight = new PieSliceObj[pieSliceObjAllRightV.size()];
                for (int i = 0; i < pieSliceObjAllRight.length; ++i) {
                    pieSliceObjAllRight[i] = (PieSliceObj)pieSliceObjAllRightV.get(i);
                }
            }
            this.calcCircularSliceLabelRects(pieSliceObjAllLeft, pieSliceObjAllRight);
        }
        if (!this.isRenderingClientPie()) {
            for (PieSliceObj slice : this.m_slices) {
                if (slice.m_bSliceDeleted || slice.m_bSliceSplit || !this.m_bSliceLabelVisibility) continue;
                this.drawSliceLabel(slice);
            }
        }
    }

    private void calcCircularSliceLabelRects(PieSliceObj[] pieSliceObjAllLeft, PieSliceObj[] pieSliceObjAllRight) {
        double occupancy;
        boolean wrapping;
        int wrappingLines;
        int maxLines;
        int labelWidth;
        PieSliceObj theSlice;
        int i;
        double newWidth;
        double newX;
        double newHeight;
        double newY;
        this.m_pieBoundary = this.getPieBounds();
        FontMetrics fm = this.getSliceLabelFontMetrics();
        this.m_fontHeightDest = fm.getHeight();
        this.m_fontHeightVC = this.m_VC.destToVirtHeight(this.m_fontHeightDest);
        this.m_widthOfM = this.m_VC.destToVirtWidth(this.m_Perspective.getFontMetricsResolver().stringWidth("M", fm));
        this.m_rPieSliceLabelFrame = new Rectangle();
        if (this.m_nPieLabelHeight > 0) {
            newY = this.m_rPieFrame.getMinY() + (double)this.m_nPieLabelHeight + (double)this.m_sliceLabelGap;
            newHeight = this.m_rPieFrame.getHeight() - (double)this.m_nPieLabelHeight - (double)this.m_sliceLabelGap;
        } else if (this.m_bGTMultiple && this.m_numberOfPies.height > 1) {
            newY = this.m_rPieFrame.getMinY() + (double)this.m_sliceLabelGap;
            newHeight = this.m_rPieFrame.getHeight() - (double)this.m_sliceLabelGap;
        } else {
            newY = this.m_rPieFrame.getMinY();
            newHeight = this.m_rPieFrame.getHeight();
        }
        if (this.m_bGTMultiple && this.m_numberOfPies.width > 1) {
            newX = this.m_rPieFrame.getX() + this.m_widthOfM / 2.0;
            newWidth = this.m_rPieFrame.getWidth() - this.m_widthOfM;
        } else {
            newX = this.m_rPieFrame.getX();
            newWidth = this.m_rPieFrame.getWidth();
        }
        if (this.m_gt.isPieBarType()) {
            newWidth -= (double)(this.m_nBarThickCoord + this.m_Perspective.getVC().destToVirtWidth(this.m_Perspective.updateMargin(3, false)));
        }
        this.m_rPieSliceLabelFrame.setRect(newX, newY, newWidth, newHeight);
        if (pieSliceObjAllLeft != null) {
            for (i = 0; i < pieSliceObjAllLeft.length; ++i) {
                theSlice = pieSliceObjAllLeft[i];
                if (!((double)theSlice.m_nDetatch > this.m_pieMostDetatchDouble)) continue;
                this.m_pieMostDetatchDouble = theSlice.m_nDetatch;
            }
        }
        if (pieSliceObjAllRight != null) {
            for (i = 0; i < pieSliceObjAllRight.length; ++i) {
                theSlice = pieSliceObjAllRight[i];
                if (!((double)theSlice.m_nDetatch > this.m_pieMostDetatchDouble)) continue;
                this.m_pieMostDetatchDouble = theSlice.m_nDetatch;
            }
        }
        double pieLabelMarginTempXVC = ((double)this.m_VC.destToVirtWidth(4) + this.m_fontHeightVC / 2.0 + this.m_pieMostDetatchDouble * 0.7 + (double)this.m_nRadius * 0.05) * this.m_fXSquashRatio;
        double pieLabelMarginTempYVC = ((double)this.m_VC.destToVirtHeight(4) + this.m_fontHeightVC / 2.0 + this.m_pieMostDetatchDouble * 0.7 + (double)this.m_nRadius * 0.05) * this.m_fYSquashRatio;
        this.m_pieLabelMargin = new Dimension((int)pieLabelMarginTempXVC, (int)pieLabelMarginTempYVC);
        this.m_pieNewBoundary = new Rectangle2D.Double(this.m_pieBoundary.getX() - this.m_pieLabelMargin.getWidth(), this.m_pieBoundary.getY() - this.m_pieLabelMargin.getHeight(), this.m_pieBoundary.getWidth() + this.m_pieLabelMargin.getWidth() * 2.0, this.m_pieBoundary.getHeight() + this.m_pieLabelMargin.getHeight() * 2.0);
        this.m_pieNewBoundary = new Rectangle2D.Double(this.m_pieBoundary.getX() - this.m_pieLabelMargin.getWidth(), this.m_pieBoundary.getY() - this.m_pieLabelMargin.getHeight(), this.m_pieBoundary.getWidth() + this.m_pieLabelMargin.getWidth() * 2.0, this.m_pieBoundary.getHeight() + this.m_pieLabelMargin.getHeight() * 2.0);
        if (pieSliceObjAllLeft != null) {
            labelWidth = this.m_leftMostPointOfPie - this.m_pivotLineVirt - this.m_feelerTextGapVirt - this.m_sliceLabelLeftEdge;
            maxLines = this.numberOfLineWrappingAvailable(pieSliceObjAllLeft);
            wrappingLines = this.checkWrappingNeeded(pieSliceObjAllLeft, labelWidth, maxLines);
            wrapping = wrappingLines > 1;
            occupancy = this.findLabelOccupancyColumn(pieSliceObjAllLeft);
            if (occupancy > 0.0 && occupancy < 0.9) {
                this.calcCircularSliceOptimal(pieSliceObjAllLeft, true);
                if (this.checkForLabelCollision(pieSliceObjAllLeft)) {
                    this.calcCircularSliceCluster(pieSliceObjAllLeft, true);
                    this.checkWrappingNeeded(pieSliceObjAllLeft, -1, wrappingLines);
                    this.classifyTopBottomSlices(pieSliceObjAllLeft, true);
                    if (wrapping && !this.m_bGTMultiple) {
                        this.calcSliceLabelRelocation(true);
                    }
                }
            } else {
                this.calcCircularSlicePacked(pieSliceObjAllLeft, true);
            }
            if (!wrapping) {
                this.calcNoWrappedLabelSimple(pieSliceObjAllLeft);
            }
            this.calcCircularSliceFinal(pieSliceObjAllLeft, true);
        }
        if (pieSliceObjAllRight != null) {
            labelWidth = this.m_sliceLabelRightEdge - this.m_rightMostPointOfPie - this.m_pivotLineVirt - this.m_feelerTextGapVirt;
            maxLines = this.numberOfLineWrappingAvailable(pieSliceObjAllRight);
            wrappingLines = this.checkWrappingNeeded(pieSliceObjAllRight, labelWidth, maxLines);
            wrapping = wrappingLines > 1;
            occupancy = this.findLabelOccupancyColumn(pieSliceObjAllRight);
            if (occupancy > 0.0 && occupancy < 0.9) {
                this.calcCircularSliceOptimal(pieSliceObjAllRight, false);
                if (this.checkForLabelCollision(pieSliceObjAllRight)) {
                    this.calcCircularSliceCluster(pieSliceObjAllRight, false);
                    this.checkWrappingNeeded(pieSliceObjAllRight, -1, wrappingLines);
                    this.classifyTopBottomSlices(pieSliceObjAllRight, false);
                    if (wrapping && !this.m_bGTMultiple) {
                        this.calcSliceLabelRelocation(false);
                    }
                }
            } else {
                this.calcCircularSlicePacked(pieSliceObjAllRight, false);
            }
            if (!wrapping) {
                this.calcNoWrappedLabelSimple(pieSliceObjAllRight);
            }
            this.calcCircularSliceFinal(pieSliceObjAllRight, false);
        }
        this.m_Perspective.setRect(391, this.m_rPieSliceLabelFrame);
    }

    private void calcCircularSliceOptimal(PieSliceObj[] pieSliceObjs, boolean isLeft) {
        FontMetrics fm = this.getSliceLabelFontMetrics();
        int collisionWidth = this.m_VC.destToVirtWidth(this.m_Perspective.getFontMetricsResolver().stringWidth("M", fm)) / 2;
        int collisionHeight = this.m_sliceLabelGap / 2;
        int x = 0;
        int y = 0;
        boolean specialCase = false;
        if (this.m_nThickOffset == 0) {
            specialCase = true;
        }
        double f12OClock = -1.5707963267948966;
        for (int i = 0; i < pieSliceObjs.length; ++i) {
            PieSliceObj theSlice = pieSliceObjs[i];
            int stringWidthVirt = this.m_VC.destToVirtWidth(this.m_stringWidths[theSlice.m_nSliceIdx]);
            int stringHeightVirt = this.m_VC.destToVirtHeight(fm.getHeight());
            theSlice.setLabelTextRawDim(new Dimension(stringWidthVirt, stringHeightVirt));
            Rectangle trial = this.calcIndividualLabelRectangle(theSlice.getLabelText(), theSlice.m_ptCenter.x, theSlice.m_ptCenter.y, 3, isLeft);
            double pieFeelerMarginVC = 0.0;
            Rectangle destRect = this.m_VC.getDestCoords();
            pieFeelerMarginVC = Math.abs(destRect.width) > Math.abs(destRect.height) ? (double)this.m_VC.destToVirtHeight(4) : (double)this.m_VC.destToVirtWidth(4);
            double distanceFromCenterY = 0.0;
            double fontHeightSquashed = this.m_fontHeightVC / this.m_fYSquashRatio;
            double textBoxHeightSquashed = trial.getHeight() / this.m_fYSquashRatio;
            if (this.m_pieBoundary.getHeight() != 0.0) {
                distanceFromCenterY = Math.abs((double)theSlice.m_ptCenter.y - this.m_pieBoundary.getCenterY()) / this.m_pieBoundary.getHeight();
            }
            double newDistance = pieFeelerMarginVC + (double)this.m_nRadius * 0.05 + this.m_pieMostDetatchDouble * 0.7 + fontHeightSquashed / 2.0 + (textBoxHeightSquashed - fontHeightSquashed) * distanceFromCenterY;
            double fAngle = f12OClock + theSlice.m_fAngleAvg * (Math.PI * 2);
            x = (int)this.m_pieNewBoundary.getCenterX() + (int)(Math.cos(fAngle) * this.m_fXSquashRatio * ((double)this.m_nRadius + newDistance));
            y = (int)this.m_pieNewBoundary.getCenterY() - (int)(Math.sin(fAngle) * this.m_fYSquashRatio * ((double)this.m_nRadius + newDistance));
            if (this.checkYOnCrust(y) != 0) {
                y -= this.m_nThickOffset;
            }
            if (isLeft && !specialCase && theSlice.m_fAngleStart < 0.75 && theSlice.m_fAngleEnd > 0.75 && theSlice.m_fAngleAvg < 0.75) {
                specialCase = true;
                if (theSlice.m_fAngleEnd - theSlice.m_fAngleStart < 0.05 && theSlice.m_fAngleEnd - theSlice.m_fAngleStart > 0.01) {
                    x = (int)(-this.m_pieNewBoundary.getWidth() / 2.0 + this.m_pieNewBoundary.getCenterX());
                    y = (int)((double)(-this.m_nThickOffset / 2) + this.m_pieNewBoundary.getCenterY());
                    theSlice.setPartOfPie(1);
                }
            }
            if (!isLeft && !specialCase && theSlice.m_fAngleStart < 0.25 && theSlice.m_fAngleEnd > 0.25 && theSlice.m_fAngleAvg > 0.25) {
                specialCase = true;
                if (theSlice.m_fAngleEnd - theSlice.m_fAngleStart < 0.05 && theSlice.m_fAngleEnd - theSlice.m_fAngleStart > 0.01) {
                    x = (int)(this.m_pieNewBoundary.getWidth() / 2.0 + this.m_pieNewBoundary.getCenterX());
                    y = (int)((double)(-this.m_nThickOffset / 2) + this.m_pieNewBoundary.getCenterY());
                    theSlice.setPartOfPie(1);
                }
            }
            if ((double)y > this.m_rPieSliceLabelFrame.getMaxY() - trial.getHeight() / 2.0) {
                y = (int)this.m_rPieSliceLabelFrame.getMaxY() - (int)trial.getHeight() / 2;
                x = (int)this.getXByYBlock(y, this.m_pieNewBoundary.getHeight(), isLeft);
            } else if ((double)y < this.m_rPieSliceLabelFrame.getMinY() + trial.getHeight() / 2.0) {
                y = (int)this.m_rPieSliceLabelFrame.getMinY() + (int)trial.getHeight() / 2;
                x = (int)this.getXByYBlock(y, this.m_pieNewBoundary.getHeight(), isLeft);
            }
            theSlice.setCalcPoint(new Point(x, y));
            theSlice.setLabelOptimalPoint(new Point(x, y));
            theSlice.setAlgorithm(0);
            trial = this.calcIndividualLabelRectangle(theSlice.getLabelText(), x, y, 3, isLeft);
            theSlice.m_LabelCollisionRect = new Rectangle((int)trial.getMinX() - collisionWidth, (int)trial.getMinY() - collisionHeight, (int)trial.getWidth() + collisionWidth * 2, (int)trial.getHeight() + collisionHeight * 2);
        }
    }

    private void calcCircularSliceCluster(PieSliceObj[] pieSliceObjs, boolean isLeft) {
        for (int i = 0; i < pieSliceObjs.length; ++i) {
            pieSliceObjs[i].setPreviousSlice(null);
            pieSliceObjs[i].m_LabelTextGreatestDim = new Dimension(pieSliceObjs[i].m_LabelTextDim);
        }
        ArrayList<PieSliceObj> newCluster = new ArrayList<PieSliceObj>();
        int colliTail = 0;
        for (int colliHead = 1; colliHead < pieSliceObjs.length; ++colliHead) {
            if (this.checkForLabelCollisionSimple(pieSliceObjs[colliHead - 1], pieSliceObjs[colliHead])) {
                if (newCluster.size() == 0) {
                    colliTail = colliHead - 1;
                    newCluster.add(pieSliceObjs[colliTail]);
                }
                newCluster.add(pieSliceObjs[colliHead]);
                pieSliceObjs[colliHead].setPreviousSlice(pieSliceObjs[colliHead - 1]);
                this.getOptimalYPosition(newCluster);
                while (colliTail > 0 && this.checkForLabelCollisionSimple(pieSliceObjs[colliTail - 1], pieSliceObjs[colliTail])) {
                    pieSliceObjs[colliTail].setPreviousSlice(pieSliceObjs[colliTail - 1]);
                    newCluster.add(0, pieSliceObjs[--colliTail]);
                    while (pieSliceObjs[colliTail].getPreviousSlice() != null) {
                        newCluster.add(0, pieSliceObjs[--colliTail]);
                    }
                    this.getOptimalYPosition(newCluster);
                }
                continue;
            }
            newCluster.clear();
        }
        for (int sliceID = 0; sliceID < pieSliceObjs.length; ++sliceID) {
            PieSliceObj theSlice = pieSliceObjs[sliceID];
            if (theSlice.getAlgorithm() != 1) continue;
            double y = theSlice.getCalcPoint().getY();
            double x = this.getXByYBlock(y, this.m_pieNewBoundary.getHeight(), isLeft);
            theSlice.getCalcPoint().setLocation(x, y);
        }
    }

    private void calcCircularSlicePacked(PieSliceObj[] pieSliceObjs, boolean isLeft) {
        int reqHeight;
        int numberOfRows = this.getNumberOfTotalLines(pieSliceObjs);
        int columnHeight = reqHeight = numberOfRows * (int)this.m_fontHeightVC + (numberOfRows - 1) * this.m_sliceLabelGap;
        if ((double)reqHeight < this.m_pieNewBoundary.getHeight() + (double)this.m_nThickOffset) {
            columnHeight = (int)this.m_pieNewBoundary.getHeight() + this.m_nThickOffset;
        }
        int maximumRows = (columnHeight + this.m_sliceLabelGap) / ((int)this.m_fontHeightVC + this.m_sliceLabelGap);
        Point[] assigningPoint = new Point[maximumRows];
        this.calcLabelPointLocations(assigningPoint, isLeft, columnHeight);
        int j = 0;
        for (int i = 0; i < pieSliceObjs.length; ++i) {
            if (j >= assigningPoint.length) continue;
            pieSliceObjs[i].setCalcPoint(assigningPoint[j]);
            pieSliceObjs[i].setAlgorithm(2);
            j += pieSliceObjs[i].m_LabelNumOfLines;
        }
    }

    private void calcSliceLabelRelocation(boolean isLeft) {
        int yOpt;
        int xOpt;
        int numOfOriginalLine;
        int numOfLine;
        int sliceID;
        ArrayList botSlices;
        ArrayList topSlices;
        PieSliceObj theSlice = null;
        PieSliceObj thePrevSlice = null;
        if (isLeft) {
            topSlices = this.m_topLeftSlices;
            botSlices = this.m_botLeftSlices;
        } else {
            topSlices = this.m_topRightSlices;
            botSlices = this.m_botRightSlices;
        }
        int y = 0;
        int x = 0;
        for (sliceID = 0; sliceID < topSlices.size(); ++sliceID) {
            theSlice = (PieSliceObj)topSlices.get(sliceID);
            y = (int)theSlice.getCalcPoint().getY();
            x = (int)theSlice.getCalcPoint().getX();
            if (theSlice.m_LabelOptimalPoint.getY() > theSlice.m_CalcPoint.getY()) {
                y = (int)theSlice.m_LabelOptimalPoint.getY();
                if (thePrevSlice == null) {
                    if ((double)(y + theSlice.m_LabelTextDim.height) > this.m_rPieSliceLabelFrame.getMaxY()) {
                        y = (int)(this.m_rPieSliceLabelFrame.getMaxY() - (double)theSlice.m_LabelTextDim.height);
                    }
                } else {
                    numOfLine = 1;
                    numOfOriginalLine = 3;
                    while (numOfOriginalLine != numOfLine) {
                        y = (int)theSlice.m_LabelOptimalPoint.getY();
                        numOfOriginalLine = numOfLine;
                        if ((double)(y + theSlice.m_LabelTextDim.height / 2 + this.m_sliceLabelGap) > thePrevSlice.getCalcPoint().getY() - (double)(thePrevSlice.m_LabelTextDim.height / 2)) {
                            y = (int)(thePrevSlice.getCalcPoint().getY() - (double)(thePrevSlice.m_LabelTextDim.height / 2) - (double)(theSlice.m_LabelTextDim.height / 2) - (double)this.m_sliceLabelGap);
                        }
                        x = (int)this.getXByYBlock(y, this.m_pieNewBoundary.getHeight(), isLeft);
                        theSlice.setCalcPoint(new Point(x, y));
                        numOfLine = this.calcIndividualLabelHeight(theSlice, -1, theSlice.m_LabelNumOfLines);
                    }
                }
            } else {
                int yBotLimit = y - theSlice.m_LabelTextGreatestDim.height / 2;
                y = (int)theSlice.m_LabelOptimalPoint.getY();
                if (y - theSlice.m_LabelTextDim.height / 2 < yBotLimit) {
                    y = yBotLimit + theSlice.m_LabelTextDim.height / 2;
                }
            }
            x = (int)this.getXByYBlock(y, this.m_pieNewBoundary.getHeight(), isLeft);
            theSlice.setCalcPoint(new Point(x, y));
            thePrevSlice = theSlice;
        }
        thePrevSlice = null;
        for (sliceID = 0; sliceID < botSlices.size(); ++sliceID) {
            theSlice = (PieSliceObj)botSlices.get(sliceID);
            y = (int)theSlice.getCalcPoint().getY();
            x = (int)theSlice.getCalcPoint().getX();
            if (theSlice.m_LabelOptimalPoint.getY() < theSlice.m_CalcPoint.getY()) {
                y = (int)theSlice.m_LabelOptimalPoint.getY();
                if (thePrevSlice == null) {
                    if ((double)y < this.m_rPieSliceLabelFrame.getMinY()) {
                        y = (int)this.m_rPieSliceLabelFrame.getMinY();
                    }
                } else {
                    numOfLine = 1;
                    numOfOriginalLine = 3;
                    while (numOfOriginalLine != numOfLine) {
                        y = (int)theSlice.m_LabelOptimalPoint.getY();
                        numOfOriginalLine = numOfLine;
                        if ((double)(y - theSlice.m_LabelTextDim.height / 2 - this.m_sliceLabelGap) < thePrevSlice.getCalcPoint().getY() + (double)(thePrevSlice.m_LabelTextDim.height / 2)) {
                            y = (int)(thePrevSlice.getCalcPoint().getY() + (double)(thePrevSlice.m_LabelTextDim.height / 2) + (double)(theSlice.m_LabelTextDim.height / 2) + (double)this.m_sliceLabelGap);
                        }
                        x = (int)this.getXByYBlock(y, this.m_pieNewBoundary.getHeight(), isLeft);
                        theSlice.setCalcPoint(new Point(x, y));
                        numOfLine = this.calcIndividualLabelHeight(theSlice, -1, theSlice.m_LabelNumOfLines);
                    }
                }
            } else {
                int yTopLimit = y + theSlice.m_LabelTextGreatestDim.height / 2;
                y = (int)theSlice.m_LabelOptimalPoint.getY();
                if (y + theSlice.m_LabelTextDim.height / 2 > yTopLimit) {
                    y = yTopLimit - theSlice.m_LabelTextDim.height / 2;
                }
            }
            x = (int)this.getXByYBlock(y, this.m_pieNewBoundary.getHeight(), isLeft);
            theSlice.setCalcPoint(new Point(x, y));
            thePrevSlice = theSlice;
        }
        if (topSlices.size() > 0 && (theSlice = (PieSliceObj)topSlices.get(0)).getCalcPoint().getY() > this.m_pieBoundary.getMaxY()) {
            xOpt = (int)theSlice.getLabelOptimalPoint().getX();
            yOpt = (int)theSlice.getCalcPoint().getY();
            theSlice.setCalcPoint(new Point(xOpt, yOpt));
        }
        if (botSlices.size() > 0 && (theSlice = (PieSliceObj)botSlices.get(0)).getCalcPoint().getY() < this.m_pieBoundary.getMinY()) {
            xOpt = (int)theSlice.getLabelOptimalPoint().getX();
            yOpt = (int)theSlice.getCalcPoint().getY();
            theSlice.setCalcPoint(new Point(xOpt, yOpt));
        }
    }

    private void classifyTopBottomSlices(PieSliceObj[] pieSliceObjs, boolean isLeft) {
        int sliceID;
        PieSliceObj theSlice = null;
        this.m_topLeftSlices.clear();
        this.m_topRightSlices.clear();
        this.m_botLeftSlices.clear();
        this.m_botRightSlices.clear();
        for (sliceID = 0; sliceID < pieSliceObjs.length && (theSlice = pieSliceObjs[sliceID]).getCalcPoint().getY() > (double)this.m_nYCenter; ++sliceID) {
            if (isLeft) {
                this.m_topLeftSlices.add(theSlice);
                continue;
            }
            this.m_topRightSlices.add(theSlice);
        }
        for (sliceID = pieSliceObjs.length - 1; sliceID >= 0 && (theSlice = pieSliceObjs[sliceID]).getCalcPoint().getY() <= (double)this.m_nYCenter; --sliceID) {
            if (isLeft) {
                this.m_botLeftSlices.add(theSlice);
                continue;
            }
            this.m_botRightSlices.add(theSlice);
        }
    }

    private Rectangle calcIndividualLabelRectangle(String label, double x, double y, int maxLines, boolean isLeft) {
        FontMetrics fm = this.getSliceLabelFontMetrics();
        double width = this.m_Perspective.getVC().destToVirtWidth(this.m_Perspective.getFontMetricsResolver().stringWidth(label, fm));
        double left = isLeft ? x - width + this.m_widthOfM / 2.0 : x - this.m_widthOfM / 2.0;
        if (isLeft) {
            if (left + width + this.m_widthOfM / 2.0 > (double)this.m_nXCenter) {
                left = (double)this.m_nXCenter - width - this.m_widthOfM / 2.0;
            }
        } else if (left - this.m_widthOfM / 2.0 < (double)this.m_nXCenter) {
            left = (double)this.m_nXCenter + this.m_widthOfM / 2.0;
        }
        if (left + width > this.m_rPieSliceLabelFrame.getMaxX()) {
            width = this.m_rPieSliceLabelFrame.getMaxX() - left;
        }
        if (left < this.m_rPieSliceLabelFrame.getMinX()) {
            width = left + width - (double)((int)this.m_rPieSliceLabelFrame.getMinX());
            left = this.m_rPieSliceLabelFrame.getMinX();
        }
        int numLinesUsed = 1;
        if (maxLines > 1) {
            this.m_textStyleFeelers.setTextTruncate(true, maxLines, 0);
            this.m_textStyleFeelers.setTextTruncated(false);
            this.m_textStyleFeelers.setWordWrap(true);
            ArrayList strs = new ArrayList();
            numLinesUsed = this.m_textStyleFeelers.extractLinesWordWrap(label, strs, this.m_VC.virtToDestWidth((int)width), fm, this.m_Perspective.getFontMetricsResolver());
        }
        double height = this.m_fontHeightVC * (double)numLinesUsed;
        double top = y - height / 2.0;
        return new Rectangle((int)left, (int)top, (int)width, (int)height);
    }

    private void calcNoWrapLabelWidth(PieSliceObj theSlice) {
        FontMetrics fm = this.getSliceLabelFontMetrics();
        theSlice.m_LabelTextRawDim.width = this.m_Perspective.getVC().destToVirtWidth(this.m_Perspective.getFontMetricsResolver().stringWidth(theSlice.getLabelText(), fm));
        theSlice.setTruncated(theSlice.m_LabelTextDim.width < theSlice.m_LabelTextRawDim.width);
    }

    private int calcWrappedLabelWidth(PieSliceObj theSlice) {
        int maxWidth = 0;
        FontMetrics fm = this.getSliceLabelFontMetrics();
        String label = theSlice.getLabelText();
        int labelWidth = theSlice.getLabelTextDim().width;
        this.m_textStyleFeelers.setTextTruncate(false, theSlice.m_LabelNumOfLines, 0);
        this.m_textStyleFeelers.setTextTruncated(false);
        this.m_textStyleFeelers.setWordWrap(true);
        ArrayList<String> strs = new ArrayList<String>();
        int numLinesUsed = this.m_textStyleFeelers.extractLinesWordWrap(label, strs, this.m_VC.virtToDestWidth(labelWidth), fm, this.m_Perspective.getFontMetricsResolver());
        if (numLinesUsed > 3) {
            String lastLine = "";
            for (int i = 2; i < strs.size(); ++i) {
                lastLine = lastLine + strs.get(i);
                if (i == strs.size() - 1) continue;
                lastLine = lastLine + " ";
            }
            strs.set(2, lastLine);
        }
        for (int i = 0; i < strs.size(); ++i) {
            String text = (String)strs.get(i);
            int widthOfText = this.m_VC.destToVirtWidth(this.m_Perspective.getFontMetricsResolver().stringWidth(text, fm));
            if (widthOfText <= maxWidth) continue;
            maxWidth = widthOfText;
        }
        return maxWidth;
    }

    private void calcCircularSliceFinal(PieSliceObj[] pieSliceObjs, boolean isLeft) {
        PieSliceObj theSlice = null;
        for (int sliceID = 0; sliceID < pieSliceObjs.length; ++sliceID) {
            theSlice = pieSliceObjs[sliceID];
            if (theSlice.getPartOfPie() == 0) {
                theSlice.setPartOfPie(this.checkPartOfSlice(theSlice.m_fAngleAvg));
            }
            Rectangle labelRect = this.calcIndividualLabelRectangle(theSlice.getLabelText(), theSlice.getCalcPoint().getX(), theSlice.getCalcPoint().getY(), theSlice.m_LabelNumOfLines, isLeft);
            theSlice.m_LabelTextDim.width = (int)labelRect.getWidth();
            if (labelRect.getCenterY() > this.m_rPieSliceLabelFrame.getMaxY() || labelRect.getCenterY() < this.m_rPieSliceLabelFrame.getMinY()) {
                theSlice.setVisible(false);
            }
            if (!theSlice.getWrapped()) {
                this.calcNoWrapLabelWidth(theSlice);
            }
            if (theSlice.getTruncated()) {
                theSlice.setTooltipNeeded(true);
                this.m_sliceLabelTruncated = true;
            } else if (theSlice.getWrapped() && labelRect.getWidth() < (double)this.calcWrappedLabelWidth(theSlice)) {
                theSlice.setTooltipNeeded(true);
                this.m_sliceLabelTruncated = true;
            }
            theSlice.m_LabelRect = labelRect;
        }
    }

    private Rectangle2D getPieBounds() {
        double fXSquashRatio = 1.0;
        Rectangle destRect = this.m_VC.getDestCoords();
        double fYSquashRatio = (double)Math.abs(destRect.width) / (double)destRect.height;
        if (fYSquashRatio > 1.0) {
            fXSquashRatio = 1.0 / fYSquashRatio;
            fYSquashRatio = 1.0;
        }
        fYSquashRatio -= fYSquashRatio * this.m_fPieTilt;
        this.m_fYSquashRatio = fYSquashRatio;
        this.m_fXSquashRatio = fXSquashRatio;
        double virtXRadius = (double)this.m_nRadius * fXSquashRatio;
        double virtYRadius = (double)this.m_nRadius * fYSquashRatio;
        double virtX = (double)this.m_nXCenter - virtXRadius;
        double virtY = (double)this.m_nYCenter - virtYRadius;
        Rectangle2D.Double pieBounds = new Rectangle2D.Double(virtX, virtY, 2.0 * virtXRadius, 2.0 * virtYRadius);
        return pieBounds;
    }

    private int checkYOnCrust(int y) {
        if (this.m_nThickOffset > 0) {
            if ((double)y >= this.m_pieNewBoundary.getY() + this.m_pieNewBoundary.getHeight() / 2.0) {
                return 0;
            }
            if ((double)y > this.m_pieNewBoundary.getY() + this.m_pieNewBoundary.getHeight() / 2.0 - (double)this.m_nThickOffset) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    private int checkPartOfSlice(double angle) {
        if (this.m_nThickOffset > 0 && angle > 0.26 && angle < 0.74) {
            return 2;
        }
        return 0;
    }

    private double getXByYBlock(double y, double columnHeight, boolean isLeft) {
        double x = 0.0;
        double ratio = this.m_pieNewBoundary.getWidth() * this.m_pieNewBoundary.getWidth() / columnHeight / columnHeight;
        double yFromCenterSq = 0.0;
        double xRadiusSq = this.m_pieNewBoundary.getWidth() * this.m_pieNewBoundary.getWidth() / 4.0;
        if (this.m_nThickOffset > 0) {
            int checkY = this.checkYOnCrust((int)y);
            if (checkY == 0) {
                yFromCenterSq = (y - this.m_pieBoundary.getCenterY()) * (y - this.m_pieBoundary.getCenterY());
            } else if (checkY == 1) {
                yFromCenterSq = 0.0;
            } else if (checkY == 2) {
                yFromCenterSq = (y + (double)this.m_nThickOffset - this.m_pieBoundary.getCenterY()) * (y + (double)this.m_nThickOffset - this.m_pieBoundary.getCenterY());
            }
        } else {
            yFromCenterSq = (y - this.m_pieBoundary.getCenterY()) * (y - this.m_pieBoundary.getCenterY());
        }
        double distX = Math.max(this.m_widthOfM / 2.0, Math.sqrt(Math.max(0.0, xRadiusSq - yFromCenterSq * ratio)));
        x = isLeft ? Math.max(this.m_pieNewBoundary.getMinX(), this.m_pieBoundary.getCenterX() - distX) : Math.min(this.m_pieNewBoundary.getMaxX(), this.m_pieBoundary.getCenterX() + distX);
        return x;
    }

    private void getOptimalYPosition(List pieSliceObjs) {
        double averageY = 0.0;
        double height = 0.0;
        for (int i = 0; i < pieSliceObjs.size(); ++i) {
            PieSliceObj theSlice = (PieSliceObj)pieSliceObjs.get(i);
            averageY += theSlice.getLabelOptimalPoint().getY();
            height += (double)theSlice.m_LabelTextDim.height;
        }
        height += (double)(this.m_sliceLabelGap * (pieSliceObjs.size() - 1));
        if ((averageY /= (double)pieSliceObjs.size()) + height / 2.0 > this.m_rPieSliceLabelFrame.getMaxY()) {
            averageY = this.m_rPieSliceLabelFrame.getMaxY() - height / 2.0;
        }
        if (averageY - height / 2.0 < this.m_rPieSliceLabelFrame.getMinY()) {
            averageY = this.m_rPieSliceLabelFrame.getMinY() + height / 2.0;
        }
        int y = (int)(averageY + height / 2.0);
        for (int i = 0; i < pieSliceObjs.size(); ++i) {
            PieSliceObj theSlice = (PieSliceObj)pieSliceObjs.get(i);
            theSlice.getCalcPoint().setLocation(theSlice.getCalcPoint().getX(), y - theSlice.m_LabelTextDim.height / 2);
            theSlice.setAlgorithm(1);
            y -= theSlice.m_LabelTextDim.height + this.m_sliceLabelGap;
        }
    }

    private void calcLabelPointLocations(Point[] assigningPoint, boolean isLeft, int columnHeight) {
        double x = 0.0;
        double y = 0.0;
        y = this.m_pieNewBoundary.getCenterY() + (double)(columnHeight / 2) - (double)(this.m_nThickOffset / 2) - this.m_fontHeightVC / 2.0;
        for (int i = 0; i < assigningPoint.length; ++i) {
            assigningPoint[i] = new Point(0, 0);
            x = this.getXByYBlock(y, columnHeight, isLeft);
            assigningPoint[i].setLocation((int)x, (int)y);
            y -= this.m_fontHeightVC + (double)this.m_sliceLabelGap;
        }
    }

    private double findLabelOccupancyColumn(PieSliceObj[] pieSliceObjs) {
        int numberOfRows = this.getNumberOfTotalLines(pieSliceObjs);
        int reqHeight = numberOfRows * ((int)this.m_fontHeightVC + this.m_sliceLabelGap);
        int columnHeight = (int)this.m_pieNewBoundary.getHeight() + this.m_nThickOffset;
        double occupancy = (double)reqHeight / (double)columnHeight;
        return occupancy;
    }

    private boolean checkForLabelCollisionSimple(PieSliceObj pieSliceObjUp, PieSliceObj pieSliceObjDown) {
        if (pieSliceObjUp == null || pieSliceObjDown == null) {
            return false;
        }
        int prevY = (int)pieSliceObjUp.getCalcPoint().getY() - pieSliceObjUp.getLabelTextDim().height / 2;
        int currY = (int)pieSliceObjDown.getCalcPoint().getY() + pieSliceObjDown.getLabelTextDim().height / 2;
        if ((double)(prevY + pieSliceObjUp.getLabelTextDim().height / 2) > this.m_rPieSliceLabelFrame.getMaxY()) {
            return false;
        }
        if ((double)(currY - pieSliceObjUp.getLabelTextDim().height / 2) < this.m_rPieSliceLabelFrame.getMinY()) {
            return false;
        }
        return currY > prevY;
    }

    private boolean checkForLabelCollision(PieSliceObj[] pieSliceObjs) {
        boolean collision = false;
        if (pieSliceObjs.length < 2) {
            return false;
        }
        for (int i = 0; i < pieSliceObjs.length; ++i) {
            Rectangle prev = pieSliceObjs[i].m_LabelCollisionRect;
            for (int j = i + 1; j < pieSliceObjs.length; ++j) {
                Rectangle curr = pieSliceObjs[j].m_LabelCollisionRect;
                if (!prev.intersects(curr)) continue;
                pieSliceObjs[i].m_Collision = true;
                pieSliceObjs[j].m_Collision = true;
                collision = true;
            }
            if (this.m_rPieSliceLabelFrame.contains(prev)) continue;
            collision = true;
        }
        return collision;
    }

    private int getNumberOfTotalLines(PieSliceObj[] pieSliceObjs) {
        int totalLines = 0;
        for (int i = 0; i < pieSliceObjs.length; ++i) {
            totalLines += pieSliceObjs[i].m_LabelNumOfLines;
        }
        return totalLines;
    }

    /*
     * Unable to fully structure code
     */
    private void drawSliceLabel(PieSliceObj theSlice) {
        rLabel = null;
        gx = this.m_Perspective.getGraphicsContext();
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(295, theSlice.m_nSeriesID);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(295, theSlice.m_nSeriesID, theSlice.m_nGroupID);
        }
        rBlackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        rBlackBoxLabel.setTransparentFillColor(true);
        rBlackBoxLabel.setTransparentBorderColor(true);
        idColor = new IdentObj(294);
        savedValue = this.m_nPieFeelerTextDisplay;
        if (this.m_nPieFeelerTextDisplay == 4 && !this.m_no_collision) {
            this.m_nPieFeelerTextDisplay = 1;
        } else if (this.m_nPieFeelerTextDisplay == 4 && this.m_circular) {
            this.m_nPieFeelerTextDisplay = 1;
        } else if (this.m_nPieFeelerTextDisplay == 4 && this.m_no_collision) {
            this.m_nPieFeelerTextDisplay = 2;
        }
        switch (this.m_nPieFeelerTextDisplay) {
            case 0: {
                return;
            }
            case 1: {
                blackBox = new BlackBoxObj(this.m_Perspective, idColor);
                rLabel = theSlice.m_LabelRect;
                if (theSlice.m_nSliceSide == 0) {
                    this.m_textStyleFeelers.setHorizAlign(4);
                } else {
                    this.m_textStyleFeelers.setHorizAlign(2);
                }
                if (theSlice.getTruncated()) {
                    this.truncateLabelAsNeeded(theSlice, rLabel.width, this.getSliceLabelFontMetrics());
                }
                if (this.m_circular) break;
                this.drawFeelers(theSlice, blackBox);
                break;
            }
            case 2: {
                if (theSlice.m_nSliceSide == 0) {
                    rLabel = new Rectangle(this.m_sliceLabelLeftEdge, theSlice.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, theSlice.m_ptFeelerJoint.x - this.m_sliceLabelLeftEdge - this.m_feelerTextGapVirt, this.m_labelDimVC.height);
                    this.m_textStyleFeelers.setHorizAlign(4);
                } else {
                    rLabel = new Rectangle(theSlice.m_ptFeelerJoint.x + this.m_feelerTextGapVirt, theSlice.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, this.m_sliceLabelRightEdge - theSlice.m_ptFeelerJoint.x, this.m_labelDimVC.height);
                    this.m_textStyleFeelers.setHorizAlign(2);
                }
                this.truncateLabelAsNeeded(theSlice, rLabel.width, this.getSliceLabelFontMetrics());
                break;
            }
            default: {
                position = 0.66;
                idFeeler = this.m_Perspective.getPieSliceLabel();
                nFontSizeVC = this.m_Perspective.getFontSizeAbsolute(idFeeler) != false ? this.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(idFeeler)) : this.m_Perspective.getFontSizeVC(idFeeler);
                centerX = 0;
                centerY = 0;
                tipX = 0;
                tipY = 0;
                if (this.m_nSliceCount >= 20) ** GOTO lbl98
                if (theSlice.m_ringArc != null) {
                    extent = theSlice.m_ringArc.getAngleExtent();
                    theSlice.m_ringArc.setAngleExtent(extent / 2.0);
                    midPoint = theSlice.m_ringArc.getEndPoint();
                    theSlice.m_ringArc.setAngleExtent(extent);
                    tipX = (int)this.m_VC.destToVirtX(midPoint.getX());
                    tipY = (int)this.m_VC.destToVirtY(midPoint.getY());
                } else {
                    tipX = (int)this.m_VC.destToVirtX(theSlice.m_ptRingRight.getX());
                    tipY = (int)this.m_VC.destToVirtY(theSlice.m_ptRingRight.getY());
                }
                for (i = 0; i < 2; ++i) {
                    diffX = (int)((double)Math.abs(theSlice.m_ptCenter.x - tipX) * position);
                    diffY = (int)((double)Math.abs(theSlice.m_ptCenter.y - tipY) * position);
                    centerX = theSlice.m_ptCenter.x > tipX ? tipX + diffX : tipX - diffX;
                    centerY = theSlice.m_ptCenter.y > tipY ? tipY + diffY : tipY - diffY;
                    dim = new Dimension(32000, 32000);
                    vector = new Vector<E>();
                    vector.add(this.m_vectStrLabels.elementAt(theSlice.m_nSliceIdx));
                    this.m_textStyleFeelers.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(idFeeler), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, vector, dim, this.m_VC);
                    if (theSlice.m_ringArc != null) {
                        slice = new Area(JChart_2D_Pie._convertShapeToArea(theSlice.m_outerArc, theSlice.m_ringArc));
                    } else {
                        temp = theSlice.m_outerArc.getArcType();
                        theSlice.m_outerArc.setArcType(2);
                        slice = new Area(theSlice.m_outerArc);
                        theSlice.m_outerArc.setArcType(temp);
                    }
                    x = centerX - dim.width / 2;
                    y = centerY - dim.height / 2;
                    labelRect = new Rectangle(x, y, dim.width, dim.height);
                    if (!slice.contains(labelRect)) {
                        if (position == 0.66) {
                            position = 0.5;
                            continue;
                        }
                        if (position != 0.5) continue;
                        position = 0.66;
                        diffX = (int)((double)Math.abs(theSlice.m_ptCenter.x - tipX) * position);
                        diffY = (int)((double)Math.abs(theSlice.m_ptCenter.y - tipY) * position);
                        centerX = theSlice.m_ptCenter.x > tipX ? tipX + diffX : tipX - diffX;
                        centerY = theSlice.m_ptCenter.y > tipY ? tipY + diffY : tipY - diffY;
                        continue;
                    }
                    ** GOTO lbl112
                }
                ** GOTO lbl112
lbl98:
                // 1 sources

                if (theSlice.m_ringArc != null) {
                    extent = theSlice.m_ringArc.getAngleExtent();
                    theSlice.m_ringArc.setAngleExtent(extent / 2.0);
                    midPoint = theSlice.m_ringArc.getEndPoint();
                    theSlice.m_ringArc.setAngleExtent(extent);
                    tipX = (int)this.m_VC.destToVirtX(midPoint.getX());
                    tipY = (int)this.m_VC.destToVirtY(midPoint.getY());
                } else {
                    tipX = (int)this.m_VC.destToVirtX(theSlice.m_ptTip.getX());
                    tipY = (int)this.m_VC.destToVirtY(theSlice.m_ptTip.getY());
                }
                diffX = (int)((double)Math.abs(theSlice.m_ptCenter.x - tipX) * position);
                diffY = (int)((double)Math.abs(theSlice.m_ptCenter.y - tipY) * position);
                centerX = theSlice.m_ptCenter.x > tipX ? tipX + diffX : tipX - diffX;
                centerY = theSlice.m_ptCenter.y > tipY ? tipY + diffY : tipY - diffY;
lbl112:
                // 3 sources

                x = centerX - this.m_labelDimVC.width / 2;
                rLabel = new Rectangle(x, centerY - this.m_labelDimVC.height / 2, this.m_labelDimVC.width, this.m_labelDimVC.height);
            }
        }
        this.m_nPieFeelerTextDisplay = savedValue;
        if (this.m_gt.isPieBarType()) {
            idBackground = new IdentObj(388, theSlice.m_nSeriesID);
            idBackground.setMiscID(theSlice.m_nGroupID);
        } else {
            idBackground = new IdentObj(388, theSlice.m_nSeriesID, theSlice.m_nGroupID);
        }
        blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        if (theSlice.getVisible()) {
            this.m_textStyleFeelers.setWordWrap(theSlice.getWrapped());
            this.m_textStyleFeelers.setTextTruncate(true, theSlice.m_LabelNumOfLines, 0);
            this.m_textStyleFeelers.setTextTruncated(theSlice.getTruncated());
            theSlice.setLabel(new DetLabel(this.m_Detectiv, id, (String)this.m_vectStrLabels.elementAt(theSlice.m_nSliceIdx), this.m_fullSliceLabels[theSlice.m_nSliceIdx], rLabel, this.m_textStyleFeelers, blackBoxLabel, false));
        }
    }

    private double getSlope(double x0, double y0, double x1, double y1) {
        double slope = 0.0;
        if (x0 == x1) {
            x0 += Double.MIN_VALUE;
        }
        slope = (y1 - y0) / (x1 - x0);
        return slope;
    }

    private void drawFeelers(PieSliceObj theSlice, BlackBoxObj blackBox) {
        double y2;
        double x2;
        double y0;
        double x0;
        IdentObj idFeeler;
        if (!theSlice.getVisible()) {
            return;
        }
        Rectangle rLabel = null;
        rLabel = theSlice.m_LabelRect;
        Point[] ptPolyline = new Point[2];
        if (this.m_gt.isPieBarType()) {
            idFeeler = new IdentObj(294, theSlice.m_nSeriesID);
            idFeeler.setMiscID(theSlice.m_nGroupID);
        } else {
            idFeeler = new IdentObj(294, theSlice.m_nSeriesID, theSlice.m_nGroupID);
        }
        if (theSlice.getPartOfPie() == 0) {
            x0 = theSlice.m_ptCenter.x;
            y0 = theSlice.m_ptCenter.y;
        } else if (theSlice.getPartOfPie() == 2) {
            x0 = theSlice.m_ptCenter.x;
            y0 = theSlice.m_ptCenter.y - this.m_nThickOffset;
        } else if (theSlice.m_nSliceSide == 0) {
            x0 = this.m_pieBoundary.getMinX();
            y0 = this.m_pieBoundary.getCenterY() - (double)(this.m_nThickOffset / 2);
        } else {
            x0 = this.m_pieBoundary.getMaxX();
            y0 = this.m_pieBoundary.getCenterY() - (double)(this.m_nThickOffset / 2);
        }
        ptPolyline[0] = new Point((int)x0, (int)y0);
        double x1 = theSlice.m_nSliceSide == 0 ? (double)(rLabel.x + rLabel.width) - this.m_widthOfM / 2.0 : (double)rLabel.x + this.m_widthOfM / 2.0;
        double y1 = rLabel.y + rLabel.height / 2;
        if (x1 - x0 < 0.0) {
            x2 = rLabel.getMaxX();
            y2 = y0 + this.getSlope(x0, x0, x1, x2) * (y1 - y0);
        } else {
            x2 = rLabel.getMinX();
            y2 = y0 + this.getSlope(x0, x0, x1, x2) * (y1 - y0);
        }
        if (y2 < rLabel.getMinY() || y2 > rLabel.getMaxY()) {
            if (y1 - y0 < 0.0) {
                y2 = rLabel.getMaxY();
                x2 = x0 + this.getSlope(y0, y0, y1, y2) * (x1 - x0);
            } else {
                y2 = rLabel.getMinY();
                x2 = x0 + this.getSlope(y0, y0, y1, y2) * (x1 - x0);
            }
        }
        double y3 = y2;
        double x3 = x2;
        if (y3 > this.m_rPieSliceLabelFrame.getMaxY()) {
            y3 = this.m_rPieSliceLabelFrame.getMaxY();
            x3 = x0 + this.getSlope(y0, y0, y2, y3) * (x2 - x0);
        } else if (y3 < this.m_rPieSliceLabelFrame.getMinY()) {
            y3 = this.m_rPieSliceLabelFrame.getMinY();
            x3 = x0 + this.getSlope(y0, y0, y2, y3) * (x2 - x0);
        }
        ptPolyline[1] = new Point((int)x3, (int)y3);
        IdentObj newID = new IdentObj(idFeeler);
        newID.setMiscID(100);
        Vector<Point> polylinePts = new Vector<Point>(2);
        polylinePts.add(ptPolyline[0]);
        polylinePts.add(ptPolyline[1]);
        new DetPolyline(this.m_Detectiv, newID, polylinePts, (BlackBoxIF)blackBox, null, false, false, this.m_nLineWidthFeeler, this.m_nLineStyleFeeler);
    }

    private int calcIndividualLabelHeight(PieSliceObj theSlice, int toWidth, int maxLines) {
        FontMetrics fm = this.getSliceLabelFontMetrics();
        String label = (String)this.m_vectStrLabels.elementAt(theSlice.m_nSliceIdx);
        int stringWidthVirt = this.m_VC.destToVirtWidth(this.m_stringWidths[theSlice.m_nSliceIdx]);
        int stringHeightVirt = this.m_VC.destToVirtHeight(fm.getHeight());
        theSlice.setLabelTextRawDim(new Dimension(stringWidthVirt, stringHeightVirt));
        int numLinesUsed = 1;
        int truncateWidth = toWidth;
        if (toWidth == -1) {
            truncateWidth = theSlice.m_LabelTextDim.width;
        }
        if (maxLines > 1) {
            int numLinesAvail = maxLines;
            this.m_textStyleFeelers.setTextTruncate(true, numLinesAvail, 0);
            this.m_textStyleFeelers.setTextTruncated(false);
            this.m_textStyleFeelers.setWordWrap(true);
            ArrayList strs = new ArrayList();
            numLinesUsed = this.m_textStyleFeelers.extractLinesWordWrap(label, strs, this.m_VC.virtToDestWidth(truncateWidth), fm, this.m_Perspective.getFontMetricsResolver());
        }
        int rectHeight = (int)this.m_fontHeightVC * numLinesUsed;
        theSlice.m_LabelText = label;
        theSlice.m_LabelNumOfLines = numLinesUsed;
        theSlice.setLabelTextDim(new Dimension(truncateWidth, rectHeight));
        return numLinesUsed;
    }

    private int checkWrappingNeeded(PieSliceObj[] pieSliceObjects, int toWidth, int maxLines) {
        int maxNumLinesNeeded = 1;
        for (int i = 0; i < pieSliceObjects.length; ++i) {
            PieSliceObj theSlice = pieSliceObjects[i];
            int numLinesUsed = this.calcIndividualLabelHeight(theSlice, toWidth, maxLines);
            if (numLinesUsed <= maxNumLinesNeeded) continue;
            maxNumLinesNeeded = numLinesUsed;
        }
        return maxNumLinesNeeded;
    }

    private int numberOfLineWrappingAvailable(PieSliceObj[] pieSliceObjects) {
        double numberOfLines = (double)this.m_rPieSliceLabelFrame.height / (this.m_fontHeightVC + (double)this.m_sliceLabelGap) / (double)pieSliceObjects.length;
        int numberOfLinesRounded = Math.max(Math.min(3, (int)Math.floor(numberOfLines)), 1);
        return numberOfLinesRounded;
    }

    private void calcNoWrappedLabelSimple(PieSliceObj[] pieSliceObjects) {
        if (pieSliceObjects == null) {
            return;
        }
        int fontHeightVC = this.m_VC.destToVirtHeight(this.m_sliceLabelFontHeight);
        PieSliceObj theSlice = pieSliceObjects[0];
        for (int i = 0; i < pieSliceObjects.length; ++i) {
            theSlice = pieSliceObjects[i];
            int labelWidth = this.m_VC.destToVirtWidth(this.m_stringWidths[theSlice.m_nSliceIdx]);
            int numLinesUsed = 1;
            int rectHeight = fontHeightVC * numLinesUsed + this.m_feelerTextGapVirt;
            theSlice.m_LabelNumOfLines = numLinesUsed;
            theSlice.setTruncated(true);
            theSlice.setWrapped(false);
            theSlice.setLabelTextDim(new Dimension(labelWidth, rectHeight));
        }
    }

    protected void truncateLabelAsNeeded(PieSliceObj theSlice, int labelWidth, FontMetrics fm) {
        if (this.m_stringWidths[theSlice.m_nSliceIdx] > this.m_VC.virtToDestWidth(labelWidth)) {
            String label;
            this.m_fullSliceLabels[theSlice.m_nSliceIdx] = label = (String)this.m_vectStrLabels.elementAt(theSlice.m_nSliceIdx);
            label = PresUtils.truncateText(label, fm, 0, this.m_VC.virtToDestWidth(labelWidth), this.m_Perspective.getFontMetricsResolver());
            this.m_vectStrLabels.setElementAt(label, theSlice.m_nSliceIdx);
            this.m_sliceLabelTruncated = true;
        }
    }

    private void drawSliceCrust(PieSliceObj theSlice) {
        BlackBoxIF blackBox;
        IdentObj id;
        int nObjectID = this.getSliceObjectID(299);
        int s = theSlice.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, s);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, s, theSlice.m_nGroupID);
        }
        if (this.m_autoGradient && this.m_Perspective.m_bExportingToXML) {
            IdentObj idS = new IdentObj(299, id.getSeriesID());
            idS.setUseSeriesLooping(true);
            blackBox = new BlackBoxObj(this.m_Perspective, idS);
            blackBox = blackBox.runRules(s, theSlice.m_nGroupID);
            FillObj fill = blackBox.getFillObj();
            if (fill instanceof FillGradientObj) {
                Rectangle2D.Double crustBounds = new Rectangle2D.Double(this.m_arc2DBounds.getX(), this.m_arc2DBounds.getY() + (double)this.m_VC.virtToDestHeight(this.m_nThickOffset), this.m_arc2DBounds.getWidth(), this.m_arc2DBounds.getHeight());
                ((FillGradientObj)fill).setBoundingBox(crustBounds);
            }
        } else {
            blackBox = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, theSlice.m_nGroupID), this.m_bWantRiserBorder);
            blackBox = blackBox.runRules(s, theSlice.m_nGroupID);
        }
        double fIntensity = 0.6;
        if ((theSlice.m_fAngleStart >= 0.75 || theSlice.m_fAngleStart <= 0.25) && (theSlice.m_fAngleEnd >= 0.75 || theSlice.m_fAngleEnd <= 0.25) && (theSlice.m_fAngleAvg <= 0.25 || theSlice.m_fAngleAvg >= 0.75)) {
            id.setMiscID(7000 + theSlice.m_nSliceIdx);
            this._createSliceCrust(theSlice, id, blackBox, fIntensity);
        } else if (theSlice.m_fAngleStart >= 0.25 && theSlice.m_fAngleStart <= 0.75 && theSlice.m_fAngleEnd >= 0.25 && theSlice.m_fAngleEnd <= 0.75 && theSlice.m_fAngleAvg >= 0.25 && theSlice.m_fAngleAvg <= 0.75) {
            id.setMiscID(4000 + theSlice.m_nSliceIdx);
            this._createSliceCrust(theSlice, id, blackBox, fIntensity);
        } else {
            int offset = 0;
            if (theSlice.m_bSliceSplit && theSlice.m_fAngleEnd == 0.0) {
                offset = 500;
            }
            double start = theSlice.m_fAngleStart;
            double end = theSlice.m_fAngleEnd;
            if (theSlice.m_fAngleEnd > theSlice.m_fAngleStart && theSlice.m_fAngleStart < 0.25 && theSlice.m_fAngleEnd > 0.25 || theSlice.m_fAngleEnd <= theSlice.m_fAngleStart && theSlice.m_fAngleStart < 0.25 || theSlice.m_fAngleStart >= 0.75) {
                id.setMiscID(7000 + theSlice.m_nSliceIdx + offset);
                theSlice.m_fAngleEnd = 0.25;
                this._createSliceCrust(theSlice, id, blackBox, fIntensity);
                theSlice.m_fAngleStart = 0.25;
                theSlice.m_fAngleEnd = end;
            }
            double tempStart = theSlice.m_fAngleStart;
            if (theSlice.m_fAngleEnd > theSlice.m_fAngleStart && theSlice.m_fAngleStart < 0.75 && theSlice.m_fAngleEnd > 0.75 || theSlice.m_fAngleEnd <= theSlice.m_fAngleStart && (theSlice.m_fAngleEnd > 0.75 || theSlice.m_fAngleEnd <= 0.25)) {
                id.setMiscID(7000 + theSlice.m_nSliceIdx + offset);
                theSlice.m_fAngleStart = 0.75;
                this._createSliceCrust(theSlice, id, blackBox, fIntensity);
                theSlice.m_fAngleStart = tempStart;
                theSlice.m_fAngleEnd = 0.75;
            }
            id = new IdentObj(id);
            id.setMiscID(4000 + theSlice.m_nSliceIdx + offset);
            this._createSliceCrust(theSlice, id, blackBox, fIntensity);
            theSlice.m_fAngleStart = start;
            theSlice.m_fAngleEnd = end;
        }
    }

    private void _createSliceCrust(PieSliceObj theSlice, IdentObj id, BlackBoxIF blackBox, double fIntensity) {
        double start = this._calcAngleStart(theSlice);
        double extent = this._calcAngleExtent(theSlice);
        double tempStart = theSlice.m_outerArc.getAngleStart();
        double tempExtent = theSlice.m_outerArc.getAngleExtent();
        theSlice.m_outerArc.setAngleStart(start);
        theSlice.m_outerArc.setAngleExtent(extent);
        theSlice.m_outerArc3D.setAngleStart(start);
        theSlice.m_outerArc3D.setAngleExtent(extent);
        Area crust = JChart_2D_Pie._convertShapeToArea(theSlice.m_outerArc, theSlice.m_outerArc3D);
        theSlice.m_outerArc.setAngleStart(tempStart);
        theSlice.m_outerArc.setAngleExtent(tempExtent);
        theSlice.m_outerArc3D.setAngleStart(tempStart);
        theSlice.m_outerArc3D.setAngleExtent(tempExtent);
        if (crust != null) {
            new DetArea(this.m_Detectiv, id, crust, blackBox, fIntensity, false);
        }
    }

    private void drawSliceLeftEdge(PieSliceObj theSlice) {
        BlackBoxIF blackBox;
        IdentObj id;
        if (theSlice.m_bSliceSplit && theSlice.m_fAngleStart == 0.0) {
            return;
        }
        double fIntensity = 0.8;
        int nObjectID = this.getSliceObjectID(299);
        int s = theSlice.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, s);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, s, theSlice.m_nGroupID);
        }
        if (this.m_autoGradient && this.m_Perspective.m_bExportingToXML) {
            IdentObj idCrust = new IdentObj(299, id.getSeriesID(), -3, -3, 2000);
            idCrust.setUseSeriesLooping(true);
            blackBox = new BlackBoxObj(this.m_Perspective, idCrust);
            blackBox = blackBox.runRules(s, theSlice.m_nGroupID);
            FillObj fill = blackBox.getFillObj();
            if (fill instanceof FillGradientObj) {
                ((FillGradientObj)fill).setBoundingBox(this.m_arc2DBounds);
            }
        } else {
            blackBox = this.assignSeriesColor(s, theSlice.m_nGroupID);
            blackBox = blackBox.runRules(s, theSlice.m_nGroupID);
        }
        Area leftArea = this._createLeftSide(theSlice);
        id.setMiscID(2000 + theSlice.m_nSliceIdx);
        if (leftArea != null) {
            new DetArea(this.m_Detectiv, id, leftArea, blackBox, fIntensity, false);
        }
    }

    private void drawSliceRightEdge(PieSliceObj theSlice) {
        BlackBoxIF blackBox;
        IdentObj id;
        if (theSlice.m_bSliceSplit && theSlice.m_fAngleEnd == 0.0) {
            return;
        }
        double fIntensity = 0.4;
        int nObjectID = this.getSliceObjectID(299);
        int s = theSlice.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, s);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, s, theSlice.m_nGroupID);
        }
        if (this.m_autoGradient && this.m_Perspective.m_bExportingToXML) {
            IdentObj idCrust = new IdentObj(299, id.getSeriesID(), -3, -3, 2000);
            idCrust.setUseSeriesLooping(true);
            blackBox = new BlackBoxObj(this.m_Perspective, idCrust);
            blackBox = blackBox.runRules(s, theSlice.m_nGroupID);
            FillObj fill = blackBox.getFillObj();
            if (fill instanceof FillGradientObj) {
                ((FillGradientObj)fill).setBoundingBox(this.m_arc2DBounds);
            }
        } else {
            blackBox = this.assignSeriesColor(s, theSlice.m_nGroupID);
            blackBox = blackBox.runRules(s, theSlice.m_nGroupID);
        }
        Area rightArea = this._createRightSide(theSlice);
        id.setMiscID(3000 + theSlice.m_nSliceIdx);
        if (rightArea != null) {
            new DetArea(this.m_Detectiv, id, rightArea, blackBox, fIntensity, false);
        }
    }

    private void drawSliceRing(PieSliceObj theSlice) {
        IdentObj id;
        if (this.m_fRingPct <= 0.0) {
            return;
        }
        double fIntensity = 0.6;
        int nObjectID = this.getSliceObjectID(299);
        int s = theSlice.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, s);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, s, theSlice.m_nGroupID);
        }
        BlackBoxIF blackBox = this.assignSeriesColor(s, theSlice.m_nGroupID);
        blackBox = blackBox.runRules(s, theSlice.m_nGroupID);
        id.setMiscID(5000 + theSlice.m_nSliceIdx);
        Area ring = this._createRingArea(theSlice);
        if (ring != null) {
            new DetArea(this.m_Detectiv, id, ring, blackBox, fIntensity, false);
        }
    }

    private void drawSliceTop(PieSliceObj theSlice) {
        IdentObj id;
        int nObjectID = this.getSliceObjectID(298);
        if (this.m_gt.isPieBarType()) {
            id = new IdentObj(nObjectID, theSlice.m_nSeriesID);
            id.setMiscID(theSlice.m_nGroupID);
        } else {
            id = new IdentObj(nObjectID, theSlice.m_nSeriesID, theSlice.m_nGroupID);
        }
        Shape sliceTop = this._createTopShape(theSlice);
        if (sliceTop != null) {
            Rectangle2D b = sliceTop.getBounds2D();
            this.m_smallMarker = b != null && (b.getHeight() <= 10.0 || b.getWidth() <= 10.0);
        }
        BlackBoxIF blackBox = this.assignSeriesColor(theSlice.m_nSeriesID, theSlice.m_nGroupID);
        if ((blackBox = blackBox.runRules(theSlice.m_nSeriesID, theSlice.m_nGroupID)).getFillObj() instanceof FillGradientObj && blackBox instanceof BlackBoxObj) {
            blackBox = new BlackBoxObj((BlackBoxObj)blackBox);
            FillObj fill = blackBox.getFillObj();
            ((FillGradientObj)fill).setBoundingBox(this.m_arc2DBounds);
        }
        if (this.isRenderingClientPie()) {
            int explode = this.m_VC.virtToDestWidth(theSlice.m_nDetatch);
            String customLabel = null;
            if (this.m_Perspective.getCustomMarkerTextCallback() != null || this.m_bShowingZeroLabels) {
                customLabel = this.m_vectStrLabels.get(theSlice.m_nSliceIdx).toString();
            }
            new DetSlice(this.m_Detectiv, id, blackBox, explode, customLabel);
            return;
        }
        id.setMiscID(1000);
        if (sliceTop instanceof Area) {
            new DetShape(this.m_Detectiv, id, blackBox, (Area)sliceTop);
        } else if (sliceTop instanceof Arc2D) {
            new DetShape(this.m_Detectiv, id, blackBox, (Arc2D)sliceTop);
        }
    }

    public double getGroupTotal(int g) {
        double fPosSum = 0.0;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            DatumObj dobj = this.getDataValue(s, g);
            double fValue = dobj.m_fValue;
            if (fValue > 0.0) {
                fPosSum += fValue;
                this.m_positiveVal = true;
                continue;
            }
            if (fValue == 0.0 && dobj.m_bOK) {
                this.m_zeroVal = true;
                continue;
            }
            if (!(fValue < 0.0)) continue;
            this.m_negativeVal = true;
        }
        return fPosSum;
    }

    public double getSeriesTotal(int s) {
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double fPosSum = 0.0;
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            DatumObj dobj = this.getDataValue(s, g);
            double fValue = dobj.m_fValue;
            if (fValue > 0.0) {
                fPosSum += fValue;
                this.m_positiveVal = true;
                continue;
            }
            if (fValue == 0.0 && dobj.m_bOK) {
                this.m_zeroVal = true;
                continue;
            }
            if (!(fValue < 0.0)) continue;
            this.m_negativeVal = true;
        }
        return fPosSum;
    }

    public double getSumTotal() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double fPosSum = 0.0;
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                double fValue = this.getDataValue((int)s, (int)g).m_fValue;
                if (!(fValue > 0.0)) continue;
                fPosSum += fValue;
            }
        }
        return fPosSum;
    }

    private void createSeriesPartOfOther(int nNumSeries, int nNumGroups) {
        this.m_bSeriesPartOfOther = new boolean[nNumSeries][nNumGroups];
        for (int nSeries = 0; nSeries < nNumSeries; ++nSeries) {
            for (int nGroup = 0; nGroup < nNumGroups; ++nGroup) {
                this.m_bSeriesPartOfOther[nSeries][nGroup] = false;
            }
        }
    }

    private void createSeriesDrawn(int nNumSeries, int nNumGroups) {
        this.m_bSeriesDrawn = new boolean[nNumSeries][nNumGroups];
        for (int nSeries = 0; nSeries < nNumSeries; ++nSeries) {
            for (int nGroup = 0; nGroup < nNumGroups; ++nGroup) {
                this.m_bSeriesDrawn[nSeries][nGroup] = false;
            }
        }
    }

    private void setSeriesPartOfOther(int nSeries, int nGroup, boolean bValue) {
        if (this.m_bSeriesPartOfOther != null) {
            this.m_bSeriesPartOfOther[nSeries][nGroup] = bValue;
        }
        if (bValue) {
            this.m_bOtherPercentage = true;
        }
    }

    private void setSeriesDrawn(int nSeries, int nGroup, boolean bValue) {
        if (this.m_bSeriesDrawn != null) {
            this.m_bSeriesDrawn[nSeries][nGroup] = bValue;
        }
    }

    protected boolean isSeriesPartOfOther(int nSeries) {
        boolean bSeriesIsPartOfOther = false;
        if (this.m_Perspective.getOtherSeries() && this.m_bSeriesDrawn != null && this.m_bSeriesPartOfOther != null) {
            int nGraphType = this.m_Perspective.getGraphType();
            switch (nGraphType) {
                default: {
                    return bSeriesIsPartOfOther;
                }
                case 55: 
                case 56: 
                case 93: 
                case 94: {
                    bSeriesIsPartOfOther = this.m_bSeriesPartOfOther[nSeries][0];
                    break;
                }
                case 57: 
                case 58: 
                case 59: 
                case 60: {
                    int nNumSeriesAssignedToOther = this.getNumSeriesAssignedToOther(nSeries);
                    if (nNumSeriesAssignedToOther != this.m_nTotalGroups) break;
                    bSeriesIsPartOfOther = true;
                }
            }
            int nNumSeriesDrawn = this.getNumSeriesDrawn(nSeries);
            bSeriesIsPartOfOther = nNumSeriesDrawn <= 0;
        }
        return bSeriesIsPartOfOther;
    }

    private int getNumSeriesAssignedToOther(int nSeries) {
        int nNumSeriesAssignedToOther = 0;
        for (int nGroup = 0; nGroup < this.m_nTotalGroups; ++nGroup) {
            boolean bOther = this.m_bSeriesPartOfOther[nSeries][nGroup];
            if (!bOther) continue;
            ++nNumSeriesAssignedToOther;
        }
        return nNumSeriesAssignedToOther;
    }

    private int getNumSeriesDrawn(int nSeries) {
        int nNumSeriesDrawn = 0;
        for (int nGroup = 0; nGroup < this.m_nTotalGroups; ++nGroup) {
            boolean bDrawn = this.m_bSeriesDrawn[nSeries][nGroup];
            if (!bDrawn) continue;
            ++nNumSeriesDrawn;
        }
        return nNumSeriesDrawn;
    }

    protected boolean getOtherPercentageFlag() {
        return this.m_bOtherPercentage;
    }

    public int getBarThickness() {
        return 0;
    }

    protected double getPieRotation() {
        double fPieRotAngle = (double)this.m_Perspective.getPieRotate() / 360.0;
        return fPieRotAngle;
    }

    protected int getSliceObjectID(int nDefaultID) {
        return nDefaultID;
    }

    protected boolean isPieBarSliceOK() {
        return false;
    }

    private void calcDrillLabel() {
        this.m_drillLabel = new IdentObj(232);
        this.m_drillLabelBox = new IdentObj(230);
        IdentObj title = this.getTitle();
        if (title == null) {
            return;
        }
        Dimension dimTitleVC = new Dimension(0, 0);
        IdentObj box = this.getTitleBox();
        String strTitle = this.m_Perspective.getTextString(title);
        if (this.m_Perspective.getDisplay(title) && strTitle.length() != 0) {
            TextStyleObj titleTextStyle = this.getTitleTextStyle();
            int nTitleFontSizeVC = this.getTitleFontSizeVC();
            int nDestTitleFontSize = this.m_VC.virtToDestHeight(nTitleFontSizeVC);
            int fontSize = !this.m_Perspective.getFontSizeAbsolute(title) ? this.m_VC.virtToDestHeight(this.m_Perspective.getFontSizeVC(title)) : this.m_Perspective.getFontSize(title);
            int fontStyle = TextStyleObj.getJavaFontStyle(this.m_Perspective.getFontStyle(title));
            String fontName = this.m_Perspective.getFontName(title);
            Graphics g = this.m_Perspective.getGraphicsContext();
            Font font = new Font(fontName, fontStyle, fontSize);
            FontMetrics fm = g.getFontMetrics(font);
            Dimension dimMax = new Dimension(16000, 16000);
            dimMax = this.m_VC.virtToDest(dimMax);
            Dimension dimTitleDC = titleTextStyle.getTextSizeDC(g, strTitle, nDestTitleFontSize, this.m_VC, dimMax, null, this.m_Perspective.getFontMetricsResolver());
            dimTitleVC.width = this.m_VC.destToVirtWidth(dimTitleDC.width);
            dimTitleVC.height = this.m_VC.destToVirtHeight(dimTitleDC.height);
            Rectangle pieFrame = this.m_Perspective.getRect(this.m_Perspective.getPieFrame());
            this.m_drillLabelRect = new Rectangle();
            this.m_drillLabelRect.y = pieFrame.y - this.m_VC.destToVirtHeight(10) - dimTitleVC.height;
            this.m_drillLabelRect.width = pieFrame.width;
            this.m_drillLabelRect.height = dimTitleVC.height;
            this.m_drillLabelRect.x = pieFrame.x;
            int rectLength = this.m_VC.virtToDestWidth(this.m_drillLabelRect.width);
            String displayText = strTitle;
            if (!this.m_Perspective.getTextWrap(title) && rectLength < this.m_Perspective.getFontMetricsResolver().stringWidth(strTitle, fm)) {
                displayText = PresUtils.truncateText(strTitle, fm, 2, rectLength, this.m_Perspective.getFontMetricsResolver());
                this.m_Perspective.setAxisTitleTruncated(true, 0, title);
            }
            if (this.m_Perspective.getDisplay(box)) {
                BlackBoxObj bbBox = new BlackBoxObj(this.m_Perspective, box);
                new DetRect(this.m_Perspective.getDetectiv(), box, this.m_drillLabelRect.x, this.m_drillLabelRect.y, this.m_drillLabelRect.width, this.m_drillLabelRect.height, bbBox, null, false, true, true);
            }
            BlackBoxObj titleBox = new BlackBoxObj(this.m_Perspective, title);
            new DetLabel(this.m_Perspective.getDetectiv(), title, displayText, strTitle, this.m_drillLabelRect, titleTextStyle, titleBox, this.m_Perspective.getMoveAxisTitles());
        }
    }

    private TextStyleObj getTitleTextStyle() {
        IdentObj title = this.getTitle();
        boolean bAutofit = this.m_Perspective.getAutofit(title);
        int nTitleFontSizeVC = this.getTitleFontSizeVC();
        boolean bTitleFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(title);
        TextStyleObj titleTextStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(title), this.m_Perspective.getFontStyle(title), bTitleFontSizeAbsolute, this.m_Perspective.getFontSize(title), nTitleFontSizeVC, 0, this.m_Perspective.getTextJustHoriz(title), this.m_Perspective.getTextJustVert(title), bAutofit, false, this.m_Perspective.getTextWrap(title), this.m_Perspective.getLocale());
        titleTextStyle.setDisplayDrillIcon(true);
        int fontSize = this.m_VC.virtToDestHeight(nTitleFontSizeVC);
        if (fontSize < 18 && TextStyleObj.SMALL_DRILL_IMAGE == null) {
            TextStyleObj.SMALL_DRILL_IMAGE = TextStyleObj.getImageResource(TextStyleObj.class, "images/graph_drill_up.gif");
        } else if (fontSize >= 18 && TextStyleObj.LARGE_DRILL_IMAGE == null) {
            TextStyleObj.LARGE_DRILL_IMAGE = TextStyleObj.getImageResource(TextStyleObj.class, "images/large_drill_up.gif");
        }
        return titleTextStyle;
    }

    private int getTitleFontSizeVC() {
        IdentObj title = this.getTitle();
        boolean bTitleFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(title);
        int nTitleFontSizeVC = bTitleFontSizeAbsolute ? this.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(title)) : this.m_Perspective.getFontSizeVC(title);
        return nTitleFontSizeVC;
    }

    private IdentObj getTitle() {
        if (this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString(this.m_drillLabel) != null && this.m_Perspective.getDisplay(this.m_drillLabel)) {
            return this.m_drillLabel;
        }
        return null;
    }

    private IdentObj getTitleBox() {
        if (this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString(this.m_drillLabel) != null && this.m_Perspective.getDisplay(this.m_drillLabel)) {
            return this.m_drillLabelBox;
        }
        return null;
    }

    private boolean isRenderingClientPie() {
        HashMap ctx = (HashMap)this.m_Perspective.getCommonGraph().getContext();
        String imageFormatKey = "imageFormat";
        String imageFormat = "";
        String IMAGE_HTML5 = "5";
        if (ctx != null && ctx.get(imageFormatKey) != null) {
            imageFormat = ctx.get(imageFormatKey).toString();
        }
        return this.m_Perspective.isExportingToXML() && this.m_Perspective.getGraphType() == 55 && (!this.m_Perspective.isBIDILocale() || imageFormat.equals(IMAGE_HTML5));
    }
}

