/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Polygon;
import oracle.dss.graph.pfj.Cubic;

public class NatCubic {
    static final int STEPS = 12;

    private NatCubic() {
    }

    static Cubic[] calcNaturalCubic(int n, int[] x) {
        int i;
        float[] gamma = new float[n + 1];
        float[] delta = new float[n + 1];
        float[] D = new float[n + 1];
        gamma[0] = 0.5f;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0f / (4.0f - gamma[i - 1]);
        }
        gamma[n] = 1.0f / (2.0f - gamma[n - 1]);
        delta[0] = (float)(3 * (x[1] - x[0])) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = ((float)(3 * (x[i + 1] - x[i - 1])) - delta[i - 1]) * gamma[i];
        }
        delta[n] = ((float)(3 * (x[n] - x[n - 1])) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], (float)(3 * (x[i + 1] - x[i])) - 2.0f * D[i] - D[i + 1], (float)(2 * (x[i] - x[i + 1])) + D[i] + D[i + 1]);
        }
        return C;
    }

    public static Polygon interpolate(Polygon polyIn) {
        Polygon polyOut = new Polygon();
        if (polyIn.npoints >= 2) {
            Cubic[] X = NatCubic.calcNaturalCubic(polyIn.npoints - 1, polyIn.xpoints);
            Cubic[] Y = NatCubic.calcNaturalCubic(polyIn.npoints - 1, polyIn.ypoints);
            polyOut.addPoint(Math.round(X[0].eval(0.0f)), Math.round(Y[0].eval(0.0f)));
            for (int i = 0; i < X.length; ++i) {
                for (int j = 1; j <= 12; ++j) {
                    float u = (float)j / 12.0f;
                    polyOut.addPoint(Math.round(X[i].eval(u)), Math.round(Y[i].eval(u)));
                }
            }
        }
        return polyOut;
    }
}

