/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.GraphSVGWriter;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.math.FP;

public class DetPolygon
extends DetObj {
    private static final long serialVersionUID = 1L;
    Polygon m_polygon;
    Polygon m_destPolygon;
    double m_fIntensity;
    Rectangle m_clipRect;

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, double fIntensity) {
        super(detectiv, id, blackBox, false, true, true);
        this.m_polygon = poly;
        this.m_fIntensity = fIntensity;
        if (id.getObjectID() == 277 && this.m_polygon != null) {
            int destWidth = this.m_Detectiv.getPerspective().getVC().virtToDestWidth(this.m_polygon.getBounds().width);
            this.setVisualEffectsMap(JChart_2D.getBarEffectsMap(destWidth));
        } else if (id.getObjectID() == 256 && this.m_Detectiv.getPerspective().getDepthRadius() == 0) {
            this.setVisualEffectsMap(JChart_2D.getAreaEffectsMap());
        }
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, double fIntensity, boolean bHiliteable) {
        this(detectiv, id, poly, blackBox, null, fIntensity, bHiliteable);
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, Rectangle clipRect) {
        this(detectiv, id, poly, blackBox, clipRect, 1.0, true);
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, Rectangle clipRect, List groups) {
        this(detectiv, id, poly, blackBox, clipRect, 1.0, true);
        this.m_groups = groups;
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, boolean bHiliteable, Rectangle clipRect) {
        this(detectiv, id, poly, blackBox, bHiliteable);
        this.m_clipRect = clipRect;
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, boolean bHiliteable) {
        super(detectiv, id, blackBox, false, true, bHiliteable);
        this.m_fIntensity = 1.0;
        this.m_destPolygon = poly;
        if (id.getObjectID() == 277 && this.m_destPolygon != null) {
            this.setVisualEffectsMap(JChart_2D.getBarEffectsMap(this.m_destPolygon.getBounds().width));
        } else if (id.getObjectID() == 256 && this.m_Detectiv.getPerspective().getDepthRadius() == 0) {
            this.setVisualEffectsMap(JChart_2D.getAreaEffectsMap());
        }
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, Rectangle clipRect, double fIntensity, boolean bHiliteable) {
        super(detectiv, id, blackBox, false, true, bHiliteable);
        this.m_clipRect = clipRect;
        this.m_polygon = poly;
        this.m_fIntensity = fIntensity;
        if (id.getObjectID() == 277 && this.m_polygon != null) {
            int destWidth = this.m_Detectiv.getPerspective().getVC().virtToDestWidth(this.m_polygon.getBounds().width);
            this.setVisualEffectsMap(JChart_2D.getBarEffectsMap(destWidth));
        } else if (id.getObjectID() == 256 && this.m_Detectiv.getPerspective().getDepthRadius() == 0) {
            this.setVisualEffectsMap(JChart_2D.getAreaEffectsMap());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetPolygon)) {
            return false;
        }
        DetPolygon detPolygon = (DetPolygon)obj;
        return this.m_id.equals(detPolygon.m_id);
    }

    @Override
    public Rectangle getBounds() {
        if (this.m_destPolygon != null) {
            return this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_destPolygon).getBounds();
        }
        return this.m_polygon.getBounds();
    }

    @Override
    public void hilite(Graphics g, VC vc) {
        g.setXORMode(Color.yellow);
        if (this.m_destPolygon != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(1.0f, 1, 1));
            g2.drawPolygon(this.m_destPolygon);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(1.0f, 1, 1));
            Polygon dest = vc.virtToDest(this.m_polygon);
            g2.drawPolygon(dest);
        }
        g.setPaintMode();
    }

    @Override
    public boolean isPointInObj(int x, int y, VC vc) {
        if (this.m_destPolygon != null) {
            return this.m_bDetectable && this.m_destPolygon.contains(vc.virtToDestX(x), vc.virtToDestY(y));
        }
        return this.m_bDetectable && this.m_polygon.contains(x, y);
    }

    @Override
    public void paintIt(Graphics g, VC vc) {
        Polygon pDest = null;
        Shape oldClip = null;
        if (this.m_clipRect != null) {
            oldClip = g.getClip();
            g.setClip(this.m_Detectiv.getPerspective().getVC().virtToDest(this.m_clipRect));
        }
        if (this.m_destPolygon != null) {
            pDest = this.m_destPolygon;
        } else if (this.m_polygon != null) {
            pDest = vc.virtToDest(this.m_polygon);
        }
        if (FP.equal(this.m_fIntensity, 1.0) || this.m_blackBox.getFillType() != 1) {
            this.paint(g, pDest);
        } else {
            Color colorOrig = this.m_blackBox.getFillColor();
            if (colorOrig == null) {
                this.paint(g, pDest);
            } else {
                double fR = (double)colorOrig.getRed() * this.m_fIntensity;
                double fG = (double)colorOrig.getGreen() * this.m_fIntensity;
                double fB = (double)colorOrig.getBlue() * this.m_fIntensity;
                this.m_blackBox.setFillColor(new Color(FP.round(fR), FP.round(fG), FP.round(fB), colorOrig.getAlpha()));
                this.paint(g, pDest);
                this.m_blackBox.setFillColor(colorOrig);
            }
        }
        if (this.m_clipRect != null) {
            g.setClip(oldClip);
        }
    }

    @Override
    public void renderItToSVG(Map context) throws IOException, Exception {
        VC vc = (VC)context.get("svgVC");
        Polygon pDest = null;
        pDest = this.m_destPolygon != null ? this.m_destPolygon : vc.virtToDest(this.m_polygon);
        if (FP.equal(this.m_fIntensity, 1.0) || this.m_blackBox.getFillType() != 1) {
            this.renderToSVG(context, pDest);
        } else {
            Color colorOrig = this.m_blackBox.getFillColor();
            if (colorOrig == null) {
                this.renderToSVG(context, pDest);
            } else {
                double fR = (double)colorOrig.getRed() * this.m_fIntensity;
                double fG = (double)colorOrig.getGreen() * this.m_fIntensity;
                double fB = (double)colorOrig.getBlue() * this.m_fIntensity;
                this.m_blackBox.setFillColor(new Color(FP.round(fR), FP.round(fG), FP.round(fB), colorOrig.getAlpha()));
                this.renderToSVG(context, pDest);
                this.m_blackBox.setFillColor(colorOrig);
            }
        }
    }

    public void paint(Graphics g, Polygon p) {
        this.m_blackBox.paint(g, p);
    }

    protected void renderToSVG(Map context, Polygon p) throws IOException, Exception {
        boolean bElementStarted;
        boolean bOnMouseOverOutPresent;
        boolean bOnClickPresent;
        GraphSVGWriter writer = (GraphSVGWriter)context.get("svgWriter");
        int mode = (Integer)context.get("svgMode");
        boolean bTooltips = (mode & 2) != 0;
        String[] tooltipsArray = null;
        if (bTooltips) {
            tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        }
        boolean bShapeAttributes = (mode & 0x10) != 0;
        String clickEventJS = null;
        boolean bl = bOnClickPresent = bShapeAttributes && writer.isOnClickPresent();
        if (bShapeAttributes && !bOnClickPresent) {
            clickEventJS = writer.getClickEventJS();
        }
        boolean bl2 = bOnMouseOverOutPresent = bShapeAttributes && writer.isOnMouseOverOutPresent();
        if (bOnMouseOverOutPresent) {
            bTooltips = false;
        }
        String saAlt = null;
        String saTitle = null;
        String saHRef = null;
        String saTarget = null;
        if (bShapeAttributes) {
            saAlt = writer.getShapeAttributesAlt();
            saTitle = writer.getShapeAttributesTitle();
            if (!bOnClickPresent) {
                saHRef = writer.getShapeAttributesHRef();
            }
            saTarget = writer.getShapeAttributesTarget();
        }
        boolean bDrilling = (mode & 4) != 0;
        bDrilling = bDrilling && !bOnClickPresent && clickEventJS == null;
        String drillJS = null;
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = writer.getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        if (bDrilling && ((drillJS = writer.getDrillJS(this)) == null || drillJS.length() < 1)) {
            bDrilling = false;
        }
        if (bTooltips) {
            if (saAlt != null) {
                tooltipsArray = new String[]{saAlt};
            } else if (saTitle != null) {
                tooltipsArray = new String[]{saTitle};
            }
        }
        if (bDrilling && bTooltips && tooltipsArray == null) {
            tooltipsArray = new String[]{writer.getDrillTooltip(this)};
        }
        bTooltips = bTooltips && tooltipsArray != null && tooltipsArray.length > 0;
        boolean bStartA = bDrilling || bOnClickPresent || clickEventJS != null || saHRef != null || bLink;
        boolean bAnchorGroup = false;
        if (bStartA) {
            writer.startElement("a");
            String href = "";
            if (clickEventJS == null && !bDrilling && saHRef != null) {
                href = saHRef;
            } else if (clickEventJS == null && !bDrilling && bLink) {
                href = link;
            }
            writer.writeAttribute("xlink:href", href);
            if (saTarget != null) {
                writer.writeAttribute("target", saTarget);
            }
            String strOnclick = null;
            if (clickEventJS != null) {
                strOnclick = clickEventJS;
            } else if (bDrilling) {
                strOnclick = drillJS;
            }
            if (strOnclick != null) {
                bAnchorGroup = true;
                writer.startElement("g");
                writer.writeAttribute("onclick", strOnclick);
            }
        }
        if (bElementStarted = writer.startElement(this.m_id, this.m_blackBox, p)) {
            if (this.m_id.getObjectID() == 357) {
                writer.writeAttribute("id", writer.getReferenceObjectId(this.m_id.getMiscID()));
                int graphID = this.m_Detectiv.getPerspective().getReferenceAssociation(this.m_id);
                int display = this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID);
                if (display == 2) {
                    writer.writeAttribute("visibility", "hidden");
                }
                writer.writeAttribute("pointer-events", "none");
            }
            if (bShapeAttributes) {
                writer.writeShapeAttributes();
            }
            if (bTooltips) {
                int rbMode;
                List l;
                String onMouseOverJS = null;
                String onMouseOutJS = null;
                int graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
                if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2 && (l = writer.getReferenceObjects(this.m_id)) != null) {
                    context.put("svgHasReferenceObj", Boolean.TRUE);
                    StringBuilder strBuf = new StringBuilder("evt,");
                    for (int i = 0; i < l.size() - 1; ++i) {
                        strBuf.append("'" + (String)l.get(i) + "',");
                    }
                    strBuf.append("'" + (String)l.get(l.size() - 1) + "'");
                    onMouseOverJS = "bi_refObj_show_mOver(" + strBuf.toString() + ");";
                    onMouseOutJS = "bi_refObj_hide_mOut(" + strBuf.toString() + ");";
                }
                if ((rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior)) != 0) {
                    String shfOver = "bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');";
                    String shfOut = "bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');";
                    onMouseOverJS = onMouseOverJS != null ? onMouseOverJS + shfOver : shfOver;
                    onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
                }
                writer.writeTooltip(tooltipsArray, onMouseOverJS, onMouseOutJS);
            } else {
                List l;
                int graphID;
                String onMouseOverJS = null;
                String onMouseOutJS = null;
                int rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior);
                if (rbMode != 0 && this.m_id.isSeriesRelated()) {
                    String shfOver = "bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');";
                    String shfOut = "bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');";
                    onMouseOverJS = onMouseOverJS != null ? onMouseOverJS + shfOver : shfOver;
                    onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
                }
                if ((graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID())) != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2 && (l = writer.getReferenceObjects(this.m_id)) != null) {
                    context.put("svgHasReferenceObj", Boolean.TRUE);
                    StringBuilder strBuf = new StringBuilder("evt,");
                    for (int i = 0; i < l.size() - 1; ++i) {
                        strBuf.append("'" + (String)l.get(i) + "',");
                    }
                    strBuf.append("'" + (String)l.get(l.size() - 1) + "'");
                    onMouseOverJS = onMouseOverJS == null ? "bi_refObj_show_mOver(" + strBuf.toString() + ");" : onMouseOverJS + "bi_refObj_show_mOver(" + strBuf.toString() + ");";
                    onMouseOutJS = onMouseOutJS == null ? "bi_refObj_hide_mOut(" + strBuf.toString() + ");" : "bi_refObj_hide_mOut(" + strBuf.toString() + ");";
                }
                if (onMouseOverJS != null) {
                    writer.writeAttribute("onmouseover", onMouseOverJS);
                }
                if (onMouseOutJS != null) {
                    writer.writeAttribute("onmouseout", onMouseOutJS);
                }
                if (saTitle != null) {
                    writer.writeTitleElement(saTitle);
                }
            }
            writer.endElement();
        }
        if (bStartA) {
            if (bAnchorGroup) {
                writer.endElement();
            }
            writer.endElement();
        }
    }

    @Override
    public void renderItToXML(Map context) throws IOException, Exception {
        VC vc = (VC)context.get("xmlVC");
        Polygon pDest = null;
        pDest = this.m_destPolygon != null ? this.m_destPolygon : vc.virtToDest(this.m_polygon);
        if (FP.equal(this.m_fIntensity, 1.0) || this.m_blackBox.getFillType() != 1) {
            this.renderToXML(context, pDest);
        } else {
            Color colorOrig = this.m_blackBox.getFillColor();
            if (colorOrig == null) {
                this.renderToXML(context, pDest);
            } else {
                double fR = (double)colorOrig.getRed() * this.m_fIntensity;
                double fG = (double)colorOrig.getGreen() * this.m_fIntensity;
                double fB = (double)colorOrig.getBlue() * this.m_fIntensity;
                this.m_blackBox.setFillColor(new Color(FP.round(fR), FP.round(fG), FP.round(fB), colorOrig.getAlpha()));
                this.renderToXML(context, pDest);
                this.m_blackBox.setFillColor(colorOrig);
            }
        }
    }

    protected void renderToXML(Map context, Polygon p) throws IOException, Exception {
        String drillJS;
        boolean bDrilling;
        GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
        String[] tooltipsArray = null;
        boolean bTooltipTemplate = writer.useTooltipTemplate(this.m_id);
        if (!bTooltipTemplate) {
            tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        }
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = this.m_Detectiv.getPerspective().getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        boolean bl = bDrilling = (drillJS = writer.getDrillJS(this)) != null && drillJS.length() > 0;
        if (bDrilling && !bTooltipTemplate && tooltipsArray == null) {
            tooltipsArray = new String[]{writer.getDrillTooltip(this)};
        }
        boolean bTooltips = tooltipsArray != null && tooltipsArray.length > 0;
        boolean bElementStarted = writer.startElement(this.m_id, this.m_blackBox, p);
        Rectangle gradRect = p.getBounds();
        if (bElementStarted) {
            int graphID;
            if (this.m_id.getObjectID() == 357) {
                graphID = this.m_Detectiv.getPerspective().getReferenceAssociation(this.m_id);
                int display = this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID);
                if (display == 2) {
                    writer.writeAttribute("v", "h");
                }
            }
            writer.writeDataZoomAndScrollEventJsAttributes(this);
            if (bDrilling) {
                writer.writeAttribute("drillJs", drillJS);
            }
            if (bLink) {
                writer.writeAttribute("link", link);
            }
            if (!writer.hasAlt()) {
                if (bTooltips && tooltipsArray != null) {
                    writer.writeTooltipAttribute(tooltipsArray);
                } else if (!bTooltipTemplate) {
                    writer.writeCachedAttribute("tt", "f", null);
                }
            }
            writer.writeVisualEffectsAttributes(this.m_visualEffectsMap);
            writer.writeCustomPropertyAttribute();
            writer.writeShapeAttributesElement();
            writer.writeFillChildren(this.m_id, this.m_blackBox, gradRect);
            writer.writeBorderChildren(this.m_id, this.m_blackBox, gradRect);
            graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
            if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2) {
                writer.writeReferenceObjectsElement(this.m_id);
            }
            writer.endElement();
        }
    }

    @Override
    public void setBounds(Rectangle rBounds) {
    }

    @Override
    public Polygon getShape(VC vc) {
        if (this.m_destPolygon != null) {
            return vc.destToVirt(this.m_destPolygon);
        }
        return this.m_polygon;
    }

    @Override
    public boolean isMoveable() {
        return super.isMoveable();
    }
}

