/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxb;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.jaxb.JaxbBindingSchema;
import oracle.xml.jaxb.JaxbConstants;
import oracle.xml.jaxb.JaxbCustomization;
import oracle.xml.jaxb.JaxbProperty;
import oracle.xml.jaxb.JaxbUtil;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDParticleNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.DOMLocator;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class JaxbSchemaCompiler
implements JaxbConstants {
    Hashtable bindingSchema = new Hashtable();
    Hashtable schPackage = new Hashtable();
    HashMap className = new HashMap();
    XMLError err = new XMLError();
    EntityResolver entityResolver = null;
    String serialVersionUID = null;
    boolean useAnyTypeClassLoader = false;
    String targetPkg = null;
    ArrayList bindingFileList = null;
    JaxbCustomization customization;
    boolean extensionOption = false;

    public JaxbSchemaCompiler() {
        this.err.showWarnings(true);
        this.customization = new JaxbCustomization();
        this.customization.setError(this.err);
    }

    public void setSerialVersionUID(String string) {
        this.serialVersionUID = string;
    }

    public void setUseAnyTypeClassLoader(boolean bl) {
        this.useAnyTypeClassLoader = bl;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setError(XMLError xMLError) {
        this.err = xMLError;
    }

    public void setTargetPkg(String string) {
        if (!string.equals("")) {
            this.targetPkg = string;
        }
    }

    public void setBindingFileList(ArrayList arrayList) {
        this.bindingFileList = arrayList;
    }

    public void setExtension(boolean bl) {
        this.extensionOption = bl;
    }

    public void setCustomization(JaxbCustomization jaxbCustomization) {
        this.customization = jaxbCustomization;
    }

    public Hashtable compile(InputStream inputStream) throws Exception {
        return this.compile(inputStream, null);
    }

    public Hashtable compile(InputStream inputStream, URL uRL) throws Exception {
        DOMParser dOMParser = null;
        XMLDocument xMLDocument = null;
        XSDBuilder xSDBuilder = new XSDBuilder();
        XMLSchema xMLSchema = new XMLSchema();
        try {
            dOMParser = this.initParser(uRL);
            dOMParser.setError(this.err);
            dOMParser.parse(inputStream);
            xMLDocument = dOMParser.getDocument();
            if (xMLDocument == null) {
                return null;
            }
            xMLDocument = this.addExternalCustomization(xMLDocument);
            xSDBuilder.setError(this.err);
            xSDBuilder.setDebugMode(true);
            if (this.entityResolver != null) {
                xSDBuilder.setEntityResolver(this.entityResolver);
            }
            xMLSchema = xSDBuilder.build(xMLDocument, uRL);
            this.err.flushErrors();
        }
        catch (Exception exception) {
            this.err.error0(32000, 0);
            this.err.flushErrors();
        }
        return this.compileSchema(xMLSchema);
    }

    public Hashtable compile(URL uRL) throws Exception {
        DOMParser dOMParser = null;
        XMLDocument xMLDocument = null;
        XSDBuilder xSDBuilder = new XSDBuilder();
        XMLSchema xMLSchema = new XMLSchema();
        try {
            dOMParser = this.initParser(null);
            dOMParser.setError(this.err);
            dOMParser.parse(uRL);
            xMLDocument = dOMParser.getDocument();
            if (xMLDocument == null) {
                return null;
            }
            if (this.bindingFileList != null) {
                xMLDocument = this.addExternalCustomization(xMLDocument);
            }
            xSDBuilder.setError(this.err);
            xSDBuilder.setDebugMode(true);
            if (this.entityResolver != null) {
                xSDBuilder.setEntityResolver(this.entityResolver);
            }
            xMLSchema = xSDBuilder.build(xMLDocument, uRL);
            this.err.flushErrors();
        }
        catch (Exception exception) {
            this.err.error0(32000, 0);
            this.err.flushErrors();
        }
        return this.compileSchema(xMLSchema);
    }

    private Hashtable compileSchema(XMLSchema xMLSchema) throws Exception {
        this.setJavaPackages(xMLSchema);
        this.setGlobalAndSchemaBindings(xMLSchema);
        Enumeration enumeration = xMLSchema.getXMLSchemaNodeTable().keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            JaxbBindingSchema jaxbBindingSchema;
            String string;
            String string2;
            String string3;
            String string4;
            XSDNode xSDNode;
            int n;
            String string5 = (String)enumeration.nextElement();
            if (string5.equals("http://www.w3.org/2001/XMLSchema") || string5.equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
            XMLSchemaNode xMLSchemaNode = xMLSchema.getSchemaByTargetNS(string5);
            if (xMLSchemaNode.getNotationSetSize() != 0 && !this.extensionOption) {
                this.setLoc(this.err, (XSDNode)xMLSchemaNode);
                this.err.error0(32014, 1);
                throw new Exception(this.err.getMessage0(32014));
            }
            XSDNode[] xSDNodeArray = xMLSchemaNode.getElementSet();
            XSDNode[] xSDNodeArray2 = xMLSchemaNode.getComplexTypeSet();
            XSDNode[] xSDNodeArray3 = xMLSchemaNode.getGroupSet();
            XSDNode[] xSDNodeArray4 = xMLSchemaNode.getSimpleTypeSet();
            for (n = 0; n < xSDNodeArray3.length; ++n) {
                xSDNode = xSDNodeArray3[n];
                string4 = xSDNode.getName();
                string3 = this.getGroupClassNameAnnotation((XSDGroup)xSDNode);
                if (string3 == null) continue;
                string2 = xSDNode.getTargetNS();
                string = this.getPackageName(xSDNode);
                jaxbBindingSchema = new JaxbBindingSchema(string4, string2, string, string3, null, null, 5);
                jaxbBindingSchema.setGlobal(true);
                jaxbBindingSchema.setCustomizationSet(0);
                jaxbBindingSchema.setSerialVersionUID(this.serialVersionUID);
                object = string + "." + string3;
                this.bindGroupDeclaration(jaxbBindingSchema, xSDNode, (String)object, (String)object + "Impl");
                this.putBindingSchema(jaxbBindingSchema);
            }
            for (n = 0; n < xSDNodeArray2.length; ++n) {
                xSDNode = xSDNodeArray2[n];
                string4 = xSDNode.getName();
                string3 = this.getClassName(xSDNode, 1);
                string2 = xSDNode.getTargetNS();
                string = this.getPackageName(xSDNode);
                jaxbBindingSchema = new JaxbBindingSchema(string4, string2, string, string3, null, null, 1);
                jaxbBindingSchema.setGlobal(true);
                jaxbBindingSchema.setSerialVersionUID(this.serialVersionUID);
                if (((XSDComplexType)xSDNode).isSimpleContent() && !(((XSDComplexType)xSDNode).getBaseType() instanceof XSDComplexType)) {
                    object = new JaxbProperty("", "", 2);
                    this.customizeProperty(xSDNode, (JaxbProperty)object, false, 0);
                    this.setTargetJavaDataType(xSDNode, (JaxbProperty)object);
                    jaxbBindingSchema.setDataValueType((JaxbProperty)object);
                }
                object = string + "." + string3;
                String string6 = (String)object + "Impl";
                this.bindComplexTypeDeclaration(jaxbBindingSchema, xSDNode, (String)object, string6);
                this.putBindingSchema(jaxbBindingSchema);
            }
            for (n = 0; n < xSDNodeArray.length; ++n) {
                xSDNode = xSDNodeArray[n];
                string4 = xSDNode.getName();
                if (((XSDElement)xSDNode).getEquivClassRef() != null && !this.extensionOption) {
                    this.setLoc(this.err, xSDNode);
                    this.err.error0(32012, 1);
                    throw new Exception(this.err.getMessage0(32012));
                }
                string3 = this.getClassName(xSDNode, 3);
                string2 = xSDNode.getTargetNS();
                string = this.getPackageName(xSDNode);
                jaxbBindingSchema = new JaxbBindingSchema(string4, string2, string, string3, null, null, 3);
                jaxbBindingSchema.setGlobal(true);
                jaxbBindingSchema.setSerialVersionUID(this.serialVersionUID);
                this.bindElementDeclaration(jaxbBindingSchema, xSDNode, false, null, string, string);
                this.putBindingSchema(jaxbBindingSchema);
            }
            for (n = 0; n < xSDNodeArray4.length; ++n) {
                Object object2;
                xSDNode = xSDNodeArray4[n];
                object = ((XSDSimpleType)xSDNode).getEnumeration();
                if (object == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                string4 = xSDNode.getName();
                string3 = this.getClassName(xSDNode, 10);
                string2 = xSDNode.getTargetNS();
                string = this.getPackageName(xSDNode);
                XSDSimpleType xSDSimpleType = ((XSDSimpleType)xSDNode).getBase();
                JaxbProperty jaxbProperty = new JaxbProperty("", "", xSDSimpleType.getNodeType());
                String string7 = this.getTypesafeEnumClassName(xSDNode);
                if (string7 != null) {
                    string3 = string7;
                }
                jaxbBindingSchema = new JaxbBindingSchema(string4, string2, string, string3, null, null, 2);
                jaxbBindingSchema.setGlobal(true);
                jaxbBindingSchema.setDataValueType(jaxbProperty);
                jaxbBindingSchema.setSerialVersionUID(this.serialVersionUID);
                String string8 = xSDSimpleType.getName();
                String string9 = null;
                while (!JaxbUtil.isSchemaDataType(string8)) {
                    object2 = xSDSimpleType.getBase();
                    string8 = object2.getName();
                    string9 = JaxbUtil.getBuiltInType(string8);
                    jaxbProperty.setJavaType(string9);
                    jaxbProperty.setXmlType(string8);
                }
                if (this.customization.isTypeSafeEnumBase((XSDSimpleType)xSDNode)) {
                    bl = true;
                }
                string9 = JaxbUtil.getBuiltInType(string8);
                jaxbProperty.setJavaType(string9);
                jaxbProperty.setXmlType(string8);
                if (xSDNode.getAnnotation() != null) {
                    bl2 = this.setTypesafeEnumClassAnnotation(xSDNode, jaxbBindingSchema);
                }
                if (bl) {
                    object2 = jaxbBindingSchema.getEnumeration();
                    if (object2 == null) {
                        object2 = new HashMap();
                        jaxbBindingSchema.setEnumeration((HashMap)object2);
                    }
                    int n2 = ((Vector)object).size();
                    for (int i = 0; i < n2; ++i) {
                        String string10 = (String)((Vector)object).elementAt(i);
                        String string11 = this.getEnumAnnotationValue(string10, (XSDSimpleType)xSDNode);
                        if (string11 != null) {
                            ((HashMap)object2).put(string11, string10);
                        } else if (!((HashMap)object2).containsValue(string10)) {
                            ((HashMap)object2).put(string10, string10);
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        for (String string12 : ((HashMap)object2).keySet()) {
                            String string13 = (String)((HashMap)object2).get(string12);
                            if (!((Vector)object).contains(string13)) continue;
                            hashMap.put(string13, string12);
                        }
                        jaxbBindingSchema.setEnumeration(hashMap);
                    }
                }
                if (!bl && !bl2) continue;
                this.putBindingSchema(jaxbBindingSchema);
            }
        }
        return this.bindingSchema;
    }

    String getEnumAnnotationValue(String string, XSDSimpleType xSDSimpleType) throws Exception {
        XSDAnnotation xSDAnnotation = xSDSimpleType.getEnumAnnotation(string);
        if (xSDAnnotation == null) {
            return null;
        }
        Vector vector = xSDAnnotation.getApplicationInformation();
        if (vector == null) {
            return null;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement = (XMLElement)vector.get(i);
            NodeList nodeList = xMLElement.getChildNodes();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                XMLNode xMLNode = (XMLNode)nodeList.item(j);
                if (xMLNode.getNodeType() != 1 || xMLNode.getNamespaceURI() != "http://java.sun.com/xml/ns/jaxb" || !xMLNode.getLocalName().equals("typesafeEnumMember")) continue;
                String string2 = ((XMLElement)xMLNode).getAttribute("value");
                if (!string2.equals("")) {
                    this.setLoc1(this.err, (XMLElement)xMLNode);
                    this.err.error1(32201, 1, "typesafeEnumMember");
                    throw new Exception(this.err.getMessage0(32201));
                }
                return ((XMLElement)xMLNode).getAttribute("name");
            }
        }
        return null;
    }

    private JaxbBindingSchema createAnyTypeBS() throws Exception {
        String string;
        String string2;
        if (this.targetPkg != null) {
            string2 = this.targetPkg;
            string = this.targetPkg + "." + "AnyType";
        } else {
            string2 = "org.w3._2001.xmlschema";
            string = "org.w3._2001.xmlschema.AnyType";
        }
        JaxbBindingSchema jaxbBindingSchema = new JaxbBindingSchema("anyType", "http://www.w3.org/2001/XMLSchema-instance", string2, "AnyType", string2, string2, 1);
        jaxbBindingSchema.setGlobal(true);
        jaxbBindingSchema.setAnyType(true);
        jaxbBindingSchema.setMixedContent(true);
        jaxbBindingSchema.setSerialVersionUID(this.serialVersionUID);
        jaxbBindingSchema.setUseAnyTypeClassLoader(this.useAnyTypeClassLoader);
        this.putBindingSchema(string, jaxbBindingSchema);
        return jaxbBindingSchema;
    }

    private boolean setTypesafeEnumClassAnnotation(XSDNode xSDNode, JaxbBindingSchema jaxbBindingSchema) throws Exception {
        boolean bl = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        XSDAnnotation xSDAnnotation = xSDNode.getAnnotation();
        if (xSDAnnotation == null) {
            return bl;
        }
        Vector vector = xSDAnnotation.getApplicationInformation();
        if (vector == null) {
            return bl;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement = (XMLElement)vector.get(i);
            NodeList nodeList = xMLElement.getChildNodes();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                XMLNode xMLNode = (XMLNode)nodeList.item(j);
                if (xMLNode.getNodeType() != 1 || xMLNode.getNamespaceURI() != "http://java.sun.com/xml/ns/jaxb") continue;
                NodeList nodeList2 = xMLNode.getChildNodes();
                for (int k = 0; k < nodeList2.getLength(); ++k) {
                    XMLNode xMLNode2 = (XMLNode)nodeList2.item(k);
                    if (xMLNode2.getNodeType() != 1 || xMLNode2.getNamespaceURI() != "http://java.sun.com/xml/ns/jaxb" || !xMLNode2.getLocalName().equals("typesafeEnumMember")) continue;
                    String string = ((XMLElement)xMLNode2).getAttribute("name");
                    String string2 = ((XMLElement)xMLNode2).getAttribute("value");
                    if (string2.equals("")) {
                        this.setLoc1(this.err, (XMLElement)xMLNode2);
                        this.err.error1(32214, 1, "typesafeEnumMember");
                        throw new Exception(this.err.getMessage0(32214));
                    }
                    hashMap.put(string, string2);
                    bl = true;
                }
                jaxbBindingSchema.setEnumeration(hashMap);
            }
        }
        return bl;
    }

    private String getTypesafeEnumClassName(XSDNode xSDNode) throws Exception {
        String string = null;
        XSDAnnotation xSDAnnotation = xSDNode.getAnnotation();
        if (xSDAnnotation == null) {
            return null;
        }
        Vector vector = xSDAnnotation.getApplicationInformation();
        if (vector == null) {
            return null;
        }
        boolean bl = false;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement = (XMLElement)vector.get(i);
            NodeList nodeList = xMLElement.getChildNodes();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                XMLNode xMLNode = (XMLNode)nodeList.item(j);
                if (xMLNode.getNodeType() != 1 || xMLNode.getNamespaceURI() != "http://java.sun.com/xml/ns/jaxb" || !xMLNode.getLocalName().equals("typesafeEnumClass")) continue;
                if (bl) {
                    this.setLoc1(this.err, (XMLElement)xMLNode);
                    this.err.error1(32215, 1, xSDNode.getName());
                    throw new Exception(this.err.getMessage0(32215));
                }
                bl = true;
                String string2 = ((XMLElement)xMLNode).getAttribute("name");
                if (string2.equals("")) continue;
                string = string2;
            }
        }
        return string;
    }

    private void setGlobalAndSchemaBindings(XMLSchema xMLSchema) throws Exception {
        String string = "";
        boolean bl = false;
        Enumeration enumeration = xMLSchema.getXMLSchemaNodeTable().keys();
        while (enumeration.hasMoreElements()) {
            Vector vector;
            XMLSchemaNode xMLSchemaNode;
            XSDAnnotation xSDAnnotation;
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("http://www.w3.org/2001/XMLSchema") || string2.equals("http://www.w3.org/2001/XMLSchema-instance") || (xSDAnnotation = (xMLSchemaNode = xMLSchema.getSchemaByTargetNS(string2)).getAnnotation()) == null || (vector = xSDAnnotation.getApplicationInformation()) == null) continue;
            for (int i = 0; i < vector.size(); ++i) {
                XMLElement xMLElement = (XMLElement)vector.get(i);
                NodeList nodeList = xMLElement.getChildNodes();
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    XMLNode xMLNode = (XMLNode)nodeList.item(j);
                    if (xMLNode.getNodeType() != 1 || xMLNode.getNamespaceURI() != "http://java.sun.com/xml/ns/jaxb") continue;
                    this.setLoc1(this.customization.getError(), (XMLElement)xMLNode);
                    if (xMLNode.getLocalName() == "globalBindings") {
                        this.customization.setGlobalBindings(xMLNode);
                        continue;
                    }
                    if (xMLNode.getLocalName() != "schemaBindings") continue;
                    if (bl && string2.equals(string)) {
                        this.setLoc1(this.err, (XMLElement)xMLNode);
                        this.err.error0(32202, 0);
                        this.err.flushErrors();
                    }
                    this.customization.setSchemaBindings(xMLNode, string2);
                    bl = true;
                    string = string2;
                }
            }
        }
    }

    private void setJavaPackages(XMLSchema xMLSchema) {
        String[] stringArray = xMLSchema.getAllTargetNS();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("http://www.w3.org/2001/XMLSchema") || stringArray[i].equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
            this.customization.setJavaPackage(stringArray[i], this.targetPkg);
        }
        this.schPackage = this.customization.getJavaPackage();
    }

    private String getClassName(XSDNode xSDNode, int n) throws Exception {
        String string = null;
        String string2 = xSDNode.getName();
        String string3 = this.getPackageName(xSDNode);
        string = this.customization.getClassName(string3, string2, n);
        XSDAnnotation xSDAnnotation = xSDNode.getAnnotation();
        if (xSDAnnotation == null) {
            return string;
        }
        Vector vector = xSDAnnotation.getApplicationInformation();
        if (vector == null) {
            return string;
        }
        boolean bl = false;
        int n2 = vector.size();
        n2 = 1;
        for (int i = 0; i < n2; ++i) {
            XMLElement xMLElement = (XMLElement)vector.get(i);
            NodeList nodeList = xMLElement.getChildNodes();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                XMLNode xMLNode = (XMLNode)nodeList.item(j);
                if (xMLNode.getNodeType() != 1 || xMLNode.getNamespaceURI() != "http://java.sun.com/xml/ns/jaxb" || !xMLNode.getLocalName().equals("class")) continue;
                if (bl) {
                    this.setLoc1(this.err, (XMLElement)xMLNode);
                    this.err.error1(32203, 1, string2);
                    throw new Exception(this.err.getMessage0(32203));
                }
                String string4 = ((XMLElement)xMLNode).getAttribute("name");
                if (string4.indexOf(46) != -1) {
                    this.setLoc1(this.err, (XMLElement)xMLNode);
                    this.err.error1(32204, 1, string4);
                    throw new Exception(this.err.getMessage0(32201));
                }
                if (!string4.equals("")) {
                    string = this.customization.isEnableJavaNamingConventions() ? JaxbUtil.className(string4) : string4;
                    bl = true;
                }
                if ((string4 = ((XMLElement)xMLNode).getAttribute("implClass")).equals("")) continue;
                this.setLoc1(this.err, (XMLElement)xMLNode);
                this.err.error1(32212, 2, string2);
            }
        }
        return string;
    }

    private void bindElementDeclaration(JaxbBindingSchema jaxbBindingSchema, XSDNode xSDNode, boolean bl, JaxbBindingSchema jaxbBindingSchema2, String string, String string2) throws Exception {
        boolean bl2;
        String string3 = xSDNode.getRefLocalname();
        String string4 = this.getPackageName(xSDNode);
        boolean bl3 = ((XSDElement)xSDNode).isNillable();
        XSDNode xSDNode2 = ((XSDElement)xSDNode).getType();
        int n = xSDNode2.getNodeType();
        if (((XSDElement)xSDNode).hasIdentityConstraints() && !this.extensionOption) {
            this.setLoc(this.err, xSDNode);
            this.err.error0(32013, 1);
            throw new Exception(this.err.getMessage0(32013));
        }
        if (n == 5 && !((XSDGroup)xSDNode2).isTopGroup()) {
            n = 1;
        }
        if (jaxbBindingSchema != null) {
            jaxbBindingSchema.setNillable(bl3);
        }
        if (xSDNode2 instanceof XSDComplexType && ((XSDComplexType)xSDNode2).isAbstract()) {
            this.setLoc(this.err, xSDNode2);
            this.err.error2(32011, 1, string3, xSDNode.getName());
            this.err.flushErrors();
        }
        if (xSDNode2 instanceof XSDComplexType && (bl2 = ((XSDComplexType)xSDNode2).isUrType())) {
            String string5 = this.targetPkg != null ? this.targetPkg + "." + "AnyType" : "org.w3._2001.xmlschema.AnyType";
            if (jaxbBindingSchema != null) {
                jaxbBindingSchema.setExtendsNode(string5);
            }
            if (this.bindingSchema.get(string5) != null) {
                return;
            }
            JaxbBindingSchema jaxbBindingSchema3 = this.createAnyTypeBS();
            JaxbProperty jaxbProperty = new JaxbProperty("Content", "", n);
            jaxbProperty.setCollectionType(this.customization.getCollectionType());
            jaxbProperty.setPosition(0);
            jaxbBindingSchema3.addContentProperty(jaxbProperty);
            return;
        }
        if (string3 != null) {
            if (n == 1) {
                String string6 = this.getPackageName(xSDNode);
                String string7 = this.appendClassName(string6, JaxbUtil.className(string3), false);
                if (jaxbBindingSchema != null) {
                    jaxbBindingSchema.setExtendsNode(string7);
                }
            } else if (n == 2) {
                String string8;
                JaxbProperty jaxbProperty = new JaxbProperty("", "", n);
                this.bindSimpleTypeDeclaration(xSDNode2, jaxbProperty);
                if (bl3) {
                    string8 = jaxbProperty.getJavaType();
                    jaxbProperty.setNillable(bl3);
                }
                if ((string8 = this.getTypesafeEnumClassName(xSDNode2)) != null) {
                    string8 = string4 + "." + string8;
                    jaxbProperty.setJavaType(string8);
                }
                boolean bl4 = false;
                if (!bl && ((XSDElement)xSDNode).getMaxOccurs() > 1) {
                    bl4 = true;
                }
                this.customizeProperty(xSDNode, jaxbProperty, bl4, 0);
                this.setSimpleTypeAnnotation(xSDNode, jaxbProperty, false);
                if (jaxbBindingSchema != null) {
                    jaxbBindingSchema.setDataValueType(jaxbProperty);
                }
            }
        } else if (n == 1) {
            XSDNode xSDNode3;
            String string9 = jaxbBindingSchema.getNodeName();
            String string10 = jaxbBindingSchema.getNamespace();
            String string11 = jaxbBindingSchema.getPackageName();
            String string12 = this.customization.getClassName(string11, jaxbBindingSchema.getNodeName(), 9);
            String string13 = JaxbUtil.className(jaxbBindingSchema.getNodeName()) + "Type";
            if (jaxbBindingSchema != null) {
                jaxbBindingSchema.setExtendsNode(this.appendClassName(string, string13, false));
            }
            String string14 = this.appendClassName(string, string12, false);
            String string15 = this.appendClassName(string2, string12, true);
            JaxbBindingSchema jaxbBindingSchema4 = new JaxbBindingSchema(string9, string10, string11, string12, string, string2, 1);
            jaxbBindingSchema4.setAnonymousType(true);
            jaxbBindingSchema4.setSerialVersionUID(this.serialVersionUID);
            jaxbBindingSchema.setExtendsBindingSchema(jaxbBindingSchema4);
            if (((XSDComplexType)xSDNode2).isSimpleContent() && (xSDNode3 = ((XSDComplexType)xSDNode2).getBaseType()).getNodeType() == 2) {
                JaxbProperty jaxbProperty = new JaxbProperty("", "", 2);
                this.bindSimpleTypeDeclaration(xSDNode3, jaxbProperty);
                if (bl3) {
                    String string16 = jaxbProperty.getJavaType();
                    jaxbProperty.setJavaType(JaxbUtil.getJavaWrapperClass(string16));
                    jaxbProperty.setNillable(bl3);
                }
                jaxbBindingSchema4.setDataValueType(jaxbProperty);
                this.customizeProperty(xSDNode, jaxbProperty, ((XSDElement)xSDNode).getMaxOccurs() > 1, 0);
                this.setSimpleTypeAnnotation(xSDNode, jaxbProperty, false);
            }
            if (!bl) {
                jaxbBindingSchema4.setGlobal(true);
            }
            this.bindComplexTypeDeclaration(jaxbBindingSchema4, xSDNode2, string14, string15);
            this.putBindingSchema(string14, jaxbBindingSchema4);
            if (bl) {
                jaxbBindingSchema2.addInnerInterface(jaxbBindingSchema4);
            }
        } else if (n == 2) {
            JaxbProperty jaxbProperty = new JaxbProperty("", "", 2);
            this.bindSimpleTypeDeclaration(xSDNode2, jaxbProperty);
            if (bl3) {
                String string17 = jaxbProperty.getJavaType();
                jaxbProperty.setJavaType(JaxbUtil.getJavaWrapperClass(string17));
                jaxbProperty.setNillable(bl3);
            }
            if (jaxbBindingSchema != null) {
                jaxbBindingSchema.setDataValueType(jaxbProperty);
            }
            this.customizeProperty(xSDNode, jaxbProperty, ((XSDElement)xSDNode).getMaxOccurs() > 1, 0);
            this.setSimpleTypeAnnotation(xSDNode, jaxbProperty, false);
        }
    }

    private void bindSimpleTypeDeclaration(XSDNode xSDNode, JaxbProperty jaxbProperty) throws Exception {
        this.setTargetJavaDataType(xSDNode, jaxbProperty);
    }

    private void bindComplexTypeDeclaration(JaxbBindingSchema jaxbBindingSchema, XSDNode xSDNode, String string, String string2) throws Exception {
        Object object;
        int n = 0;
        String string3 = xSDNode.getRefLocalname();
        if (string3 != null && string3.intern() != "anyType" && !((XSDComplexType)xSDNode).isSimpleContent()) {
            object = null;
            object = this.getPackageName(xSDNode);
            String string4 = this.appendClassName((String)object, JaxbUtil.className(string3), false);
            jaxbBindingSchema.setExtendsNode(string4);
        }
        object = this.getInnerLocalAttributes(xSDNode);
        this.bindComplexTypeLocalAttributes(jaxbBindingSchema, (XSDNode[])object, xSDNode);
        int n2 = ((XSDComplexType)xSDNode).getContent();
        XSDNode xSDNode2 = ((XSDComplexType)xSDNode).getBaseType();
        if (xSDNode2.getName() != null && xSDNode2.getName() != "anyType") {
            String string5 = this.getPackageName(xSDNode2);
            if (xSDNode2.getNodeType() == 1) {
                jaxbBindingSchema.setExtendsNode(this.appendClassName(string5, JaxbUtil.className(xSDNode2.getName()), false));
            }
            XSDNode[] xSDNodeArray = this.getInnerLocalElements(xSDNode);
            if (n2 == 13) {
                JaxbProperty jaxbProperty;
                int n3;
                jaxbBindingSchema.setMixedContent(true);
                for (n3 = 0; n3 < xSDNodeArray.length; ++n3) {
                    this.bindRepeatingModelGroup(jaxbBindingSchema, null, xSDNodeArray[n3], string, string2, n);
                }
                n3 = xSDNode2.getNodeType();
                if (n3 == 5) {
                    if (!((XSDGroup)xSDNode2).isTopGroup()) {
                        n3 = 1;
                    }
                    jaxbProperty = new JaxbProperty("Content", "", n3);
                    jaxbProperty.populateChildElemList((XSDGroup)xSDNode2);
                } else {
                    jaxbProperty = new JaxbProperty("Content", "", n3);
                }
                jaxbProperty.setCollectionType(this.customization.getCollectionType());
                jaxbProperty.setDerivedList(true);
                jaxbProperty.setPosition(n++);
                jaxbProperty.setInnerInterface(true);
                jaxbBindingSchema.addContentProperty(jaxbProperty);
                return;
            }
            for (int i = 0; i < xSDNodeArray.length; ++i) {
                XSDNode xSDNode3 = xSDNodeArray[i];
                if (xSDNode3 instanceof XSDGroup) {
                    n = this.bindSingletonModelGroup(jaxbBindingSchema, (XSDGroup)xSDNode3, string, string2, n);
                    continue;
                }
                if (xSDNode3 instanceof XSDAny) {
                    this.bindAny(jaxbBindingSchema, xSDNode3, n++);
                    continue;
                }
                this.bindModelGroupLocalElements(jaxbBindingSchema, 0, xSDNode3, string, string2, n++);
            }
            return;
        }
        XSDGroup xSDGroup = ((XSDComplexType)xSDNode).getTypeGroup();
        if (xSDGroup == null) {
            return;
        }
        if (n2 == 13 || xSDGroup.getMaxOccurs() > 1) {
            XSDNode[] xSDNodeArray = this.getInnerLocalElements(xSDNode);
            for (int i = 0; i < xSDNodeArray.length; ++i) {
                XSDNode xSDNode4 = xSDNodeArray[i];
                if (xSDNode4 instanceof XSDAny) continue;
                this.bindRepeatingModelGroup(jaxbBindingSchema, null, xSDNode4, string, string2, n);
            }
            String string6 = null;
            if (n2 == 13) {
                jaxbBindingSchema.setMixedContent(true);
                string6 = "Content";
            } else {
                string6 = this.getCollectionListName(xSDGroup);
            }
            JaxbProperty jaxbProperty = new JaxbProperty(string6, "", xSDGroup.getNodeType());
            jaxbProperty.populateChildElemList(xSDGroup);
            jaxbProperty.setJavaType("java.lang.Object");
            jaxbProperty.setDerivedList(true);
            jaxbProperty.setCollectionType(this.customization.getCollectionType());
            jaxbProperty.setPosition(n++);
            jaxbProperty.setInnerInterface(true);
            jaxbBindingSchema.addContentProperty(jaxbProperty);
        } else {
            String string7;
            if (xSDGroup.getAnnotation() != null && (string7 = this.getGroupClassNameAnnotation(xSDGroup)) != null) {
                String string8 = xSDGroup.getRefLocalname();
                String string9 = xSDGroup.getTargetNS();
                String string10 = null;
                string10 = this.getPackageName((XSDNode)xSDGroup);
                String string11 = this.appendClassName(string, string7, false);
                JaxbProperty jaxbProperty = string8 != null ? new JaxbProperty(string8, string9, 5) : new JaxbProperty(this.getCollectionListName(xSDGroup), string9, 5);
                jaxbProperty.setJavaType(string11);
                jaxbProperty.setPosition(n++);
                jaxbProperty.setInnerInterface(true);
                jaxbBindingSchema.addContentProperty(jaxbProperty);
                JaxbBindingSchema jaxbBindingSchema2 = new JaxbBindingSchema(string8, string9, string10, string7, string, string2, 5);
                jaxbBindingSchema2.setCustomizationSet(0);
                jaxbBindingSchema2.setSerialVersionUID(this.serialVersionUID);
                this.bindGroupDeclaration(jaxbBindingSchema2, (XSDNode)xSDGroup, string, string2);
                jaxbBindingSchema.addInnerInterface(jaxbBindingSchema2);
                return;
            }
            if (xSDGroup.getRefLocalname() != null) {
                string7 = this.getPackageName((XSDNode)xSDGroup);
                String string12 = xSDGroup.getRefLocalname();
                String string13 = string7 + "." + JaxbUtil.className(string12);
                JaxbBindingSchema jaxbBindingSchema3 = (JaxbBindingSchema)this.bindingSchema.get(string13);
                if (jaxbBindingSchema3 != null) {
                    JaxbProperty jaxbProperty = new JaxbProperty(string12, "", 5);
                    jaxbProperty.setDerivedList(false);
                    jaxbProperty.setDataType("", string7 + "." + jaxbBindingSchema3.getClassName());
                    jaxbProperty.setPosition(n++);
                    jaxbProperty.setInnerInterface(false);
                    jaxbBindingSchema.addContentProperty(jaxbProperty);
                    return;
                }
            }
            n = this.bindSingletonModelGroup(jaxbBindingSchema, xSDGroup, string, string2, n);
        }
    }

    private void bindGroupDeclaration(JaxbBindingSchema jaxbBindingSchema, XSDNode xSDNode, String string, String string2) throws Exception {
        int n = 0;
        XSDGroup xSDGroup = (XSDGroup)xSDNode;
        if (xSDGroup.getMaxOccurs() > 1) {
            String string3 = this.getCollectionListName(xSDGroup);
            this.bindModelGroupLocalElements(jaxbBindingSchema, xSDGroup.getOrder(), xSDNode, string, string2, n++);
            JaxbProperty jaxbProperty = new JaxbProperty(string3, "", 5);
            jaxbProperty.populateChildElemList(xSDGroup);
            jaxbProperty.setDerivedList(true);
            jaxbProperty.setCollectionType(this.customization.getCollectionType());
            jaxbProperty.setPosition(n++);
            jaxbProperty.setInnerInterface(true);
            jaxbBindingSchema.addContentProperty(jaxbProperty);
        } else {
            n = this.bindSingletonModelGroup(jaxbBindingSchema, xSDGroup, string, string2, n);
        }
    }

    String getGroupClassNameAnnotation(XSDGroup xSDGroup) throws Exception {
        String string = null;
        String string2 = null;
        boolean bl = false;
        XSDAnnotation xSDAnnotation = xSDGroup.getAnnotation();
        if (xSDAnnotation == null) {
            return null;
        }
        Vector vector = xSDAnnotation.getApplicationInformation();
        if (vector == null) {
            return null;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement = (XMLElement)vector.get(i);
            NodeList nodeList = xMLElement.getChildNodes();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                XMLNode xMLNode = (XMLNode)nodeList.item(j);
                if (xMLNode.getNodeType() != 1 || xMLNode.getNamespaceURI() != "http://java.sun.com/xml/ns/jaxb" || !(string2 = xMLNode.getLocalName()).equals("class")) continue;
                if (bl) {
                    this.setLoc1(this.err, (XMLElement)xMLNode);
                    this.err.error1(32203, 1, "group");
                    throw new Exception(this.err.getMessage0(32203));
                }
                String string3 = ((XMLElement)xMLNode).getAttribute("name");
                if (string3.equals("")) {
                    string3 = xSDGroup.getName();
                }
                if (string3.indexOf(46) != -1) {
                    this.setLoc1(this.err, (XMLElement)xMLNode);
                    this.err.error1(32204, 1, string3);
                    throw new Exception(this.err.getMessage0(32201));
                }
                string = this.customization.isEnableJavaNamingConventions() ? JaxbUtil.className(string3) : string3;
                bl = true;
            }
        }
        return string;
    }

    private void bindRepeatingModelGroup(JaxbBindingSchema jaxbBindingSchema, XSDGroup xSDGroup, XSDNode xSDNode, String string, String string2, int n) throws Exception {
        if (xSDNode instanceof XSDGroup) {
            String string3 = JaxbUtil.className(xSDNode.getRefLocalname());
            Vector vector = ((XSDGroup)xSDNode).getNodeVector();
            int n2 = vector.size();
            XSDNode xSDNode2 = null;
            for (int i = 0; i < n2; ++i) {
                xSDNode2 = (XSDNode)vector.elementAt(i);
                String string4 = xSDNode2.getName();
                String string5 = xSDNode2.getTargetNS();
                String string6 = this.getPackageName(xSDNode2);
                String string7 = string3 + JaxbUtil.className(string4);
                String string8 = (String)this.className.get(string7);
                if (string8 != null && string8.equals(string6)) {
                    this.setLoc(this.err, xSDNode2);
                    this.err.error0(32002, 1);
                    this.err.flushErrors();
                }
                JaxbBindingSchema jaxbBindingSchema2 = new JaxbBindingSchema(string4, string5, string6, string7, string, string2, 3);
                jaxbBindingSchema2.setSerialVersionUID(this.serialVersionUID);
                this.putBindingSchema(string + "." + string7, jaxbBindingSchema2);
            }
            return;
        }
        if (xSDNode instanceof XSDElement && ((XSDElement)xSDNode).getRefState() == 0 && xSDGroup != null) {
            return;
        }
        String string9 = null;
        if (xSDGroup != null && (string9 = xSDGroup.getRefLocalname()) != null) {
            string9 = JaxbUtil.className(string9);
        }
        String string10 = xSDNode.getName();
        String string11 = xSDNode.getTargetNS();
        String string12 = this.getClassName(xSDNode, 3);
        String string13 = this.getPackageName(xSDNode);
        if (string9 != null) {
            string12 = string9 + string12;
            String string14 = string13 + "." + JaxbUtil.className(string10);
            if (this.bindingSchema.get(string14) == null) {
                JaxbBindingSchema jaxbBindingSchema3 = new JaxbBindingSchema(string10, string11, string13, string12, null, null, 3);
                jaxbBindingSchema3.setGlobal(true);
                jaxbBindingSchema3.setSerialVersionUID(this.serialVersionUID);
                this.bindElementDeclaration(jaxbBindingSchema3, xSDNode, false, null, string13, string13);
                this.putBindingSchema(jaxbBindingSchema3);
            }
        } else {
            JaxbBindingSchema jaxbBindingSchema4 = new JaxbBindingSchema(string10, string11, string13, string12, string, string2, 3);
            jaxbBindingSchema4.setPosition(n);
            jaxbBindingSchema4.setSerialVersionUID(this.serialVersionUID);
            this.bindElementDeclaration(jaxbBindingSchema4, xSDNode, true, jaxbBindingSchema, string, string2);
            jaxbBindingSchema.addInnerInterface(jaxbBindingSchema4);
            if (((XSDElement)xSDNode).getRefState() == 0) {
                jaxbBindingSchema4.setIsRefType(true);
            } else {
                jaxbBindingSchema4.setIsRefType(false);
            }
        }
    }

    private int bindSingletonModelGroup(JaxbBindingSchema jaxbBindingSchema, XSDGroup xSDGroup, String string, String string2, int n) throws Exception {
        XSDNode xSDNode = null;
        Vector vector = xSDGroup.getNodeVector();
        int n2 = vector.size();
        if (xSDGroup.getOrder() == 1) {
            jaxbBindingSchema.setWrapsChoice(true);
        }
        for (int i = 0; i < n2; ++i) {
            xSDNode = (XSDNode)vector.elementAt(i);
            if (xSDNode instanceof XSDGroup) {
                Object object;
                Object object2;
                XSDGroup xSDGroup2 = (XSDGroup)xSDNode;
                String string3 = xSDGroup2.getRefLocalname();
                string3 = string3 == null ? this.getCollectionListName(xSDGroup2) : JaxbUtil.className(string3);
                if (xSDGroup2.getMaxOccurs() > 1) {
                    object2 = xSDGroup2.getNodeVector();
                    int n3 = ((Vector)object2).size();
                    for (int j = 0; j < n3; ++j) {
                        if (xSDGroup2.getRefLocalname() != null) {
                            this.bindRepeatingModelGroup(jaxbBindingSchema, xSDGroup2, (XSDNode)((Vector)object2).elementAt(j), string, string2, n);
                            continue;
                        }
                        this.bindRepeatingModelGroup(jaxbBindingSchema, null, (XSDNode)((Vector)object2).elementAt(j), string, string2, n);
                    }
                    object = new JaxbProperty(string3, "", 5);
                    ((JaxbProperty)object).populateChildElemList(xSDGroup2);
                    ((JaxbProperty)object).setDerivedList(true);
                    ((JaxbProperty)object).setCollectionType(this.customization.getCollectionType());
                    ((JaxbProperty)object).setPosition(n++);
                    jaxbBindingSchema.addContentProperty((JaxbProperty)object);
                    continue;
                }
                String string4 = this.getPackageName(xSDNode);
                object2 = this.getGroupClassNameAnnotation(xSDGroup2);
                if (object2 != null) {
                    object = new JaxbProperty(string3, "", 5);
                    ((JaxbProperty)object).setDerivedList(false);
                    ((JaxbProperty)object).setDataType("", string4 + "." + (String)object2);
                    ((JaxbProperty)object).setPosition(n++);
                    ((JaxbProperty)object).setInnerInterface(false);
                    jaxbBindingSchema.addContentProperty((JaxbProperty)object);
                    continue;
                }
                object2 = xSDGroup2.getRefLocalname();
                if (object2 != null) {
                    object = string4 + "." + (String)object2;
                    JaxbBindingSchema jaxbBindingSchema2 = (JaxbBindingSchema)this.bindingSchema.get(object);
                    if (jaxbBindingSchema2 != null) {
                        JaxbProperty jaxbProperty = new JaxbProperty((String)object2, "", 5);
                        jaxbProperty.setDerivedList(false);
                        jaxbProperty.setDataType("", string4 + "." + jaxbBindingSchema2.getClassName());
                        jaxbProperty.setPosition(n++);
                        jaxbProperty.setInnerInterface(false);
                        jaxbBindingSchema.addContentProperty(jaxbProperty);
                        continue;
                    }
                    n = this.bindSingletonModelGroup(jaxbBindingSchema, xSDGroup2, string, string2, n);
                    continue;
                }
                n = this.bindSingletonModelGroup(jaxbBindingSchema, xSDGroup2, string, string2, n);
                continue;
            }
            if (xSDNode instanceof XSDAny) {
                this.bindAny(jaxbBindingSchema, xSDNode, n++);
                continue;
            }
            this.bindModelGroupLocalElements(jaxbBindingSchema, xSDGroup.getOrder(), xSDNode, string, string2, n++);
        }
        return n;
    }

    private void bindAny(JaxbBindingSchema jaxbBindingSchema, XSDNode xSDNode, int n) throws Exception {
        XSDAnnotation xSDAnnotation = xSDNode.getAnnotation();
        JaxbProperty jaxbProperty = new JaxbProperty("any", xSDNode.getTargetNS(), xSDNode.getNodeType());
        this.customizeProperty(xSDNode, jaxbProperty, ((XSDAny)xSDNode).getMaxOccurs() > 1, 0);
        jaxbProperty.setDataType("any", "java.lang.Object", this.customization);
        jaxbProperty.setPosition(n);
        if (jaxbBindingSchema.containsContentProperty("any")) {
            this.setLoc(this.err, xSDNode);
            this.err.error1(32010, 1, "any");
            this.err.flushErrors();
        } else {
            jaxbBindingSchema.addContentProperty(jaxbProperty);
        }
    }

    private void bindModelGroupLocalElements(JaxbBindingSchema jaxbBindingSchema, int n, XSDNode xSDNode, String string, String string2, int n2) throws Exception {
        Object object;
        XSDNode xSDNode2 = null;
        Object var17_8 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        Object var24_13 = null;
        Object var25_14 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        String string5 = xSDNode.getName();
        String string6 = xSDNode.getTargetNS();
        String string7 = xSDNode.getRefLocalname();
        xSDNode2 = ((XSDElement)xSDNode).getType();
        String string8 = xSDNode2.getName();
        String string9 = xSDNode2.getTargetNS();
        int n3 = xSDNode2.getNodeType();
        if (n3 == 5 && !((XSDGroup)xSDNode2).isTopGroup()) {
            n3 = 1;
        }
        String string10 = ((XSDElement)xSDNode).getFixedVal();
        String string11 = ((XSDElement)xSDNode).getDefaultVal();
        bl2 = ((XSDElement)xSDNode).isNillable();
        JaxbProperty jaxbProperty = new JaxbProperty(string5, string6, n3);
        jaxbProperty.setNillable(bl2);
        if (string11 != null) {
            jaxbProperty.setDefaultValue(string11);
        }
        int n4 = ((XSDParticleNode)xSDNode).getMaxOccurs();
        jaxbProperty.setPosition(n2);
        if (string8 == null && n3 == 1) {
            this.customizeProperty(xSDNode, jaxbProperty, n4 > 1, 0);
        } else {
            this.customizeProperty(xSDNode, jaxbProperty, n4 > 1, 1);
        }
        if (n4 > 1) {
            jaxbProperty.populateChildElemList(xSDNode.getTargetNS(), xSDNode.getName());
        }
        if (xSDNode2 instanceof XSDComplexType && ((XSDComplexType)xSDNode2).isUrType()) {
            String string12 = this.targetPkg != null ? this.targetPkg + "." + "AnyType" : "org.w3._2001.xmlschema.AnyType";
            jaxbProperty.setDataType("anyType", string12);
            jaxbBindingSchema.addContentProperty(jaxbProperty);
            if (this.bindingSchema.get(string12) != null) {
                return;
            }
            JaxbBindingSchema jaxbBindingSchema2 = this.createAnyTypeBS();
            JaxbProperty jaxbProperty2 = new JaxbProperty("Content", "", xSDNode2.getNodeType());
            jaxbProperty2.setCollectionType(this.customization.getCollectionType());
            jaxbProperty2.setPosition(0);
            jaxbBindingSchema2.addContentProperty(jaxbProperty2);
            return;
        }
        if (string5.equals(xSDNode.getRefLocalname())) {
            String string13 = this.getPackageName(xSDNode2);
            if (n3 == 1) {
                if (string8 != null) {
                    string4 = JaxbUtil.className(string8);
                    string3 = string13 + "." + string4;
                    jaxbProperty.setDataType(string8, string3);
                } else {
                    string4 = JaxbUtil.className(string5);
                    string3 = string13 + "." + this.customization.getClassName(string13, string5, 9);
                    jaxbProperty.setDataType(string5, string3);
                }
            } else if (n3 == 2) {
                this.bindSimpleTypeDeclaration(xSDNode, jaxbProperty);
                if (bl2) {
                    object = jaxbProperty.getJavaType();
                    jaxbProperty.setJavaType(JaxbUtil.getJavaWrapperClass((String)object));
                    jaxbProperty.setNillable(true);
                }
            }
            this.setSimpleTypeAnnotation(xSDNode, jaxbProperty, false);
        } else if (string8 == null) {
            String string14 = this.getPackageName(xSDNode2);
            if (n3 == 1) {
                XSDNode xSDNode3;
                String string15 = this.getClassName(xSDNode, 9);
                object = new JaxbBindingSchema(string5, string6, string14, string15, string, string2, 1);
                ((JaxbBindingSchema)object).setSerialVersionUID(this.serialVersionUID);
                string = this.appendClassName(string, string15, false);
                string2 = this.appendClassName(string2, string15, true);
                if (((XSDComplexType)xSDNode2).isSimpleContent() && (xSDNode3 = ((XSDComplexType)xSDNode2).getBaseType()).getNodeType() == 2) {
                    JaxbProperty jaxbProperty3 = new JaxbProperty("", "", n3);
                    this.bindSimpleTypeDeclaration(xSDNode3, jaxbProperty3);
                    if (bl2) {
                        String string16 = jaxbProperty3.getJavaType();
                        jaxbProperty3.setJavaType(JaxbUtil.getJavaWrapperClass(string16));
                        jaxbProperty3.setNillable(bl2);
                    }
                    ((JaxbBindingSchema)object).setDataValueType(jaxbProperty3);
                }
                jaxbBindingSchema.addInnerInterface((JaxbBindingSchema)object);
                this.bindComplexTypeDeclaration((JaxbBindingSchema)object, xSDNode2, string, string2);
                bl = true;
                jaxbProperty.setInnerInterface(true);
                jaxbProperty.setDataType(null, string, this.customization);
            } else if (n3 == 2) {
                if (xSDNode2.getAnnotation() != null) {
                    this.setSimpleTypeAnnotation(xSDNode2, jaxbProperty, true);
                } else {
                    this.bindSimpleTypeDeclaration(xSDNode2, jaxbProperty);
                    if (bl2) {
                        object = jaxbProperty.getJavaType();
                        jaxbProperty.setJavaType(JaxbUtil.getJavaWrapperClass((String)object));
                        jaxbProperty.setNillable(bl2);
                    }
                }
            }
        } else {
            String string17 = this.getPackageName(xSDNode2);
            if (n3 == 1) {
                string4 = JaxbUtil.className(string8);
                string3 = string17 + "." + string4;
                jaxbProperty.setDataType(string8, string3, this.customization);
            } else {
                this.bindSimpleTypeDeclaration(xSDNode, jaxbProperty);
                if (bl2) {
                    object = jaxbProperty.getJavaType();
                    jaxbProperty.setJavaType(JaxbUtil.getJavaWrapperClass((String)object));
                    jaxbProperty.setNillable(true);
                }
            }
        }
        object = jaxbProperty.getCusName();
        if (string10 != null && jaxbProperty.isFixedAttrAsConstantProperty()) {
            if (jaxbBindingSchema.containsFixedProperty((String)object)) {
                this.setLoc(this.err, xSDNode);
                this.err.error1(32010, 1, (String)object);
                this.err.flushErrors();
            } else {
                jaxbBindingSchema.addFixedProperty(jaxbProperty);
            }
        } else if (jaxbBindingSchema.containsContentProperty((String)object)) {
            if (n == 0) {
                this.setLoc(this.err, xSDNode);
                this.err.error1(32010, 1, (String)object);
                this.err.flushErrors();
            }
        } else {
            if (xSDNode instanceof XSDElement) {
                jaxbProperty.setSubstitutionGroup(((XSDElement)xSDNode).getSubstitutionGroup());
            }
            jaxbBindingSchema.addContentProperty(jaxbProperty);
        }
    }

    private void bindComplexTypeLocalAttributes(JaxbBindingSchema jaxbBindingSchema, XSDNode[] xSDNodeArray, XSDNode xSDNode) throws Exception {
        Object var8_4 = null;
        boolean bl = false;
        Object var12_6 = null;
        for (int i = 0; xSDNodeArray != null && i < xSDNodeArray.length; ++i) {
            XSDNode xSDNode2 = xSDNodeArray[i];
            String string = xSDNode2.getName();
            String string2 = xSDNode2.getTargetNS();
            var12_6 = null;
            bl = false;
            String string3 = ((XSDAttribute)xSDNode2).getFixedVal();
            String string4 = ((XSDAttribute)xSDNode2).getDefaultVal();
            int n = xSDNode2.getNodeType();
            JaxbProperty jaxbProperty = new JaxbProperty(string, string2, n);
            if (string4 != null) {
                jaxbProperty.setDefaultValue(string4);
            }
            this.customizeProperty(xSDNode2, jaxbProperty, false, 1);
            this.setSimpleTypeAnnotation(xSDNode2, jaxbProperty, false);
            if (string == null) continue;
            this.setTargetJavaDataType(xSDNode2, jaxbProperty);
            String string5 = jaxbProperty.getCusName();
            if (((XSDComplexType)xSDNode).isSimpleContent() && (string5.equals("value") || string5.equals("Value"))) {
                this.setLoc(this.err, xSDNode2);
                this.err.error1(32010, 1, string5);
                this.err.flushErrors();
            }
            if (string3 != null && jaxbProperty.isFixedAttrAsConstantProperty()) {
                if (jaxbBindingSchema.containsFixedProperty(string5)) {
                    this.setLoc(this.err, xSDNode2);
                    this.err.error1(32010, 1, string5);
                    this.err.flushErrors();
                    continue;
                }
                jaxbBindingSchema.addFixedProperty(jaxbProperty);
                continue;
            }
            if (jaxbBindingSchema.containsAttrProperty(string5)) {
                this.setLoc(this.err, xSDNode2);
                this.err.error1(32010, 1, string5);
                this.err.flushErrors();
                continue;
            }
            jaxbBindingSchema.addAttrProperty(jaxbProperty);
        }
    }

    private void customizeProperty(XSDNode xSDNode, JaxbProperty jaxbProperty, boolean bl, int n) throws Exception {
        XSDAnnotation xSDAnnotation;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (xSDNode instanceof XSDElement) {
            string3 = ((XSDElement)xSDNode).getFixedVal();
        } else if (xSDNode instanceof XSDAttribute) {
            string3 = ((XSDAttribute)xSDNode).getFixedVal();
        }
        if (bl) {
            jaxbProperty.setCollectionType(this.customization.getCollectionType());
        }
        if (string3 != null && this.customization.isFixedAttrAsConstantProperty()) {
            jaxbProperty.setFixedAttrAsConstantProperty(true);
            jaxbProperty.setFixedValue(string3);
        }
        if (this.customization.isGenerateIsSetMethod()) {
            jaxbProperty.setGenerateIsSetMethod(true);
        }
        if (xSDNode instanceof XSDElement) {
            xSDAnnotation = ((XSDElement)xSDNode).getRefAnnotation();
            if (xSDAnnotation == null) {
                xSDAnnotation = xSDNode.getAnnotation();
            }
        } else if (xSDNode instanceof XSDAttribute) {
            xSDAnnotation = ((XSDAttribute)xSDNode).getRefAnnotation();
            if (xSDAnnotation == null) {
                xSDAnnotation = xSDNode.getAnnotation();
            }
        } else {
            xSDAnnotation = xSDNode.getAnnotation();
        }
        if (xSDAnnotation == null) {
            return;
        }
        Vector vector = xSDAnnotation.getApplicationInformation();
        if (vector == null) {
            return;
        }
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            XMLElement xMLElement = (XMLElement)vector.get(i);
            NodeList nodeList = xMLElement.getChildNodes();
            boolean bl2 = false;
            for (int j = 0; j < nodeList.getLength(); ++j) {
                XMLNode xMLNode = (XMLNode)nodeList.item(j);
                if (xMLNode.getNodeType() != 1 || xMLNode.getNamespaceURI() != "http://java.sun.com/xml/ns/jaxb") continue;
                if (xMLNode.getLocalName().equals("property")) {
                    if (bl2) {
                        this.setLoc1(this.err, (XMLElement)xMLNode);
                        this.err.error1(32205, 1, xSDNode.getName());
                        throw new Exception(this.err.getMessage0(32205));
                    }
                    bl2 = true;
                    string = ((XMLElement)xMLNode).getAttribute("name");
                    if (!string.equals("")) {
                        jaxbProperty.setCusName(string);
                    }
                    if (!(string2 = ((XMLElement)xMLNode).getAttribute("fixedAttributeAsConstantProperty")).equals("") && xSDNode instanceof XSDAttribute) {
                        if (!(string2.equals("true") || string2.equals("false") || string2.equals("1") || string2.equals("0"))) {
                            this.setLoc1(this.err, (XMLElement)xMLNode);
                            this.err.error1(32210, 1, "fixedAttributeAsConstantProperty");
                            throw new Exception(this.err.getMessage0(32210));
                        }
                        if (string2.equals("true") || string2.equals("1")) {
                            jaxbProperty.setFixedAttrAsConstantProperty(true);
                            jaxbProperty.setFixedValue(string3);
                        }
                    }
                    if (!(string2 = ((XMLElement)xMLNode).getAttribute("generateIsSetMethod")).equals("")) {
                        if (!(string2.equals("true") || string2.equals("false") || string2.equals("1") || string2.equals("0"))) {
                            this.setLoc1(this.err, (XMLElement)xMLNode);
                            this.err.error1(32210, 1, "generateIsSetMethod");
                            throw new Exception(this.err.getMessage0(32210));
                        }
                        if (string2.equals("true") || string2.equals("1")) {
                            jaxbProperty.setGenerateIsSetMethod(true);
                        }
                    }
                    if (!bl || (string2 = ((XMLElement)xMLNode).getAttribute("collectionType")).equals("")) continue;
                    jaxbProperty.setCollectionType(string2);
                    continue;
                }
                if (!xMLNode.getLocalName().equals("class") || (n & 1) == 0) continue;
                this.setLoc1(this.err, (XMLElement)xMLNode);
                this.err.error1(32216, 1, xSDNode.getName());
                throw new Exception(this.err.getMessage0(32216));
            }
        }
    }

    private boolean setSimpleTypeAnnotation(XSDNode xSDNode, JaxbProperty jaxbProperty, boolean bl) throws Exception {
        Object object;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        XSDAnnotation xSDAnnotation = xSDNode.getAnnotation();
        if (xSDAnnotation == null) {
            object = xSDNode.getRefAnnotation();
            if (object == null) {
                return false;
            }
            xSDAnnotation = object;
        }
        if ((object = xSDAnnotation.getApplicationInformation()) == null) {
            return false;
        }
        int n = ((Vector)object).size();
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement = (XMLElement)((Vector)object).get(i);
            NodeList nodeList = xMLElement.getChildNodes();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                XMLNode xMLNode = (XMLNode)nodeList.item(j);
                if (xMLNode.getNodeType() != 1 || xMLNode.getNamespaceURI() != "http://java.sun.com/xml/ns/jaxb" || xMLNode.getLocalName().equals("javadoc") || xMLNode.getLocalName().equals("typesafeEnumClass")) continue;
                if (bl) {
                    if (!xMLNode.getLocalName().equals("javaType")) {
                        this.setLoc1(this.err, (XMLElement)xMLNode);
                        this.err.error1(32206, 1, xMLNode.getLocalName());
                        throw new Exception(this.err.getMessage0(32206));
                    }
                    string = ((XMLElement)xMLNode).getAttribute("name");
                    string2 = ((XMLElement)xMLNode).getAttribute("parseMethod");
                    if (string2.equals("")) {
                        string2 = JaxbUtil.getParseMethod(string);
                    } else {
                        jaxbProperty.setIsCusParseMethod(true);
                    }
                    string3 = ((XMLElement)xMLNode).getAttribute("printMethod");
                    if (string3.equals("")) {
                        string3 = JaxbUtil.getPrintMethod(string);
                    } else {
                        jaxbProperty.setIsCusPrintMethod(true);
                    }
                    jaxbProperty.setDataType(xSDNode.getName(), string, string2, string3);
                    bl2 = true;
                    continue;
                }
                if (!xMLNode.getLocalName().equals("property") && !xMLNode.getLocalName().equals("class")) {
                    this.setLoc1(this.err, (XMLElement)xMLNode);
                    this.err.error1(32205, 1, xMLNode.getLocalName());
                    throw new Exception(this.err.getMessage0(32205));
                }
                NodeList nodeList2 = ((XMLElement)xMLNode).getElementsByTagNameNS("http://java.sun.com/xml/ns/jaxb", "baseType");
                if (nodeList2 == null || nodeList2.getLength() == 0) {
                    nodeList2 = ((XMLElement)xMLNode).getElementsByTagNameNS("http://java.sun.com/xml/ns/jaxb", "javaType");
                    if (nodeList2.getLength() == 0) continue;
                    this.setLoc1(this.err, (XMLElement)xMLNode);
                    this.err.error1(32207, 1, xMLNode.getLocalName());
                    throw new Exception(this.err.getMessage0(32207));
                }
                if (nodeList2.getLength() > 1) {
                    this.setLoc1(this.err, (XMLElement)xMLNode);
                    this.err.error1(32208, 1, xMLNode.getLocalName());
                    throw new Exception(this.err.getMessage0(32208));
                }
                xMLNode = (XMLNode)nodeList2.item(0);
                if ((nodeList2 = ((XMLElement)xMLNode).getElementsByTagNameNS("http://java.sun.com/xml/ns/jaxb", "javaType")) == null || nodeList2.getLength() == 0) {
                    this.setLoc1(this.err, (XMLElement)xMLNode);
                    this.err.error1(32206, 1, xMLNode.getLocalName());
                    throw new Exception(this.err.getMessage0(32206));
                }
                if (nodeList2.getLength() > 1) {
                    this.setLoc1(this.err, (XMLElement)xMLNode);
                    this.err.error1(32209, 1, xMLNode.getLocalName());
                    throw new Exception(this.err.getMessage0(32209));
                }
                xMLNode = (XMLNode)nodeList2.item(0);
                string = ((XMLElement)xMLNode).getAttribute("name");
                string2 = ((XMLElement)xMLNode).getAttribute("parseMethod");
                if (string2.equals("")) {
                    string2 = JaxbUtil.getParseMethod(string);
                } else {
                    jaxbProperty.setIsCusParseMethod(true);
                }
                string3 = ((XMLElement)xMLNode).getAttribute("printMethod");
                if (string3.equals("")) {
                    string3 = JaxbUtil.getPrintMethod(string);
                } else {
                    jaxbProperty.setIsCusPrintMethod(true);
                }
                jaxbProperty.setDataType(xSDNode.getName(), string, string2, string3);
                bl2 = true;
            }
        }
        return bl2;
    }

    private String getCollectionListName(XSDGroup xSDGroup) {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        XSDAnnotation xSDAnnotation = xSDGroup.getAnnotation();
        if (xSDAnnotation != null && (object = xSDAnnotation.getApplicationInformation()) != null) {
            n2 = ((Vector)object).size();
            for (n = 0; n < n2; ++n) {
                XMLElement xMLElement = (XMLElement)((Vector)object).get(n);
                NodeList nodeList = xMLElement.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string;
                    XMLNode xMLNode = (XMLNode)nodeList.item(i);
                    if (xMLNode.getNodeType() != 1 || xMLNode.getNamespaceURI() != "http://java.sun.com/xml/ns/jaxb" || !xMLNode.getLocalName().equals("property") || (string = ((XMLElement)xMLNode).getAttribute("name")).equals("")) continue;
                    return string;
                }
            }
        }
        object = new ModelGrpNamMap(xSDGroup);
        for (n = 0; n < 3; ++n) {
            stringBuffer.append(((ModelGrpNamMap)object).nextTerm());
            if (n == 2) continue;
            stringBuffer.append(((ModelGrpNamMap)object).nextCompositor());
        }
        return stringBuffer.toString();
    }

    private String getCompositor(int n) {
        switch (n) {
            case 0: {
                return "And";
            }
            case 1: {
                return "Or";
            }
            case 2: {
                return "And";
            }
        }
        return "";
    }

    private XSDNode[] getInnerLocalElements(XSDNode xSDNode) {
        Object[] objectArray;
        XSDNode[] xSDNodeArray = ((XSDComplexType)xSDNode).getElementSet();
        Vector vector = new Vector();
        if (xSDNodeArray != null) {
            for (int i = 0; i < xSDNodeArray.length; ++i) {
                if (xSDNodeArray[i] instanceof XSDGroup) {
                    vector = this.getGroupElements(xSDNodeArray[i], vector);
                    continue;
                }
                vector.addElement(xSDNodeArray[i]);
            }
        }
        XSDNode[] xSDNodeArray2 = null;
        if (((XSDComplexType)xSDNode).getDerivationMethod() > 0) {
            objectArray = ((XSDComplexType)xSDNode).getBaseType();
            if (objectArray != null && objectArray instanceof XSDComplexType) {
                xSDNodeArray2 = ((XSDComplexType)objectArray).getElementSet();
            }
            if (xSDNodeArray2 != null) {
                int n;
                Vector vector2 = new Vector();
                for (n = 0; n < xSDNodeArray2.length; ++n) {
                    if (xSDNodeArray2[n] instanceof XSDGroup) {
                        vector2 = this.getGroupElements(xSDNodeArray2[n], vector2);
                        continue;
                    }
                    vector2.addElement(xSDNodeArray2[n]);
                }
                for (n = 0; n < vector2.size(); ++n) {
                    XSDNode xSDNode2 = (XSDNode)vector2.elementAt(n);
                    int n2 = vector.size();
                    for (int i = 0; i < vector.size(); ++i) {
                        XSDNode xSDNode3 = (XSDNode)vector.elementAt(i);
                        if (xSDNode3 instanceof XSDGroup) {
                            Vector vector3 = ((XSDGroup)xSDNode3).getNodeVector();
                            for (int j = 0; j < vector3.size(); ++j) {
                                XSDNode xSDNode4 = (XSDNode)vector3.elementAt(j);
                                if (xSDNode4.getName() == null || xSDNode2.getName() == null || !xSDNode4.getName().equals(xSDNode2.getName())) continue;
                                vector.removeElementAt(j);
                            }
                            continue;
                        }
                        if (xSDNode3.getName() == null && xSDNode2.getName() == null) {
                            vector.removeElementAt(i);
                        }
                        if (xSDNode3.getName() == null || xSDNode2.getName() == null || !xSDNode3.getName().equals(xSDNode2.getName())) continue;
                        vector.removeElementAt(i);
                    }
                }
            }
        }
        objectArray = new XSDNode[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private XSDNode[] getInnerLocalAttributes(XSDNode xSDNode) throws Exception {
        if (((XSDComplexType)xSDNode).getAttributeWildcard() != null && !this.extensionOption) {
            this.setLoc(this.err, xSDNode);
            this.err.error0(32015, 1);
            throw new Exception(this.err.getMessage0(32015));
        }
        XSDAttribute[] xSDAttributeArray = ((XSDComplexType)xSDNode).getAttributeDeclarations();
        Vector<XSDAttribute> vector = new Vector<XSDAttribute>();
        if (((XSDComplexType)xSDNode).getDerivationMethod() > 0) {
            XSDAttribute[] xSDAttributeArray2 = null;
            XSDNode xSDNode2 = ((XSDComplexType)xSDNode).getBaseType();
            if (xSDNode2 != null && xSDNode2 instanceof XSDComplexType) {
                xSDAttributeArray2 = ((XSDComplexType)xSDNode2).getAttributeDeclarations();
            }
            boolean bl = false;
            if (xSDAttributeArray2 != null) {
                for (int i = 0; i < xSDAttributeArray.length; ++i) {
                    bl = false;
                    for (int j = 0; j < xSDAttributeArray2.length; ++j) {
                        if (xSDAttributeArray[i].getName() == null || xSDAttributeArray2[j].getName() == null || !xSDAttributeArray[i].getName().equals(xSDAttributeArray2[j].getName())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    vector.addElement(xSDAttributeArray[i]);
                }
            } else {
                for (int i = 0; i < xSDAttributeArray.length; ++i) {
                    vector.addElement(xSDAttributeArray[i]);
                }
            }
        } else {
            for (int i = 0; i < xSDAttributeArray.length; ++i) {
                vector.addElement(xSDAttributeArray[i]);
            }
        }
        Object[] objectArray = new XSDNode[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private Vector getGroupElements(XSDNode xSDNode, Vector vector) {
        Vector vector2 = ((XSDGroup)xSDNode).getNodeVector();
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            XSDNode xSDNode2 = (XSDNode)vector2.elementAt(i);
            if (xSDNode2 instanceof XSDGroup) {
                Vector vector3 = new Vector();
                vector3 = this.getGroupElements(xSDNode2, vector3);
                for (int j = 0; j < vector3.size(); ++j) {
                    vector.addElement((XSDNode)vector3.elementAt(j));
                }
                continue;
            }
            vector.addElement(xSDNode2);
        }
        return vector;
    }

    private String appendClassName(String string, String string2, boolean bl) {
        String string3 = string == null ? string2 : string + "." + string2;
        if (bl) {
            string3 = string3 + "Impl";
        }
        return string3;
    }

    private String getPackageName(XSDNode xSDNode) {
        String string = xSDNode.getTargetNS();
        XSDNode xSDNode2 = xSDNode.getParent();
        if ((string == null || string.intern() == "") && xSDNode2 != null) {
            return this.getPackageName(xSDNode2);
        }
        if (string == null || string.intern() == "") {
            string = xSDNode.getOwnerSchema().getSchemaTargetNS();
        }
        return (String)this.schPackage.get(string);
    }

    private void setTargetJavaDataType(XSDNode xSDNode, JaxbProperty jaxbProperty) throws Exception {
        Object object;
        XSDSimpleType xSDSimpleType;
        Object object2;
        switch (xSDNode.getNodeType()) {
            case 4: {
                object2 = (XSDAttribute)xSDNode;
                if (this.setSimpleTypeAnnotation(xSDNode, jaxbProperty, false)) {
                    jaxbProperty.setXmlType(object2.getType().getName());
                    return;
                }
                if (this.setSimpleTypeAnnotation(object2.getType(), jaxbProperty, true)) {
                    return;
                }
                xSDSimpleType = (XSDSimpleType)object2.getType();
                break;
            }
            case 2: {
                xSDSimpleType = (XSDSimpleType)xSDNode;
                break;
            }
            case 1: {
                object = (XSDComplexType)xSDNode;
                if (!object.isSimpleContent()) {
                    return;
                }
                if (this.setSimpleTypeAnnotation(xSDNode, jaxbProperty, false)) {
                    return;
                }
                if (this.setSimpleTypeAnnotation(object.getBaseType(), jaxbProperty, true)) {
                    return;
                }
                while (object.getBaseType() instanceof XSDComplexType) {
                    object = (XSDComplexType)object.getBaseType();
                }
                xSDSimpleType = (XSDSimpleType)object.getBaseType();
                break;
            }
            case 3: {
                XSDElement xSDElement = (XSDElement)xSDNode;
                if (this.setSimpleTypeAnnotation(xSDNode, jaxbProperty, false)) {
                    jaxbProperty.setXmlType(xSDElement.getType().getName());
                    return;
                }
                if (this.setSimpleTypeAnnotation(xSDElement.getType(), jaxbProperty, true)) {
                    return;
                }
                xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                break;
            }
            default: {
                return;
            }
        }
        object2 = xSDSimpleType.getVariety();
        object = new TypeResCtx(xSDSimpleType, jaxbProperty);
        if (((String)object2).equals("atomic")) {
            this.resolveAtomicType((TypeResCtx)object, false);
        } else if (((String)object2).equals("list")) {
            this.resolveListType((TypeResCtx)object);
        } else if (((String)object2).equals("union")) {
            this.resolveUnionType((TypeResCtx)object);
        }
        if (object.isList) {
            jaxbProperty.setListDataType("list", this.customization);
            jaxbProperty.setCollectionType(this.customization.getCollectionType());
        } else {
            jaxbProperty.setDataType(object.xmlType, object.baseType, this.customization);
        }
    }

    private void getCommonSuperType(Vector vector, TypeResCtx typeResCtx) {
        typeResCtx.baseType = "java.lang.String";
        typeResCtx.xmlType = ANY_SIMPLE;
    }

    private void resolveUnionType(TypeResCtx typeResCtx) {
        Vector<String> vector = new Vector<String>(8);
        Vector vector2 = typeResCtx.xsdNode.getMemberTypes();
        for (int i = 0; i < vector2.size(); ++i) {
            XSDSimpleType xSDSimpleType;
            typeResCtx.xsdNode = xSDSimpleType = (XSDSimpleType)vector2.elementAt(i);
            if (xSDSimpleType.getVariety().equals("list")) {
                this.resolveListType(typeResCtx);
            } else {
                this.resolveAtomicType(typeResCtx, true);
            }
            vector.addElement(typeResCtx.baseType);
        }
        this.getCommonSuperType(vector, typeResCtx);
    }

    private void resolveListType(TypeResCtx typeResCtx) {
        XSDSimpleType xSDSimpleType = typeResCtx.xsdNode;
        XSDSimpleType xSDSimpleType2 = xSDSimpleType.getItemType();
        String string = xSDSimpleType2.getVariety();
        typeResCtx.setNode(xSDSimpleType2);
        if (string.equals("union")) {
            this.resolveUnionType(typeResCtx);
        } else {
            this.resolveAtomicType(typeResCtx, false);
        }
        typeResCtx.isList = true;
    }

    private void resolveAtomicType(TypeResCtx typeResCtx, boolean bl) {
        XSDSimpleType xSDSimpleType;
        XSDSimpleType xSDSimpleType2 = typeResCtx.xsdNode;
        if (xSDSimpleType2.getEnumeration() != null && xSDSimpleType2.getName() != null) {
            xSDSimpleType = this.getNamedBaseType(xSDSimpleType2);
            while (xSDSimpleType != null && !xSDSimpleType.getName().equals("NCName")) {
                xSDSimpleType = this.getNamedBaseType(xSDSimpleType);
            }
            if (xSDSimpleType != null) {
                String string = this.getPackageName((XSDNode)xSDSimpleType2);
                typeResCtx.baseType = string + "." + JaxbUtil.className(xSDSimpleType2.getName());
                typeResCtx.xmlType = xSDSimpleType2.getName();
                typeResCtx.prop.addCandidateObject(typeResCtx.baseType);
                typeResCtx.prop.setEnumType(true);
                return;
            }
        }
        xSDSimpleType = xSDSimpleType2;
        while (!(xSDSimpleType == null || xSDSimpleType.getName() != null && JaxbUtil.isJaxbDataType(JaxbUtil.getBuiltInType(xSDSimpleType.getName())))) {
            xSDSimpleType = this.getNamedBaseType(xSDSimpleType);
        }
        if (xSDSimpleType == null) {
            xSDSimpleType = XSDSimpleType.getPrimitiveType((int)0);
        }
        typeResCtx.xmlType = xSDSimpleType.getName();
        typeResCtx.baseType = JaxbUtil.getBuiltInType(typeResCtx.xmlType);
        if (bl) {
            typeResCtx.baseType = JaxbUtil.getJavaWrapperClass(typeResCtx.baseType);
        }
        typeResCtx.prop.addCandidateObject(typeResCtx.baseType);
    }

    private XSDSimpleType getNamedBaseType(XSDSimpleType xSDSimpleType) {
        XSDSimpleType xSDSimpleType2;
        while ((xSDSimpleType2 = xSDSimpleType.getBase()) != null && xSDSimpleType2.getName() == null) {
            xSDSimpleType = xSDSimpleType2;
        }
        return xSDSimpleType2;
    }

    private JaxbBindingSchema putBindingSchema(JaxbBindingSchema jaxbBindingSchema) throws Exception {
        String string = jaxbBindingSchema.getPackageName() + "." + JaxbUtil.className(jaxbBindingSchema.getNodeName());
        return this.putBindingSchema(string, jaxbBindingSchema);
    }

    private JaxbBindingSchema putBindingSchema(String string, JaxbBindingSchema jaxbBindingSchema) throws Exception {
        JaxbBindingSchema jaxbBindingSchema2 = (JaxbBindingSchema)this.bindingSchema.get(string);
        if (jaxbBindingSchema2 != null) {
            String string2 = jaxbBindingSchema2.getPackageName() + "." + jaxbBindingSchema2.getClassName();
            if (string.equals(string2)) {
                if (jaxbBindingSchema.getClassName().equals(jaxbBindingSchema2.getClassName())) {
                    this.err.error1(32002, 1, jaxbBindingSchema.getNodeName());
                    throw new Exception(this.err.getMessage0(32002));
                }
                return this.bindingSchema.put(string + jaxbBindingSchema.getType(), jaxbBindingSchema);
            }
            return this.bindingSchema.put(string + jaxbBindingSchema.getType(), jaxbBindingSchema);
        }
        return this.bindingSchema.put(string, jaxbBindingSchema);
    }

    private DOMParser initParser(URL uRL) throws Exception {
        DOMParser dOMParser = new DOMParser();
        if (uRL != null) {
            dOMParser.setBaseURL(uRL);
        }
        dOMParser.setPreserveWhitespace(true);
        dOMParser.setValidationMode(0);
        dOMParser.setDebugMode(true);
        return dOMParser;
    }

    private XMLDocument addExternalCustomization(XMLDocument xMLDocument) throws Exception {
        String string = null;
        DOMParser dOMParser = this.initParser(null);
        if (this.bindingFileList == null) {
            return xMLDocument;
        }
        int n = this.bindingFileList.size();
        for (int i = 0; i < n; ++i) {
            URL uRL = (URL)this.bindingFileList.get(i);
            dOMParser.parse(uRL);
            XMLDocument xMLDocument2 = dOMParser.getDocument();
            XMLNode xMLNode = (XMLNode)xMLDocument2.getDocumentElement();
            if (!xMLNode.getLocalName().equals("bindings") || !xMLNode.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxb")) {
                throw new Exception(this.err.getMessage0(32217));
            }
            NamedNodeMap namedNodeMap = xMLNode.getAttributes();
            if (namedNodeMap == null) {
                throw new Exception(this.err.getMessage0(32217));
            }
            for (XMLAttr xMLAttr = (XMLAttr)((XMLElement)xMLNode).getFirstAttribute(); xMLAttr != null; xMLAttr = xMLAttr.getNextAttribute()) {
                String string2 = xMLAttr.getLocalName();
                String string3 = xMLAttr.getNodeValue();
                if (!string3.equals("http://www.w3.org/2001/XMLSchema")) continue;
                string = string2;
            }
            xMLDocument = this.updateSchemaDoc(xMLNode, xMLDocument, string);
        }
        return xMLDocument;
    }

    private XMLDocument updateSchemaDoc(XMLNode xMLNode, XMLDocument xMLDocument, String string) throws Exception {
        XMLNode xMLNode2;
        final String string2 = string;
        String string3 = this.getPrefixUsed(xMLDocument, "http://www.w3.org/2001/XMLSchema");
        String string4 = this.getPrefixUsed(xMLDocument, "http://java.sun.com/xml/ns/jaxb");
        if (string4 == null) {
            string4 = "jaxb";
            xMLNode2 = (XMLElement)xMLDocument.getDocumentElement();
            xMLNode2.setAttributeNS("http://www.w3.org/2001/XMLSchema", "xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
        }
        XMLNode xMLNode3 = xMLNode2 = (XMLNode)xMLDocument.getDocumentElement();
        xMLNode = (XMLNode)xMLNode.getFirstChild();
        while (xMLNode != null) {
            short s = xMLNode.getNodeType();
            if (s != 1) {
                xMLNode = (XMLNode)xMLNode.getNextSibling();
                continue;
            }
            NamedNodeMap namedNodeMap = xMLNode.getAttributes();
            if (namedNodeMap != null) {
                for (XMLAttr xMLAttr = (XMLAttr)((XMLElement)xMLNode).getFirstAttribute(); xMLAttr != null; xMLAttr = xMLAttr.getNextAttribute()) {
                    NSResolver nSResolver = new NSResolver(){

                        public String resolveNamespacePrefix(String string) {
                            if (string.equals(string2)) {
                                return new String("http://www.w3.org/2001/XMLSchema");
                            }
                            return null;
                        }
                    };
                    String string5 = xMLAttr.getNodeValue();
                    NodeList nodeList = xMLNode3.selectNodes(string5, nSResolver);
                    int n = nodeList.getLength();
                    if (n <= 0) continue;
                    XMLNode xMLNode4 = (XMLNode)nodeList.item(0);
                    this.addAnnotation(xMLNode, xMLNode4, string3, string4);
                    xMLNode3 = xMLNode4;
                }
            }
            if (xMLNode.hasChildNodes()) {
                this.updateSchemaDoc(xMLNode, xMLDocument, string2);
            }
            xMLNode3 = xMLNode2;
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
        return xMLDocument;
    }

    private void addAnnotation(XMLNode xMLNode, XMLNode xMLNode2, String string, String string2) throws Exception {
        XMLNode xMLNode3 = null;
        XMLDocument xMLDocument = (XMLDocument)xMLNode2.getOwnerDocument();
        XMLElement xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
        String string3 = string + ":" + "annotation";
        XMLElement xMLElement2 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
        xMLElement.appendChild((Node)xMLElement2);
        xMLNode2.insertBefore((Node)xMLElement, xMLNode2.getFirstChild());
        XMLNode xMLNode4 = (XMLNode)xMLNode.getFirstChild();
        while (xMLNode4 != null) {
            xMLNode3 = (XMLNode)xMLNode4.getNextSibling();
            short s = xMLNode4.getNodeType();
            if (xMLNode4.getNodeType() == 1 && !xMLNode4.getLocalName().equals("bindings")) {
                XMLNode xMLNode5 = (XMLNode)xMLDocument.adoptNode((Node)xMLNode4);
                xMLNode5.setPrefix(string2);
                xMLElement2.appendChild((Node)xMLNode5);
            }
            xMLNode4 = xMLNode3;
        }
    }

    private String getPrefixUsed(XMLDocument xMLDocument, String string) {
        XMLNode xMLNode = (XMLNode)xMLDocument.getDocumentElement();
        NamedNodeMap namedNodeMap = xMLNode.getAttributes();
        if (namedNodeMap != null) {
            for (XMLAttr xMLAttr = (XMLAttr)((XMLElement)xMLNode).getFirstAttribute(); xMLAttr != null; xMLAttr = xMLAttr.getNextAttribute()) {
                if (!xMLAttr.getNodeValue().equals(string)) continue;
                return xMLAttr.getLocalName();
            }
        }
        return null;
    }

    private void setLoc(XMLError xMLError, XSDNode xSDNode) {
        DOMLocator dOMLocator = (DOMLocator)xMLError.getLocator();
        if (dOMLocator != null && xSDNode != null && xSDNode.getDomNode() != null) {
            dOMLocator.setCurrentNode((XMLNode)xSDNode.getDomNode());
        }
    }

    private void setLoc1(XMLError xMLError, XMLElement xMLElement) {
        DOMLocator dOMLocator = (DOMLocator)xMLError.getLocator();
        if (dOMLocator != null && xMLElement != null) {
            dOMLocator.setCurrentNode((XMLNode)xMLElement);
        }
    }

    class ModelGrpNamMap {
        StackElem[] stack = new StackElem[4];
        int tos;
        String currCompositor = "";

        ModelGrpNamMap(XSDGroup xSDGroup) {
            this.stack[0] = new StackElem(xSDGroup);
            this.currCompositor = this.stack[0].compositor;
            this.tos = 0;
        }

        private void updateCompositor() {
            if (this.tos == 0) {
                StackElem stackElem = this.stack[this.tos];
                if (stackElem.currPos == stackElem.vect.size()) {
                    this.currCompositor = "";
                }
            }
        }

        String nextTerm() {
            if (this.tos < 0) {
                this.currCompositor = "";
                return "";
            }
            StackElem stackElem = this.stack[this.tos];
            while (true) {
                if (stackElem.currPos < stackElem.vect.size()) {
                    XSDNode xSDNode;
                    if ((xSDNode = (XSDNode)stackElem.vect.elementAt(stackElem.currPos++)) instanceof XSDGroup) {
                        this.stack[++this.tos] = new StackElem((XSDGroup)xSDNode);
                        this.currCompositor = this.stack[this.tos].compositor;
                        this.updateCompositor();
                        return this.nextTerm();
                    }
                    if (xSDNode instanceof XSDAny) {
                        this.updateCompositor();
                        return "Any";
                    }
                    this.updateCompositor();
                    return JaxbUtil.className(xSDNode.getName());
                }
                if (--this.tos < 0) {
                    return this.nextTerm();
                }
                stackElem = this.stack[this.tos];
            }
        }

        String nextCompositor() {
            return this.currCompositor;
        }

        class StackElem {
            int currPos = 0;
            Vector vect;
            String compositor;

            StackElem(XSDGroup xSDGroup) {
                this.vect = xSDGroup.getNodeVector();
                this.compositor = JaxbSchemaCompiler.this.getCompositor(xSDGroup.getOrder());
            }
        }
    }

    class TypeResCtx {
        XSDSimpleType xsdNode;
        JaxbProperty prop;
        boolean isList;
        String baseType;
        String xmlType;

        TypeResCtx(XSDSimpleType xSDSimpleType, JaxbProperty jaxbProperty) {
            this.xsdNode = xSDSimpleType;
            this.prop = jaxbProperty;
            this.isList = false;
            this.baseType = "java.lang.Object";
        }

        void setNode(XSDSimpleType xSDSimpleType) {
            this.xsdNode = xSDSimpleType;
        }
    }
}

