/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.processes;

import java.io.OutputStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import oracle.xml.jaxp.JXTransformer;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.pipeline.controller.Input;
import oracle.xml.pipeline.controller.Output;
import oracle.xml.pipeline.controller.PipelineException;
import oracle.xml.pipeline.controller.Process;
import oracle.xml.xslt.XSLStylesheet;
import org.w3c.dom.Node;

public class XSLProcess
extends Process
implements ErrorListener {
    private Output output = null;
    private JXTransformer transformer = null;

    @Override
    public void initialize() {
        Input input = this.getInput("document");
        input.supportType(0);
        input.supportType(8);
        input.supportType(9);
        input.supportType(10);
        Output output = this.getOutput("result");
        output.supportType(4);
        output.supportType(5);
        output.supportType(6);
        output.supportType(9);
    }

    @Override
    public void execute() throws PipelineException {
        XSLStylesheet xSLStylesheet = (XSLStylesheet)this.getInParamValue("stylesheet");
        Source source = this.getInputSource("document");
        String string = (String)this.getInParamValue("baseURL");
        String string2 = (String)this.getInParamValue("outputEncoding");
        String string3 = (String)this.getInParamValue("showWarnings");
        this.transformer = new JXTransformer(xSLStylesheet);
        if (string2 != null && string2.length() != 0) {
            this.transformer.setOutputProperty("encoding", string2);
        }
        this.output = this.getOutput("result");
        OutputStream outputStream = null;
        Object var7_7 = null;
        try {
            this.transformer.setErrorListener((ErrorListener)this);
            if (this.output.isXMLType(4)) {
                this.transformToDOM(source);
            } else if (this.output.isXMLType(5)) {
                this.transformToSAX(source);
            } else {
                outputStream = this.getOutputStream("result");
                StreamResult streamResult = new StreamResult(outputStream);
                this.transformer.transform(source, (Result)streamResult);
                outputStream.flush();
                this.convertFromStream(streamResult, this.output);
            }
        }
        catch (Exception exception) {
            if (!this.ignoreError("result")) {
                this.error(30001, 17, exception);
            }
            this.info(30000, new String[]{"XSLProcess", exception.getMessage()});
            this.processError();
        }
    }

    @Override
    public void error(TransformerException transformerException) throws TransformerException {
        try {
            if (!this.ignoreError("result")) {
                this.error(30001, 16, transformerException);
            } else {
                this.info(30000, new String[]{"XSLProcess", transformerException.getMessage()});
                this.processError();
            }
        }
        catch (PipelineException pipelineException) {
            throw new TransformerException(pipelineException.getMessage());
        }
    }

    @Override
    public void fatalError(TransformerException transformerException) throws TransformerException {
        try {
            this.processError();
        }
        catch (PipelineException pipelineException) {
            throw new TransformerException(pipelineException.getMessage());
        }
    }

    @Override
    public void warning(TransformerException transformerException) throws TransformerException {
        try {
            this.error(30001, 18, transformerException);
        }
        catch (PipelineException pipelineException) {
            throw new TransformerException(pipelineException.getMessage());
        }
    }

    private void processError() throws PipelineException {
        try {
            this.transformer = new JXTransformer();
            if (this.output.isXMLType(4)) {
                this.transformToDOM(this.getErrorSource("result"));
            } else if (this.output.isXMLType(5)) {
                this.transformToSAX(this.getErrorSource("result"));
            } else {
                StreamResult streamResult = new StreamResult(this.getOutputStream("result"));
                this.transformer.transform(this.getErrorSource("result"), (Result)streamResult);
                this.setOutputResult("result", streamResult);
                this.convertFromStream(streamResult, this.output);
            }
        }
        catch (Exception exception) {
            this.error(30006, 17, exception);
        }
    }

    private void transformToDOM(Source source) throws Exception {
        DOMResult dOMResult = new DOMResult((Node)new XMLDocument());
        this.transformer.transform(source, (Result)dOMResult);
        this.setOutputResult("result", dOMResult);
        this.convertFromDOM(dOMResult, this.output);
    }

    private void transformToSAX(Source source) throws Exception {
        SAXResult sAXResult = new SAXResult(this.getSAXContentHandler(this.output));
        this.transformer.transform(source, (Result)sAXResult);
        this.setOutputResult("result", sAXResult);
        this.convertFromSAX(sAXResult, this.output);
    }
}

