/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLInitializationException;
import oracle.xml.xsql.XSQLLRUCache;
import oracle.xml.xsql.XSQLPage;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLParserHelper;
import oracle.xml.xsql.XSQLUtil;
import org.xml.sax.SAXParseException;

final class XSQLPageManager {
    private static final String HTTPURLPREF = "http:/";
    private static final String FTPURLPREF = "ftp:/";
    private static final String FILEURLPREF = "file:/";
    private static final String JARURLPREF = "jar:";
    private static final String ZIPURLPREF = "zip:";
    private static final String DYNSRVURLPREF = "dsregistry:";
    private static XSQLPageManager singleton = new XSQLPageManager();
    private static XSQLLRUCache cachedPages;

    XSQLPageManager() {
    }

    public static XSQLPageManager getManager() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSQLPage getPage(String string, XSQLPageRequest xSQLPageRequest) throws SAXParseException, FileNotFoundException {
        XSQLPage xSQLPage;
        XSQLPage xSQLPage2;
        boolean bl;
        block18: {
            bl = true;
            xSQLPage2 = null;
            if (string == null) {
                xSQLPageRequest.signalError(25013, null, null);
                throw new FileNotFoundException();
            }
            try {
                Object object;
                xSQLPage = null;
                long l = XSQLUtil.timestampOf(string);
                if (cachedPages == null) {
                    object = XSQLConfigManager.getManager();
                    cachedPages = new XSQLLRUCache(((XSQLConfigManager)object).getXSQLPageCacheSize());
                }
                if ((xSQLPage = (XSQLPage)cachedPages.get(string)) == null) {
                    xSQLPage2 = this.newXSQLPage(string, l, xSQLPageRequest);
                    if (l != 0L) {
                        object = cachedPages;
                        synchronized (object) {
                            cachedPages.put(string, xSQLPage2);
                            break block18;
                        }
                    }
                    bl = false;
                    break block18;
                }
                long l2 = xSQLPage.getTimestamp();
                if (l > l2) {
                    xSQLPage2 = this.newXSQLPage(string, l, xSQLPageRequest);
                    if (l != 0L) {
                        XSQLLRUCache xSQLLRUCache = cachedPages;
                        synchronized (xSQLLRUCache) {
                            cachedPages.put(string, xSQLPage2);
                            break block18;
                        }
                    }
                    bl = false;
                    break block18;
                }
                xSQLPage2 = xSQLPage;
            }
            catch (SAXParseException sAXParseException) {
                throw sAXParseException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (XSQLInitializationException xSQLInitializationException) {
                throw xSQLInitializationException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        if (bl) {
            xSQLPage = (XSQLPage)xSQLPage2.clone();
            return xSQLPage;
        }
        return xSQLPage2;
    }

    private XSQLPage newXSQLPage(String string, long l, XSQLPageRequest xSQLPageRequest) throws SAXParseException, FileNotFoundException {
        XSQLPage xSQLPage = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            PrintWriter printWriter = new PrintWriter(new StringWriter());
            URL uRL = null;
            uRL = !string.startsWith(HTTPURLPREF) && !string.startsWith(FTPURLPREF) && !string.startsWith(FILEURLPREF) && !string.startsWith(DYNSRVURLPREF) && !string.startsWith(ZIPURLPREF) && !string.startsWith(JARURLPREF) ? new URL("file:///" + string) : new URL(string);
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
            xSQLPage = new XSQLPage((XMLDocument)XSQLParserHelper.parse(bufferedInputStream, uRL, printWriter), l);
        }
        catch (SAXParseException sAXParseException) {
            xSQLPageRequest.signalError(25005, null, new Object[]{sAXParseException});
            throw sAXParseException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            xSQLPageRequest.signalError(25001, null, null);
            throw fileNotFoundException;
        }
        catch (Exception exception) {
            xSQLPageRequest.signalError(25012, null, new Object[]{exception.toString()});
            throw new FileNotFoundException();
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return xSQLPage;
    }
}

